/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.clusqmgr;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.clusterplugin.internal.ImageCache;
import com.ibm.mq.explorer.clusterplugin.internal.actions.RemoveQueueManagerFromCluster;
import com.ibm.mq.explorer.clusterplugin.internal.content.QmgrObjectContentPage;
import com.ibm.mq.explorer.clusterplugin.internal.factory.ClusterFactory;
import com.ibm.mq.explorer.clusterplugin.internal.factory.ExplorerTreeNodeFactory;
import com.ibm.mq.explorer.clusterplugin.internal.objects.ClusterObject;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeInt;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmClusterQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandle;
import com.ibm.mq.explorer.qmgradmin.internal.channels.ChannelActionPing;
import com.ibm.mq.explorer.qmgradmin.internal.channels.ChannelActionPurge;
import com.ibm.mq.explorer.qmgradmin.internal.channels.ChannelActionReset;
import com.ibm.mq.explorer.qmgradmin.internal.channels.ChannelActionResolve;
import com.ibm.mq.explorer.qmgradmin.internal.channels.ChannelActionStart;
import com.ibm.mq.explorer.qmgradmin.internal.channels.ChannelActionStop;
import com.ibm.mq.explorer.qmgradmin.internal.channels.UiChannel;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyPage;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UiClusterQueueManager
extends UiMQObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/clusqmgr/UiClusterQueueManager.java";
    public static final int CLUSTER_QUEUEMANGER_TYPE = 0;
    public static final int CLUSTER_CHANNEL_TYPE = 1;
    private DmClusterQueueManager dmClusterQueueManager = (DmClusterQueueManager)this.getDmObject();
    private boolean isNavigatorObject = false;
    private int clusterQueueManagerType = 0;
    private String cachedQueueManagerNameAttr = null;
    private String cachedChannnelNameAttr = null;
    private String cachedClusterNameAttr = null;
    private String cachedClusterQueueManagerId = null;
    private boolean connectionFailure = false;
    private Action actionStart = null;
    private Action actionStop = null;
    private Action actionResolve = null;
    private Action actionPing = null;
    private Action actionReset = null;
    private Action actionPurge = null;
    private static String startMenuText = null;
    private static String stopMenuText = null;
    private static String resolveMenuText = null;
    private static String pingMenuText = null;
    private static String resetMenuText = null;
    private static String purgeMenuText = null;

    public UiClusterQueueManager(Trace t, IDmObject dmObj, boolean isNavObject) {
        super(t, dmObj);
        this.isNavigatorObject = isNavObject;
        this.cachedChannnelNameAttr = this.getAttributeValue(t, 3501);
        this.cachedQueueManagerNameAttr = this.getAttributeValue(t, 2031);
        this.cachedClusterNameAttr = this.getAttributeValue(t, 2029);
        this.cachedClusterQueueManagerId = this.getAttributeValue(t, 2032);
        if (startMenuText == null) {
            startMenuText = UiPlugin.getNLSString((Trace)t, (String)"KEY_Channels", (String)"UI.CHL.Start.Menu");
            stopMenuText = UiPlugin.getNLSString((Trace)t, (String)"KEY_Channels", (String)"UI.CHL.Stop.Menu");
            resolveMenuText = UiPlugin.getNLSString((Trace)t, (String)"KEY_Channels", (String)"UI.CHL.Resolve.Menu");
            pingMenuText = UiPlugin.getNLSString((Trace)t, (String)"KEY_Channels", (String)"UI.CHL.Ping.Menu");
            resetMenuText = UiPlugin.getNLSString((Trace)t, (String)"KEY_Channels", (String)"UI.CHL.Reset.Menu");
            purgeMenuText = UiPlugin.getNLSString((Trace)t, (String)"KEY_Channels", (String)"UI.CHL.Purge.Menu");
        }
    }

    public UiClusterQueueManager(Trace t, IDmObject dmObj, boolean isNavObject, int clusQmgrType) {
        this(t, dmObj, isNavObject);
        this.clusterQueueManagerType = clusQmgrType;
    }

    public DmClusterQueueManager getDmClusterQueueManagerObject() {
        return this.dmClusterQueueManager;
    }

    public DmQueueManager getRealQueueManager(Trace t) {
        return this.dmClusterQueueManager.getRealQueueManager(t);
    }

    public String getClusterAttr() {
        return this.cachedClusterNameAttr;
    }

    public String getConnectionNameAttr(Trace t) {
        String value = this.getAttributeValue(t, 3506);
        return value;
    }

    public ClusterObject getCluster(Trace t) {
        ClusterFactory factory = ClusterFactory.getDefault();
        ClusterObject cluster = factory.getCluster(t, this.getClusterAttr());
        return cluster;
    }

    public String getClusterQueueManagerNameAttr() {
        return this.cachedQueueManagerNameAttr;
    }

    public String getClusterQueueManagerIdAttr() {
        return this.cachedClusterQueueManagerId;
    }

    public String getChannelNameAttr() {
        return this.cachedChannnelNameAttr;
    }

    public boolean isShownInExplorer(Trace t) {
        boolean visibility = false;
        DmQueueManager dmQueueManager = this.dmClusterQueueManager.getRealQueueManager(t);
        if (dmQueueManager != null && dmQueueManager.isVisible(t)) {
            visibility = true;
        }
        return visibility;
    }

    public boolean hasRealConnectedQueueManager(Trace t) {
        boolean connected = true;
        DmQueueManager qmgr = this.getRealQueueManager(Trace.getDefault());
        if (qmgr == null || !qmgr.isConnected()) {
            connected = false;
        }
        return connected;
    }

    public void setConnectionFailure(Trace t, boolean value) {
        QmgrObjectContentPage page;
        this.connectionFailure = value;
        ExplorerTreeNodeFactory factory = ExplorerTreeNodeFactory.getDefault();
        factory.updateClusterQueueManager(t, this);
        if (!this.connectionFailure && (page = QmgrObjectContentPage.getDefault()) != null) {
            page.kick(t);
        }
    }

    public boolean isPartialRepository(Trace t) {
        boolean retval = false;
        if (this.getRepositoryAttr().equals("0")) {
            retval = true;
        }
        return retval;
    }

    public boolean isFullRepository(Trace t) {
        boolean retval = false;
        if (this.getRepositoryAttr().equals("1")) {
            retval = true;
        }
        return retval;
    }

    public boolean isExplicitClusterSenderDefinition(Trace t) {
        boolean retval = false;
        if (this.getDefinitionTypeAttr(t).equals("1")) {
            retval = true;
        }
        return retval;
    }

    public boolean isAutoDefinedClusterSenderDefinition(Trace t) {
        boolean retval = false;
        if (this.getDefinitionTypeAttr(t).equals("2")) {
            retval = true;
        }
        return retval;
    }

    public boolean isClusterReceiverDefinition(Trace t) {
        boolean retval = false;
        if (this.getDefinitionTypeAttr(t).equals("3")) {
            retval = true;
        }
        return retval;
    }

    public boolean isAutoAndExplicitClusterSenderDefinition(Trace t) {
        boolean retval = false;
        if (this.getDefinitionTypeAttr(t).equals("4")) {
            retval = true;
        }
        return retval;
    }

    private String getDefinitionTypeAttr(Trace t) {
        return this.getAttributeValue(t, 1084);
    }

    public int getStatusAttr() {
        int status = this.getIntegerAttributeValue(Trace.getDefault(), 1527);
        return status;
    }

    public boolean isSuspended(Trace t) {
        boolean retval = false;
        String value = this.getAttributeValue(Trace.getDefault(), 1087);
        if (value.equals("1")) {
            retval = true;
        }
        return retval;
    }

    public String getRepositoryAttr() {
        return this.getAttributeValue(Trace.getDefault(), 1085);
    }

    public String getHostname(Trace t) {
        String name = "";
        String conn = this.getConnectionNameAttr(t);
        int end = conn.indexOf("(");
        name = end != -1 ? conn.substring(0, end) : conn;
        return name;
    }

    public String getConnamePortInfo(Trace t) {
        String port = "";
        String conn = this.getConnectionNameAttr(t);
        int start = conn.indexOf("(");
        int end = conn.indexOf(")");
        if (start != -1 && end != -1) {
            port = conn.substring(start + 1, end);
        }
        return port;
    }

    public void performRemoveFromCluster(Trace t) {
        RemoveQueueManagerFromCluster action = new RemoveQueueManagerFromCluster(this);
        Display display = UiPlugin.getDisplay();
        display.asyncExec((Runnable)action);
    }

    public int issueResumeCommand(Trace t) {
        DmQueueManager dmQueueManager = this.getRealQueueManager(t);
        int result = dmQueueManager.actionResumeCluster(t, null, this.getClusterAttr(), null);
        return result;
    }

    public int issueSuspendCommand(Trace t) {
        DmQueueManager dmQmgr = this.dmClusterQueueManager.getRealQueueManager(t);
        int result = dmQmgr.actionSuspendCluster(t, null, this.getClusterAttr(), null);
        return result;
    }

    public int issueRefreshCommand(Trace t, int refreshRepositoryInformation, boolean allClusters) {
        int refreshRepos = refreshRepositoryInformation;
        DmQueueManager dmQmgr = this.getRealQueueManager(t);
        if (dmQmgr.getCommandLevel() == 510) {
            refreshRepos = 0;
        }
        int result = !allClusters ? dmQmgr.actionRefreshCluster(t, null, this.getClusterAttr(), refreshRepos) : dmQmgr.actionRefreshCluster(t, null, "*", refreshRepos);
        return result;
    }

    public void showInExplorer(Trace t) {
        QueueManagerHandle queueManagerHandle;
        DmQueueManagerHandle dmQueueManagerHandle;
        DmQueueManager dmQueueManager = this.getRealQueueManager(t);
        if (dmQueueManager != null && (dmQueueManagerHandle = dmQueueManager.getConnectionHandle()) != null && (queueManagerHandle = dmQueueManagerHandle.getQueueManagerHandle(t)) != null) {
            queueManagerHandle.setVisible(t, 1);
            UiPlugin.refreshNavigatorViews((Trace)t, (boolean)true);
        }
    }

    public int getDataModelObjectType(Trace t) {
        return 0;
    }

    public boolean isSupportDelete() {
        return false;
    }

    public boolean isAllowProperties() {
        return true;
    }

    public String getObjectType() {
        return null;
    }

    public String getNLSResourceFileKey() {
        return null;
    }

    public boolean isChangeProperties(Trace t) {
        return false;
    }

    public boolean isCustomGroup(Trace t, UiDisplayGroup uiDisplayGroup) {
        return false;
    }

    public boolean isCustomItem(Trace t, Attr attr) {
        return false;
    }

    public CustomPropertyPage createCustomPropertyPage(Trace t, Composite parent, int style, UiDisplayGroup uiDisplayGroup, boolean readonly) {
        return null;
    }

    public CustomPropertyItem createCustomPropertyItem(Trace t, Composite parent, int style, Attr attr, boolean readonly) {
        return null;
    }

    public boolean isNotifyChangedOnPropertyPage(Attr attr) {
        return false;
    }

    public boolean attrValueChangedOnPropertyPage(Trace t, Attr attr, Object newValue) {
        return false;
    }

    public boolean isAllowApplyProperties() {
        return false;
    }

    public boolean isDefaultDataModeEbcdic(Trace t) {
        return false;
    }

    public String getAttributeName(Trace t, int attrId) {
        return null;
    }

    public String getAttributeValue(Trace t, int attrId) {
        String value = "";
        Attr attr = this.dmClusterQueueManager.getAttribute(t, attrId, 0);
        if (attr != null && attr.getValue(t) != null) {
            value = attr.getValue(t).toString();
        }
        return value;
    }

    private int getIntegerAttributeValue(Trace t, int attrId) {
        AttrType type;
        Attr attr = this.dmClusterQueueManager.getAttribute(t, attrId, 0);
        int value = -1;
        if (attr != null && ((type = attr.getAttrType()) instanceof AttrTypeInt || type instanceof AttrTypeEnum)) {
            value = (Integer)attr.getValue(t);
        }
        return value;
    }

    public String getCharacterSetIdForByteArray(Trace t, int attrId) {
        return null;
    }

    public String getId() {
        return "com.ibm.mq.explorer.clusterqueuemanager";
    }

    public String toString() {
        String name = this.cachedQueueManagerNameAttr;
        if (this.clusterQueueManagerType == 1) {
            name = this.cachedChannnelNameAttr;
        }
        return name;
    }

    public void updateIcon() {
        if (!this.isNavigatorObject) {
            Image image = ImageCache.getImage(Trace.getDefault(), "clusterSmall.gif");
            switch (this.clusterQueueManagerType) {
                case 0: {
                    image = this.getClusterQueueManagerImage();
                    break;
                }
                case 1: {
                    image = this.getClusterChannelImage();
                    break;
                }
                default: {
                    image = this.getClusterQueueManagerImage();
                }
            }
            super.setImage(image);
        }
    }

    private Image getClusterChannelImage() {
        Trace t = Trace.getDefault();
        int status = this.getStatusAttr();
        boolean qdispGroup = this.isAGroupChannel(t);
        int chanType = this.getChannelType(t);
        Image image = UiChannel.getUpdateIcon((Trace)t, (int)chanType, (int)status, (boolean)qdispGroup);
        return image;
    }

    private Image getClusterQueueManagerImage() {
        Trace t = Trace.getDefault();
        Image image = ImageCache.getImage(Trace.getDefault(), "clusterSmall.gif");
        DmQueueManager dmQmgr = this.getRealQueueManager(t);
        image = this.isFullRepository(t) ? (dmQmgr != null && dmQmgr.isConnected() ? (this.isSuspended(t) ? ImageCache.getImage(Trace.getDefault(), "clusterRepositoryFullSuspended.gif") : ImageCache.getImage(Trace.getDefault(), "clusterRepositoryFull.gif")) : ImageCache.getImage(Trace.getDefault(), "clusterRepositoryFullDisconnected.gif")) : (dmQmgr != null && dmQmgr.isConnected() ? (this.isSuspended(t) ? ImageCache.getImage(Trace.getDefault(), "clusterRepositoryPartialSuspended.gif") : ImageCache.getImage(Trace.getDefault(), "clusterRepositoryPartial.gif")) : ImageCache.getImage(Trace.getDefault(), "clusterRepositoryPartialDisconnected.gif"));
        return image;
    }

    public int getChannelType(Trace t) {
        int chTyp = 8;
        Integer clusterReceiverConst = 3;
        chTyp = this.getDefinitionTypeAttr(t).equals(clusterReceiverConst.toString()) ? 8 : 9;
        return chTyp;
    }

    public boolean isAGroupChannel(Trace t) {
        int i;
        boolean qdispGroup = false;
        Attr attr = this.getDmObject().getAttribute(t, 63, 0);
        if (attr != null && (i = ((Integer)attr.getValue(t)).intValue()) == 3) {
            qdispGroup = true;
        }
        return qdispGroup;
    }

    public void appendToContextMenu(Shell sh, IMenuManager manager, Object contextObject) {
        DmChannel dmChl;
        Attr a;
        Trace t = Trace.getDefault();
        if (this.actionStart == null) {
            this.actionStart = new Action(){

                public void run() {
                    Trace trace = Trace.getDefault();
                    UiClusterQueueManager.this.startMenuAction(trace);
                }
            };
            this.actionStart.setText(startMenuText);
            UiUtils.setHelp((IAction)this.actionStart, (String)"com.ibm.mq.explorer.ui.infopop.UI_ChannelStartMenuItem");
        }
        if (this.actionStop == null) {
            this.actionStop = new Action(){

                public void run() {
                    Trace trace = Trace.getDefault();
                    UiClusterQueueManager.this.stopMenuAction(trace);
                }
            };
            this.actionStop.setText(stopMenuText);
            UiUtils.setHelp((IAction)this.actionStop, (String)"com.ibm.mq.explorer.ui.infopop.UI_ChannelStopMenuItem");
        }
        if (this.actionResolve == null) {
            this.actionResolve = new Action(){

                public void run() {
                    Trace trace = Trace.getDefault();
                    UiClusterQueueManager.this.resolveMenuAction(trace);
                }
            };
            this.actionResolve.setText(resolveMenuText);
            UiUtils.setHelp((IAction)this.actionResolve, (String)"com.ibm.mq.explorer.ui.infopop.UI_ChannelResolveMenuItem");
        }
        if (this.actionPing == null) {
            this.actionPing = new Action(){

                public void run() {
                    Trace trace = Trace.getDefault();
                    UiClusterQueueManager.this.pingMenuAction(trace);
                }
            };
            this.actionPing.setText(pingMenuText);
            UiUtils.setHelp((IAction)this.actionPing, (String)"com.ibm.mq.explorer.ui.infopop.UI_ChannelPingMenuItem");
        }
        if (this.actionReset == null) {
            this.actionReset = new Action(){

                public void run() {
                    Trace trace = Trace.getDefault();
                    UiClusterQueueManager.this.resetMenuAction(trace);
                }
            };
            this.actionReset.setText(resetMenuText);
            UiUtils.setHelp((IAction)this.actionReset, (String)"com.ibm.mq.explorer.ui.infopop.UI_ChannelResetMenuItem");
        }
        if (this.actionPurge == null) {
            this.actionPurge = new Action(){

                public void run() {
                    Trace trace = Trace.getDefault();
                    UiClusterQueueManager.this.purgeMenuAction(trace);
                }
            };
            this.actionPurge.setText(purgeMenuText);
            UiUtils.setHelp((IAction)this.actionPurge, (String)"com.ibm.mq.explorer.ui.infopop.UI_ChannelPurgeMenuItem");
        }
        if ((a = (dmChl = (DmChannel)this.getDmObject()).getAttribute(t, 1527, 0)) != null) {
            int i = (Integer)a.getValue(t);
            switch (i) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 13: {
                    manager.add((IAction)this.actionStop);
                    break;
                }
                case 8: {
                    manager.add((IAction)this.actionStart);
                    break;
                }
                default: {
                    manager.add((IAction)this.actionStart);
                    manager.add((IAction)this.actionStop);
                }
            }
        }
        manager.add((IContributionItem)new Separator());
        if (this.isExplicitClusterSenderDefinition(t) || this.isAutoAndExplicitClusterSenderDefinition(t) || this.isAutoDefinedClusterSenderDefinition(t)) {
            manager.add((IAction)this.actionResolve);
            manager.add((IAction)this.actionPing);
            manager.add((IAction)this.actionReset);
        } else if (this.isClusterReceiverDefinition(t)) {
            manager.add((IAction)this.actionReset);
        }
        manager.add((IContributionItem)new Separator("additions"));
        super.appendToContextMenu(sh, manager, contextObject);
    }

    private void startMenuAction(Trace t) {
        DmChannel dmChannel = (DmChannel)this.getDmObject();
        new ChannelActionStart(t, this.shell, dmChannel);
    }

    private void stopMenuAction(Trace t) {
        DmChannel dmChannel = (DmChannel)this.getDmObject();
        new ChannelActionStop(t, this.shell, dmChannel);
    }

    private void purgeMenuAction(Trace t) {
        DmChannel dmChannel = (DmChannel)this.getDmObject();
        new ChannelActionPurge(t, this.shell, dmChannel);
    }

    private void pingMenuAction(Trace t) {
        DmChannel dmChannel = (DmChannel)this.getDmObject();
        new ChannelActionPing(t, this.shell, dmChannel);
    }

    private void resolveMenuAction(Trace t) {
        DmChannel dmChannel = (DmChannel)this.getDmObject();
        new ChannelActionResolve(t, this.shell, dmChannel);
    }

    private void resetMenuAction(Trace t) {
        DmChannel dmChannel = (DmChannel)this.getDmObject();
        new ChannelActionReset(t, this.shell, dmChannel);
    }
}

