/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.clusqmgr;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.clusterplugin.extensions.MQClusterQmgrExtObject;
import com.ibm.mq.explorer.clusterplugin.internal.clusqmgr.ClusterQueueManagerTreeNode;
import com.ibm.mq.explorer.clusterplugin.internal.clusqmgr.UiClusterQueueManager;
import com.ibm.mq.explorer.clusterplugin.internal.objects.ClusterQueueManagerFolder;
import com.ibm.mq.explorer.clusterplugin.internal.treenodes.AddTreeNodeRunnable;
import com.ibm.mq.explorer.clusterplugin.internal.treenodes.RemoveTreeNodeRunnable;
import com.ibm.mq.explorer.clusterplugin.internal.treenodes.UpdateTreeNodeRunnable;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.widgets.Display;

public final class ClusterQueueManagerTreeNodeFactory
implements IExecutableExtension {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/clusqmgr/ClusterQueueManagerTreeNodeFactory.java";
    private Object treelock = new Object();

    public ClusterQueueManagerTreeNodeFactory(Trace t) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(Trace t, UiClusterQueueManager uiObj) {
        MQClusterQmgrExtObject exObj;
        TreeNode node = uiObj.getTreeNode();
        TreeNode parentNode = null;
        if (node == null && (parentNode = ((ClusterQueueManagerFolder)(exObj = (MQClusterQmgrExtObject)uiObj.getExternalObject()).getParent()).getTreeNode()) != null) {
            Object object = this.treelock;
            synchronized (object) {
                boolean hide = this.checkAddNodeHiddenStatus(t, parentNode, uiObj);
                node = new ClusterQueueManagerTreeNode(t, parentNode, exObj);
                if (hide) {
                    node.setVisible(false);
                } else {
                    node.setVisible(true);
                }
                uiObj.setTreeNode(node);
                Display.getDefault().syncExec((Runnable)new AddTreeNodeRunnable(t, parentNode, node));
            }
        }
    }

    private boolean checkAddNodeHiddenStatus(Trace t, TreeNode parentNode, UiClusterQueueManager uiObj) {
        String newhost = uiObj.getHostname(t);
        String newname = uiObj.getClusterQueueManagerNameAttr();
        String newuuid = uiObj.getClusterQueueManagerIdAttr();
        boolean hidden = false;
        TreeNode[] children = parentNode.getRealChildren();
        int idx = 0;
        while (idx < children.length) {
            TreeNode child = children[idx];
            MQClusterQmgrExtObject exObj2 = (MQClusterQmgrExtObject)((Object)child.getObject());
            UiClusterQueueManager uiObj2 = (UiClusterQueueManager)((Object)exObj2.getInternalObject());
            String oldhost = uiObj2.getHostname(t);
            String oldname = uiObj2.getClusterQueueManagerNameAttr();
            String olduuid = uiObj2.getClusterQueueManagerIdAttr();
            if (newname.equals(oldname) && newhost.equals(oldhost) && newuuid.equals(olduuid)) {
                hidden = true;
                break;
            }
            ++idx;
        }
        return hidden;
    }

    private TreeNode checkRemoveNodeHiddenStatus(Trace t, TreeNode parentNode, UiClusterQueueManager uiObj) {
        TreeNode hiddenNode = null;
        String oldhost = uiObj.getHostname(t);
        String oldname = uiObj.getClusterQueueManagerNameAttr();
        TreeNode[] children = parentNode.getRealChildren();
        int idx = 0;
        while (idx < children.length) {
            TreeNode child = children[idx];
            MQClusterQmgrExtObject exObj2 = (MQClusterQmgrExtObject)((Object)child.getObject());
            UiClusterQueueManager uiObj2 = (UiClusterQueueManager)((Object)exObj2.getInternalObject());
            String newhost = uiObj2.getHostname(t);
            String newname = uiObj2.getClusterQueueManagerNameAttr();
            if (oldname.equals(newname) && oldhost.equals(newhost)) {
                hiddenNode = child;
                break;
            }
            ++idx;
        }
        return hiddenNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(Trace t, UiClusterQueueManager uiObj) {
        uiObj.getTreeNode();
        TreeNode node = uiObj.getTreeNode();
        TreeNode parentNode = null;
        if (node != null && (parentNode = node.getParent()) != null) {
            Object object = this.treelock;
            synchronized (object) {
                TreeNode hiddenChild = null;
                if (node.isVisible()) {
                    hiddenChild = this.checkRemoveNodeHiddenStatus(t, parentNode, uiObj);
                }
                uiObj.setTreeNode(null);
                Display.getDefault().syncExec((Runnable)new RemoveTreeNodeRunnable(t, parentNode, node));
                if (hiddenChild != null) {
                    hiddenChild.setVisible(true);
                    Display.getDefault().asyncExec((Runnable)new UpdateTreeNodeRunnable(t, hiddenChild));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNode(Trace t, UiClusterQueueManager uiObj) {
        TreeNode node = uiObj.getTreeNode();
        Object object = this.treelock;
        synchronized (object) {
            if (node != null) {
                Display.getDefault().asyncExec((Runnable)new UpdateTreeNodeRunnable(t, node));
            }
        }
    }
}

