/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.actions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.clusterplugin.internal.ClusterPlugin;
import com.ibm.mq.explorer.clusterplugin.internal.clusqmgr.UiClusterQueueManager;
import com.ibm.mq.explorer.clusterplugin.internal.clusqmgr.UiClusterQueueManagerFactory;
import com.ibm.mq.explorer.clusterplugin.internal.objects.ClusterObject;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.ops.ClusterChannelAlterOperation;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.ops.ClusterChannelDeleteOperation;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.ops.ClusterChannelStopOperation;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.ops.ClusterRefreshClusterOperation;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.ops.ClusterWizardOperations;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.ops.QmgrRemoveRepositoryAttrOperation;
import com.ibm.mq.explorer.clusterplugin.internal.wizards.ops.SuspendFromClusterOperation;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmClusterQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.pcf.event.PCFFilter;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RemoveQueueManagerFromCluster
extends ClusterWizardOperations
implements Runnable,
DmObjectListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/actions/RemoveQueueManagerFromCluster.java";
    private UiClusterQueueManager uiObj = null;
    private DmQueueManager qmgr = null;
    private String clusname = "";
    private String fREPOSNL = "";
    private BusyDialog busy = null;
    private String fCLUSNL = null;

    public RemoveQueueManagerFromCluster(UiClusterQueueManager object) {
        Trace t = Trace.getDefault();
        this.uiObj = object;
        this.qmgr = this.uiObj.getRealQueueManager(t);
        this.init(t);
    }

    public void init(Trace t) {
        this.fREPOSNL = this.qmgr.getAttributeValue(t, 2036, 0);
        if (!this.fREPOSNL.equals("")) {
            this.fFailed = true;
        }
    }

    @Override
    public void run() {
        Trace t = Trace.getDefault();
        this.clusname = this.uiObj.getClusterAttr();
        ClusterObject clusterObj = this.uiObj.getCluster(t);
        DmQueueManager qmSourceRepository = clusterObj.getProvider();
        if (!this.fFailed) {
            String title = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4188", (String[])new String[]{this.qmgr.getTitle(), this.clusname});
            int result = MessageBox.showYesNoMessage((Trace)t, null, (String)title, (int)1, (String)"AMQ4188");
            if (result == 0) {
                ArrayList<UiClusterQueueManager> fulls = this.uiObj.getCluster(t).getFullRepositoryContainer().getClusterQueueManagers();
                ArrayList<UiClusterQueueManager> parts = this.uiObj.getCluster(t).getPartRepositoryContainer().getClusterQueueManagers();
                boolean isFullRepos = this.uiObj.isFullRepository(t);
                if (fulls.size() == 1 && isFullRepos && parts.size() > 0) {
                    String warningMsg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4404", (String[])new String[]{this.qmgr.getTitle(), this.clusname});
                    int r = MessageBox.showYesNoMessage((Trace)t, null, (String)warningMsg, (int)1, (String)"AMQ4404");
                    if (r == 0) {
                        this.doRemove(t);
                    }
                } else if (qmSourceRepository.equals((Object)this.uiObj.getRealQueueManager(t))) {
                    String warningMsg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4524", (String[])new String[]{this.qmgr.getTitle(), this.clusname});
                    int r = MessageBox.showYesNoMessage((Trace)t, null, (String)warningMsg, (int)1, (String)"AMQ4524");
                    if (r == 0) {
                        this.doRemove(t);
                    }
                } else {
                    this.doRemove(t);
                }
            }
        } else {
            String userMsg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4092");
            String formMsg = Message.format((String)userMsg, (String)this.fREPOSNL);
            MessageBox.showMessageFailure((Trace)t, (Shell)UiPlugin.getShell(), (String)formMsg, (String)"AMQ4092");
        }
    }

    private void doRemove(Trace t) {
        String busyMessage = Message.format((String)ClusterPlugin.getResourceString("UI.QMGR.RemoveFromCluster.BusyText"), (String)this.qmgr.getTitle(), (String)this.clusname);
        this.busy = new BusyDialog(UiPlugin.getShell(), busyMessage);
        PCFFilter pcfFilter = PCFFilter.getFilter((int)2029, (PCFFilter.Operation)PCFFilter.EQUAL_TO, (String)this.clusname);
        DmObjectFilter filter = new DmObjectFilter(t, 70, pcfFilter);
        this.qmgr.getObjects(t, (DmObjectListListener)this, filter);
        this.busy.showDialog(t);
    }

    public void dmObjectAdded(DmObjectEvent event) {
    }

    public void dmObjectChanged(DmObjectEvent event) {
    }

    public void dmObjectDeleted(DmObjectEvent event) {
    }

    public void dmRefreshComplete(DmObjectEvent event) {
    }

    public void dmObjectSummary(DmObjectSummaryEvent event) {
    }

    public void dmObjectListDone(DmObjectListEvent event) {
        final Trace t = Trace.getDefault();
        final DmObjectListEvent lEvent = event;
        final Display display = UiPlugin.getDisplay();
        new Thread(){

            @Override
            public void run() {
                DmChannel fChanHandle;
                ArrayList channelList;
                DmObjectFilter filter;
                UiClusterQueueManager uiObject;
                ArrayList<UiClusterQueueManager> rcvr = new ArrayList<UiClusterQueueManager>();
                ArrayList<UiClusterQueueManager> sdr = new ArrayList<UiClusterQueueManager>();
                ArrayList<DmQueueManager> qmgrs = new ArrayList<DmQueueManager>();
                this.setName("IBM MQ Cluster Comp : Remove cluster queue manager " + RemoveQueueManagerFromCluster.this.qmgr.getTitle());
                ArrayList list = lEvent.getList();
                boolean isRepos = false;
                int idx = 0;
                while (idx < list.size()) {
                    DmClusterQueueManager dmObject = (DmClusterQueueManager)list.get(idx);
                    UiClusterQueueManagerFactory factory = new UiClusterQueueManagerFactory(null);
                    UiClusterQueueManager uiObject2 = (UiClusterQueueManager)factory.create(t, (DmObject)dmObject, null);
                    String channel = uiObject2.getChannelNameAttr();
                    qmgrs.add(dmObject.getRealQueueManager(t, true));
                    if (Trace.isTracing) {
                        t.data(66, "RemoveQueueManagerFromCluster.run", 300, "Found channel: " + channel + " on qmgr " + dmObject.toString(t));
                    }
                    if (uiObject2.isClusterReceiverDefinition(t)) {
                        rcvr.add(uiObject2);
                        if (Trace.isTracing) {
                            t.data(66, "RemoveQueueManagerFromCluster.run", 300, "Channel '" + channel + "' added to reciver list");
                        }
                        if (uiObject2.isFullRepository(t)) {
                            isRepos = true;
                        }
                    } else if (uiObject2.isExplicitClusterSenderDefinition(t) || uiObject2.isAutoAndExplicitClusterSenderDefinition(t)) {
                        sdr.add(uiObject2);
                        if (Trace.isTracing) {
                            t.data(66, "RemoveQueueManagerFromCluster.run", 300, "Channel '" + channel + "' added to sender list");
                        }
                    }
                    ++idx;
                }
                RemoveQueueManagerFromCluster.this.operations.add(new SuspendFromClusterOperation(RemoveQueueManagerFromCluster.this.qmgr, RemoveQueueManagerFromCluster.this.clusname));
                if (isRepos) {
                    RemoveQueueManagerFromCluster.this.operations.add(new QmgrRemoveRepositoryAttrOperation(RemoveQueueManagerFromCluster.this.qmgr, RemoveQueueManagerFromCluster.this.clusname));
                }
                boolean usingCLUSNL = false;
                int idx2 = 0;
                while (idx2 < rcvr.size()) {
                    uiObject = (UiClusterQueueManager)((Object)rcvr.get(idx2));
                    filter = new DmObjectFilter(t, uiObject.getChannelNameAttr(), 25);
                    try {
                        channelList = RemoveQueueManagerFromCluster.this.qmgr.getObjects(t, filter);
                        fChanHandle = (DmChannel)channelList.get(0);
                        RemoveQueueManagerFromCluster.this.fCLUSNL = fChanHandle.getAttributeValue(t, 2030, 0);
                        if (!RemoveQueueManagerFromCluster.this.fCLUSNL.equals("")) {
                            usingCLUSNL = true;
                            break;
                        }
                        RemoveQueueManagerFromCluster.this.operations.add(new ClusterChannelStopOperation(RemoveQueueManagerFromCluster.this.qmgr, RemoveQueueManagerFromCluster.this.clusname, fChanHandle, true));
                        RemoveQueueManagerFromCluster.this.operations.add(new ClusterChannelAlterOperation(RemoveQueueManagerFromCluster.this.qmgr, RemoveQueueManagerFromCluster.this.clusname, fChanHandle));
                        RemoveQueueManagerFromCluster.this.operations.add(new ClusterChannelDeleteOperation(RemoveQueueManagerFromCluster.this.qmgr, RemoveQueueManagerFromCluster.this.clusname, fChanHandle));
                    }
                    catch (DmCoreException e) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                RemoveQueueManagerFromCluster.this.busy.closeDialog(t);
                                MessageBox.showExceptionMessage((Trace)t, (Shell)UiPlugin.getShell(), (DmCoreException)e);
                            }
                        });
                    }
                    for (DmQueueManager sdrqmgr : qmgrs) {
                        if (sdrqmgr == RemoveQueueManagerFromCluster.this.qmgr || sdrqmgr == null) continue;
                        if (Trace.isTracing) {
                            t.data(66, "RemoveQueueManagerFromCluster.run", 300, "Checking for sender channels on qmgr: " + sdrqmgr.toString(t));
                        }
                        t.data(66, "RemoveQueueManagerFromCluster.run", 300, "Checking for sender channels on qmgr: " + sdrqmgr.toString(t));
                        uiObject = (UiClusterQueueManager)((Object)rcvr.get(idx2));
                        filter = new DmObjectFilter(t, uiObject.getChannelNameAttr(), 25);
                        try {
                            ArrayList channelList2 = sdrqmgr.getObjects(t, filter);
                            if (channelList2.size() <= 0) continue;
                            DmChannel fChanHandle2 = (DmChannel)channelList2.get(0);
                            RemoveQueueManagerFromCluster.this.fCLUSNL = fChanHandle2.getAttributeValue(t, 2030, 0);
                            if (!RemoveQueueManagerFromCluster.this.fCLUSNL.equals("")) {
                                usingCLUSNL = true;
                                break;
                            }
                            t.data(66, "RemoveQueueManagerFromCluster.run", 300, "adding opertaions to stop and remove sdr: " + fChanHandle2.toString(t) + " from qmgr: " + sdrqmgr.getTitle());
                            RemoveQueueManagerFromCluster.this.operations.add(new ClusterChannelStopOperation(sdrqmgr, RemoveQueueManagerFromCluster.this.clusname, fChanHandle2, true));
                            RemoveQueueManagerFromCluster.this.operations.add(new ClusterChannelAlterOperation(sdrqmgr, RemoveQueueManagerFromCluster.this.clusname, fChanHandle2));
                            RemoveQueueManagerFromCluster.this.operations.add(new ClusterChannelDeleteOperation(sdrqmgr, RemoveQueueManagerFromCluster.this.clusname, fChanHandle2));
                        }
                        catch (DmCoreException e) {
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    RemoveQueueManagerFromCluster.this.busy.closeDialog(t);
                                    MessageBox.showExceptionMessage((Trace)t, (Shell)UiPlugin.getShell(), (DmCoreException)e);
                                }
                            });
                        }
                    }
                    ++idx2;
                }
                if (!usingCLUSNL) {
                    idx2 = 0;
                    while (idx2 < sdr.size()) {
                        if (Trace.isTracing) {
                            t.data(66, "RemoveQueueManagerFromCluster.run", 300, "Checking for sender channels on qmgr: " + RemoveQueueManagerFromCluster.this.qmgr.toString(t));
                        }
                        uiObject = (UiClusterQueueManager)((Object)sdr.get(idx2));
                        filter = new DmObjectFilter(t, uiObject.getChannelNameAttr(), 25);
                        try {
                            channelList = RemoveQueueManagerFromCluster.this.qmgr.getObjects(t, filter);
                            fChanHandle = (DmChannel)channelList.get(0);
                            RemoveQueueManagerFromCluster.this.fCLUSNL = fChanHandle.getAttributeValue(t, 2030, 0);
                            if (!RemoveQueueManagerFromCluster.this.fCLUSNL.equals("")) {
                                usingCLUSNL = true;
                                break;
                            }
                            if (Trace.isTracing) {
                                t.data(66, "RemoveQueueManagerFromCluster.run", 300, "adding opertaions to stop and remove rcvr: " + fChanHandle.toString(t) + " from qmgr: " + RemoveQueueManagerFromCluster.this.qmgr.getTitle());
                            }
                            RemoveQueueManagerFromCluster.this.operations.add(new ClusterChannelStopOperation(RemoveQueueManagerFromCluster.this.qmgr, RemoveQueueManagerFromCluster.this.clusname, fChanHandle, true));
                            RemoveQueueManagerFromCluster.this.operations.add(new ClusterChannelAlterOperation(RemoveQueueManagerFromCluster.this.qmgr, RemoveQueueManagerFromCluster.this.clusname, fChanHandle));
                            RemoveQueueManagerFromCluster.this.operations.add(new ClusterChannelDeleteOperation(RemoveQueueManagerFromCluster.this.qmgr, RemoveQueueManagerFromCluster.this.clusname, fChanHandle));
                        }
                        catch (DmCoreException e) {
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    RemoveQueueManagerFromCluster.this.busy.closeDialog(t);
                                    MessageBox.showExceptionMessage((Trace)t, (Shell)UiPlugin.getShell(), (DmCoreException)e);
                                }
                            });
                        }
                        ++idx2;
                    }
                }
                if (!usingCLUSNL) {
                    RemoveQueueManagerFromCluster.this.fFailed = RemoveQueueManagerFromCluster.this.performAll(t);
                    if (!RemoveQueueManagerFromCluster.this.fFailed) {
                        for (DmQueueManager dmQm : qmgrs) {
                            if (dmQm == null || !new ClusterRefreshClusterOperation(dmQm, RemoveQueueManagerFromCluster.this.clusname).redo(t, null)) continue;
                            RemoveQueueManagerFromCluster.this.fFailed = true;
                            break;
                        }
                    }
                    if (RemoveQueueManagerFromCluster.this.fFailed) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                RemoveQueueManagerFromCluster.this.busy.closeDialog(t);
                                MessageBox.showMessageFailure((Trace)t, (Shell)UiPlugin.getShell(), (String)RemoveQueueManagerFromCluster.this.getfFailureMessageString());
                                UiPlugin.refreshNavigatorViews((Trace)t, (boolean)true);
                            }
                        });
                    } else {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                RemoveQueueManagerFromCluster.this.busy.closeDialog(t);
                                MessageBox.showSystemMessageById((Trace)t, (Shell)UiPlugin.getShell(), (String)"AMQ4501", null, (String)"AMQ4501");
                                UiPlugin.refreshNavigatorViews((Trace)t, (boolean)true);
                            }
                        });
                    }
                } else {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            String namelist = RemoveQueueManagerFromCluster.this.fCLUSNL;
                            RemoveQueueManagerFromCluster.this.busy.closeDialog(t);
                            String userMsg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4092");
                            String formMsg = Message.format((String)userMsg, (String)namelist);
                            MessageBox.showMessageFailure((Trace)t, (Shell)UiPlugin.getShell(), (String)formMsg, (String)"AMQ4092");
                            UiPlugin.refreshNavigatorViews((Trace)t, (boolean)true);
                        }
                    });
                }
            }
        }.start();
    }
}

