/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.actions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.clusterplugin.internal.ClusterPlugin;
import com.ibm.mq.explorer.clusterplugin.internal.clusqmgr.UiClusterQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RefreshClusterActionDialog
extends Dialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/actions/RefreshClusterActionDialog.java";
    private Shell shell = null;
    private UiClusterQueueManager uiObj = null;
    private Button refreshAllClusters = null;
    private Button clearRepositoryInformation = null;
    private Label label = null;
    private static final String UNEXPECTED_ERROR = "AMQ4999";
    private static final String REFRESH_OK = "AMQ4513";

    public RefreshClusterActionDialog(Shell parent, UiClusterQueueManager object) {
        this(parent, 0);
        this.uiObj = object;
    }

    public RefreshClusterActionDialog(Shell parent, int style) {
        super(parent, style);
    }

    public void open(Trace t) {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 68848);
        this.shell.setText(Message.format((String)ClusterPlugin.getResourceString("UI.DIA.REFRESH.RefreshCluster.Title"), (String)this.uiObj.getClusterQueueManagerNameAttr()));
        UiUtils.setHelp((Control)this.shell, (String)"com.ibm.mq.explorer.ui.infopop.UI_ClusterRefreshDialog");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = false;
        this.shell.setLayout((Layout)gridLayout);
        Group swtgroup = new Group((Composite)this.shell, 0);
        swtgroup.setText(ClusterPlugin.getResourceString("UI.DIA.REFRESH.RefreshClusterOptions.Group"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        swtgroup.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        swtgroup.setLayoutData((Object)gridData);
        Button refreshOneCluster = new Button((Composite)swtgroup, 16);
        refreshOneCluster.setText(Message.format((String)ClusterPlugin.getResourceString("UI.DIA.REFRESH.RefreshOneCluster.Label"), (String)this.uiObj.getClusterAttr()));
        gridData = new GridData(256);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        refreshOneCluster.setLayoutData((Object)gridData);
        refreshOneCluster.setSelection(true);
        this.refreshAllClusters = new Button((Composite)swtgroup, 16);
        this.refreshAllClusters.setText(ClusterPlugin.getResourceString("UI.DIA.REFRESH.RefreshAllClusters.Label"));
        gridData = new GridData(256);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        this.refreshAllClusters.setLayoutData((Object)gridData);
        DmQueueManager qm = this.uiObj.getRealQueueManager(t);
        if (qm != null && qm.getCommandLevel() < 530) {
            this.refreshAllClusters.setEnabled(false);
        }
        this.label = new Label((Composite)this.shell, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.label.setLayoutData((Object)gridData);
        this.clearRepositoryInformation = new Button((Composite)this.shell, 32);
        this.clearRepositoryInformation.setText(ClusterPlugin.getResourceString("UI.DIA.REFRESH.ClearReposInfo.Label"));
        gridData = new GridData(256);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.refreshAllClusters.setLayoutData((Object)gridData);
        if (this.uiObj.isFullRepository(t)) {
            this.clearRepositoryInformation.setEnabled(false);
        }
        this.label = new Label((Composite)this.shell, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.label.setLayoutData((Object)gridData);
        Composite compButtons = new Composite((Composite)this.shell, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 7;
        compButtons.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 7;
        gridData.grabExcessHorizontalSpace = true;
        compButtons.setLayoutData((Object)gridData);
        this.label = new Label(compButtons, 0);
        this.label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 200;
        this.label.setLayoutData((Object)gridData);
        this.label = new Label(compButtons, 0);
        this.label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        this.label.setLayoutData((Object)gridData);
        Button buttonOK = new Button(compButtons, 8);
        buttonOK.setText(ClusterPlugin.getResourceString("UI.GENERAL.OK"));
        buttonOK.setEnabled(true);
        GridData gridDataOK = new GridData();
        gridDataOK.horizontalAlignment = 3;
        buttonOK.setLayoutData((Object)gridDataOK);
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                RefreshClusterActionDialog.this.okSelected(t2);
            }
        });
        Button buttonCancel = new Button(compButtons, 8);
        buttonCancel.setText(ClusterPlugin.getResourceString("UI.GENERAL.CANCEL"));
        GridData gridDataCancel = new GridData();
        gridDataCancel.horizontalAlignment = 3;
        buttonCancel.setLayoutData((Object)gridDataCancel);
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RefreshClusterActionDialog.this.shell.close();
            }
        });
        this.shell.setDefaultButton(buttonOK);
        int maxWidth = 0;
        Point sizeOK = buttonOK.computeSize(-1, -1);
        Point sizeCancel = buttonCancel.computeSize(-1, -1);
        if (sizeOK.x > maxWidth) {
            maxWidth = sizeOK.x;
        }
        if (sizeCancel.x > maxWidth) {
            maxWidth = sizeCancel.x;
        }
        gridDataOK.widthHint = maxWidth;
        gridDataCancel.widthHint = maxWidth;
        this.shell.pack();
        this.shell.layout();
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void okSelected(Trace t) {
        boolean allClusters = this.refreshAllClusters.getSelection();
        int clearInfo = this.clearRepositoryInformation.getSelection() ? 1 : 0;
        final int result = this.uiObj.issueRefreshCommand(t, clearInfo, allClusters);
        Display display = UiPlugin.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Trace t2 = Trace.getDefault();
                Shell sh = UiPlugin.getShell();
                if (result == 0) {
                    MessageBox.showSystemMessageById((Trace)t2, (Shell)sh, (String)RefreshClusterActionDialog.REFRESH_OK);
                } else {
                    if (Trace.isTracing) {
                        t2.data(66, "RefreshClusterActionDialog.okSelected", 900, "result: " + result + " refresh QueueManager in cluster");
                    }
                    String insert = Integer.toString(result);
                    String message = CommonServices.getSystemMessage((Trace)t2, (String)RefreshClusterActionDialog.UNEXPECTED_ERROR, (String)insert);
                    MessageBox.showMessageFailure((Trace)t2, (Shell)sh, (String)message, (String)RefreshClusterActionDialog.UNEXPECTED_ERROR);
                }
            }
        });
        this.shell.close();
    }
}

