/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.actions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmNamelist;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import java.util.ArrayList;

public class NamelistActions {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/actions/NamelistActions.java";

    public static boolean createNamelist(Trace trace, String name, DmQueueManager qmgr, ArrayList contents) {
        DmNamelist newnamelist = (DmNamelist)DmObject.clone((Trace)trace, (DmQueueManager)qmgr, (String)name, (int)36, (int)0);
        Object jobid = newnamelist.beginUpdate(trace);
        newnamelist.setAttributeValue(trace, jobid, 2020, 0, (Object)contents);
        int returncode = newnamelist.actionCreate(trace, null, jobid);
        return returncode == 0;
    }

    public static boolean addToNamelist(Trace trace, String name, String newentry, DmQueueManager qmgr) {
        ArrayList nlists;
        if (name.trim().equals("")) {
            return false;
        }
        try {
            nlists = qmgr.getObjects(trace, new DmObjectFilter(trace, 36));
        }
        catch (DmCoreException dmCoreException) {
            nlists = new ArrayList();
        }
        int numnamelists = nlists.size();
        DmNamelist namelist = null;
        int i = 0;
        while (i < numnamelists) {
            DmNamelist nxtNamelist = (DmNamelist)nlists.get(i);
            if (nxtNamelist.getTitle().equals(name)) {
                namelist = nxtNamelist;
                break;
            }
            ++i;
        }
        if (namelist == null) {
            return false;
        }
        Attr contentsattr = namelist.getAttribute(trace, 2020, 0);
        ArrayList contents = (ArrayList)contentsattr.getValue(trace);
        boolean added = contents.add(newentry);
        if (!added) {
            return false;
        }
        Object jobid = namelist.beginUpdate(trace);
        namelist.setAttributeValue(trace, jobid, 2020, 0, (Object)contents);
        namelist.actionChange(trace, null, jobid, false);
        namelist.endUpdate(trace, jobid);
        return true;
    }

    public static void removeFromNamelist(Trace t, String name, String entry, DmQueueManager qmgr) {
        ArrayList nlists;
        if (name.trim().equals("")) {
            return;
        }
        try {
            nlists = qmgr.getObjects(t, new DmObjectFilter(t, 36));
        }
        catch (DmCoreException dmCoreException) {
            nlists = new ArrayList();
        }
        int numnamelists = nlists.size();
        DmNamelist namelist = null;
        int i = 0;
        while (i < numnamelists) {
            DmNamelist nxtNamelist = (DmNamelist)nlists.get(i);
            if (nxtNamelist.getTitle().equals(name)) {
                namelist = nxtNamelist;
                break;
            }
            ++i;
        }
        if (namelist == null) {
            return;
        }
        Attr contentsattr = namelist.getAttribute(t, 2020, 0);
        ArrayList contents = (ArrayList)contentsattr.getValue(t);
        boolean removed = contents.remove(entry);
        if (removed) {
            Object jobid = namelist.beginUpdate(t);
            namelist.setAttributeValue(t, jobid, 2020, 0, (Object)contents);
            namelist.actionChange(t, null, jobid, false);
            namelist.endUpdate(t, jobid);
        }
    }
}

