/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal.actions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.clusterplugin.internal.ClusterPlugin;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListListener;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmNamelist;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class GetReceiverChannelNames
implements IRunnableWithProgress,
DmObjectListListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/actions/GetReceiverChannelNames.java";
    private DmQueueManager selectedqueuemanager;
    private DmChannel[] results = null;
    private String cluster;

    public void init(DmQueueManager qmgr, String clusname) {
        this.selectedqueuemanager = qmgr;
        this.cluster = clusname;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Trace trace = Trace.getDefault();
        monitor.done();
        monitor.beginTask(String.valueOf(ClusterPlugin.getResourceString("UI.QMGR.Accessing.Wizard")) + this.selectedqueuemanager.getTreeName(Trace.getDefault()), -1);
        if (this.selectedqueuemanager == null) {
            throw new InterruptedException();
        }
        monitor.done();
        monitor.beginTask(ClusterPlugin.getResourceString("UI.QMGR.GetChannels.Wizard"), -1);
        DmObjectFilter filter = new DmObjectFilter(trace, 25, 8);
        this.selectedqueuemanager.getObjects(trace, (DmObjectListListener)this, filter);
        while (this.results == null) {
            Thread.sleep(1000L);
        }
    }

    public final String[] getChannelNames() {
        if (this.results != null) {
            String[] names = new String[this.results.length];
            int i = 0;
            while (i < this.results.length) {
                names[i] = this.results[i].getTitle();
                ++i;
            }
            return names;
        }
        return new String[0];
    }

    public final DmChannel[] getChannels() {
        return this.results;
    }

    public void dmObjectListDone(DmObjectListEvent event) {
        Trace t = Trace.getDefault();
        ArrayList response = event.getList();
        ArrayList<DmChannel> res = new ArrayList<DmChannel>();
        if (Trace.isTracing) {
            t.data(66, "GetReceiverChannelNames.dmObjectListDone", 300, "Looking for receiver channels for cluster: " + this.cluster);
        }
        for (DmChannel chan : response) {
            if (Trace.isTracing) {
                t.data(66, "GetReceiverChannelNames.dmObjectListDone", 300, "Checking channel: " + chan.toString(t));
            }
            String clus = "";
            String clusnl = "";
            clus = chan.getAttributeValue(t, 2029, 0);
            clusnl = chan.getAttributeValue(t, 2030, 0);
            if (Trace.isTracing) {
                t.data(66, "GetReceiverChannelNames.dmObjectListDone", 300, "CLUS   = " + clus);
                t.data(66, "GetReceiverChannelNames.dmObjectListDone", 300, "CLUSNL = " + clusnl);
            }
            if (clus.equals(this.cluster)) {
                if (Trace.isTracing) {
                    t.data(66, "GetReceiverChannelNames.dmObjectListDone", 300, "CLUS field matched, adding to list");
                }
                res.add(chan);
                continue;
            }
            if (clusnl.equals("")) continue;
            if (Trace.isTracing) {
                t.data(66, "GetReceiverChannelNames.dmObjectListDone", 300, "CLUSNL field not empty - scanning namelist: " + clusnl);
            }
            ArrayList al = null;
            try {
                al = this.selectedqueuemanager.getObjects(t, new DmObjectFilter(t, clusnl, 36));
            }
            catch (DmCoreException dmCoreException) {}
            if (al == null) continue;
            for (DmNamelist nl : al) {
                String names = nl.getAttributeValue(t, 2020, 0);
                if (Trace.isTracing) {
                    t.data(66, "GetReceiverChannelNames.dmObjectListDone", 300, "Namelist contents: " + names);
                }
                if (names.indexOf(this.cluster) == -1) continue;
                if (Trace.isTracing) {
                    t.data(66, "GetReceiverChannelNames.dmObjectListDone", 300, "Cluster name found in namelist, adding to list");
                }
                res.add(chan);
            }
        }
        this.results = res.toArray(new DmChannel[res.size()]);
    }
}

