/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.clusterplugin.internal.ClusterPlugin;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public final class ImageCache {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/ImageCache.java";

    private ImageCache() {
    }

    public static final Image getImage(Trace t, String filename) {
        Image img = ClusterPlugin.getDefault().getImageRegistry().get(filename);
        if (img == null) {
            try {
                String iconPath = "icons/";
                Bundle bund = ClusterPlugin.getDefault().getBundle();
                URL url = bund.getEntry(String.valueOf(iconPath) + filename);
                ImageDescriptor imgDesc = ImageDescriptor.createFromURL((URL)url);
                img = imgDesc.createImage();
            }
            catch (NullPointerException nullPointerException) {
                img = ImageCache.makeBrokenImage(t);
            }
            ClusterPlugin.getDefault().getImageRegistry().put(filename, img);
        }
        return img;
    }

    private static Image makeBrokenImage(Trace t) {
        Image broken_image = new Image((Device)Display.getDefault(), 32, 32);
        GC gc = new GC((Drawable)broken_image);
        gc.drawLine(0, 0, 31, 31);
        gc.drawLine(0, 31, 31, 0);
        gc.dispose();
        return broken_image;
    }
}

