/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.clusterplugin.internal.ClusterPlugin;
import com.ibm.mq.explorer.clusterplugin.internal.factory.ClusterFactory;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.event.DmQueueManagerListener;
import com.ibm.mq.explorer.core.internal.objects.DmClusterQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.ui.extensions.ExplorerNotifyEvent;
import com.ibm.mq.explorer.ui.extensions.IExplorerNotify;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrder;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;

public class ExplorerRegistrationRoot
implements IExplorerNotify,
DmQueueManagerListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/ExplorerRegistrationRoot.java";
    private boolean explorerShutdown = false;
    private boolean pluginEnabled = false;
    private static ExplorerRegistrationRoot root = null;

    public ExplorerRegistrationRoot() {
        root = this;
    }

    public ExplorerRegistrationRoot getDefault() {
        return root;
    }

    public void explorerInitialised() {
        Trace t = Trace.getDefault();
        int[] attrIds = new int[]{2031, 2032, 3506};
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        int[] order = nArray;
        String orderName = ClusterPlugin.getResourceString("UI.WIZ.INFPROV.RepositorySchemeLabel");
        Message msgFile = UiPlugin.getUIMessages((Trace)t, (String)"KEY_Schemes");
        String nameDist = msgFile.getMessage(t, "UI.SCHEMES.Distrib.Name");
        String nameZOS = msgFile.getMessage(t, "UI.SCHEMES.zOS.Name");
        String copyDistToZos = msgFile.getMessage(t, "UI.SCHEMES.Button.CopyDistToZos");
        String copyZosToDist = msgFile.getMessage(t, "UI.SCHEMES.Button.CopyZosToDist");
        int[] allAttrs = attrIds;
        int[] orderDistributed = order;
        AttributeOrder newOrder = new AttributeOrder(t, "com.ibm.mq.explorer.orderid.clusterqueuemanagers", orderName, "com.ibm.mq.explorer.clusterqueuemanager", false, false);
        newOrder.setDualOrderNames(t, nameDist, nameZOS);
        newOrder.setCopyButtonNames(t, copyDistToZos, copyZosToDist);
        int i = 0;
        while (i < allAttrs.length) {
            String name = DmClusterQueueManager.getAttributeTitle((Trace)t, (int)allAttrs[i]);
            newOrder.add(t, new AttributeOrderItem(t, allAttrs[i], name, orderDistributed[i], orderDistributed[i]));
            ++i;
        }
        newOrder.setOrderUniversalId("com.ibm.mq.explorer.scheme.uid.clusterreposqueuemanager");
        AttributeOrderManager attrOrderManager = UiPlugin.getAttributeOrderManager();
        attrOrderManager.addUserDefinedOrder(t, "com.ibm.mq.explorer.orderid.clusterqueuemanagers", newOrder);
    }

    private void processQueueManager(final Trace t, final DmObjectEvent event) {
        new Thread(){

            @Override
            public void run() {
                block3: {
                    this.setName("Cluster Component Event Process Thread");
                    ClusterFactory factory = ClusterFactory.getDefault();
                    try {
                        if (!ExplorerRegistrationRoot.this.explorerShutdown && factory != null) {
                            factory.ProcessQueueManagerEvent(t, event);
                        }
                    }
                    catch (Exception e) {
                        if (!Trace.isTracing) break block3;
                        t.data(66, "ExplorerRegistrationRoot.processQueueManager", 900, "Error processing event " + e.getMessage());
                    }
                }
            }
        }.start();
    }

    public void queueManagerAdded(ExplorerNotifyEvent event) {
    }

    public boolean isPreventRemoveQueueManager(ExplorerNotifyEvent event) {
        return false;
    }

    public boolean isPreventDeleteQueueManager(ExplorerNotifyEvent event) {
        Trace t = Trace.getDefault();
        boolean veto = true;
        MQQmgrExtObject exObj = (MQQmgrExtObject)event.getSource();
        UiQueueManager uiObj = (UiQueueManager)exObj.getInternalObject();
        DmQueueManager dmObj = (DmQueueManager)uiObj.getDmObject();
        String qmname = uiObj.toString();
        ClusterFactory factory = ClusterFactory.getDefault();
        if (factory.isMemberOfCluster(t, dmObj)) {
            String sysMsg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4198", (String)qmname);
            int result = MessageBox.showDeleteCancelMessage((Trace)t, null, (String)sysMsg, (int)1, (String)"AMQ4198");
            if (result == 0) {
                veto = false;
            }
        } else {
            veto = false;
        }
        return veto;
    }

    public boolean isPreventStopQueueManager(ExplorerNotifyEvent event) {
        return false;
    }

    public void queueManagerRemoved(ExplorerNotifyEvent event) {
    }

    public void queueManagerDeleted(ExplorerNotifyEvent event) {
    }

    public void queueManagerStopped(ExplorerNotifyEvent event) {
    }

    public void queueManagerStarted(ExplorerNotifyEvent event) {
    }

    public void queueManagerShown(ExplorerNotifyEvent event) {
    }

    public void queueManagerHidden(ExplorerNotifyEvent event) {
    }

    public void viewOpened(ExplorerNotifyEvent event) {
    }

    public void viewClosed(ExplorerNotifyEvent event) {
    }

    public void pluginEnabled(ExplorerNotifyEvent event) {
        Trace t = Trace.getDefault();
        if (event.getId().equals("com.ibm.mq.explorer.clusterplugin")) {
            UiPlugin.getTheDataModel().addObserver(t, (DmObjectListener)this, null);
            this.pluginEnabled = true;
        }
    }

    public void pluginDisabled(ExplorerNotifyEvent event) {
        Trace t = Trace.getDefault();
        if (event.getId().equals("com.ibm.mq.explorer.clusterplugin") && this.pluginEnabled) {
            ClusterFactory factory = ClusterFactory.getDefault();
            factory.pluginDisabled(t);
            UiPlugin.getTheDataModel().deleteObserver(t, (DmObjectListener)this);
            this.pluginEnabled = false;
        }
    }

    public void explorerClosing() {
        this.explorerShutdown = true;
    }

    public void dmQueueManagerShown(DmObjectEvent event) {
        Trace trace = Trace.getDefault();
        DmQueueManager qmgr = (DmQueueManager)event.getSource();
        if (Trace.isTracing) {
            trace.data(66, "ExplorerRegistrationRoot.dmQueueManagerShown", Integer.MIN_VALUE, "event received for: " + qmgr.getTitle());
        }
        if (qmgr.isConnected()) {
            this.processQueueManager(trace, event);
        }
    }

    public void dmQueueManagerHidden(DmObjectEvent event) {
        Trace trace = Trace.getDefault();
        DmQueueManager qmgr = (DmQueueManager)event.getSource();
        if (qmgr.isConnected()) {
            this.processQueueManager(trace, event);
        }
    }

    public void dmQueueManagerConnected(DmObjectEvent event) {
        Trace trace = Trace.getDefault();
        DmQueueManager qmgr = (DmQueueManager)event.getSource();
        if (qmgr.isVisible(trace)) {
            this.processQueueManager(trace, event);
        }
    }

    public void dmQueueManagerDisconnected(DmObjectEvent event) {
        Trace trace = Trace.getDefault();
        DmQueueManager qmgr = (DmQueueManager)event.getSource();
        if (qmgr.isVisible(trace)) {
            this.processQueueManager(trace, event);
        }
    }

    public void dmQueueManagerConnecting(DmObjectEvent event) {
    }

    public void dmObjectAdded(DmObjectEvent event) {
    }

    public void dmObjectChanged(DmObjectEvent event) {
    }

    public void dmObjectDeleted(DmObjectEvent event) {
    }

    public void dmRefreshComplete(DmObjectEvent event) {
    }

    public void dmObjectListDone(DmObjectListEvent event) {
    }

    public void dmObjectSummary(DmObjectSummaryEvent event) {
    }

    public void explorerPreferenceChanged(ExplorerNotifyEvent event) {
    }
}

