/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.clusterplugin.internal;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.clusterplugin.internal.listeners.FieldChangeListener;
import com.ibm.mq.explorer.clusterplugin.internal.objects.ClusterObject;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import java.util.Vector;

public class ClusterInformationProvider {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.clusterplugin/src/com/ibm/mq/explorer/clusterplugin/internal/ClusterInformationProvider.java";
    private FieldChangeListener fieldListener = null;
    private DmQueueManager theQmgr = null;
    private boolean listenerStarted = false;

    public ClusterInformationProvider(Trace t, DmQueueManager qmgr) {
        this.theQmgr = qmgr;
        this.fieldListener = new FieldChangeListener(t, this.theQmgr);
    }

    public void beginListener(Trace t) {
        if (!this.listenerStarted) {
            this.fieldListener.initialise(t);
            DmObjectFilter filter = new DmObjectFilter(t, 2);
            this.theQmgr.addObserver(t, (DmObjectListener)this.fieldListener, filter);
            this.listenerStarted = true;
        }
    }

    public void endListener(Trace t) {
        this.theQmgr.deleteObserver(t, (DmObjectListener)this.fieldListener);
        this.listenerStarted = false;
    }

    public void addCluster(Trace t, ClusterObject cluster) {
        this.fieldListener.addCluster(t, cluster);
    }

    public void removeCluster(Trace t, ClusterObject cluster) {
        this.fieldListener.removeCluster(t, cluster);
    }

    public Vector getClusters(Trace t) {
        return this.fieldListener.getClusters();
    }

    public boolean contains(Trace t, ClusterObject cluster) {
        boolean found = false;
        Vector clusters = this.fieldListener.getClusters();
        int idx = 0;
        while (idx < clusters.size()) {
            if (clusters.contains(cluster)) {
                found = true;
                break;
            }
            ++idx;
        }
        return found;
    }

    public DmQueueManager getProvider() {
        return this.theQmgr;
    }
}

