/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.tests.internal.tests;

import com.ibm.mq.MQException;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.oam.tests.internal.OamTestsPlugin;
import com.ibm.mq.explorer.oam.tests.internal.tests.OamTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFMessageAgent;
import com.ibm.mq.pcf.event.PCFQuery;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;

public class UserAppSystemUser
extends OamTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam.tests/src/com/ibm/mq/explorer/oam/tests/internal/tests/UserAppSystemUser.java";
    private static final String USER_APP_SYSTEM_USER_MESSAGE = "OAM.Test.Message.User.App.System.User";
    private static final String QMGR_DISCONNECTED = "OAM.Test.Message.QMgr.Disconnected";

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        String errorMessage = null;
        Trace t = Trace.getDefault();
        this.testResults.clear();
        String pluginName = OamTestsPlugin.testMessages.getMessage("OAM.Plugin.Name");
        super.runTest(callback, guimonitor, contextObjects, treenode);
        guimonitor.beginTask(pluginName, -1);
        int i = 0;
        while (i < contextObjects.length) {
            if (contextObjects[i] instanceof MQQmgrExtObject) {
                MQQmgrExtObject nextQueueManager = (MQQmgrExtObject)contextObjects[i];
                if (nextQueueManager != null) {
                    block24: {
                        MQQueueManager qmgr = nextQueueManager.getMQQueueManager();
                        if (nextQueueManager.isConnected()) {
                            String qmgrName = nextQueueManager.getName();
                            if (Trace.isTracing) {
                                t.data(66, "UserAppSystemUser.runTest", 300, "Testing queue manager : " + qmgrName);
                            }
                            try {
                                String qmgrUserId = null;
                                PCFMessageAgent agent = new PCFMessageAgent(qmgr);
                                PCFMessage cmd = new PCFMessage(85);
                                cmd.addParameter(7007, PCFQuery.ALL_BINARY_NAMES);
                                cmd.addParameter(1107, PCFQuery.ALL_ATTRS);
                                PCFMessage[] responses = agent.send(cmd);
                                int responseIndex = 0;
                                while (responseIndex < responses.length) {
                                    if (responses[responseIndex].getIntParameterValue(1) == 7) {
                                        qmgrUserId = responses[responseIndex].getStringParameterValue(3025);
                                        break;
                                    }
                                    ++responseIndex;
                                }
                                if (qmgrUserId != null) {
                                    responseIndex = 0;
                                    while (responseIndex < responses.length) {
                                        if (qmgrUserId.equals(responses[responseIndex].getStringParameterValue(3025)) && responses[responseIndex].getIntParameterValue(1) == 25) {
                                            errorMessage = OamTestsPlugin.testMessages.getMessage(USER_APP_SYSTEM_USER_MESSAGE, responses[responseIndex].getStringParameterValue(3058).trim(), qmgrUserId.trim());
                                            this.testResult = new WMQTestResult(1, errorMessage, qmgrName, this.getTestSubCategory());
                                            this.testResults.add(this.testResult);
                                        }
                                        ++responseIndex;
                                    }
                                }
                                agent.disconnect();
                            }
                            catch (PCFException e) {
                                if (Trace.isTracing) {
                                    t.data(66, "UserAppSystemUser.runTest", 900, "PCF Error from send command\n" + (Object)((Object)e));
                                }
                                break block24;
                            }
                            catch (MQException mqe) {
                                if (Trace.isTracing) {
                                    t.data(66, "UserAppSystemUser.runTest", 900, "Error connecting\n" + (Object)((Object)mqe));
                                }
                                break block24;
                            }
                            catch (IOException e) {
                                if (Trace.isTracing) {
                                    t.data(66, "UserAppSystemUser.runTest", 900, "IO Error from send command\n" + e);
                                }
                                break block24;
                            }
                            catch (Exception e) {
                                if (Trace.isTracing) {
                                    t.data(66, "UserAppSystemUser.runTest", 900, "Error processing request\n" + e);
                                }
                                break block24;
                            }
                        }
                        errorMessage = OamTestsPlugin.testMessages.getMessage(QMGR_DISCONNECTED, this.getTestName().trim(), nextQueueManager.getName().trim());
                        this.testResult = new WMQTestResult(1, errorMessage, nextQueueManager.getName(), this.getTestSubCategory());
                        this.testResults.add(this.testResult);
                    }
                    guimonitor.worked(1);
                    if (this.isCancelled()) {
                        if (!Trace.isTracing) break;
                        t.data(66, "UserAppSystemUser.runTest", 300, "Quitting - test has been cancelled");
                        break;
                    }
                } else if (Trace.isTracing) {
                    t.data(66, "UserAppSystemUser.runTest", 900, "NULL MQExtObject");
                }
            } else if (Trace.isTracing) {
                t.data(66, "UserAppSystemUser.runTest", 900, "Not an MQQmgrExtObject : " + contextObjects[i].getName());
            }
            ++i;
        }
        WMQTestResult[] finalresults = this.testResults.toArray(new WMQTestResult[this.testResults.size()]);
        this.testComplete(finalresults);
    }
}

