/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.oam.tests.internal.tests;

import com.ibm.mq.MQQueueManager;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.oam.tests.internal.OamTestsPlugin;
import com.ibm.mq.explorer.oam.tests.internal.tests.OamTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import org.eclipse.core.runtime.IProgressMonitor;

public class NoAuthServInstalled
extends OamTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.oam.tests/src/com/ibm/mq/explorer/oam/tests/internal/tests/NoAuthServInstalled.java";
    private static final String NOT_INSTALLED_MESSAGE = "OAM.Test.Message.No.Auth.Serv";
    private static final String QMGR_DISCONNECTED = "OAM.Test.Message.QMgr.Disconnected";

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        String errorMessage = null;
        Trace t = Trace.getDefault();
        this.testResults.clear();
        String pluginName = OamTestsPlugin.testMessages.getMessage("OAM.Plugin.Name");
        super.runTest(callback, guimonitor, contextObjects, treenode);
        guimonitor.beginTask(pluginName, -1);
        int i = 0;
        while (i < contextObjects.length) {
            if (contextObjects[i] instanceof MQQmgrExtObject) {
                MQQmgrExtObject nextQueueManager = (MQQmgrExtObject)contextObjects[i];
                if (nextQueueManager != null) {
                    MQQueueManager qmgr = nextQueueManager.getMQQueueManager();
                    if (nextQueueManager.isConnected()) {
                        String qmgrName = nextQueueManager.getName();
                        if (Trace.isTracing) {
                            t.data(66, "NoAuthServInstalled.runTest", 300, "Testing queue manager : " + qmgrName);
                        }
                        if (!this.authorizationServicesInstalled(t, qmgr)) {
                            errorMessage = OamTestsPlugin.testMessages.getMessage(NOT_INSTALLED_MESSAGE);
                            this.testResult = new WMQTestResult(2, errorMessage, qmgrName, this.getTestSubCategory());
                            this.testResults.add(this.testResult);
                        }
                    } else {
                        errorMessage = OamTestsPlugin.testMessages.getMessage(QMGR_DISCONNECTED, this.getTestName().trim(), nextQueueManager.getName().trim());
                        this.testResult = new WMQTestResult(1, errorMessage, nextQueueManager.getName(), this.getTestSubCategory());
                        this.testResults.add(this.testResult);
                    }
                    guimonitor.worked(1);
                    if (this.isCancelled()) {
                        if (!Trace.isTracing) break;
                        t.data(66, "NoAuthServInstalled.runTest", 300, "Quitting - test has been cancelled");
                        break;
                    }
                } else if (Trace.isTracing) {
                    t.data(66, "NoAuthServInstalled.runTest", 900, "NULL MQExtObject");
                }
            } else if (Trace.isTracing) {
                t.data(66, "NoAuthServInstalled.runTest", 900, "Not an MQQmgrExtObject : " + contextObjects[i].getName());
            }
            ++i;
        }
        WMQTestResult[] finalresults = this.testResults.toArray(new WMQTestResult[this.testResults.size()]);
        this.testComplete(finalresults);
    }
}

