/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.views;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.event.DmMonitor;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.extensions.DragDropTreeNode;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.navigator.NavigatorContentProvider;
import com.ibm.mq.explorer.ui.internal.navigator.RootTreeNode;
import com.ibm.mq.explorer.ui.internal.plugins.PluginsChangedEvent;
import com.ibm.mq.explorer.ui.internal.plugins.PluginsChangedListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public class MQNavigatorView
extends CommonNavigator
implements PluginsChangedListener,
IPropertyChangeListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/views/MQNavigatorView.java";
    private boolean oldIsShowObjectStatus = false;
    private Set<TreeNode> nodesToExpand = new HashSet<TreeNode>();
    private NavigatorContentProvider provider;
    private IContextProvider viewContextProvider = null;

    public Object getAdapter(Class key) {
        if (key.equals(IContextProvider.class)) {
            if (this.viewContextProvider == null) {
                this.viewContextProvider = new NavigatorViewContextProvider();
            }
            return this.viewContextProvider;
        }
        return super.getAdapter(key);
    }

    protected IAdaptable getInitialInput() {
        return new RootTreeNode(null, null);
    }

    public void init(IViewSite aSite, IMemento aMemento) throws PartInitException {
        Trace t = Trace.getDefault();
        super.init(aSite, aMemento);
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        Action refreshAction = new Action(){

            public void run() {
                MQNavigatorView.this.refreshNavigationTree(Trace.getDefault(), null, true, true);
            }
        };
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_Actions");
        String text = msgFile.getMessage(t, "UI.ACTIONS.Toolbar.Refresh");
        String textToolTip = msgFile.getMessage(t, "UI.ACTIONS.Toolbar.Refresh.ToolTip");
        refreshAction.setText(text);
        refreshAction.setToolTipText(textToolTip);
        refreshAction.setImageDescriptor(Icons.getDescriptor(Icons.iconkeyRefresh));
        manager.add((IAction)refreshAction);
        manager.update(true);
        IMenuManager menu = bars.getMenuManager();
        menu.add((IAction)refreshAction);
        this.oldIsShowObjectStatus = UiPlugin.isShowObjectStatus();
        UiPlugin.getPrefStore().addPropertyChangeListener((IPropertyChangeListener)this);
        UiPlugin.getPluginRegistrationManager().addChangeListener(t, this);
        UiPlugin.addNavigatorView(t, this);
    }

    public void setFocus() {
        Control ctrl = this.getCommonViewer().getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            try {
                ctrl.setFocus();
                UiPlugin.getHelpSystem().setHelp(ctrl, "com.ibm.mq.explorer.ui.infopop.UI_NavigatorTree");
            }
            catch (SWTException sWTException) {}
        }
    }

    public CommonViewer getTreeViewer() {
        return this.getCommonViewer();
    }

    public void selectTreeNode(Trace t, TreeNode treeNode) {
        Object obj;
        TreeNode selTreeNode = null;
        CommonViewer treeViewer = this.getCommonViewer();
        ISelection select = treeViewer.getSelection();
        if (select != null && (obj = ((IStructuredSelection)select).getFirstElement()) != null) {
            selTreeNode = (TreeNode)((Object)obj);
        }
        if (selTreeNode != treeNode) {
            treeViewer.getTree().setFocus();
            StructuredSelection selection = new StructuredSelection((Object)treeNode);
            treeViewer.setSelection((ISelection)selection, true);
            treeViewer.reveal((Object)treeNode);
            if (Trace.isTracing) {
                t.data(67, "MQNavigatorView.selectTreeNode", 300, "Selecting treenode: " + treeNode.toString());
            }
        }
    }

    public void expandTreeNode(Trace t, final TreeNode treeNode) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MQNavigatorView.this.getCommonViewer().setExpandedState((Object)treeNode, true);
                if (!Arrays.asList(MQNavigatorView.this.getCommonViewer().getExpandedElements()).contains((Object)treeNode)) {
                    MQNavigatorView.this.nodesToExpand.add(treeNode);
                }
            }
        });
    }

    public void propertyChange(PropertyChangeEvent event) {
        Trace t = Trace.getDefault();
        String strProperty = event.getProperty();
        if (strProperty.compareTo("ShowObjectStatus") == 0) {
            boolean isShowObjectStatus = UiPlugin.isShowObjectStatus();
            boolean isRefresh = false;
            if (isShowObjectStatus != this.oldIsShowObjectStatus) {
                this.oldIsShowObjectStatus = isShowObjectStatus;
                isRefresh = true;
            }
            if (isRefresh) {
                if (Trace.isTracing) {
                    t.data(67, "MQNavigatorView.propertyChange", 300, "calling refresh...");
                }
                this.refreshNavigationTree(t, null, false, true);
            }
        }
    }

    public void setNavigatorProvider(NavigatorContentProvider provider) {
        this.provider = provider;
    }

    public TreeNode findTreeNode(Trace t, String treeNodeId) {
        TreeNode treeNode = null;
        if (this.provider != null) {
            treeNode = this.provider.findTreeNode(t, treeNodeId);
        }
        return treeNode;
    }

    public TreeNode findTreeNode(Trace t, DragDropTreeNode dragDropTreeNode) {
        TreeNode treeNode = this.findTreeNode(t, dragDropTreeNode.getTreeNodeId());
        if (treeNode != null && (treeNode.toString().compareTo(dragDropTreeNode.getTreeNodeName()) != 0 || treeNode.getPlugin_id().compareTo(dragDropTreeNode.getTreeNodePlugin_id()) != 0)) {
            treeNode = null;
        }
        return treeNode;
    }

    public void refreshNavigationTree(Trace t, TreeNode treeNode, boolean force, boolean isRebuildTree) {
        if (!UiPlugin.isShutdownInProgress()) {
            if (force) {
                DmMonitor.setUserRefresh((boolean)true);
                UiPlugin.getTheDataModel().refreshDmMonitor(t);
            }
            if (isRebuildTree && this.provider != null) {
                this.provider.setRebuildTree(true);
            }
            this.changeSelection();
            this.getCommonViewer().refresh();
            if (this.provider != null) {
                this.provider.setRebuildTree(false);
            }
            if (this.nodesToExpand.size() > 0) {
                for (TreeNode node : this.nodesToExpand) {
                    this.getCommonViewer().setExpandedState((Object)node, true);
                }
                this.nodesToExpand.clear();
            }
        }
    }

    public void dispose() {
        Trace t = Trace.getDefault();
        UiPlugin.removeNavigatorView(t, this);
        UiPlugin.getPrefStore().removePropertyChangeListener((IPropertyChangeListener)this);
        UiPlugin.getPluginRegistrationManager().removeChangeListener(t, this);
        super.dispose();
    }

    @Override
    public void pluginsChanged(PluginsChangedEvent event) {
        Trace t = Trace.getDefault();
        this.refreshNavigationTree(t, null, false, true);
    }

    private void changeSelection() {
        TreeItem parentOfSelected;
        TreeItem[] items = this.getTreeViewer().getTree().getSelection();
        if (items.length != 0 && (parentOfSelected = items[0].getParentItem()) != null && parentOfSelected.getData() instanceof TreeNode) {
            MQQmgrExtObject qmgrExtObj;
            TreeNode qmgr = (TreeNode)((Object)parentOfSelected.getData());
            while (!qmgr.getTreeNodeId().contains("com.ibm.mq.explorer.treenode.qm.") && !qmgr.getTreeNodeId().contains("com.ibm.mq.explorer.treenode.root")) {
                qmgr = qmgr.getParent();
            }
            Object qmgrObj = qmgr.getObject();
            if (qmgrObj instanceof MQQmgrExtObject && !(qmgrExtObj = (MQQmgrExtObject)qmgrObj).isConnected()) {
                this.selectTreeNode(Trace.getInstance(), qmgr);
            }
        }
    }

    private class NavigatorViewContextProvider
    implements IContextProvider {
        private NavigatorViewContextProvider() {
        }

        public int getContextChangeMask() {
            return 1;
        }

        public IContext getContext(Object target) {
            Object data;
            TreeItem[] sel;
            if (target instanceof Tree && (sel = ((Tree)target).getSelection()) != null && sel.length > 0 && (data = sel[0].getData()) != null && data instanceof TreeNode) {
                TreeNode treeNode = (TreeNode)((Object)data);
                return HelpSystem.getContext((String)treeNode.getHelpId());
            }
            return null;
        }

        public String getSearchExpression(Object target) {
            return null;
        }
    }
}

