/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.views;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.extensions.ContentPage;
import com.ibm.mq.explorer.ui.extensions.IContentPageFactory;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.TreeNodeDeletedEvent;
import com.ibm.mq.explorer.ui.internal.base.TreeNodeDeletedListener;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.content.BlankContentPage;
import com.ibm.mq.explorer.ui.internal.content.ContentPersistence;
import com.ibm.mq.explorer.ui.internal.content.MQContentPage;
import com.ibm.mq.explorer.ui.internal.utils.ToolbarAccessibility;
import com.ibm.mq.explorer.ui.internal.views.ExplorerViewPart;
import com.ibm.mq.explorer.ui.internal.views.HideSystemObjectsMenuAction;
import com.ibm.mq.explorer.ui.internal.views.MQNavigatorView;
import com.ibm.mq.explorer.ui.internal.views.RefreshToolbarAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class MQContentView
extends ExplorerViewPart
implements ISelectionListener,
TreeNodeDeletedListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/views/MQContentView.java";
    private StackLayout stackLayout;
    private Composite compositeContent;
    private Hashtable<String, ContentPage> pages;
    private Hashtable<String, IContentPageFactory> contentPageFactories = null;
    private ContentPage currentContentPage = null;
    private MQExtObject currentObject = null;
    private HideSystemObjectsMenuAction hideSystemObjectsMenuAction = null;
    private RefreshToolbarAction refreshToolbarAction = null;
    private boolean viewActive = false;
    private ContentPersistence contentPersistence = null;
    private BlankContentPage blankContentPage = null;
    private ArrayList<String> invalidPageIds = null;
    protected MQContentView mqContentView = null;

    public void createPartControl(Composite parent) {
        Trace t = Trace.getDefault();
        this.pages = new Hashtable();
        this.invalidPageIds = new ArrayList();
        this.mqContentView = this;
        this.contentPersistence = new ContentPersistence(t, UiPlugin.getPersistentFileLocation());
        this.contentPersistence.load(t);
        this.setShowSystemObjects(this.contentPersistence.isShowSystemObjects());
        this.contentPageFactories = UiPlugin.getContentPageFactoriesTable();
        this.makeActions(t);
        this.contributeToActionBar(t);
        this.contributeToMenu(t);
        this.compositeContent = new Composite(parent, 2048);
        this.stackLayout = new StackLayout();
        this.compositeContent.setLayout((Layout)this.stackLayout);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.compositeContent.setLayoutData((Object)gridData);
        this.blankContentPage = new BlankContentPage(this.compositeContent, 0);
        this.blankContentPage.setViewPart(this);
        this.blankContentPage.init();
        this.pages.put("com.ibm.mq.explorer.contentpage.blank", this.blankContentPage);
        this.showContentPage(t, "com.ibm.mq.explorer.contentpage.wmq", null);
        parent.layout();
        parent.redraw();
        parent.update();
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        UiPlugin.addITreeNodeDeletedListener(t, this);
        this.viewActive = true;
        UiPlugin.addContentView(t, this);
    }

    public void setFocus() {
        Control control = this.stackLayout.topControl;
        if (control != null) {
            control.setFocus();
        }
        this.compositeContent.getParent().layout();
        this.compositeContent.getParent().redraw();
        this.compositeContent.getParent().update();
    }

    private void makeActions(Trace t) {
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_Actions");
        String text = msgFile.getMessage(t, "UI.ACTIONS.Menu.ShowSystemObjects");
        String textToolTip = msgFile.getMessage(t, "UI.ACTIONS.Menu.ShowSystemObjects.ToolTip");
        this.hideSystemObjectsMenuAction = new HideSystemObjectsMenuAction(this);
        this.hideSystemObjectsMenuAction.setText(text);
        this.hideSystemObjectsMenuAction.setToolTipText(textToolTip);
        this.hideSystemObjectsMenuAction.setImageDescriptor(Icons.getDescriptor(Icons.iconkeyIncMQObj));
        text = msgFile.getMessage(t, "UI.ACTIONS.Toolbar.Refresh");
        textToolTip = msgFile.getMessage(t, "UI.ACTIONS.Toolbar.Refresh.ToolTip");
        this.refreshToolbarAction = new RefreshToolbarAction(this);
        this.refreshToolbarAction.setText(text);
        this.refreshToolbarAction.setToolTipText(textToolTip);
        this.refreshToolbarAction.setImageDescriptor(Icons.getDescriptor(Icons.iconkeyRefresh));
    }

    private void contributeToActionBar(Trace t) {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.hideSystemObjectsMenuAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("com.ibm.mq.explorer.contentview.toolbar"));
        manager.add((IContributionItem)new Separator("com.ibm.mq.explorer.content.toolbar.action"));
        manager.add((IAction)this.refreshToolbarAction);
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator());
        manager.update(true);
        bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshToolbarAction);
        ToolbarAccessibility.addViewToolbarAccessibility(manager);
    }

    private void contributeToMenu(Trace t) {
        IActionBars bars = this.getViewSite().getActionBars();
        IMenuManager manager = bars.getMenuManager();
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.hideSystemObjectsMenuAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("com.ibm.mq.explorer.contentview.menu"));
        manager.add((IContributionItem)new Separator("com.ibm.mq.explorer.content.menu.action"));
        manager.add((IAction)this.refreshToolbarAction);
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator());
        manager.update(true);
    }

    public void showContentPage(Trace t, String pageId, MQExtObject owningObject) {
        this.showContentPage(t, pageId, owningObject, false);
    }

    public void showContentPage(Trace t, String pageId, MQExtObject owningObject, boolean force) {
        ContentPage contentPage;
        if (Trace.isTracing) {
            t.data(67, "MQContentView.showContentPage", 300, "showing page for id " + pageId);
        }
        UiPlugin.showBusyCursor(t, true);
        String showPageId = pageId;
        if (showPageId == null) {
            showPageId = "com.ibm.mq.explorer.contentpage.blank";
        }
        if (((contentPage = this.pages.get(showPageId)) == null || force) && this.contentPageFactories.containsKey(showPageId)) {
            IContentPageFactory contentPageFactory = this.contentPageFactories.get(showPageId);
            if (UiPlugin.isPluginEnabledForContentPageFactory(t, contentPageFactory)) {
                contentPage = contentPageFactory.makePage(this.compositeContent);
                if (contentPage != null) {
                    contentPage.setViewPart(this);
                    contentPage.init();
                    this.pages.put(showPageId, contentPage);
                }
            } else if (Trace.isTracing) {
                t.data(67, "MQContentView.showContentPage", 900, "ignoring factory: " + contentPageFactory.toString() + ", its plug-in is disabled");
            }
        }
        if (contentPage == null) {
            if (!this.invalidPageIds.contains(showPageId)) {
                t.FFST(67, "MQContentView.showContentPage", 10, 50039, 0, 0, "Failed to create content page", "page id = '" + showPageId + "'", null);
                this.invalidPageIds.add(showPageId);
            }
            contentPage = this.blankContentPage;
        }
        if (force || !((Object)((Object)contentPage)).equals((Object)this.currentContentPage) || owningObject != null && this.currentObject != null && !owningObject.equals(this.currentObject)) {
            if (this.currentContentPage != null) {
                this.currentContentPage.setActive(false);
            }
            this.stackLayout.topControl = contentPage;
            contentPage.setObject(owningObject);
            contentPage.updatePage();
            this.compositeContent.layout();
            this.enableRefreshAction(contentPage.isEnableRefreshAction());
            this.enableSystemObjectsAction(contentPage.isEnableSystemObjectsAction());
            this.currentContentPage = contentPage;
            this.currentObject = owningObject;
            contentPage.setActive(true);
        }
        UiPlugin.showBusyCursor(t, false);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Trace t = Trace.getDefault();
        if (this.viewActive && part instanceof MQNavigatorView) {
            this.showSelection(t, selection);
        }
    }

    private void showSelection(Trace t, ISelection selection) {
        IStructuredSelection structuredSelection;
        Object object;
        if (selection != null && selection instanceof IStructuredSelection && (object = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)((Object)object);
            if (Trace.isTracing) {
                t.data(67, "MQContentView.showSelection", 300, "selected TreeNode: " + treeNode.toString());
            }
            MQExtObject extObj = (MQExtObject)treeNode.getObject();
            this.showContentPage(t, treeNode.getContentPageId(), extObj);
        }
    }

    @Override
    public void refresh(Trace t, String objectId, boolean force, boolean isRebuildTree) {
        ContentPage page = (ContentPage)this.stackLayout.topControl;
        boolean doRefresh = true;
        if (objectId != null && page instanceof MQContentPage) {
            MQContentPage mqPage = (MQContentPage)page;
            boolean bl = doRefresh = mqPage.getObjectId().compareTo(objectId) == 0;
        }
        if (doRefresh) {
            UiPlugin.showBusyCursor(t, true);
            if (page != null) {
                if (force) {
                    page.refresh();
                } else {
                    page.repaint();
                }
                this.compositeContent.layout();
            }
            UiPlugin.showBusyCursor(t, false);
        }
    }

    public void dispose() {
        Trace t = Trace.getDefault();
        this.viewActive = false;
        UiPlugin.removeTreeNodeDeletedListener(t, this);
        this.contentPersistence.setShowSystemObjects(this.isShowSystemObjects());
        this.contentPersistence.save(t);
        if (this.currentContentPage != null) {
            this.currentContentPage.setActive(false);
        }
        UiPlugin.removeContentView(t, this);
        super.dispose();
    }

    public void enableRefreshAction(boolean enabled) {
        this.refreshToolbarAction.setEnabled(enabled);
    }

    public void enableSystemObjectsAction(boolean enabled) {
        this.hideSystemObjectsMenuAction.setEnabled(enabled);
    }

    @Override
    public String getId() {
        return "com.ibm.mq.explorer.ui.internal.views.mqcontent";
    }

    @Override
    public void initialisationComplete(Trace t) {
        ISelection selection = UiPlugin.getMQNavigatorViewSelection(t);
        if (selection != null) {
            this.showSelection(t, selection);
        }
    }

    @Override
    public void treeNodeDeleted(TreeNodeDeletedEvent event) {
        Trace t = Trace.getDefault();
        TreeNode treeNode = event.getDeletedTreeNode();
        String pageId = treeNode.getContentPageId();
        if (pageId != null) {
            ContentPage contentPage = this.pages.get(pageId);
            boolean mustDispose = false;
            if (contentPage == null && this.contentPageFactories.containsKey(pageId)) {
                IContentPageFactory contentPageFactory = this.contentPageFactories.get(pageId);
                contentPage = contentPageFactory.makePage(this.compositeContent);
                mustDispose = true;
            }
            if (contentPage == null) {
                t.FFST(67, "MQContentView.treeNodeDeleted", 10, 50039, 0, 0, "Failed to create content page", pageId, null);
            } else {
                contentPage.instanceDeleted(treeNode.getObject());
                if (mustDispose) {
                    contentPage.dispose();
                }
            }
        }
    }

    @Override
    public void setShowSystemObjects(boolean b) {
        super.setShowSystemObjects(b);
        Enumeration<ContentPage> enumPages = this.pages.elements();
        while (enumPages.hasMoreElements()) {
            ContentPage page = enumPages.nextElement();
            page.showSystemObjects(b);
        }
    }

    public void reloadCurrentPage(Trace t) {
        String pageId = this.currentContentPage.getId();
        MQExtObject owningObject = this.currentObject;
        this.showContentPage(t, pageId, owningObject, true);
    }
}

