/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.utils;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtCombo;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class UiUtils {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/utils/UiUtils.java";
    private static Color rwtextBackColor = null;

    public static void resizeControl(Trace t, Control control) {
        Composite parent = control.getParent();
        Layout layout = parent.getLayout();
        Object layoutData = control.getLayoutData();
        if (layout instanceof GridLayout) {
            if (layoutData instanceof GridData) {
                GridLayout gridLayout = (GridLayout)layout;
                GridData gridData = (GridData)layoutData;
                Rectangle rect = parent.getClientArea();
                int width = rect.width - 2 * gridLayout.marginWidth;
                if (width > 0) {
                    Point ptLabel = control.computeSize(width, -1);
                    gridData.widthHint = ptLabel.x;
                    gridData.heightHint = ptLabel.y;
                    parent.layout(true);
                }
            } else {
                t.FFST(67, "UiUtils.resizeControl", 0, 0, "Control did not have layout data of type GridData on resize");
            }
        } else {
            t.FFST(67, "UiUtils.resizeControl", 1, 0, "Control parent did not have layout of type GridLayout on resize");
        }
    }

    public static void makeTextControlReadOnly(Trace t, Text text, boolean isNoMenu) {
        if (text != null) {
            text.setEditable(false);
            if (rwtextBackColor == null) {
                boolean isEnabled = text.isEnabled();
                boolean isEditable = text.getEditable();
                text.setEnabled(true);
                text.setEditable(true);
                rwtextBackColor = text.getBackground();
                text.setEnabled(isEnabled);
                text.setEditable(isEditable);
            }
            if (rwtextBackColor.equals((Object)UiPlugin.getReadonlyTextCtrlBackColor())) {
                text.setEnabled(false);
            }
            text.setBackground(UiPlugin.getReadonlyTextCtrlBackColor());
            if (isNoMenu) {
                Menu nullMenu = new Menu((Control)text);
                text.setMenu(nullMenu);
            }
        }
    }

    public static void makeTextControlReadWrite(Trace t, Text text) {
        if (text != null) {
            text.setEditable(true);
            text.setEnabled(true);
            if (rwtextBackColor != null) {
                text.setBackground(rwtextBackColor);
            }
        }
    }

    public static void makeShellCenteredOnParent(Trace t, Shell parent, Shell shell) {
        Point size = shell.getSize();
        Point parentSize = parent.getSize();
        Point parentLoc = parent.getLocation();
        if (size.x < parentSize.x && size.y < parentSize.y) {
            shell.setLocation(parentLoc.x + (parentSize.x - size.x) / 2, parentLoc.y + (parentSize.y - size.y) / 2);
        }
    }

    public static void createBlankLine(Composite parent, int horizontalSpan) {
        Label label = new Label(parent, 0);
        GridData layout = new GridData(768);
        layout.horizontalSpan = horizontalSpan;
        label.setLayoutData((Object)layout);
    }

    public static void createInformationTextArea(Trace t, Composite composite, String text, int horizontalSpan) {
        if (text != null && text.length() > 0) {
            UiUtils.createBlankLine(composite, 1);
            Composite informationComposite = new Composite(composite, 2048);
            GridLayout layout = new GridLayout(2, false);
            informationComposite.setLayout((Layout)layout);
            GridData layoutData = new GridData(768);
            layoutData.horizontalSpan = horizontalSpan;
            layoutData.widthHint = 300;
            informationComposite.setLayoutData((Object)layoutData);
            Display display = informationComposite.getDisplay();
            Image informationImage = display.getSystemImage(2);
            if (informationImage != null) {
                Label imageLabel = new Label(informationComposite, 0);
                informationImage.setBackground(imageLabel.getBackground());
                imageLabel.setImage(informationImage);
            }
            Text informationTextField = new Text(informationComposite, 66);
            informationTextField.setText(text);
            UiUtils.makeTextControlReadOnly(t, informationTextField, false);
            layoutData = new GridData(768);
            int marginWidth = 2 * layout.marginWidth;
            int borderWidth = 2 * informationComposite.getBorderWidth();
            int widthHint = 300 - marginWidth - borderWidth;
            if (informationImage != null) {
                widthHint -= informationImage.getBounds().width;
            }
            layoutData.widthHint = widthHint;
            informationTextField.setLayoutData((Object)layoutData);
            UiUtils.createBlankLine(composite, 1);
        }
    }

    public static void enableControls(Trace t, Control[] list, boolean enable) {
        if (list != null && list.length > 0) {
            int i = 0;
            while (i < list.length) {
                Control c = list[i];
                c.setEnabled(enable);
                ++i;
            }
        } else if (Trace.isTracing) {
            t.data(67, "UiUtils.enableControls", 300, "Empty list of controls");
        }
    }

    public static int getVScrollBarWidth(Trace t, Table table) {
        int width = 0;
        if (table != null) {
            Point vBarSize = table.getVerticalBar().getSize();
            width = vBarSize.x;
        }
        return width;
    }

    public static String createBackupFile(Trace t, String fileName) {
        File oldFile = new File(fileName);
        int c = 1;
        boolean renamed = false;
        while (!renamed) {
            File nf = new File(String.valueOf(fileName) + "bak" + c);
            if (oldFile.renameTo(nf)) {
                renamed = true;
                continue;
            }
            ++c;
        }
        return String.valueOf(fileName) + "bak" + c;
    }

    public static void addScrollListeners(ScrolledComposite scrolledComposite) {
        Listener activateListener = UiUtils.createScrollOnActivateListener(scrolledComposite);
        Listener arrowKeyListener = UiUtils.createArrowKeyListener(scrolledComposite);
        Control control = scrolledComposite.getContent();
        Control[] controls = control instanceof Composite ? ((Composite)control).getChildren() : new Control[]{control};
        UiUtils.addListenersRecursively(activateListener, arrowKeyListener, controls);
    }

    private static void addListenersRecursively(Listener listener, Listener keyListener, Control[] controls) {
        int j = 0;
        while (j < controls.length) {
            if (controls[j] instanceof Composite) {
                Composite comp = (Composite)controls[j];
                if (comp.getChildren().length > 0) {
                    UiUtils.addListenersRecursively(listener, keyListener, comp.getChildren());
                } else if (comp.getClass() != Composite.class) {
                    comp.addListener(26, listener);
                    comp.addListener(1, keyListener);
                }
            } else if (!(controls[j] instanceof Label)) {
                controls[j].addListener(26, listener);
                controls[j].addListener(1, keyListener);
            }
            ++j;
        }
    }

    private static Listener createScrollOnActivateListener(final ScrolledComposite scrolledComposite) {
        return new Listener(){

            public void handleEvent(Event e) {
                int checkWidth;
                Control child = (Control)e.widget;
                if (child.getParent() instanceof ExtCombo) {
                    child = child.getParent();
                }
                Rectangle bounds = scrolledComposite.getDisplay().map((Control)child.getParent(), (Control)scrolledComposite, child.getBounds());
                Rectangle area = scrolledComposite.getClientArea();
                Point origin = scrolledComposite.getOrigin();
                if (bounds.x < 0) {
                    origin.x = Math.max(0, origin.x + bounds.x);
                }
                if (bounds.y < 0) {
                    origin.y = Math.max(0, origin.y + bounds.y);
                }
                if (area.width < bounds.x + (checkWidth = Math.min(100, bounds.width))) {
                    origin.x = Math.max(0, origin.x + bounds.x + checkWidth - area.width);
                }
                if (area.height < bounds.y + bounds.height) {
                    origin.y = Math.max(0, origin.y + bounds.y + bounds.height - area.height);
                }
                scrolledComposite.setOrigin(origin);
            }
        };
    }

    private static Listener createArrowKeyListener(final ScrolledComposite scrolledComposite) {
        return new Listener(){

            public void handleEvent(Event e) {
                if (e.stateMask == 262144) {
                    Point p = scrolledComposite.getOrigin();
                    Point orig = scrolledComposite.getOrigin();
                    if (e.keyCode == 0x1000003) {
                        p.x -= 4;
                    } else if (e.keyCode == 0x1000004) {
                        p.x += 4;
                    } else if (e.keyCode == 0x1000001) {
                        p.y -= 4;
                    } else if (e.keyCode == 0x1000002) {
                        p.y += 4;
                    }
                    if (!orig.equals((Object)p)) {
                        scrolledComposite.setOrigin(p);
                        if (!orig.equals((Object)scrolledComposite.getOrigin()) || !(e.widget instanceof Text)) {
                            e.doit = false;
                        }
                    }
                }
            }
        };
    }

    public static void runInUIThread(Runnable r) {
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(r);
        } else {
            r.run();
        }
    }

    public static ControlDecoration createControlDecoration(Trace t, Control control) {
        return UiUtils.createControlDecoration(t, control, 0x1004000);
    }

    public static ControlDecoration createControlDecoration(Trace t, Control control, int style) {
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_General");
        final String requiredTxt = msgFile.getMessage("UI.PROP.Required.Attribute");
        ControlDecoration ctrlDec = new ControlDecoration(control, style);
        ctrlDec.setMarginWidth(2);
        ctrlDec.setDescriptionText(requiredTxt);
        ctrlDec.setImage(Icons.get(Icons.iconkeyRequiredFieldCue));
        control.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = e.result != null ? String.valueOf(e.result) + " " + requiredTxt : requiredTxt;
            }
        });
        return ctrlDec;
    }

    public static void limitSpinner(Trace t, final Spinner spinner) {
        final Message msgFile = UiPlugin.getUIMessages(t, "KEY_General");
        spinner.addModifyListener(new ModifyListener(){
            private ControlDecoration cd;

            public void modifyText(ModifyEvent e) {
                boolean outOfRange = false;
                int maximum = spinner.getMaximum();
                int minimum = spinner.getMinimum();
                try {
                    int value;
                    String txt = UiUtils.getSpinnerText(spinner);
                    if (txt != null && ((value = Integer.parseInt(txt)) < minimum || value > maximum)) {
                        outOfRange = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    outOfRange = true;
                }
                if (outOfRange) {
                    if (this.cd == null) {
                        String msg = msgFile.getMessage("UI.GENERAL.SPINNER.OUT.OF.RANGE", new String[]{String.valueOf(minimum), String.valueOf(maximum)});
                        this.cd = new ControlDecoration((Control)spinner, 0x1004000);
                        this.cd.setMarginWidth(2);
                        this.cd.setDescriptionText(msg);
                        FieldDecoration deco = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
                        this.cd.setImage(deco.getImage());
                    }
                } else if (this.cd != null) {
                    this.cd.hide();
                    this.cd.dispose();
                    this.cd = null;
                }
            }
        });
        Object obj = spinner.getLayoutData();
        if (obj instanceof GridData) {
            GridData gd = (GridData)obj;
            if (gd.horizontalIndent < 8) {
                gd.horizontalIndent = 8;
                spinner.setLayoutData((Object)gd);
            }
        }
    }

    private static String getSpinnerText(Spinner spinner) {
        try {
            Method getText = Spinner.class.getMethod("getText", null);
            Object ret = getText.invoke((Object)spinner, null);
            if (ret instanceof String) {
                return (String)ret;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return null;
    }

    public static void setHelp(Control control, String helpContextId) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            IWorkbenchHelpSystem helpSystem = workbench.getHelpSystem();
            helpSystem.setHelp(control, helpContextId);
        }
    }

    public static void setHelp(IAction action, String helpContextId) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            IWorkbenchHelpSystem helpSystem = workbench.getHelpSystem();
            helpSystem.setHelp(action, helpContextId);
        }
    }
}

