/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.utils;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Text;

public class StringValidation {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/utils/StringValidation.java";

    public static boolean isValidMQName(Trace t, String name, int length) {
        boolean result = false;
        if (Trace.isTracing) {
            t.data(67, "StringValidation.isValidMQName", 300, "name = " + name + ", length = " + length);
        }
        if (name.length() <= length) {
            Pattern regularExpression = Pattern.compile("[ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789%/._]+");
            Matcher matcher = regularExpression.matcher(name);
            result = matcher.matches();
        }
        if (Trace.isTracing) {
            t.data(67, "StringValidation.isValidMQName", 300, "result = " + result);
        }
        return result;
    }

    public static boolean isValidMQQueueName(Trace t, String name) {
        return StringValidation.isValidMQName(t, name, 48);
    }

    public static boolean isValidMQTopicName(Trace t, String name) {
        return StringValidation.isValidMQName(t, name, 48);
    }

    public static boolean isValidMQQueueManagerName(Trace t, String name) {
        return StringValidation.isValidMQName(t, name, 48);
    }

    public static boolean verifyMQObjectName(Trace t, VerifyEvent e) {
        return StringValidation.verifyMQObjectNameAdditional(t, e, "");
    }

    public static boolean verifyMQObjectNameAdditional(Trace t, VerifyEvent e, String additionalVerifyChars) {
        boolean result = true;
        String textString = e.text;
        Object source = e.getSource();
        if (source instanceof Text) {
            if (textString.length() > 1) {
                e.text = textString = UiPlugin.stripTrailingSpaces(t, textString);
            }
            String current = ((Text)source).getText();
            String beginning = current.substring(0, e.start);
            String end = current.substring(e.end);
            textString = String.valueOf(beginning) + textString + end;
        }
        char[] chars = new char[textString.length()];
        textString.getChars(0, chars.length, chars, 0);
        String verifyString = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789%/._" + additionalVerifyChars;
        if (!StringValidation.verifyString(t, verifyString, chars)) {
            UiPlugin.getDisplay().beep();
            result = false;
        }
        if (Trace.isTracing) {
            t.data(67, "StringValidation.verifyMQObjectNameAdditional", 300, "result = " + result);
        }
        return result;
    }

    private static boolean verifyString(Trace t, String verifyString, char[] testChars) {
        boolean result = true;
        int i = 0;
        while (i < testChars.length) {
            if (verifyString.indexOf(testChars[i]) == -1) {
                result = false;
                if (!Trace.isTracing) break;
                t.data(67, "StringValidation.verifyString", 300, "name contains invalid character '" + testChars[i] + "'");
                break;
            }
            ++i;
        }
        return result;
    }

    public static boolean verifyString(Trace t, String testString, String validChars) {
        boolean result = true;
        int i = 0;
        while (i < testString.length()) {
            char ch = testString.charAt(i);
            if (validChars.indexOf(ch) == -1) {
                result = false;
                if (!Trace.isTracing) break;
                t.data(67, "StringValidation.verifyString", 300, "name contains invalid character '" + ch + "'");
                break;
            }
            ++i;
        }
        return result;
    }

    public static boolean verifyIPAddress(Trace t, VerifyEvent e) {
        boolean result = true;
        String textString = e.text;
        char[] chars = new char[textString.length()];
        textString.getChars(0, chars.length, chars, 0);
        int i = 0;
        while (i < chars.length) {
            boolean valid = false;
            if (chars[i] >= '0' && chars[i] <= '9' || chars[i] == '.' || chars[i] == ':') {
                valid = true;
            }
            if (!valid) {
                UiPlugin.getDisplay().beep();
                result = false;
                if (!Trace.isTracing) break;
                t.data(67, "StringValidation.verifyIPAddress", 300, "string contains invalid character '" + chars[i] + "'");
                break;
            }
            ++i;
        }
        if (Trace.isTracing) {
            t.data(67, "StringValidation.verifyIPAddress", 300, "result = " + result);
        }
        return result;
    }

    public static boolean verifyNumeric(Trace t, VerifyEvent e) {
        String textString = e.text;
        Object source = e.getSource();
        if (source instanceof Text) {
            if (textString.length() > 1) {
                e.text = textString = UiPlugin.stripTrailingSpaces(t, textString);
            }
            textString = ((Text)source).getText();
        }
        Pattern p = Pattern.compile("[0-9]*");
        boolean result = StringValidation.verifyUsingRegularExpression(t, textString, e, p);
        return result;
    }

    public static boolean verifyPCFFilterStringValue(Trace t, VerifyEvent e) {
        boolean result = true;
        String textString = e.text;
        char[] chars = new char[textString.length()];
        textString.getChars(0, chars.length, chars, 0);
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '?' || chars[i] == ':') {
                result = false;
                if (!Trace.isTracing) break;
                t.data(67, "StringValidation.verifyPCFFilterStringValue", 300, "value contains '?' or ':'");
                break;
            }
            ++i;
        }
        if (!result) {
            UiPlugin.getDisplay().beep();
        }
        if (Trace.isTracing) {
            t.data(67, "StringValidation.verifyPCFFilterStringValue", 300, "result = " + result);
        }
        return result;
    }

    public static boolean verifyUsingRegularExpression(Trace t, String currentText, VerifyEvent e, Pattern p) {
        boolean result = true;
        String beginning = currentText.substring(0, e.start);
        String end = currentText.substring(e.end);
        String textToVerify = String.valueOf(beginning) + e.text + end;
        if (Trace.isTracing) {
            t.data(67, "StringValidation.verifyUsingRegularExpression", 300, "text = " + textToVerify);
        }
        Matcher m = p.matcher(textToVerify);
        Matcher trailingSpacesRemoved = null;
        if (!m.matches()) {
            int length = e.text.length();
            if (length > 1) {
                e.text = UiPlugin.stripTrailingSpaces(t, e.text);
                trailingSpacesRemoved = p.matcher(e.text);
                if (!trailingSpacesRemoved.matches()) {
                    result = false;
                }
            } else {
                result = false;
            }
            if (!result) {
                UiPlugin.getDisplay().beep();
                if (Trace.isTracing) {
                    t.data(67, "StringValidation.verifyUsingRegularExpression", 300, "name contains invalid character '" + e.character + "'");
                }
            }
        }
        return result;
    }

    public static String getMessageForPattern(Trace t, Pattern p) {
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_General");
        String msg = msgFile.getMessage("UI.GENERAL.NAME.INVALID.CHARS");
        if (p.pattern().trim().equals("[A-Z][A-Z0-9]*")) {
            msg = msgFile.getMessage("UI.GENERAL.MQ.NAME.INVALID.CHARS.UPPERCASE");
        }
        return msg;
    }
}

