/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.utils;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandle;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;

public class FipsUtils {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/utils/FipsUtils.java";
    private static final String SSL_FIPS_NOT_SUPPORTED_ON_QMGR = "AMQ4641";
    private static Message msgFile = null;

    private FipsUtils() {
        System.out.println("*** You should not be using this constructor ***");
    }

    public static boolean getFipsConfirmation(Trace t, DmQueueManager dmQmgr) {
        QueueManagerHandle qmgrHandle;
        boolean prompt = false;
        final boolean[] retValue = new boolean[]{true};
        DmQueueManagerHandle dmQmgrHandle = dmQmgr != null ? dmQmgr.getConnectionHandle() : null;
        QueueManagerHandle queueManagerHandle = qmgrHandle = dmQmgrHandle != null ? dmQmgrHandle.getQueueManagerHandle(t) : null;
        if (!CommonServices.isSSLFIPSSupported()) {
            if (dmQmgrHandle != null && dmQmgrHandle.isClient(t)) {
                if (qmgrHandle != null && qmgrHandle.getSSLFIPSRequired() == 1) {
                    if (Trace.isTracing) {
                        t.data(67, "FipsUtils.getFipsConfirmation", 300, "Requested client connection is configured for FIPS but the functionality is not available! Warn & prompt the user for confirmation.");
                    }
                    prompt = true;
                } else if (Trace.isTracing) {
                    t.data(67, "FipsUtils.getFipsConfirmation", 300, "Requested client connection is not configured for FIPS or cannot be determined!");
                }
            } else if (Trace.isTracing) {
                t.data(67, "FipsUtils.getFipsConfirmation", 300, "Requested connection is local or cannot be determined!");
            }
        } else if (Trace.isTracing) {
            t.data(67, "FipsUtils.getFipsConfirmation", 300, "FIPS is supported in this version!");
        }
        if (prompt) {
            if (msgFile == null) {
                msgFile = UiPlugin.getUIMessages(t, "KEY_Queue Manager");
            }
            UiUtils.runInUIThread(new Runnable(){

                @Override
                public void run() {
                    String[] buttons = new String[]{msgFile.getMessage("UI.GENERAL.YES"), msgFile.getMessage("UI.GENERAL.NO")};
                    int pressed = MessageBox.showMessage(Trace.getDefault(), UiPlugin.getShell(), CommonServices.getSystemMessage((String)FipsUtils.SSL_FIPS_NOT_SUPPORTED_ON_QMGR, (String)qmgrHandle.getQueueManagerName()), 4, buttons, 1, FipsUtils.SSL_FIPS_NOT_SUPPORTED_ON_QMGR);
                    if (pressed != 0) {
                        retValue[0] = false;
                    }
                }
            });
        }
        if (Trace.isTracing) {
            t.data(67, "FipsUtils.getFipsConfirmation", 300, retValue[0] ? "Connection request will continue!" : "Connection request halted by user!");
        }
        return retValue[0];
    }
}

