/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.status;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.DialogWithContextHelp;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObjectLink;
import com.ibm.mq.explorer.ui.internal.queuemanager.IQueueManagerDisconnectActionListener;
import com.ibm.mq.explorer.ui.internal.queuemanager.QueueManagerDisconnectActionEvent;
import com.ibm.mq.explorer.ui.internal.status.StatusComposite;
import com.ibm.mq.explorer.ui.internal.status.StatusCompositeContentChangedEvent;
import com.ibm.mq.explorer.ui.internal.status.StatusCompositeContentChangedListener;
import com.ibm.mq.explorer.ui.internal.status.StatusCompositeSelectionChangedEvent;
import com.ibm.mq.explorer.ui.internal.status.StatusCompositeSelectionChangedListener;
import com.ibm.mq.explorer.ui.internal.status.UiStatusProvider;
import com.ibm.mq.explorer.ui.internal.utils.ButtonTools;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class StatusDialog
extends DialogWithContextHelp
implements ShellListener,
StatusCompositeContentChangedListener,
StatusCompositeSelectionChangedListener,
DisposeListener,
IQueueManagerDisconnectActionListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/status/StatusDialog.java";
    private Shell shellDlg = null;
    private Text[] infoTextArray = null;
    private Composite compRefreshCloseButtons = null;
    private Button buttonRefreshSelected = null;
    private Button buttonRefresh = null;
    private Button buttonClose = null;
    private Message msgFile = null;
    private UiStatusProvider primaryUiStatusProvider = null;
    private StatusComposite primaryStatusComposite = null;
    private int rows = 0;
    private String statusType = null;
    private UiMQObject ownerUiMQObject = null;
    private Object contextObject = null;
    private SashForm sashForm = null;
    private Hashtable<UiStatusProvider, StatusComposite> tableStatusComposites = new Hashtable();
    private boolean isActiveWindow = false;
    private boolean isListeningForQueueManagerDisconnectActions = false;
    private boolean isProcessRefreshKey = false;
    private StatusKeyListener statusKeyListener = null;

    public StatusDialog(Shell parent, int style) {
        super(parent, style);
    }

    public void open(Trace t, UiStatusProvider uiStatusProvider, String statType, UiMQObject ownerObject, Object contextObj) {
        this.primaryUiStatusProvider = uiStatusProvider;
        this.ownerUiMQObject = ownerObject;
        this.contextObject = contextObj;
        this.statusType = statType;
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Status");
        Shell parent = this.getParent();
        int shellOptions = 3312;
        if ((parent.getStyle() & 0x10000) == 65536) {
            shellOptions |= 0x10000;
        }
        this.shellDlg = new Shell(parent, shellOptions);
        String helpId = uiStatusProvider.getDialogHelpIdForStatusType(t, this.statusType);
        if (helpId == null) {
            helpId = "com.ibm.mq.explorer.ui.infopop.UI_StatusDialog";
        }
        UiPlugin.getHelpSystem().setHelp((Control)this.shellDlg, helpId);
        this.shellDlg.setText(this.getText());
        this.shellDlg.setImage(uiStatusProvider.getImage(this.statusType));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = false;
        this.shellDlg.setLayout((Layout)gridLayout);
        this.statusKeyListener = new StatusKeyListener();
        this.shellDlg.getDisplay().addFilter(2, (Listener)this.statusKeyListener);
        this.shellDlg.addDisposeListener((DisposeListener)this);
        this.isProcessRefreshKey = true;
        String element1 = ownerObject.toString();
        String element2 = uiStatusProvider.getNameForStatusType(t, this.statusType);
        if (element2 == null) {
            element2 = uiStatusProvider.getMenuText(t);
        }
        String title = Message.format((String)this.msgFile.getMessage(t, "UI.STATUS.Status.Title"), (String)element1, (String)element2);
        this.shellDlg.setText(title);
        this.addInformationArea(t, uiStatusProvider, this.statusType);
        Composite compStatusComps = new Composite((Composite)this.shellDlg, 0);
        FillLayout fillLayout = new FillLayout();
        compStatusComps.setLayout((Layout)fillLayout);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        compStatusComps.setLayoutData((Object)gridData);
        this.createStatusComposites(t, compStatusComps);
        this.compRefreshCloseButtons = new Composite((Composite)this.shellDlg, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.compRefreshCloseButtons.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.compRefreshCloseButtons.setLayoutData((Object)gridData);
        this.createHelpControl(this.compRefreshCloseButtons);
        Label label = new Label(this.compRefreshCloseButtons, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        int statusInstances = uiStatusProvider.getStatusInstances(t, this.ownerUiMQObject, this.contextObject);
        if (statusInstances == 3) {
            this.buttonRefreshSelected = new Button(this.compRefreshCloseButtons, 8);
            this.buttonRefreshSelected.setText(this.msgFile.getMessage(t, "UI.GENERAL.REFRESH"));
            gridData = new GridData();
            gridData.horizontalAlignment = 3;
            this.buttonRefreshSelected.setLayoutData((Object)gridData);
            this.buttonRefreshSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace tr = Trace.getDefault();
                    StatusDialog.this.refreshSelectedItem(tr);
                }
            });
            this.buttonRefresh = new Button(this.compRefreshCloseButtons, 8);
            this.buttonRefresh.setText(this.msgFile.getMessage(t, "UI.GENERAL.REFRESH.ALL"));
            gridData = new GridData();
            gridData.horizontalAlignment = 3;
            this.buttonRefresh.setLayoutData((Object)gridData);
            this.buttonRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace tr = Trace.getDefault();
                    StatusDialog.this.refresh(tr);
                }
            });
            this.primaryStatusComposite.addSelectionChangedListener(t, this);
        } else {
            label = new Label(this.compRefreshCloseButtons, 0);
            gridData = new GridData();
            gridData.horizontalSpan = 1;
            gridData.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)gridData);
            this.buttonRefresh = new Button(this.compRefreshCloseButtons, 8);
            this.buttonRefresh.setText(this.msgFile.getMessage(t, "UI.GENERAL.REFRESH"));
            gridData = new GridData();
            gridData.horizontalAlignment = 3;
            this.buttonRefresh.setLayoutData((Object)gridData);
            this.buttonRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace tr = Trace.getDefault();
                    StatusDialog.this.refresh(tr);
                }
            });
        }
        this.buttonClose = new Button(this.compRefreshCloseButtons, 8);
        this.buttonClose.setText(this.msgFile.getMessage(t, "UI.GENERAL.CLOSE"));
        GridData gridDataClose = new GridData();
        gridDataClose.horizontalAlignment = 3;
        this.buttonClose.setLayoutData((Object)gridDataClose);
        this.buttonClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StatusDialog.this.shellDlg.close();
            }
        });
        ButtonTools.makeEqualWidthGridData(t, this.compRefreshCloseButtons);
        this.refresh(t);
        this.shellDlg.addShellListener((ShellListener)this);
        UiPlugin.addQueueManagerDisconnectActionListener(t, this);
        this.isListeningForQueueManagerDisconnectActions = true;
        Collection<StatusComposite> statusComps = this.tableStatusComposites.values();
        for (StatusComposite statusComp : statusComps) {
            statusComp.startListening(t);
        }
        if (this.tableStatusComposites.size() == 1 && this.primaryStatusComposite.isSingleInstanceMode()) {
            this.shellDlg.pack();
        } else {
            this.shellDlg.layout();
        }
        if (this.rows > 1) {
            Point sizeShell = this.shellDlg.getSize();
            Point sizeParent = this.shellDlg.getParent().getSize();
            Point size = sizeShell;
            if (size.y < sizeParent.y - 25) {
                size.y = sizeParent.y - 25;
            }
            this.shellDlg.setSize(size);
        }
        UiUtils.makeShellCenteredOnParent(t, parent, this.shellDlg);
        this.shellDlg.open();
        this.shellDlg.setDefaultButton(this.buttonClose);
        this.buttonClose.setFocus();
        Display display = parent.getDisplay();
        while (!this.shellDlg.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void createStatusComposites(Trace t, Composite composite) {
        int[] weights;
        FillLayout fillLayout;
        Composite compTables = null;
        Composite compTop = null;
        ScrolledComposite scrolledCompTop = null;
        UiStatusProvider dualModeUiStatusProvider = this.primaryUiStatusProvider.getDualModeStatusProvider(t, this.statusType);
        if (dualModeUiStatusProvider != null) {
            this.sashForm = new SashForm(composite, 512);
        } else {
            compTables = new Composite(composite, 2048);
            FillLayout fillLayout2 = new FillLayout();
            compTables.setLayout((Layout)fillLayout2);
        }
        if (this.sashForm != null) {
            Composite compBorder = new Composite((Composite)this.sashForm, 2048);
            fillLayout = new FillLayout();
            compBorder.setLayout((Layout)fillLayout);
            scrolledCompTop = new ScrolledComposite(compBorder, 768);
        } else {
            scrolledCompTop = new ScrolledComposite(compTables, 768);
        }
        compTop = new Composite((Composite)scrolledCompTop, 0);
        scrolledCompTop.setContent((Control)compTop);
        ++this.rows;
        UiStatusProvider[] providers = this.primaryUiStatusProvider.getCollectionStatusProviders(t, this.statusType);
        if (providers != null) {
            scrolledCompTop.setContent((Control)compTop);
            int count = providers.length;
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            compTop.setLayout((Layout)gridLayout);
            Composite compHeaders = new Composite(compTop, 0);
            gridLayout = new GridLayout(count, true);
            gridLayout.numColumns = count;
            gridLayout.marginHeight = 0;
            compHeaders.setLayout((Layout)gridLayout);
            GridData gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            compHeaders.setLayoutData((Object)gridData);
            Composite compContent = new Composite(compTop, 0);
            gridLayout = new GridLayout(count, true);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            gridLayout.verticalSpacing = 0;
            compContent.setLayout((Layout)gridLayout);
            gridData = new GridData(1808);
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            compContent.setLayoutData((Object)gridData);
            int i = 0;
            while (i < providers.length) {
                Composite compHeader = new Composite(compHeaders, 0);
                gridLayout = new GridLayout();
                gridLayout.marginHeight = 0;
                compHeader.setLayout((Layout)gridLayout);
                gridData = new GridData(1808);
                gridData.grabExcessHorizontalSpace = true;
                compHeader.setLayoutData((Object)gridData);
                StatusComposite statusComp = new StatusComposite(t, compHeader, compContent, 0, providers[i], this.statusType, this.ownerUiMQObject, this.contextObject);
                gridData = new GridData(1808);
                gridData.grabExcessHorizontalSpace = true;
                gridData.grabExcessVerticalSpace = true;
                statusComp.setLayoutData(gridData);
                this.tableStatusComposites.put(providers[i], statusComp);
                if (i == 0) {
                    this.primaryStatusComposite = statusComp;
                }
                ++i;
            }
        } else {
            fillLayout = new FillLayout();
            compTop.setLayout((Layout)fillLayout);
            this.primaryStatusComposite = new StatusComposite(t, compTop, compTop, 0, this.primaryUiStatusProvider, this.statusType, this.ownerUiMQObject, this.contextObject);
            this.tableStatusComposites.put(this.primaryUiStatusProvider, this.primaryStatusComposite);
        }
        compTop.layout();
        Point size = compTop.computeSize(-1, -1);
        scrolledCompTop.setMinWidth(size.x);
        scrolledCompTop.setMinHeight(size.y);
        scrolledCompTop.setExpandHorizontal(true);
        scrolledCompTop.setExpandVertical(true);
        scrolledCompTop.layout();
        if (dualModeUiStatusProvider != null) {
            Composite compBottom = new Composite((Composite)this.sashForm, 2048);
            FillLayout fillLayout3 = new FillLayout();
            compBottom.setLayout((Layout)fillLayout3);
            this.createAdditionalRowStatusComposites(t, compBottom, dualModeUiStatusProvider);
        }
        Enumeration<UiStatusProvider> statusProviders = this.tableStatusComposites.keys();
        while (statusProviders.hasMoreElements()) {
            UiStatusProvider provider = statusProviders.nextElement();
            UiStatusProvider owner = this.primaryUiStatusProvider.getOwningStatusProvider(t, this.statusType, provider);
            if (owner == null) continue;
            StatusComposite statusCompOwner = this.tableStatusComposites.get(owner);
            StatusComposite statusCompOwned = this.tableStatusComposites.get(provider);
            if (statusCompOwner == null || statusCompOwned == null) continue;
            statusCompOwner.setChildStatusComposite(t, statusCompOwned);
        }
        if (this.sashForm != null && (weights = this.primaryUiStatusProvider.getRowWeights()) != null) {
            if (weights.length == this.rows) {
                this.sashForm.setWeights(weights);
            } else if (Trace.isTracing) {
                t.data(67, "StatusDialog.createStatusComposites", 900, "Unable to use weights, count does not match number of rows");
            }
        }
    }

    private void createAdditionalRowStatusComposites(Trace t, Composite composite, UiStatusProvider uiStatusProvider) {
        ++this.rows;
        ScrolledComposite scrolledComp = new ScrolledComposite(composite, 768);
        Composite comp = new Composite((Composite)scrolledComp, 0);
        scrolledComp.setContent((Control)comp);
        UiStatusProvider[] providers = uiStatusProvider.getCollectionStatusProviders(t, this.statusType);
        if (providers != null) {
            int count = providers.length;
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = count;
            comp.setLayout((Layout)gridLayout);
            int i = 0;
            while (i < providers.length) {
                UiMQObject ownerObj = this.ownerUiMQObject;
                UiStatusProvider owner = this.primaryUiStatusProvider.getOwningStatusProvider(t, this.statusType, providers[i]);
                if (owner != null) {
                    ownerObj = null;
                }
                StatusComposite statusComp = new StatusComposite(t, comp, comp, 0, providers[i], this.statusType, ownerObj, this.contextObject);
                GridData gridData = new GridData(1808);
                gridData.grabExcessHorizontalSpace = true;
                gridData.grabExcessVerticalSpace = true;
                statusComp.setLayoutData(gridData);
                this.tableStatusComposites.put(providers[i], statusComp);
                ++i;
            }
        } else {
            FillLayout fillLayout = new FillLayout();
            comp.setLayout((Layout)fillLayout);
            UiMQObject ownerObj = this.ownerUiMQObject;
            StatusComposite statusComp = new StatusComposite(t, comp, comp, 0, uiStatusProvider, this.statusType, ownerObj, this.contextObject);
            this.tableStatusComposites.put(uiStatusProvider, statusComp);
        }
        comp.layout();
        Point size = comp.computeSize(-1, -1);
        scrolledComp.setMinWidth(size.x);
        scrolledComp.setMinHeight(size.y);
        scrolledComp.setExpandHorizontal(true);
        scrolledComp.setExpandVertical(true);
        scrolledComp.layout();
        UiStatusProvider dualModeUiStatusProvider = uiStatusProvider.getDualModeStatusProvider(t, this.statusType);
        if (dualModeUiStatusProvider != null) {
            Composite compBottom = new Composite((Composite)this.sashForm, 2048);
            FillLayout fillLayout = new FillLayout();
            compBottom.setLayout((Layout)fillLayout);
            this.createAdditionalRowStatusComposites(t, compBottom, dualModeUiStatusProvider);
        }
    }

    private void addInformationArea(Trace t, UiStatusProvider statusProvider, String type) {
        String[] titles = statusProvider.getInformationAreaTitles(t, type);
        if (titles != null) {
            Composite composite = new Composite((Composite)this.shellDlg, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 4;
            composite.setLayout((Layout)gridLayout);
            GridData gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = 4;
            composite.setLayoutData((Object)gridData);
            int count = titles.length;
            if (count % 2 == 1) {
                ++count;
            }
            Label label = new Label(composite, 0);
            gridData = new GridData(768);
            gridData.horizontalSpan = 4;
            gridData.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)gridData);
            this.infoTextArray = new Text[count];
            int i = 0;
            while (i < count) {
                label = new Label(composite, 0);
                if (i < titles.length) {
                    label.setText(titles[i]);
                }
                gridData = new GridData();
                label.setLayoutData((Object)gridData);
                if (i < titles.length) {
                    this.infoTextArray[i] = new Text(composite, 8);
                    gridData = new GridData(768);
                    gridData.grabExcessHorizontalSpace = true;
                    this.infoTextArray[i].setLayoutData((Object)gridData);
                    this.infoTextArray[i].setBackground(composite.getDisplay().getSystemColor(22));
                } else {
                    label = new Label(composite, 0);
                    gridData = new GridData();
                    label.setLayoutData((Object)gridData);
                }
                ++i;
            }
        }
    }

    private void refresh(Trace t) {
        Collection<StatusComposite> statusComps = this.tableStatusComposites.values();
        for (StatusComposite statusComp : statusComps) {
            statusComp.refresh(t);
        }
        this.refreshInformationAreaValues(t);
    }

    private void refreshSelectedItem(Trace t) {
        Collection<StatusComposite> statusComps = this.tableStatusComposites.values();
        for (StatusComposite statusComp : statusComps) {
            statusComp.refreshSelectedItem(t);
        }
        this.refreshInformationAreaValues(t);
    }

    public void refreshInformationAreaValues(Trace t) {
        if (this.infoTextArray != null) {
            String[] values = this.primaryUiStatusProvider.getInformationAreaValues(t, this.statusType, this.ownerUiMQObject);
            int limit = values.length;
            if (limit > this.infoTextArray.length) {
                limit = this.infoTextArray.length;
            }
            int i = 0;
            while (i < limit) {
                this.infoTextArray[i].setText(values[i]);
                ++i;
            }
        }
    }

    public void shellActivated(ShellEvent e) {
        this.isActiveWindow = true;
    }

    public void shellClosed(ShellEvent e) {
        Trace t = Trace.getDefault();
        Collection<StatusComposite> statusComps = this.tableStatusComposites.values();
        for (StatusComposite statusComp : statusComps) {
            statusComp.stopListening(t);
        }
    }

    public void shellDeactivated(ShellEvent e) {
        this.isActiveWindow = false;
    }

    public void shellDeiconified(ShellEvent e) {
    }

    public void shellIconified(ShellEvent e) {
    }

    @Override
    public void contentChanged(StatusCompositeContentChangedEvent event) {
        Trace t = Trace.getDefault();
        this.refreshInformationAreaValues(t);
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.isListeningForQueueManagerDisconnectActions) {
            UiPlugin.removeQueueManagerDisconnectActionListener(Trace.getDefault(), this);
            this.isListeningForQueueManagerDisconnectActions = false;
        }
        this.isProcessRefreshKey = false;
        this.shellDlg.getDisplay().removeFilter(2, (Listener)this.statusKeyListener);
    }

    @Override
    public void selectionChanged(StatusCompositeSelectionChangedEvent event) {
        if (this.buttonRefreshSelected != null) {
            UiMQObject selUiMQObject = event.getObject();
            boolean enableButton = true;
            if (selUiMQObject instanceof UiMQObjectLink) {
                enableButton = !((UiMQObjectLink)selUiMQObject).isDummyObject();
            }
            this.buttonRefreshSelected.setEnabled(enableButton);
        }
    }

    public Shell getShell() {
        return this.shellDlg;
    }

    @Override
    public void queueManagerBeingDisconnected(QueueManagerDisconnectActionEvent event) {
        DmQueueManager dmQueueManager;
        Trace t = Trace.getDefault();
        if (this.primaryUiStatusProvider != null && (dmQueueManager = this.primaryUiStatusProvider.getDmQueueManagerObject(t, this.ownerUiMQObject)) != null && dmQueueManager.equals((Object)event.getDmQueueManager())) {
            if (this.buttonRefresh != null) {
                this.buttonRefresh.setEnabled(false);
            }
            if (this.buttonRefreshSelected != null) {
                this.buttonRefreshSelected.setEnabled(false);
            }
            this.isProcessRefreshKey = false;
        }
    }

    private class StatusKeyListener
    implements Listener {
        private StatusKeyListener() {
        }

        public void handleEvent(Event event) {
            if (event.keyCode == 0x100000E && StatusDialog.this.isActiveWindow) {
                if (StatusDialog.this.isProcessRefreshKey) {
                    StatusDialog.this.refresh(Trace.getDefault());
                } else {
                    event.doit = false;
                }
            }
        }
    }
}

