/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.status;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.base.CorePlugin;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTable;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableContentChangedEvent;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableContentChangedListener;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableSelectionChangedEvent;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableSelectionChangedListener;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.objecttable.ObjectTable;
import com.ibm.mq.explorer.ui.internal.objecttable.ObjectTableContentChangedEvent;
import com.ibm.mq.explorer.ui.internal.objecttable.ObjectTableContentChangedListener;
import com.ibm.mq.explorer.ui.internal.splittreetable.ISplitTreeTableContentListener;
import com.ibm.mq.explorer.ui.internal.splittreetable.SplitTreeTable;
import com.ibm.mq.explorer.ui.internal.splittreetable.SplitTreeTableContentChangedEvent;
import com.ibm.mq.explorer.ui.internal.splittreetable.SplitTreeTableContentChangedListener;
import com.ibm.mq.explorer.ui.internal.splittreetable.SplitTreeTableContentProvider;
import com.ibm.mq.explorer.ui.internal.splittreetable.SplitTreeTableSelectionChangedEvent;
import com.ibm.mq.explorer.ui.internal.splittreetable.SplitTreeTableSelectionChangedListener;
import com.ibm.mq.explorer.ui.internal.status.InfoBar;
import com.ibm.mq.explorer.ui.internal.status.StatusCompositeContentChangedEvent;
import com.ibm.mq.explorer.ui.internal.status.StatusCompositeContentChangedListener;
import com.ibm.mq.explorer.ui.internal.status.StatusCompositeSelectionChangedEvent;
import com.ibm.mq.explorer.ui.internal.status.StatusCompositeSelectionChangedListener;
import com.ibm.mq.explorer.ui.internal.status.UiStatusProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class StatusComposite
extends Composite
implements ExplorerTableContentChangedListener,
ExplorerTableSelectionChangedListener,
ObjectTableContentChangedListener,
SplitTreeTableContentChangedListener,
SplitTreeTableSelectionChangedListener,
ISplitTreeTableContentListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/status/StatusComposite.java";
    private static final int MODE_SINGLE_INSTANCE = 0;
    private static final int MODE_MULTIPLE_INSTANCES = 1;
    private static final int MODE_MULTIPLE_INSTANCES_IN_TREE = 2;
    private Composite compositeTable = null;
    private Button buttonProperties = null;
    private Label labelHeading = null;
    private ExplorerTable explorerTable = null;
    private ObjectTable objectTable = null;
    private SplitTreeTable splitTreeTable = null;
    private SplitTreeTableContentProvider splitTreeTableContentProvider = null;
    private static final int TABLE_WIDTH_HINT = 350;
    private static final int TABLE_HEIGHT_HINT = 300;
    private Composite compAdditionalButton = null;
    private Button[] additionalButtons = null;
    private int[] additionalButtonIds = null;
    private UiStatusProvider uiStatusProvider = null;
    private String statusType = null;
    private UiMQObject ownerUiMQObject = null;
    private int mode = 0;
    private boolean isListening = false;
    private boolean shouldWeListen = false;
    private IDmObservable observableObject = null;
    private int listenDmObjectId = -1;
    private DmObjectFilter objectTableExplicitFilter = null;
    private DmObjectFilter explorerTableExplicitFilter = null;
    private StatusComposite childStatusComposite = null;
    private Vector<StatusCompositeContentChangedListener> contentChangedListeners = null;
    private Vector<StatusCompositeSelectionChangedListener> selectionChangedListeners = null;
    private InfoBar infoBar;

    public StatusComposite(Trace t, Composite header, Composite parent, int style, UiStatusProvider statusProvider, String type, UiMQObject ownerObject, Object contextObject) {
        super(parent, style);
        Label label;
        GridData gridData;
        String heading;
        this.uiStatusProvider = statusProvider;
        this.ownerUiMQObject = ownerObject;
        this.statusType = type;
        this.contentChangedListeners = new Vector();
        this.selectionChangedListeners = new Vector();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = false;
        if (header != parent) {
            gridLayout.marginHeight = 0;
        }
        this.setLayout((Layout)gridLayout);
        Composite headerComp = header;
        if (header != parent) {
            gridLayout = new GridLayout();
            gridLayout.numColumns = 4;
            gridLayout.makeColumnsEqualWidth = false;
            header.setLayout((Layout)gridLayout);
        } else {
            headerComp = this;
        }
        int statusInstances = statusProvider.getStatusInstances(t, this.ownerUiMQObject, contextObject);
        this.mode = statusInstances == 1 ? 0 : (statusInstances == 2 ? 1 : 2);
        this.shouldWeListen = this.uiStatusProvider.supportsDataModelListen(t, type);
        if (this.shouldWeListen) {
            this.observableObject = this.uiStatusProvider.getDmQueueManagerObject(t, this.ownerUiMQObject);
            this.listenDmObjectId = this.uiStatusProvider.getDataModelObjectType(t, type);
        }
        if ((heading = statusProvider.getTableHeading(t, type, this.ownerUiMQObject)) != null) {
            this.labelHeading = new Label(headerComp, 0);
            this.labelHeading.setText(heading);
            gridData = header != parent ? new GridData(1808) : new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            gridData.verticalAlignment = 1024;
            gridData.horizontalSpan = 3;
            this.labelHeading.setLayoutData((Object)gridData);
            if (statusProvider.getStatusInstances(t, this.ownerUiMQObject, contextObject) == 1 && statusProvider.isShowPropertiesButton(t, type)) {
                this.createPropertiesButton(t, headerComp);
            }
        } else if (statusProvider.getStatusInstances(t, this.ownerUiMQObject, contextObject) == 1 && statusProvider.isShowPropertiesButton(t, type)) {
            label = new Label((Composite)this, 0);
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            label.setLayoutData((Object)gridData);
            this.createPropertiesButton(t, headerComp);
        }
        this.compositeTable = new Composite((Composite)this, 0);
        FillLayout fillLayout = new FillLayout();
        this.compositeTable.setLayout((Layout)fillLayout);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        gridData.widthHint = 350;
        if (this.mode == 0) {
            gridData.heightHint = 300;
        }
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.compositeTable.setLayoutData((Object)gridData);
        if (this.mode == 2) {
            this.splitTreeTableContentProvider = statusProvider.getSplitTreeTableContentProvider(t, this);
            this.splitTreeTable = new SplitTreeTable(t, this.compositeTable, 0, statusProvider.getGenericObjectName(t, type), statusProvider.showSchemeBar(t, type, this.ownerUiMQObject), true, true, "com.ibm.mq.explorer.context.statusdlg", this.splitTreeTableContentProvider);
            this.splitTreeTable.setViewPart(t, (ViewPart)UiPlugin.getMQNavigatorView());
            this.splitTreeTable.setAttributeOrderId(t, statusProvider.getAttributeOrderId(type));
            this.splitTreeTable.setInstance(t, null, false);
            this.splitTreeTable.setOwnerObject(ownerObject);
            this.splitTreeTable.setAssociatedDmQueueManager(t, this.uiStatusProvider.getDmQueueManagerObject(t, ownerObject));
        } else if (this.mode == 1) {
            String filterId = statusProvider.getFilterId(type);
            this.explorerTable = new ExplorerTable(t, this.compositeTable, 0, statusProvider.getGenericObjectName(t, type), filterId != null, statusProvider.showSchemeBar(t, type, this.ownerUiMQObject), true, true, "com.ibm.mq.explorer.context.statusdlg", 0, null, false);
            this.explorerTable.setViewPart(t, (ViewPart)UiPlugin.getMQNavigatorView());
            this.explorerTable.setObjectId(t, statusProvider.getObjectId(type));
            this.explorerTable.setFilterId(t, filterId);
            this.explorerTable.setFilterProvider(t, statusProvider.getFilterProvider(t, type));
            this.explorerTable.setFilterQSGDisposition(statusProvider.getFilterQSGDisposition(t, type));
            this.explorerTable.setAttributeOrderId(t, statusProvider.getAttributeOrderId(type));
            if (statusProvider.isTickCrossMode(t, type, this.ownerUiMQObject)) {
                this.explorerTable.setTickCrossMode(t, true, statusProvider.getTickCrossModeTickIcon(t, type, this.ownerUiMQObject), statusProvider.getTickCrossModeCrossIcon(t, type, this.ownerUiMQObject));
            } else {
                this.explorerTable.setTickCrossMode(t, false);
            }
            this.explorerTable.setInstance(t, null, false);
            ViewerFilter viewerFilter = statusProvider.getTableViewerFilter(t, type);
            if (viewerFilter != null) {
                this.explorerTable.addViewerFilter(t, viewerFilter);
            }
            if (this.shouldWeListen) {
                this.explorerTable.setUiMQObjectFactoryClass(t, this.uiStatusProvider.getUiMQObjectFactory(t, type, this.ownerUiMQObject), this.ownerUiMQObject);
                if (!statusProvider.isGenericStatus(t) && this.ownerUiMQObject != null) {
                    DmObjectFilter dmObjectFilter = this.uiStatusProvider.getExplicitDmObjectFilter(t, this.ownerUiMQObject);
                    if (dmObjectFilter != null) {
                        Integer qsgDisp = this.uiStatusProvider.getExplicitDmObjectFilterQSGDisposition(t, this.ownerUiMQObject);
                        this.explorerTableExplicitFilter = dmObjectFilter;
                        this.explorerTable.setFilterQSGDisposition(qsgDisp);
                    } else {
                        int objectType = this.uiStatusProvider.getDataModelObjectType(t, this.statusType);
                        int objectSubType = statusProvider.getDataModelObjectSubType(t, type);
                        dmObjectFilter = objectSubType != -1 ? new DmObjectFilter(t, this.ownerUiMQObject.toString(), objectType, objectSubType) : new DmObjectFilter(t, this.ownerUiMQObject.toString(), objectType);
                        this.explorerTableExplicitFilter = dmObjectFilter;
                    }
                }
            }
            if (this.uiStatusProvider.supportsMaxResponses()) {
                this.infoBar = new InfoBar(t, this.explorerTable, 0);
                gridData = new GridData(1808);
                gridData.horizontalSpan = 2;
                gridData.grabExcessHorizontalSpace = true;
                gridData.grabExcessVerticalSpace = false;
                this.infoBar.setLayoutData(gridData);
            }
        } else {
            this.objectTable = new ObjectTable(t, this.compositeTable, 0, statusProvider.showSchemeBar(t, type, this.ownerUiMQObject), true, false);
            this.objectTable.setObjectId(t, statusProvider.getObjectId(type));
            this.objectTable.setUiMQObjectFactoryClass(t, statusProvider.getUiMQObjectFactory(t, type, this.ownerUiMQObject), this.ownerUiMQObject);
            this.objectTable.setAttributeOrderId(t, statusProvider.getAttributeOrderId(type));
            if (statusProvider.isTickCrossMode(t, type, this.ownerUiMQObject)) {
                this.objectTable.setTickCrossMode(t, true, statusProvider.getTickCrossModeTickIcon(t, type, this.ownerUiMQObject), statusProvider.getTickCrossModeCrossIcon(t, type, this.ownerUiMQObject));
            } else {
                this.objectTable.setTickCrossMode(t, false);
            }
            this.objectTable.addContentChangedListener(t, this);
            if (!statusProvider.isGenericStatus(t) && this.ownerUiMQObject != null) {
                DmObjectFilter dmObjectFilter = this.uiStatusProvider.getExplicitDmObjectFilter(t, this.ownerUiMQObject);
                if (dmObjectFilter == null) {
                    int objectType = this.uiStatusProvider.getDataModelObjectType(t, this.statusType);
                    int objectSubType = statusProvider.getDataModelObjectSubType(t, type);
                    dmObjectFilter = objectSubType != -1 ? new DmObjectFilter(t, this.ownerUiMQObject.toString(), objectType, objectSubType) : new DmObjectFilter(t, this.ownerUiMQObject.toString(), objectType);
                }
                this.objectTableExplicitFilter = dmObjectFilter;
            }
        }
        DmQueueManager dmQmgr = this.ownerUiMQObject.getDmObject().getQueueManager();
        if (dmQmgr != null) {
            if (this.splitTreeTable != null) {
                this.splitTreeTable.setInstance(t, dmQmgr.getTreeName(t), dmQmgr.isZos());
            } else if (this.explorerTable != null) {
                this.explorerTable.setInstance(t, dmQmgr.getTreeName(t), dmQmgr.isZos());
            } else if (this.objectTable != null) {
                this.objectTable.setInstance(t, dmQmgr.getTreeName(t), dmQmgr.isZos());
            }
        }
        this.additionalButtonIds = statusProvider.getAdditionalButtonIds(t, type);
        if (this.additionalButtonIds != null) {
            this.compAdditionalButton = new Composite((Composite)this, 0);
            gridLayout = new GridLayout();
            gridLayout.numColumns = this.additionalButtonIds.length + 1;
            this.compAdditionalButton.setLayout((Layout)gridLayout);
            gridData = new GridData(768);
            gridData.horizontalSpan = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.compAdditionalButton.setLayoutData((Object)gridData);
            label = new Label(this.compAdditionalButton, 0);
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)gridData);
            this.additionalButtons = new Button[this.additionalButtonIds.length];
            int i = 0;
            while (i < this.additionalButtonIds.length) {
                this.additionalButtons[i] = new Button(this.compAdditionalButton, 8);
                this.additionalButtons[i].setText(statusProvider.getAdditionalButtonText(t, type, this.additionalButtonIds[i]));
                this.additionalButtons[i].setEnabled(false);
                this.additionalButtons[i].setData((Object)i);
                gridData = new GridData();
                this.additionalButtons[i].setLayoutData((Object)gridData);
                this.additionalButtons[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        Trace tr = Trace.getDefault();
                        if (event.getSource() instanceof Button) {
                            Button button = (Button)event.getSource();
                            int index = (Integer)button.getData();
                            StatusComposite.this.additionalButtonSelected(tr, index);
                        }
                    }
                });
                ++i;
            }
        }
        if (this.splitTreeTable != null) {
            this.splitTreeTable.addSelChangedListener(t, this);
        }
        if (this.explorerTable != null) {
            this.explorerTable.addSelChangedListener(t, this);
        }
    }

    private void createPropertiesButton(Trace t, Composite parent) {
        this.buttonProperties = new Button(parent, 8);
        Message msgFileProp = UiPlugin.getUIMessages(t, "KEY_Properties");
        this.buttonProperties.setText(msgFileProp.getMessage(t, "UI.PROP.Properties.Action"));
        this.buttonProperties.setEnabled(false);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 3;
        this.buttonProperties.setLayoutData((Object)gridData);
        this.buttonProperties.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                StatusComposite.this.propertiesButtonSelected(tr);
            }
        });
        this.buttonProperties.setVisible(true);
    }

    private void propertiesButtonSelected(Trace t) {
        if (this.buttonProperties != null) {
            if (this.explorerTable != null) {
                UiMQObject selUiMQObject = this.explorerTable.getSelectedItem(t);
                selUiMQObject.showProperties(t, this.getShell());
                this.explorerTable.refresh();
            } else if (this.objectTable != null) {
                this.objectTable.getObject(t).showProperties(t, this.getShell());
            }
        }
    }

    @Override
    public void contentChanged(ExplorerTableContentChangedEvent event) {
        Trace t = Trace.getDefault();
        this.sendContentChangedEvent(t);
        if (this.additionalButtons != null && this.explorerTable != null) {
            int i = 0;
            while (i < this.additionalButtons.length) {
                Button buttonAdditional = this.additionalButtons[i];
                if (buttonAdditional != null) {
                    UiMQObject selUiMQObject = this.explorerTable.getSelectedItem(t);
                    buttonAdditional.setEnabled(selUiMQObject != null);
                }
                ++i;
            }
        }
        if (this.uiStatusProvider.supportsMaxResponses()) {
            try {
                int maxResponses = CorePlugin.getDefault().getMaxResponses();
                int itemCount = this.explorerTable.getItemCount(t);
                if (itemCount >= maxResponses) {
                    Message msgFile = UiPlugin.getUIMessages(t, "KEY_Properties");
                    String text = msgFile.getMessage("UI.Msg.TooManyResponses", String.valueOf(maxResponses));
                    this.infoBar.setImage("dialog_messasge_info_image");
                    this.infoBar.setText(text);
                    this.infoBar.setVisible(true);
                } else {
                    this.infoBar.setImage(null);
                    this.infoBar.setText(null);
                    this.infoBar.setVisible(false);
                }
            }
            catch (Exception e) {
                UiPlugin.logException(e);
                t.FFST(67, "StatusComposite.contentChanged", 30, 50999, 0, 0, e.getClass().getName(), e.getMessage(), "", (Throwable)e);
            }
        }
    }

    @Override
    public void contentChanged(ObjectTableContentChangedEvent event) {
        Trace t = Trace.getDefault();
        this.sendContentChangedEvent(t);
        UiMQObject uiMQObject = this.objectTable.getObject(t);
        if (uiMQObject == null) {
            if (this.buttonProperties != null) {
                this.buttonProperties.setEnabled(false);
            }
        } else {
            if (this.buttonProperties != null) {
                this.buttonProperties.setEnabled(this.uiStatusProvider.isEnablePropertiesButton(t, this.statusType, uiMQObject));
            }
            if (this.childStatusComposite != null && !this.childStatusComposite.isListening) {
                this.childStatusComposite.setOwnerObject(t, uiMQObject);
            }
        }
    }

    @Override
    public void selChanged(ExplorerTableSelectionChangedEvent event) {
        Trace t = Trace.getDefault();
        UiMQObject selUiMQObject = event.getObject();
        int size = this.selectionChangedListeners.size();
        if (size > 0) {
            StatusCompositeSelectionChangedEvent scSelectionEvent = new StatusCompositeSelectionChangedEvent(t, selUiMQObject);
            int i = 0;
            while (i < size) {
                StatusCompositeSelectionChangedListener listener = this.selectionChangedListeners.elementAt(i);
                listener.selectionChanged(scSelectionEvent);
                ++i;
            }
        }
        if (this.additionalButtonIds != null) {
            int i = 0;
            while (i < this.additionalButtonIds.length) {
                Button buttonAdditional = this.additionalButtons[i];
                if (buttonAdditional != null) {
                    buttonAdditional.setEnabled(this.uiStatusProvider.isEnableAdditionalButton(t, this.statusType, this.additionalButtonIds[i], selUiMQObject));
                }
                ++i;
            }
        }
        if (this.childStatusComposite != null) {
            this.childStatusComposite.setOwnerObject(t, selUiMQObject);
        }
    }

    private void additionalButtonSelected(Trace t, int index) {
        if (this.additionalButtons[index] != null) {
            if (this.explorerTable != null) {
                UiMQObject selUiMQObject = this.explorerTable.getSelectedItem(t);
                this.uiStatusProvider.additionalButtonSelected(t, this.additionalButtonIds[index], this.getShell(), selUiMQObject);
                this.explorerTable.refresh();
            } else if (this.objectTable != null) {
                this.uiStatusProvider.additionalButtonSelected(t, this.additionalButtonIds[index], this.getShell(), this.objectTable.getObject(t));
            }
        }
    }

    public void startListening(Trace t) {
        if (this.ownerUiMQObject != null && this.shouldWeListen) {
            this.observableObject = this.uiStatusProvider.getDmQueueManagerObject(t, this.ownerUiMQObject);
            if (this.observableObject == null) {
                if (Trace.isTracing) {
                    t.data(67, "StatusComposite.startListening", 300, "observableObject is null, unable to start listener");
                }
            } else if (this.mode == 1) {
                this.isListening = this.explorerTableExplicitFilter != null ? this.explorerTable.startListener(t, this.observableObject, this.explorerTableExplicitFilter) : (this.uiStatusProvider.getFilterId(this.statusType) != null ? this.explorerTable.startListener(t, this.observableObject) : this.explorerTable.startListener(t, this.observableObject, this.listenDmObjectId));
                if (!this.isListening && Trace.isTracing) {
                    t.data(67, "StatusComposite.startListening", 900, "failed to start listening for changes - listenDmQmgr " + this.observableObject.getObservableName() + ", explorerTableExplicitFilter " + this.explorerTableExplicitFilter + ", listenDmObjectId " + this.listenDmObjectId);
                }
                this.explorerTable.addContentChangedListener(t, this);
            } else if (this.mode == 0) {
                this.isListening = this.objectTableExplicitFilter != null ? this.objectTable.startListener(t, this.observableObject, this.objectTableExplicitFilter) : this.objectTable.startListener(t, this.observableObject, this.listenDmObjectId);
                if (!this.isListening && Trace.isTracing) {
                    t.data(67, "StatusComposite.startListening", 900, "failed to start listening for changes - listenDmQmgr " + this.observableObject.getObservableName() + ", listenDmObjectId " + this.listenDmObjectId);
                }
            }
        }
    }

    public void stopListening(Trace t) {
        if (this.isListening) {
            if (this.mode == 1) {
                if (!this.explorerTable.stopListener(t, this.observableObject) && Trace.isTracing) {
                    t.data(67, "StatusComposite.stopListening", 900, "failed to stop listening for changes - listenDmQmgr " + this.observableObject.getObservableName() + ", listenDmObjectId " + this.listenDmObjectId);
                }
                this.explorerTable.removeContentChangedListener(t, this);
            } else if (this.mode == 0 && !this.objectTable.stopListener(t, this.observableObject)) {
                t.data(67, "StatusComposite.stopListening", 900, "failed to stop listening for changes - listenDmQmgr " + this.observableObject.getObservableName() + ", listenDmObjectId " + this.listenDmObjectId);
            }
        }
    }

    public void refresh(Trace t) {
        this.uiStatusProvider.refresh(t, this.ownerUiMQObject);
        if (this.shouldWeListen) {
            if (this.mode == 0) {
                this.objectTable.refresh();
            } else if (this.mode == 1) {
                this.explorerTable.refresh();
            } else if (this.mode == 2) {
                this.splitTreeTable.refresh();
            }
        } else if (this.mode == 0) {
            this.objectTable.removeAll(t);
            UiMQObject[] statusObjects = this.uiStatusProvider.getStatusObjectsForStatusType(t, this.statusType, this.ownerUiMQObject);
            if (statusObjects.length > 0) {
                this.objectTable.setObject(t, statusObjects[0], this.shouldWeListen);
                if (this.buttonProperties != null) {
                    this.buttonProperties.setEnabled(this.uiStatusProvider.isEnablePropertiesButton(t, this.statusType, statusObjects[0]));
                }
            } else if (this.buttonProperties != null) {
                this.buttonProperties.setEnabled(false);
            }
        } else if (this.mode == 1) {
            this.explorerTable.beginUpdate(t);
            this.explorerTable.removeAll(t);
            UiMQObject[] statusObjects = this.uiStatusProvider.getStatusObjectsForStatusType(t, this.statusType, this.ownerUiMQObject);
            int i = 0;
            while (i < statusObjects.length) {
                this.explorerTable.addTableItem(t, statusObjects[i]);
                ++i;
            }
            this.explorerTable.endUpdate(t);
        } else {
            this.splitTreeTable.beginUpdate(t);
            this.splitTreeTable.refresh();
            this.splitTreeTable.endUpdate(t);
        }
    }

    public boolean isSingleInstanceMode() {
        return this.mode == 0;
    }

    public void setChildStatusComposite(Trace t, StatusComposite child) {
        this.childStatusComposite = child;
    }

    public void setOwnerObject(Trace t, UiMQObject ownerObject) {
        DmObjectFilter dmObjectFilter;
        if (this.isListening) {
            this.stopListening(t);
        }
        if (this.explorerTable != null) {
            this.explorerTable.removeAll(t);
        }
        this.ownerUiMQObject = ownerObject;
        DmQueueManager dmQmgr = this.uiStatusProvider.getDmQueueManagerObject(t, ownerObject);
        if (dmQmgr != null) {
            if (this.explorerTable != null) {
                this.explorerTable.setInstance(t, dmQmgr.getTreeName(t), dmQmgr.isZos());
            } else if (this.objectTable != null) {
                this.objectTable.setInstance(t, dmQmgr.getTreeName(t), dmQmgr.isZos());
            }
        }
        if (this.splitTreeTable != null) {
            this.splitTreeTable.setOwnerObject(ownerObject);
        }
        if (this.labelHeading != null) {
            this.labelHeading.setText(this.uiStatusProvider.getTableHeading(t, this.statusType, this.ownerUiMQObject));
            this.labelHeading.getParent().layout(true);
        }
        if ((dmObjectFilter = this.uiStatusProvider.getExplicitDmObjectFilter(t, this.ownerUiMQObject)) != null) {
            Integer qsgDisp = this.uiStatusProvider.getExplicitDmObjectFilterQSGDisposition(t, this.ownerUiMQObject);
            this.explorerTableExplicitFilter = dmObjectFilter;
            this.explorerTable.setFilterQSGDisposition(qsgDisp);
        }
        this.startListening(t);
    }

    public void addContentChangedListener(Trace t, StatusCompositeContentChangedListener listener) {
        this.contentChangedListeners.addElement(listener);
    }

    public void removeContentChangedListener(Trace t, StatusCompositeContentChangedListener listener) {
        this.contentChangedListeners.removeElement(listener);
    }

    public void addSelectionChangedListener(Trace t, StatusCompositeSelectionChangedListener listener) {
        this.selectionChangedListeners.addElement(listener);
    }

    public void removeSelectionChangedListener(Trace t, StatusCompositeSelectionChangedListener listener) {
        this.selectionChangedListeners.removeElement(listener);
    }

    private void sendContentChangedEvent(Trace t) {
        StatusCompositeContentChangedEvent ccEvent = new StatusCompositeContentChangedEvent(this);
        int size = this.contentChangedListeners.size();
        int i = 0;
        while (i < size) {
            StatusCompositeContentChangedListener listener = this.contentChangedListeners.elementAt(i);
            listener.contentChanged(ccEvent);
            ++i;
        }
    }

    @Override
    public void contentChanged(SplitTreeTableContentChangedEvent event) {
        Trace t = Trace.getDefault();
        this.sendContentChangedEvent(t);
        if (this.additionalButtons != null && this.explorerTable != null) {
            int i = 0;
            while (i < this.additionalButtons.length) {
                Button buttonAdditional = this.additionalButtons[i];
                if (buttonAdditional != null) {
                    UiMQObject selUiMQObject = this.splitTreeTable.getSelectedItem(t);
                    buttonAdditional.setEnabled(selUiMQObject != null);
                }
                ++i;
            }
        }
    }

    @Override
    public void selChanged(SplitTreeTableSelectionChangedEvent event) {
        Trace t = Trace.getDefault();
        UiMQObject selUiMQObject = event.getObject();
        int size = this.selectionChangedListeners.size();
        if (size > 0) {
            StatusCompositeSelectionChangedEvent scSelectionEvent = new StatusCompositeSelectionChangedEvent(t, selUiMQObject);
            int i = 0;
            while (i < size) {
                StatusCompositeSelectionChangedListener listener = this.selectionChangedListeners.elementAt(i);
                listener.selectionChanged(scSelectionEvent);
                ++i;
            }
        }
        if (this.additionalButtonIds != null) {
            int i = 0;
            while (i < this.additionalButtonIds.length) {
                Button buttonAdditional = this.additionalButtons[i];
                if (buttonAdditional != null) {
                    buttonAdditional.setEnabled(this.uiStatusProvider.isEnableAdditionalButton(t, this.statusType, this.additionalButtonIds[i], selUiMQObject));
                }
                ++i;
            }
        }
        if (this.childStatusComposite != null) {
            this.childStatusComposite.setOwnerObject(t, selUiMQObject);
        }
    }

    @Override
    public void showObjects(Trace t, UiMQObject parentObject, ArrayList<UiMQObject> objects) {
        this.splitTreeTable.beginUpdate(t);
        if (parentObject != null) {
            this.splitTreeTable.removeLoadingChild(t, parentObject);
        }
        this.splitTreeTable.addSiblingObjects(t, objects.toArray(new UiMQObject[objects.size()]));
        this.splitTreeTable.endUpdate(t);
    }

    @Override
    public void refreshObjects(Trace t, UiMQObject parentObject, UiMQObject refreshObject, ArrayList<UiMQObject> objects) {
        this.splitTreeTable.beginUpdate(t);
        Iterator<UiMQObject> iterator = objects.iterator();
        while (iterator.hasNext()) {
            this.splitTreeTable.refreshObject(t, parentObject, refreshObject, iterator.next());
        }
        this.splitTreeTable.endUpdate(t);
    }

    @Override
    public void dmCoreExceptionReceived(Trace t, UiMQObject parentObject, DmCoreException dmCoreException) {
        if (Trace.isTracing) {
            t.data(67, "StatusComposite.dmCoreExceptionReceived", 900, "DmCoreException received: cc=" + dmCoreException.getCompCode() + " rc=" + dmCoreException.getReasonCode());
        }
        MessageBox.showExceptionMessage(t, UiPlugin.getShell(), dmCoreException);
        if (this.splitTreeTable != null) {
            this.splitTreeTable.beginUpdate(t);
            this.splitTreeTable.removeAll(t);
            this.splitTreeTable.endUpdate(t);
        }
    }

    public void refreshSelectedItem(Trace t) {
        if (this.mode == 2) {
            this.splitTreeTable.refreshSelectedItem(t);
        } else {
            this.refresh(t);
        }
    }
}

