/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.splittreetable;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectLink;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.splittreetable.SplitTreeTableItemData;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class SplitTreeTableLabelProvider
implements IPropertyChangeListener,
DisposeListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/splittreetable/SplitTreeTableLabelProvider.java";
    private Tree treeLeft = null;
    private Tree treeRight = null;
    private int attrOrderIconAttrId = -1;
    private Hashtable<MQExtObject, ArrayList<TreeColumn>> greyCellLists = null;

    public SplitTreeTableLabelProvider(Trace t, Tree treeLft, Tree treeRght) {
        this.treeLeft = treeLft;
        this.treeRight = treeRght;
        this.greyCellLists = new Hashtable();
        UiPlugin.getPrefStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.treeLeft.addDisposeListener((DisposeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        Trace t = Trace.getDefault();
        String strProperty = event.getProperty();
        if (strProperty.compareTo("InvalidCellColorChanged") == 0) {
            this.paintGreyCells(t);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        UiPlugin.getPrefStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void paintGreyCells(Trace t) {
        Color color = UiPlugin.getDisabledColor();
        int i = 0;
        while (i < this.treeRight.getItemCount()) {
            TreeItem treeItemLeft = this.treeLeft.getItem(i);
            TreeItem treeItemRight = this.treeRight.getItem(i);
            this.paintGreyCellsForTreeItems(t, color, treeItemLeft, treeItemRight);
            ++i;
        }
        this.treeLeft.redraw();
        this.treeRight.redraw();
    }

    private void paintGreyCellsForTreeItems(Trace t, Color color, TreeItem treeItemLeft, TreeItem treeItemRight) {
        ArrayList<TreeColumn> greyCellList;
        SplitTreeTableItemData splitTreeTableItemData = (SplitTreeTableItemData)treeItemRight.getData();
        UiMQObject uiMQObject = splitTreeTableItemData.uiMQObject;
        int j = 0;
        while (j < this.treeLeft.getColumnCount()) {
            treeItemLeft.setBackground(j, null);
            treeItemLeft.setForeground(j, null);
            ++j;
        }
        j = 0;
        while (j < this.treeRight.getColumnCount()) {
            treeItemRight.setBackground(j, null);
            treeItemRight.setForeground(j, null);
            ++j;
        }
        MQExtObject mqExtObject = uiMQObject.getExternalObject();
        if (mqExtObject != null && (greyCellList = this.getGreyCellList(t, mqExtObject)) != null) {
            int j2 = 0;
            while (j2 < greyCellList.size()) {
                TreeColumn treeColumn = greyCellList.get(j2);
                int colNumber = this.treeLeft.indexOf(treeColumn);
                if (colNumber != -1) {
                    treeItemLeft.setBackground(colNumber, color);
                    treeItemLeft.setForeground(colNumber, color);
                } else {
                    colNumber = this.treeRight.indexOf(treeColumn);
                    if (colNumber != -1) {
                        treeItemRight.setBackground(colNumber, color);
                        treeItemRight.setForeground(colNumber, color);
                    }
                }
                ++j2;
            }
        }
        TreeItem[] treeItemsLeft = treeItemLeft.getItems();
        TreeItem[] treeItemsRight = treeItemRight.getItems();
        int i = 0;
        while (i < treeItemsLeft.length) {
            this.paintGreyCellsForTreeItems(t, color, treeItemsLeft[i], treeItemsRight[i]);
            ++i;
        }
    }

    public Image getImageForColumn(Trace t, Object object, TreeColumn treeColumn) {
        return null;
    }

    public String getTextForColumn(Trace t, Object object, TreeColumn treeColumn) {
        AttributeOrderItem attrOrderItem;
        String colText = null;
        UiMQObject uiMQObject = null;
        MQExtObject mqExtObject = null;
        if (object instanceof UiMQObject) {
            mqExtObject = ((UiMQObject)object).getExternalObject();
            uiMQObject = (UiMQObject)object;
        } else if (object instanceof MQExtObject) {
            mqExtObject = (MQExtObject)object;
            uiMQObject = (UiMQObject)mqExtObject.getInternalObject();
        }
        if (uiMQObject != null && (attrOrderItem = (AttributeOrderItem)treeColumn.getData()) != null) {
            Attr attr;
            int attrId = attrOrderItem.getAttributeId();
            if (attrId == this.attrOrderIconAttrId) {
                colText = uiMQObject instanceof IUiMQObjectLink ? ((IUiMQObjectLink)((Object)uiMQObject)).getTreeName() : uiMQObject.toString();
            } else if (uiMQObject.getId().compareTo("com.ibm.mq.explorer.dummy.loading") != 0 && (attr = uiMQObject.getDmObject().getAttribute(t, attrId, 0)) != null && (colText = attr.toString(t)).equals("[not_found]")) {
                Message msgs = UiPlugin.getUIMessages(t, "KEY_General");
                colText = msgs != null ? msgs.getMessage(t, "UI.GENERAL.NOT.FOUND") : "";
                if (Trace.isTracing) {
                    t.data(67, "SplitTreeTableLabelProvider.getTextForColumn", 900, "no valid string found for attr: " + attr);
                }
            }
        }
        if (mqExtObject != null) {
            ArrayList<TreeColumn> greyCellList = this.getGreyCellList(t, mqExtObject);
            if (mqExtObject.getObjectId().compareTo("com.ibm.mq.explorer.dummy.loading") == 0) {
                if (colText == null) {
                    colText = "";
                }
            } else if (colText == null) {
                if (!greyCellList.contains(treeColumn)) {
                    greyCellList.add(treeColumn);
                }
                colText = "";
            } else {
                greyCellList.remove(treeColumn);
            }
        }
        return colText;
    }

    public void setIconAttributeId(int iconAttrId) {
        this.attrOrderIconAttrId = iconAttrId;
    }

    public void clearGreyCellLists(Trace t) {
        Enumeration<ArrayList<TreeColumn>> elements = this.greyCellLists.elements();
        while (elements.hasMoreElements()) {
            ArrayList<TreeColumn> element = elements.nextElement();
            element.clear();
        }
        this.greyCellLists.clear();
    }

    private ArrayList<TreeColumn> getGreyCellList(Trace t, MQExtObject mqExtObject) {
        ArrayList<Object> arrayList = null;
        arrayList = this.greyCellLists.get(mqExtObject);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.greyCellLists.put(mqExtObject, arrayList);
        }
        return arrayList;
    }
}

