/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.splittreetable;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObjectLink;
import java.util.Hashtable;

public class SplitTreeTableExpansionManager {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/splittreetable/SplitTreeTableExpansionManager.java";
    private Hashtable<String, Boolean> expansionStates = new Hashtable();

    public void setExpansionState(Trace t, UiMQObject uiMQObject, boolean state) {
        String name = this.getObjectHashName(t, uiMQObject);
        if (name != null) {
            this.expansionStates.put(name, state);
            if (Trace.isTracing) {
                t.data(67, "SplitTreeTableExpansionManager.setExpansionState", 300, "saving state " + state + " for object " + name);
            }
        }
    }

    public boolean getExpansionState(Trace t, UiMQObject uiMQObject) {
        String name = this.getObjectHashName(t, uiMQObject);
        boolean state = false;
        if (name != null && this.expansionStates.containsKey(name)) {
            state = this.expansionStates.get(name);
            if (Trace.isTracing) {
                t.data(67, "SplitTreeTableExpansionManager.getExpansionState", 300, "returning state " + state + " for object " + name);
            }
        }
        return state;
    }

    public void clearExpansionList(Trace t) {
        this.expansionStates.clear();
    }

    private String getObjectHashName(Trace t, UiMQObject uiMQObject) {
        String objName = uiMQObject.toString();
        String treeName = "";
        int depth = 0;
        if (uiMQObject instanceof UiMQObjectLink) {
            UiMQObjectLink uiMQObjectLink = (UiMQObjectLink)uiMQObject;
            treeName = uiMQObjectLink.getTreeName();
            UiMQObject parentUiMQObject = uiMQObjectLink.getParent(t);
            if (parentUiMQObject instanceof UiMQObjectLink) {
                UiMQObjectLink parentUiMQObjectLink = (UiMQObjectLink)parentUiMQObject;
                while (parentUiMQObjectLink != null) {
                    ++depth;
                    parentUiMQObject = parentUiMQObjectLink.getParent(t);
                    parentUiMQObjectLink = parentUiMQObject instanceof UiMQObjectLink ? (UiMQObjectLink)parentUiMQObject : null;
                }
            }
        }
        String hashName = String.valueOf(objName) + "%" + treeName + "%" + depth;
        return hashName;
    }
}

