/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.splittreetable;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class SplitTreeTableColumnManager {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/splittreetable/SplitTreeTableColumnManager.java";
    private static final int COLUMN_HIDE_WIDTH = 1;
    private Tree treeLeft = null;
    private Tree treeRight = null;
    private double widthConstraint = 0.0;
    private int excessWidthColumnIndex = -1;
    private boolean isResizeColumnsTimerRunning = false;
    private boolean isResizeColumnsWhenTimerPops = false;
    private boolean isResizingByProgram = false;
    private boolean isInstanceSecondary = false;
    private boolean busyResizing;
    private static boolean isTestedCanGetColWidth = false;
    private static boolean isGetColumnWidths = false;

    public SplitTreeTableColumnManager(Trace t, Tree treeLft, Tree treeRght, boolean addResizeListener) {
        this.treeLeft = treeLft;
        this.treeRight = treeRght;
        if (addResizeListener) {
            this.treeRight.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Trace t2 = Trace.getDefault();
                    SplitTreeTableColumnManager.this.resizeColumns(t2);
                }
            });
        }
    }

    public synchronized void resizeTreeTableColumns(Trace t, boolean canDelay) {
        if (Trace.isTracing) {
            Date date = new Date();
            t.data(67, "SplitTreeTableColumnManager.resizeTreeTableColumns", 300, "resizeColumns at " + date.toString());
        }
        if (this.isResizeColumnsTimerRunning && canDelay) {
            this.isResizeColumnsWhenTimerPops = true;
            if (Trace.isTracing) {
                t.data(67, "SplitTreeTableColumnManager.resizeTreeTableColumns", 300, "timer running, just setting isResizeColumnsWhenTimerPops flag");
            }
        } else if (canDelay) {
            int timerDelay = UiPlugin.getResizeColumnsTimerDelay();
            this.isResizeColumnsWhenTimerPops = false;
            if (timerDelay > 0) {
                this.treeRight.getDisplay().timerExec(timerDelay, new Runnable(){

                    @Override
                    public void run() {
                        Trace t2 = Trace.getDefault();
                        if (Trace.isTracing) {
                            t2.data(67, "SplitTreeTableColumnManager.resizeTreeTableColumns", 300, "resize columns timer popped");
                        }
                        if (SplitTreeTableColumnManager.this.isResizeColumnsWhenTimerPops) {
                            if (Trace.isTracing) {
                                t2.data(67, "SplitTreeTableColumnManager.resizeTreeTableColumns", 300, "flag set, resizing columns");
                            }
                            SplitTreeTableColumnManager.this.setResizingByProgram(true);
                            SplitTreeTableColumnManager.this.resizeColumns(t2);
                            SplitTreeTableColumnManager.this.setResizingByProgram(false);
                        }
                        SplitTreeTableColumnManager.this.isResizeColumnsTimerRunning = false;
                        SplitTreeTableColumnManager.this.isResizeColumnsWhenTimerPops = false;
                    }
                });
                this.isResizeColumnsTimerRunning = true;
            }
            this.setResizingByProgram(true);
            this.resizeColumns(t);
            this.setResizingByProgram(false);
        } else {
            this.setResizingByProgram(true);
            this.resizeColumns(t);
            this.setResizingByProgram(false);
        }
    }

    private void resizeColumns(Trace t) {
        boolean isTreeTableRedrawOff = false;
        if (!this.busyResizing) {
            int treeTableWidthRight;
            this.busyResizing = true;
            boolean isFullColumnResize = true;
            if (UiPlugin.isShutdownInProgress() || this.treeLeft.isDisposed() || this.treeRight.isDisposed()) {
                return;
            }
            int treeTableWidthLeft = this.treeLeft.getClientArea().width;
            if (treeTableWidthLeft > 0) {
                int availableWidth = treeTableWidthLeft - this.treeRight.getGridLineWidth();
                TreeColumn treeColLeft = this.treeLeft.getColumn(0);
                if (SplitTreeTableColumnManager.isGetColumnWidths(t)) {
                    treeColLeft.pack();
                    int width = treeColLeft.getWidth();
                    if (width < availableWidth + 50) {
                        treeColLeft.setWidth(availableWidth + 50);
                    }
                } else {
                    treeColLeft.setWidth(availableWidth + 200);
                }
            }
            if ((treeTableWidthRight = this.treeRight.getClientArea().width) > 0) {
                Object obj;
                int numCols = this.treeRight.getColumnCount();
                int availableWidth = treeTableWidthRight - numCols * this.treeRight.getGridLineWidth();
                boolean isConstrain = false;
                int maxWidth = 999999999;
                if (this.widthConstraint > 0.0 && availableWidth > 0) {
                    isConstrain = true;
                    maxWidth = (int)((double)availableWidth * this.widthConstraint);
                }
                this.treeLeft.setRedraw(false);
                this.treeRight.setRedraw(false);
                isTreeTableRedrawOff = true;
                ArrayList<Integer> constrainedColumns = new ArrayList<Integer>();
                TreeColumn[] treeCols = this.treeRight.getColumns();
                if (treeCols.length > 0) {
                    treeCols[0].setWidth(0);
                    if (!SplitTreeTableColumnManager.isGetColumnWidths(t)) {
                        boolean hasAttributeOrderItem = false;
                        int i = 1;
                        while (i < treeCols.length) {
                            boolean packColumn = true;
                            boolean visible = false;
                            obj = treeCols[i].getData();
                            if (obj instanceof AttributeOrderItem) {
                                hasAttributeOrderItem = true;
                                AttributeOrderItem aoi = (AttributeOrderItem)obj;
                                packColumn = aoi.getWidth() == -1;
                                visible = aoi.isVisible(this.isInstanceSecondary);
                            }
                            if (hasAttributeOrderItem) {
                                if (packColumn && visible) {
                                    treeCols[i].pack();
                                } else if (!visible) {
                                    treeCols[i].setWidth(0);
                                }
                            } else {
                                treeCols[i].pack();
                            }
                            ++i;
                        }
                        isFullColumnResize = false;
                    }
                }
                if (isFullColumnResize) {
                    int spareWidth;
                    int actualWidth = 0;
                    int visibleCount = 0;
                    int i = 1;
                    while (i < treeCols.length) {
                        int tabcolWidth;
                        boolean packColumn = treeCols[i].getWidth() > 0;
                        obj = treeCols[i].getData();
                        if (obj instanceof AttributeOrderItem) {
                            int width = ((AttributeOrderItem)obj).getWidth();
                            boolean bl = packColumn = width == -1 && treeCols[i].getWidth() > 0;
                            if (!packColumn && width > 0) {
                                treeCols[i].setWidth(width);
                            }
                        }
                        if (packColumn) {
                            Image image;
                            treeCols[i].pack();
                            if (isConstrain && treeCols[i].getWidth() > maxWidth && maxWidth != 0) {
                                treeCols[i].setWidth(maxWidth);
                                constrainedColumns.add(i);
                            }
                            if ((image = treeCols[i].getImage()) != null) {
                                treeCols[i].setWidth(treeCols[i].getWidth() + image.getBounds().width);
                            }
                        }
                        if ((tabcolWidth = treeCols[i].getWidth()) > 0) {
                            ++visibleCount;
                        }
                        actualWidth += tabcolWidth;
                        ++i;
                    }
                    if (treeCols[0] != null && treeCols[0].getWidth() == 0) {
                        treeCols[0].setWidth(1);
                        treeCols[0].setResizable(false);
                    }
                    if ((spareWidth = availableWidth - actualWidth) > 0) {
                        if (this.excessWidthColumnIndex != -1) {
                            if (this.excessWidthColumnIndex < treeCols.length) {
                                int width = treeCols[this.excessWidthColumnIndex].getWidth();
                                treeCols[this.excessWidthColumnIndex].setWidth(width + spareWidth);
                            }
                        } else {
                            int count = constrainedColumns.size();
                            if (count > 0) {
                                int delta = spareWidth / count;
                                int i2 = 0;
                                while (i2 < count) {
                                    Integer intIndex = (Integer)constrainedColumns.get(i2);
                                    int index = intIndex;
                                    treeCols[index].setWidth(treeCols[index].getWidth() + delta);
                                    ++i2;
                                }
                            } else {
                                count = treeCols.length;
                                if (visibleCount > 0) {
                                    int delta = spareWidth / visibleCount;
                                    int i3 = 0;
                                    while (i3 < count) {
                                        if (treeCols[i3].getWidth() > 1) {
                                            treeCols[i3].setWidth(treeCols[i3].getWidth() + delta);
                                        }
                                        ++i3;
                                    }
                                }
                            }
                        }
                    }
                }
                if (isTreeTableRedrawOff) {
                    this.treeLeft.setRedraw(true);
                    this.treeRight.setRedraw(true);
                    isTreeTableRedrawOff = false;
                }
                this.treeLeft.update();
                this.treeRight.update();
            }
            this.busyResizing = false;
        }
    }

    public void setMaximumColumnWidthPercent(Trace t, double percent) {
        this.widthConstraint = percent;
    }

    public void setExcessWidthColumnIndex(Trace t, int index) {
        this.excessWidthColumnIndex = index;
    }

    public boolean isResizingByProgram() {
        return this.isResizingByProgram;
    }

    public void setResizingByProgram(boolean byProgram) {
        this.isResizingByProgram = byProgram;
    }

    public static boolean isGetColumnWidths(Trace t) {
        if (!isTestedCanGetColWidth) {
            int testwidth;
            Shell shell = new Shell();
            Composite comp = new Composite((Composite)shell, 0);
            Tree tree = new Tree(comp, 0);
            TreeColumn treeCol = new TreeColumn(tree, 0);
            int width = treeCol.getWidth();
            if (width == (testwidth = 256)) {
                ++testwidth;
            }
            treeCol.setWidth(testwidth);
            if (treeCol.getWidth() != testwidth) {
                isGetColumnWidths = false;
                if (Trace.isTracing) {
                    t.data(67, "SplitTreeTableColumnManager.isGetColumnWidths", 300, "cannot reliably get column widths");
                }
            } else {
                isGetColumnWidths = true;
                if (Trace.isTracing) {
                    t.data(67, "SplitTreeTableColumnManager.isGetColumnWidths", 300, "can reliably get column widths");
                }
            }
            treeCol.setWidth(width);
            isTestedCanGetColWidth = true;
        }
        return isGetColumnWidths;
    }
}

