/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.splittreetable;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.ui.extensions.IMQExtObjectChangedListener;
import com.ibm.mq.explorer.ui.extensions.IMQExtObjectDeletedListener;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.MQExtObjectChangedEvent;
import com.ibm.mq.explorer.ui.extensions.MQExtObjectDeletedEvent;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrder;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderChangedEvent;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderManager;
import com.ibm.mq.explorer.ui.internal.attributeorder.IAttributeOrderChangedListener;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.comparewith.CompareWithProvider;
import com.ibm.mq.explorer.ui.internal.comparewith.ObjectDifferenceDialog;
import com.ibm.mq.explorer.ui.internal.explorertable.SchemeBar;
import com.ibm.mq.explorer.ui.internal.explorertable.StatusBar;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectLink;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObjectLink;
import com.ibm.mq.explorer.ui.internal.queuemanager.IQueueManagerDisconnectActionListener;
import com.ibm.mq.explorer.ui.internal.queuemanager.QueueManagerDisconnectActionEvent;
import com.ibm.mq.explorer.ui.internal.splittreetable.LoadingDmObject;
import com.ibm.mq.explorer.ui.internal.splittreetable.LoadingUiMQObject;
import com.ibm.mq.explorer.ui.internal.splittreetable.SplitTreeTableColumnManager;
import com.ibm.mq.explorer.ui.internal.splittreetable.SplitTreeTableContentChangedEvent;
import com.ibm.mq.explorer.ui.internal.splittreetable.SplitTreeTableContentChangedListener;
import com.ibm.mq.explorer.ui.internal.splittreetable.SplitTreeTableContentProvider;
import com.ibm.mq.explorer.ui.internal.splittreetable.SplitTreeTableExpansionManager;
import com.ibm.mq.explorer.ui.internal.splittreetable.SplitTreeTableItemData;
import com.ibm.mq.explorer.ui.internal.splittreetable.SplitTreeTableLabelProvider;
import com.ibm.mq.explorer.ui.internal.splittreetable.SplitTreeTableSelectionChangedEvent;
import com.ibm.mq.explorer.ui.internal.splittreetable.SplitTreeTableSelectionChangedListener;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.part.ViewPart;

public class SplitTreeTable
extends Composite
implements IMQExtObjectChangedListener,
IMQExtObjectDeletedListener,
IAttributeOrderChangedListener,
DisposeListener,
KeyListener,
IQueueManagerDisconnectActionListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/splittreetable/SplitTreeTable.java";
    public static final int TABLE_LOADING = 1;
    public static final int TABLE_CLEARING = 2;
    public static final int TABLE_RETRIEVING = 3;
    public static final int TABLE_NONE = 4;
    public static final int TABLE_REFRESHING = 5;
    private static final int[] weights = new int[]{25, 75};
    private static final int NUM_STATUS_AREAS = 2;
    private static final int INDEX_STATUS_AREA_TABLE = 0;
    private static final int INDEX_STATUS_AREA_ITEM = 1;
    private Message msgFile = null;
    private static String nlsCompareWith = "";
    private static String nlsClearing = "";
    private static String nlsLoading = "";
    private static String nlsRetrievingData = "";
    private static String nlsRefreshing = "";
    private Tree treeLeft = null;
    private Tree treeRight = null;
    TreeViewer treeViewerLeft = null;
    TreeViewer treeViewerRight = null;
    private TreeColumn treeColLeft = null;
    private ArrayList<TreeColumn> treeColsRight = new ArrayList();
    private SchemeBar schemeBar = null;
    private StatusBar statusBar = null;
    private SplitTreeTableColumnManager columnManager = null;
    private String instanceId = null;
    private boolean isInstanceSecondary = false;
    private String objectId = "";
    private boolean enableContextMenu = true;
    private AttributeOrderManager attrOrderManager = null;
    private String orderId = null;
    private AttributeOrder attrOrder = null;
    private int attrOrderIconAttrId = -1;
    private boolean isListening = false;
    private boolean isStatusBar = true;
    private boolean isSchemeBar = true;
    private boolean isBusyCursorSet = false;
    private boolean isTreeTableRedraw = true;
    private boolean isDMListenerUpdate = false;
    private boolean isEndUpdateTimerRunning = false;
    private boolean restartEndUpdateTimer = false;
    private boolean isInitialUpdate = true;
    private static final int END_UPDATE_TIMER_DELAY = 500;
    private MenuManager menuMgr = null;
    private boolean contextMenuRegistered = false;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
    private Date lastRefreshDate = null;
    private int updateCounter = 0;
    private Hashtable<UiMQObject, SplitTreeTableItemData> hashtableItems = null;
    private Hashtable<IDmObject, UiMQObject> hashtableDmObject = null;
    private IUiMQObjectFactory uiMQObjectFactory = null;
    private UiMQObject parentObjectForFactory = null;
    private Vector<SplitTreeTableSelectionChangedListener> selChangedListeners = null;
    private Vector<SplitTreeTableContentChangedListener> contentChangedListeners = null;
    private Object contextObject = null;
    private Action actionCompare = null;
    private ViewPart explorerViewPart = null;
    private SplitTreeTableContentProvider splitTreeTableContentProvider = null;
    private SplitTreeTableLabelProvider splitTreeTableLabelProvider = null;
    private UiMQObject ownerObject = null;
    private DmQueueManager associatedDmQueueManager = null;
    private boolean isListeningForQueueManagerDisconnectActions = false;
    private SplitTreeTableExpansionManager expansionManager = null;
    private ArrayList<SplitTreeTableItemData> selectedData = null;
    private TreeItem topTreeItemLeft = null;
    private TreeItem topTreeItemRight = null;

    public SplitTreeTable(Trace t, Composite parent, int style, String objName, boolean showSchemeBar, boolean showStatusBar, boolean contextMenu, Object contextObj, SplitTreeTableContentProvider contentProvider) {
        super(parent, style);
        this.isStatusBar = showStatusBar;
        this.isSchemeBar = showSchemeBar;
        this.enableContextMenu = contextMenu;
        this.splitTreeTableContentProvider = contentProvider;
        if (this.splitTreeTableContentProvider == null) {
            t.FFST(67, "SplitTreeTable.SplitTreeTable", 0, 50999, 0, 0, "null content provider", "", "");
        }
        this.selChangedListeners = new Vector();
        this.contentChangedListeners = new Vector();
        this.attrOrderManager = UiPlugin.getAttributeOrderManager();
        this.contextObject = contextObj;
        this.hashtableDmObject = new Hashtable();
        this.hashtableItems = new Hashtable();
        this.expansionManager = new SplitTreeTableExpansionManager();
        this.selectedData = new ArrayList();
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Tables");
        nlsCompareWith = this.msgFile.getMessage(t, "UI.TABLES.Table.CompareWith");
        nlsClearing = this.msgFile.getMessage(t, "UI.TABLES.Table.Clearing");
        nlsLoading = this.msgFile.getMessage(t, "UI.TABLES.Table.Loading");
        nlsRetrievingData = this.msgFile.getMessage(t, "UI.TABLES.Table.Retrieving");
        nlsRefreshing = this.msgFile.getMessage(t, "UI.TABLES.Table.Refreshing");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = false;
        this.setLayout((Layout)gridLayout);
        Composite compMain = new Composite((Composite)this, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        compMain.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        compMain.setLayoutData((Object)gridData);
        SashForm sashForm = new SashForm(compMain, 256);
        Composite compLeft = new Composite((Composite)sashForm, 0);
        FillLayout fillLayout = new FillLayout();
        compLeft.setLayout((Layout)fillLayout);
        Composite compRight = new Composite((Composite)sashForm, 0);
        fillLayout = new FillLayout();
        compRight.setLayout((Layout)fillLayout);
        sashForm.setWeights(weights);
        this.createTableControls(t, compLeft, compRight);
        gridData = new GridData(1808);
        gridData.minimumHeight = 3 * this.treeLeft.getItemHeight() + this.treeLeft.getHeaderHeight();
        sashForm.setLayoutData((Object)gridData);
        this.splitTreeTableLabelProvider = new SplitTreeTableLabelProvider(t, this.treeLeft, this.treeRight);
        this.treeLeft.getShell().addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeiconified(ShellEvent e) {
                Trace tr = Trace.getDefault();
                if (Trace.isTracing) {
                    tr.data(67, "SplitTreeTable.SplitTreeTable", 300, "shell de-iconified - repainting");
                }
                SplitTreeTable.this.repaint();
            }
        });
        this.treeLeft.addKeyListener((KeyListener)this);
        this.treeRight.addKeyListener((KeyListener)this);
        if (this.enableContextMenu) {
            this.hookTableContextMenu(t);
        }
        if (this.isSchemeBar) {
            this.schemeBar = new SchemeBar(t, compMain, 2048);
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            this.schemeBar.setLayoutData(gridData);
            Action actionResetWidths = new Action(){

                public void run() {
                    Trace tr = Trace.getDefault();
                    SplitTreeTable.this.resetColumnWidths(tr);
                }
            };
            actionResetWidths.setText(this.msgFile.getMessage(t, "UI.SCHEMES.Dialog.ResetColumnWidths"));
            UiPlugin.getHelpSystem().setHelp((IAction)actionResetWidths, "com.ibm.mq.explorer.ui.infopop.UI_ResetColumnWidthsMenuItem");
            if (SplitTreeTableColumnManager.isGetColumnWidths(t)) {
                this.schemeBar.addAdditionalMenuAction(t, actionResetWidths);
            }
        }
        if (this.isStatusBar) {
            this.statusBar = new StatusBar(t, compMain, 0, 2);
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            this.statusBar.setLayoutData(gridData);
        }
        this.addDisposeListener(this);
        this.attrOrderManager.addChangedListener(t, this);
    }

    private void createTableControls(Trace t, Composite compLeft, Composite compRight) {
        this.treeLeft = new Tree(compLeft, 67840);
        this.treeLeft.setHeaderVisible(true);
        this.treeLeft.setLinesVisible(true);
        this.treeRight = new Tree(compRight, 68352);
        this.treeRight.setHeaderVisible(true);
        this.treeRight.setLinesVisible(true);
        this.columnManager = new SplitTreeTableColumnManager(t, this.treeLeft, this.treeRight, false);
        this.treeLeft.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SplitTreeTable.this.treeRight.setTopItem(SplitTreeTable.this.treeLeft.getTopItem());
            }
        });
        this.treeRight.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SplitTreeTable.this.treeLeft.setTopItem(SplitTreeTable.this.treeRight.getTopItem());
            }
        });
        this.treeLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace tr = Trace.getDefault();
                TreeItem[] selItems = SplitTreeTable.this.treeLeft.getSelection();
                if (selItems != null && selItems.length > 0) {
                    MQExtObject mqExtObject = (MQExtObject)selItems[0].getData();
                    UiMQObject uiMQObject = (UiMQObject)mqExtObject.getInstanceId();
                    SplitTreeTableItemData splitTreeTableItemData = (SplitTreeTableItemData)SplitTreeTable.this.hashtableItems.get(uiMQObject);
                    if (splitTreeTableItemData != null) {
                        SplitTreeTable.this.treeRight.setSelection(splitTreeTableItemData.treeItemRight);
                        SplitTreeTable.this.treeItemSelected(tr, splitTreeTableItemData);
                        SplitTreeTable.this.rememberSelection(tr, splitTreeTableItemData);
                    }
                }
            }
        });
        this.treeRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SplitTreeTableItemData splitTreeTableItemData;
                Trace tr = Trace.getDefault();
                TreeItem[] selItems = SplitTreeTable.this.treeRight.getSelection();
                if (selItems != null && selItems.length > 0 && (splitTreeTableItemData = (SplitTreeTableItemData)selItems[0].getData()) != null) {
                    SplitTreeTable.this.treeLeft.setSelection(splitTreeTableItemData.treeItemLeft);
                    SplitTreeTable.this.treeItemSelected(tr, splitTreeTableItemData);
                    SplitTreeTable.this.rememberSelection(tr, splitTreeTableItemData);
                }
            }
        });
        this.treeLeft.addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
                TreeItem treeItemLeft = (TreeItem)e.item;
                if (treeItemLeft != null) {
                    MQExtObject mqExtObject = (MQExtObject)treeItemLeft.getData();
                    UiMQObject uiMQObject = (UiMQObject)mqExtObject.getInstanceId();
                    SplitTreeTableItemData splitTreeTableItemData = (SplitTreeTableItemData)SplitTreeTable.this.hashtableItems.get(uiMQObject);
                    TreeItem treeItemRight = splitTreeTableItemData.treeItemRight;
                    treeItemRight.setExpanded(false);
                    if (!(uiMQObject instanceof LoadingUiMQObject)) {
                        SplitTreeTable.this.expansionManager.setExpansionState(Trace.getDefault(), uiMQObject, false);
                    }
                }
            }

            public void treeExpanded(TreeEvent e) {
                SplitTreeTable.this.leftTreeItemExpanded(Trace.getDefault(), (TreeItem)e.item);
            }
        });
        this.treeRight.addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
                TreeItem treeItemRight = (TreeItem)e.item;
                if (treeItemRight != null) {
                    SplitTreeTableItemData splitTreeTableItemData = (SplitTreeTableItemData)treeItemRight.getData();
                    TreeItem treeItemLeft = splitTreeTableItemData.treeItemLeft;
                    treeItemLeft.setExpanded(false);
                    UiMQObject uiMQObject = splitTreeTableItemData.uiMQObject;
                    if (!(uiMQObject instanceof LoadingUiMQObject)) {
                        SplitTreeTable.this.expansionManager.setExpansionState(Trace.getDefault(), uiMQObject, false);
                    }
                }
            }

            public void treeExpanded(TreeEvent e) {
                TreeItem treeItemRight = (TreeItem)e.item;
                if (treeItemRight != null) {
                    TreeItem[] children;
                    SplitTreeTableItemData splitTreeTableItemData = (SplitTreeTableItemData)treeItemRight.getData();
                    TreeItem treeItemLeft = splitTreeTableItemData.treeItemLeft;
                    treeItemLeft.setExpanded(true);
                    UiMQObject uiMQObject = splitTreeTableItemData.uiMQObject;
                    if (!(uiMQObject instanceof LoadingUiMQObject)) {
                        SplitTreeTable.this.expansionManager.setExpansionState(Trace.getDefault(), uiMQObject, true);
                    }
                    if ((children = treeItemRight.getItems()) != null && children.length == 1 && ((SplitTreeTableItemData)children[0].getData()).uiMQObject.getId().compareTo("com.ibm.mq.explorer.dummy.loading") == 0) {
                        TreeItem childTreeItemRight = children[0];
                        TreeItem childTreeItemLeft = ((SplitTreeTableItemData)childTreeItemRight.getData()).treeItemLeft;
                        SplitTreeTable.this.loadChildObjects(Trace.getDefault(), ((SplitTreeTableItemData)treeItemRight.getData()).uiMQObject, childTreeItemLeft, childTreeItemRight);
                    }
                }
            }
        });
        this.treeViewerLeft = new TreeViewer(this.treeLeft);
        this.treeViewerRight = new TreeViewer(this.treeRight);
        this.treeViewerLeft.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SplitTreeTable.this.treeDoubleClicked(event);
            }
        });
        this.treeViewerRight.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SplitTreeTable.this.treeDoubleClicked(event);
            }
        });
    }

    protected void treeDoubleClicked(DoubleClickEvent event) {
        Trace t = Trace.getDefault();
        ISelection selection = event.getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection structSel = (IStructuredSelection)selection;
            Object object = structSel.getFirstElement();
            SplitTreeTableItemData splitTreeTableItemData = null;
            if (object instanceof MQExtObject) {
                MQExtObject mqExtObject = (MQExtObject)object;
                UiMQObject uiMQObject = (UiMQObject)mqExtObject.getInstanceId();
                splitTreeTableItemData = this.hashtableItems.get(uiMQObject);
            } else if (object instanceof SplitTreeTableItemData) {
                splitTreeTableItemData = (SplitTreeTableItemData)object;
            }
            if (splitTreeTableItemData != null) {
                boolean isExpanded = splitTreeTableItemData.treeItemLeft.getExpanded();
                if (isExpanded) {
                    splitTreeTableItemData.treeItemLeft.setExpanded(false);
                    splitTreeTableItemData.treeItemRight.setExpanded(false);
                } else {
                    splitTreeTableItemData.treeItemLeft.setExpanded(true);
                    this.leftTreeItemExpanded(t, splitTreeTableItemData.treeItemLeft);
                }
            }
        }
    }

    private void leftTreeItemExpanded(Trace t, TreeItem treeItemLeft) {
        MQExtObject mqExtObject;
        UiMQObject uiMQObject;
        SplitTreeTableItemData splitTreeTableItemData;
        if (treeItemLeft != null && (splitTreeTableItemData = this.hashtableItems.get(uiMQObject = (UiMQObject)(mqExtObject = (MQExtObject)treeItemLeft.getData()).getInstanceId())) != null) {
            TreeItem[] children;
            TreeItem treeItemRight = splitTreeTableItemData.treeItemRight;
            treeItemRight.setExpanded(true);
            if (!(uiMQObject instanceof LoadingUiMQObject)) {
                this.expansionManager.setExpansionState(Trace.getDefault(), uiMQObject, true);
            }
            if ((children = treeItemRight.getItems()) != null && children.length == 1 && ((SplitTreeTableItemData)children[0].getData()).uiMQObject.getId().compareTo("com.ibm.mq.explorer.dummy.loading") == 0) {
                TreeItem childTreeItemRight = children[0];
                TreeItem childTreeItemLeft = ((SplitTreeTableItemData)childTreeItemRight.getData()).treeItemLeft;
                this.loadChildObjects(Trace.getDefault(), ((SplitTreeTableItemData)treeItemRight.getData()).uiMQObject, childTreeItemLeft, childTreeItemRight);
            }
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MQExtObject mqExtObj = (MQExtObject)SplitTreeTable.this.treeLeft.getTopItem().getData();
                    UiMQObject uiMQObj = (UiMQObject)mqExtObj.getInstanceId();
                    SplitTreeTableItemData splitData = (SplitTreeTableItemData)SplitTreeTable.this.hashtableItems.get(uiMQObj);
                    SplitTreeTable.this.treeRight.setTopItem(splitData.treeItemRight);
                }
            });
        }
    }

    public void setAttributeOrderId(Trace t, String id) {
        this.orderId = id;
        AttributeOrder attOrder = null;
        if (this.attrOrderManager.isRegistered(t, this.orderId)) {
            attOrder = this.attrOrderManager.getRegisteredCurrentAttributeOrder(t, this.orderId, this.instanceId);
        }
        if (attOrder == null) {
            t.FFST(67, "SplitTreeTable.setAttributeOrderId", 10, 50020, 0, 0, "Failed to get RegisteredCurrentAttributeOrder", id, this.instanceId);
        } else {
            this.useAttributeOrder(t, attOrder);
        }
    }

    private void hookTableContextMenu(Trace t) {
        this.menuMgr = new MenuManager("#PopupMenu");
        this.menuMgr.setRemoveAllWhenShown(true);
        this.menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Trace tr = Trace.getDefault();
                SplitTreeTable.this.fillTableContextMenu(tr, manager);
                IContributionItem[] contributions = manager.getItems();
                if (contributions.length == 0) {
                    manager.add((IContributionItem)new Separator("additions"));
                }
            }
        });
        Menu menuLeft = this.menuMgr.createContextMenu((Control)this.treeLeft);
        this.treeLeft.setMenu(menuLeft);
        if (this.explorerViewPart != null) {
            this.explorerViewPart.getSite().registerContextMenu(this.menuMgr, (ISelectionProvider)this.treeViewerLeft);
            this.contextMenuRegistered = true;
        }
        Menu menuRight = this.menuMgr.createContextMenu((Control)this.treeLeft);
        this.treeRight.setMenu(menuRight);
        if (this.explorerViewPart != null) {
            this.explorerViewPart.getSite().registerContextMenu(this.menuMgr, (ISelectionProvider)this.treeViewerRight);
        }
    }

    private void fillTableContextMenu(Trace t, IMenuManager manager) {
        UiMQObject selObject = this.getSelectedItem(t);
        if (selObject != null) {
            CompareWithProvider uiCompareWithProvider;
            if (this.actionCompare == null) {
                this.actionCompare = new Action(){

                    public void run() {
                        Trace tr = Trace.getDefault();
                        SplitTreeTable.this.compareWith(tr);
                    }
                };
                this.actionCompare.setText(nlsCompareWith);
                UiPlugin.getHelpSystem().setHelp((IAction)this.actionCompare, "com.ibm.mq.explorer.ui.infopop.UI_CompareWithMenuItem");
            }
            if ((uiCompareWithProvider = selObject.getCompareWithProvider(t)) != null && uiCompareWithProvider.isSupportCompareWith()) {
                manager.add((IAction)this.actionCompare);
                manager.add((IContributionItem)new Separator("com.ibm.mq.explorer.comparewith"));
            }
            selObject.appendToContextMenu(this.getShell(), manager, this.contextObject);
            manager.add((IContributionItem)new Separator("com.ibm.mq.explorer.explorertable"));
        }
    }

    public void setViewPart(Trace t, ViewPart part) {
        this.explorerViewPart = part;
        if (this.enableContextMenu && !this.contextMenuRegistered) {
            this.explorerViewPart.getSite().registerContextMenu(this.menuMgr, (ISelectionProvider)this.treeViewerLeft);
            this.explorerViewPart.getSite().registerContextMenu(this.menuMgr, (ISelectionProvider)this.treeViewerRight);
            this.contextMenuRegistered = true;
        }
    }

    private void compareWith(Trace t) {
        UiMQObject selUiMQObject = this.getSelectedItem(t);
        if (selUiMQObject != null) {
            ObjectDifferenceDialog objectDifferenceDialog = new ObjectDifferenceDialog(this.getShell());
            AttributeOrder fullAttrOrder = this.attrOrderManager.getFullAttributeOrder(t, this.orderId);
            objectDifferenceDialog.setAttributeOrder(fullAttrOrder);
            objectDifferenceDialog.setObjectWithChoice(t, selUiMQObject, null, this.parentObjectForFactory);
            objectDifferenceDialog.open();
        }
    }

    public void setInstance(Trace t, String instId, boolean isSecondary) {
        if (!this.treeLeft.isDisposed() && !this.treeRight.isDisposed()) {
            AttributeOrder attOrder = null;
            boolean isSecondaryChanged = isSecondary ^ this.isInstanceSecondary;
            if (this.isDifferentInstance(t, instId, isSecondary)) {
                this.instanceId = instId;
                this.isInstanceSecondary = isSecondary;
                if (this.isSchemeBar) {
                    this.schemeBar.setInstance(t, instId, isSecondary);
                }
                if (this.attrOrderManager.isRegistered(t, this.orderId)) {
                    attOrder = this.attrOrderManager.getRegisteredCurrentAttributeOrder(t, this.orderId, instId);
                }
                if (attOrder == null) {
                    t.FFST(67, "SplitTreeTable.setInstance", 10, 50020, 0, 0, "Failed to get RegisteredCurrentAttributeOrder", this.orderId, instId);
                } else if (attOrder.compareTo(this.attrOrder) != 0 || isSecondaryChanged) {
                    this.reshowColumns(t, attOrder);
                }
            }
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        Trace t = Trace.getDefault();
        if (e.getSource().equals(this)) {
            this.attrOrderManager.removeChangedListener(t, this);
            if (this.isListeningForQueueManagerDisconnectActions) {
                UiPlugin.removeQueueManagerDisconnectActionListener(t, this);
            }
            this.unhideAllColumns(t);
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        UiMQObject uiMQObject;
        Trace t = Trace.getDefault();
        if (e.keyCode == 127 && this.enableContextMenu && (uiMQObject = this.getSelectedItem(t)) != null && uiMQObject.isSupportDelete()) {
            uiMQObject.deleteMenuAction(t);
        }
    }

    @Override
    public void mqExtObjectChanged(MQExtObjectChangedEvent event) {
        Trace t = Trace.getDefault();
        MQExtObject mqExtObject = event.getMQExtObject();
        UiMQObject uiMQObject = (UiMQObject)mqExtObject.getInternalObject();
        SplitTreeTable.trace(t, "SplitTreeTable.mqExtObjectChanged", "object changed is " + uiMQObject.toString());
        this.refreshItem(uiMQObject);
        this.repaint();
    }

    @Override
    public void mqExtObjectDeleted(MQExtObjectDeletedEvent event) {
        Trace t = Trace.getDefault();
        MQExtObject mqExtObject = event.getMQExtObject();
        UiMQObject uiMQObject = (UiMQObject)mqExtObject.getInternalObject();
        SplitTreeTable.trace(t, "SplitTreeTable.mqExtObjectDeleted", "object deleted is " + uiMQObject.toString());
        this.deleteItem(uiMQObject);
    }

    @Override
    public void changed(AttributeOrderChangedEvent e) {
        Trace t = Trace.getDefault();
        if (!this.treeLeft.isDisposed() && !this.treeRight.isDisposed() && this.orderId != null && e.getOrderId().compareTo(this.orderId) == 0) {
            AttributeOrder attOrder = this.attrOrderManager.getRegisteredCurrentAttributeOrder(t, this.orderId, this.instanceId);
            if (attOrder == null) {
                t.FFST(67, "SplitTreeTable.changed", 10, 50020, 0, 0, "Failed to get RegisteredCurrentAttributeOrder", this.orderId, this.instanceId);
            } else {
                this.reshowColumns(t, attOrder);
            }
        }
    }

    @Override
    public void selectionChanged(AttributeOrderChangedEvent e) {
        Trace t = Trace.getDefault();
        if (!this.treeLeft.isDisposed() && !this.treeRight.isDisposed() && this.orderId != null && e.getOrderId().compareTo(this.orderId) == 0) {
            AttributeOrder attOrder = this.attrOrderManager.getRegisteredCurrentAttributeOrder(t, this.orderId, this.instanceId);
            if (attOrder == null) {
                t.FFST(67, "SplitTreeTable.selectionChanged", 10, 50020, 0, 0, "Failed to get RegisteredCurrentAttributeOrder", this.orderId, this.instanceId);
            } else {
                this.reshowColumns(t, attOrder);
            }
        }
    }

    private void reshowColumns(Trace t, AttributeOrder attOrder) {
        this.showBusyCursor(t);
        this.attrOrder = attOrder;
        this.attrOrderIconAttrId = this.attrOrder.getIconAttrId(t);
        this.splitTreeTableLabelProvider.setIconAttributeId(this.attrOrderIconAttrId);
        this.setTreeTableRedraw(t, false);
        AttributeOrderItem attrOrderItem = this.attrOrder.getAttributeOrderItemFromPosition(t, 0, this.isInstanceSecondary);
        this.treeColLeft.setData((Object)attrOrderItem);
        if (attrOrderItem != null) {
            this.treeColLeft.setText(attrOrderItem.getAttributeName());
        } else {
            this.treeColLeft.setText("");
            t.data(67, "SplitTreeTable.reshowColumns", 900, "failed to find AttributeOrderItem for column in left-hand tree table");
        }
        int i = 0;
        while (i < this.treeColsRight.size()) {
            TreeColumn treecol = this.treeColsRight.get(i);
            attrOrderItem = this.attrOrder.getAttributeOrderItemFromPosition(t, i, this.isInstanceSecondary);
            if (attrOrderItem != null) {
                treecol.setText(attrOrderItem.getAttributeName());
                this.columnManager.setResizingByProgram(true);
                int width = 100;
                if (i == 0) {
                    width = 0;
                } else {
                    width = attrOrderItem.getWidth();
                    if (width <= 0) {
                        width = 100;
                    }
                }
                treecol.setWidth(width);
                this.columnManager.setResizingByProgram(false);
                treecol.setResizable(true);
                treecol.setData((Object)attrOrderItem);
            } else {
                this.columnManager.setResizingByProgram(true);
                treecol.setWidth(0);
                this.columnManager.setResizingByProgram(false);
                treecol.setResizable(false);
                treecol.setData(null);
            }
            ++i;
        }
        this.resizeTreeTableColumns(t, false);
        this.setTreeTableRedraw(t, true);
        if (this.isSchemeBar) {
            this.schemeBar.setScheme(t, this.attrOrder);
        }
        this.repaint();
        this.showNormalCursor(t);
    }

    public UiMQObject getSelectedItem(Trace t) {
        Object object;
        TreeItem[] selItems;
        UiMQObject selObject = null;
        if (!this.treeLeft.isDisposed() && !this.treeRight.isDisposed() && (selItems = this.treeLeft.getSelection()) != null && selItems.length > 0 && (object = selItems[0].getData()) instanceof MQExtObject) {
            MQExtObject mqExtObject = (MQExtObject)object;
            selObject = (UiMQObject)mqExtObject.getInstanceId();
        }
        return selObject;
    }

    public TreeItem getSelectedTreeItem(Trace t) {
        TreeItem[] selItems;
        TreeItem selItem = null;
        if (!this.treeLeft.isDisposed() && !this.treeRight.isDisposed() && (selItems = this.treeLeft.getSelection()) != null && selItems.length > 0) {
            selItem = selItems[0];
        }
        return selItem;
    }

    private void useAttributeOrder(Trace t, AttributeOrder attOrder) {
        AttributeOrderItem attrOrderItem;
        int maxPosition = -1;
        this.unhideAllColumns(t);
        this.attrOrder = attOrder;
        this.attrOrderIconAttrId = this.attrOrder.getIconAttrId(t);
        this.splitTreeTableLabelProvider.setIconAttributeId(this.attrOrderIconAttrId);
        this.setTreeTableRedraw(t, false);
        int i = 0;
        while (i < this.attrOrder.size()) {
            attrOrderItem = this.attrOrder.getAttributeOrderItemFromPosition(t, i, this.isInstanceSecondary);
            if (attrOrderItem != null && attrOrderItem.isVisible(this.isInstanceSecondary)) {
                int position = attrOrderItem.getAttributePosition(this.isInstanceSecondary);
                if (position > maxPosition) {
                    maxPosition = position;
                }
                TreeColumn treecol = this.createTreeColumn(t, this.treeRight, attrOrderItem, position);
                treecol.setData((Object)attrOrderItem);
                this.treeColsRight.add(treecol);
                if (position == 0) {
                    this.treeColLeft = this.createTreeColumn(t, this.treeLeft, attrOrderItem, position);
                    this.treeColLeft.setWidth(500);
                    this.treeColLeft.setData((Object)attrOrderItem);
                    treecol.setWidth(0);
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.attrOrder.size()) {
            attrOrderItem = this.attrOrder.get(t, i);
            if (!attrOrderItem.isVisible(this.isInstanceSecondary)) {
                TreeColumn treecol = this.createTreeColumn(t, this.treeRight, attrOrderItem, ++maxPosition);
                this.treeColsRight.add(treecol);
                this.columnManager.setResizingByProgram(true);
                treecol.setWidth(0);
                attrOrderItem.setWidth(0);
                this.columnManager.setResizingByProgram(false);
                treecol.setResizable(false);
            }
            ++i;
        }
        if (this.isSchemeBar) {
            this.schemeBar.setScheme(t, this.attrOrder);
        }
        this.columnManager.setResizingByProgram(true);
        this.columnManager.resizeTreeTableColumns(t, false);
        this.columnManager.setResizingByProgram(false);
        this.setTreeTableRedraw(t, true);
    }

    private TreeColumn createTreeColumn(Trace t, Tree tree, AttributeOrderItem attrOrderItem, int position) {
        TreeColumn treecol = new TreeColumn(tree, 0, position);
        treecol.setText(attrOrderItem.getAttributeName());
        this.columnManager.setResizingByProgram(true);
        treecol.setResizable(true);
        treecol.pack();
        if (!attrOrderItem.isVisible(this.isInstanceSecondary)) {
            treecol.setWidth(0);
            treecol.setResizable(false);
            SplitTreeTable.trace(t, "SplitTreeTable.createTreeColumn", "invisible column");
        }
        this.columnManager.setResizingByProgram(false);
        treecol.setData((Object)attrOrderItem);
        treecol.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TreeColumn treecolumn;
                Object source;
                if (!SplitTreeTable.this.columnManager.isResizingByProgram() && (source = e.getSource()) != null && source instanceof TreeColumn && (treecolumn = (TreeColumn)source).getData() != null) {
                    AttributeOrderItem attOrderItem = (AttributeOrderItem)treecolumn.getData();
                    attOrderItem.setWidth(treecolumn.getWidth());
                }
            }
        });
        return treecol;
    }

    @Override
    public void queueManagerBeingDisconnected(QueueManagerDisconnectActionEvent event) {
        Trace t = Trace.getDefault();
        DmQueueManager dmQmgr = event.getDmQueueManager();
        if (dmQmgr.equals((Object)this.associatedDmQueueManager)) {
            this.removeAll(t);
        }
    }

    public void setUiMQObjectFactoryClass(Trace t, IUiMQObjectFactory factoryClass, UiMQObject parentToNewObjects) {
        this.uiMQObjectFactory = factoryClass;
        this.parentObjectForFactory = parentToNewObjects;
    }

    private void resetColumnWidths(Trace t) {
        this.showBusyCursor(t);
        ArrayList<AttributeOrderItem> aoItems = this.attrOrder.getAttributeOrderItems(t);
        int i = 0;
        while (i < aoItems.size()) {
            AttributeOrderItem attrOrderItem = aoItems.get(i);
            if (attrOrderItem.getWidth() != 0) {
                attrOrderItem.setWidth(-1);
            }
            ++i;
        }
        this.reshowColumns(t, this.attrOrder);
        this.showNormalCursor(t);
    }

    private void resizeTreeTableColumns(Trace t, boolean canDelay) {
        this.updateTableLoadingStatus(t, 5);
        boolean setBusyCursor = this.showBusyCursor(t);
        this.columnManager.setResizingByProgram(true);
        this.columnManager.resizeTreeTableColumns(t, canDelay);
        this.columnManager.setResizingByProgram(false);
        if (setBusyCursor) {
            this.showNormalCursor(t);
        }
        this.updateTableLoadingStatus(t, 4);
    }

    private boolean showBusyCursor(Trace t) {
        boolean result = false;
        if (!this.isBusyCursorSet) {
            UiPlugin.showBusyCursor(t, true);
            this.isBusyCursorSet = true;
            result = true;
        }
        return result;
    }

    private void showNormalCursor(Trace t) {
        UiPlugin.showBusyCursor(t, false);
        this.isBusyCursorSet = false;
    }

    public void removeAll(Trace t) {
        this.removeAll(t, true, true);
    }

    public void removeAll(Trace t, boolean clearExpansionList, boolean notifyListeners) {
        if (!this.treeLeft.isDisposed() && !this.treeRight.isDisposed()) {
            this.setStatus(t, nlsClearing, 0);
            Enumeration<UiMQObject> keys = this.hashtableItems.keys();
            while (keys.hasMoreElements()) {
                UiMQObject uiMQObject = keys.nextElement();
                MQExtObject mqExtObject = uiMQObject.getExternalObject();
                mqExtObject.removeObjectChangedListener(this);
            }
            this.hashtableItems.clear();
            this.hashtableDmObject.clear();
            if (clearExpansionList) {
                this.expansionManager.clearExpansionList(t);
            }
            this.treeLeft.removeAll();
            this.treeRight.removeAll();
            this.topTreeItemLeft = null;
            this.topTreeItemRight = null;
            this.treeLeft.redraw();
            this.treeRight.redraw();
            this.setStatus(t, "", 0);
            this.setStatus(t, "", 1);
            if (notifyListeners) {
                this.sendContentChangedEvent(t);
            }
            this.splitTreeTableLabelProvider.clearGreyCellLists(t);
        }
    }

    public void updateTableLoadingStatus(Trace t, int status) {
        switch (status) {
            case 1: {
                this.setStatus(t, nlsLoading, 0);
                break;
            }
            case 3: {
                this.setStatus(t, nlsRetrievingData, 0);
                break;
            }
            case 4: {
                this.updateLastRefreshText(t);
                break;
            }
            case 5: {
                this.setStatus(t, nlsRefreshing, 0);
                break;
            }
            default: {
                this.setStatus(t, "", 0);
            }
        }
    }

    public void updateLastRefreshText(Trace t) {
        if (!this.treeLeft.isDisposed() && !this.treeRight.isDisposed() && this.isStatusBar) {
            String dateString = this.lastRefreshDate != null ? this.dateFormat.format(this.lastRefreshDate) : this.dateFormat.format(new Date());
            String statusText = Message.format((String)this.msgFile.getMessage(t, "UI.TABLES.Table.Last.Refresh"), (String)dateString);
            this.setStatus(t, statusText, 0);
        }
    }

    private void unhideAllColumns(Trace t) {
        if (this.attrOrder != null) {
            int i = 0;
            while (i < this.attrOrder.size()) {
                AttributeOrderItem attrOrderItem = this.attrOrder.get(t, i);
                if (attrOrderItem != null) {
                    attrOrderItem.setForcedNotVisible(false);
                }
                ++i;
            }
        }
    }

    private void setStatus(Trace t, String status, int index) {
        if (this.statusBar != null && !this.statusBar.isDisposed()) {
            this.statusBar.showMessage(t, status, index);
        }
    }

    private void setTreeTableRedraw(Trace t, boolean isRedraw) {
        if (this.isTreeTableRedraw != isRedraw) {
            this.treeLeft.setRedraw(isRedraw);
            this.treeRight.setRedraw(isRedraw);
            this.isTreeTableRedraw = isRedraw;
        }
    }

    private static void trace(Trace t, String fid, String msg) {
        if (Trace.isTracing) {
            t.data(67, fid, 300, msg);
        }
    }

    private boolean isDifferentInstance(Trace t, String instId, boolean isSecondary) {
        boolean result = false;
        boolean instanceIdDifferent = true;
        if (instId == null && this.instanceId == null) {
            instanceIdDifferent = false;
        } else if (instId == null || this.instanceId == null) {
            instanceIdDifferent = true;
        } else if (instId.compareTo(this.instanceId) == 0) {
            instanceIdDifferent = false;
        }
        boolean isSecondaryDifferent = isSecondary ^ this.isInstanceSecondary;
        result = instanceIdDifferent || isSecondaryDifferent;
        return result;
    }

    public void addSelChangedListener(Trace t, SplitTreeTableSelectionChangedListener listener) {
        this.selChangedListeners.addElement(listener);
    }

    public void removeSelChangedListener(Trace t, SplitTreeTableSelectionChangedListener listener) {
        this.selChangedListeners.removeElement(listener);
    }

    public void addContentChangedListener(Trace t, SplitTreeTableContentChangedListener listener) {
        this.contentChangedListeners.addElement(listener);
    }

    public void removeContentChangedListener(Trace t, SplitTreeTableContentChangedListener listener) {
        this.contentChangedListeners.removeElement(listener);
    }

    private void sendSelectionChangedEvent(Trace t, UiMQObject selObject) {
        SplitTreeTableSelectionChangedEvent selEvent = new SplitTreeTableSelectionChangedEvent(this, selObject);
        int size = this.selChangedListeners.size();
        int i = 0;
        while (i < size) {
            SplitTreeTableSelectionChangedListener listener = this.selChangedListeners.elementAt(i);
            listener.selChanged(selEvent);
            ++i;
        }
    }

    private void sendContentChangedEvent(Trace t) {
        int size = this.contentChangedListeners.size();
        if (size > 0) {
            SplitTreeTableContentChangedEvent ccEvent = new SplitTreeTableContentChangedEvent(this);
            int i = 0;
            while (i < size) {
                SplitTreeTableContentChangedListener listener = this.contentChangedListeners.elementAt(i);
                listener.contentChanged(ccEvent);
                ++i;
            }
        }
    }

    public void refresh() {
        Trace t = Trace.getDefault();
        if (!this.treeLeft.isDisposed() && !this.treeRight.isDisposed()) {
            this.lastRefreshDate = new Date();
            this.removeAll(t, false, false);
            if (this.splitTreeTableContentProvider != null) {
                this.splitTreeTableContentProvider.getInitialObjects(t, this.ownerObject);
            }
        }
    }

    public void repaint() {
        Trace t = Trace.getDefault();
        if (!this.treeLeft.isDisposed() && !this.treeRight.isDisposed()) {
            this.updateTableLoadingStatus(t, 5);
            boolean setBusyCursor = this.showBusyCursor(t);
            Enumeration<UiMQObject> uiMQObjects = this.hashtableItems.keys();
            while (uiMQObjects.hasMoreElements()) {
                this.updateObject(t, uiMQObjects.nextElement());
            }
            this.splitTreeTableLabelProvider.paintGreyCells(t);
            this.setTreeTableRedraw(t, true);
            if (setBusyCursor) {
                this.showNormalCursor(t);
            }
            this.updateTableLoadingStatus(t, 4);
        }
    }

    public void beginUpdate(Trace t) {
        if (!this.treeLeft.isDisposed() && !this.treeRight.isDisposed()) {
            this.showBusyCursor(t);
            if (this.isStatusBar && !this.statusBar.isDisposed()) {
                this.statusBar.setProgressBarVisible(t, true);
            }
            this.setTreeTableRedraw(t, false);
            ++this.updateCounter;
            this.topTreeItemLeft = this.treeLeft.getTopItem();
            this.topTreeItemRight = this.treeRight.getTopItem();
        }
    }

    public void endUpdate(Trace t) {
        if (this.isEndUpdateTimerRunning) {
            if (Trace.isTracing) {
                t.data(67, "SplitTreeTable.endUpdate", 300, "EndUpdateTimer already running, setting flag to restart when pops");
            }
            this.restartEndUpdateTimer = true;
        } else {
            this.startEndUpdateTimer(t);
        }
    }

    private void startEndUpdateTimer(Trace t) {
        if (!(UiPlugin.isShutdownInProgress() || this.treeLeft.isDisposed() || this.treeRight.isDisposed())) {
            this.getDisplay().timerExec(500, new Runnable(){

                @Override
                public void run() {
                    Trace tr = Trace.getDefault();
                    if (SplitTreeTable.this.restartEndUpdateTimer) {
                        if (Trace.isTracing) {
                            tr.data(67, "SplitTreeTable.startEndUpdateTimer", 300, "restarting EndUpdateTimer");
                        }
                        SplitTreeTable.this.restartEndUpdateTimer = false;
                        SplitTreeTable.this.startEndUpdateTimer(tr);
                    } else {
                        if (Trace.isTracing) {
                            tr.data(67, "SplitTreeTable.startEndUpdateTimer", 300, "end update timer popped - doing end update");
                        }
                        if (!UiPlugin.isShutdownInProgress()) {
                            SplitTreeTable.this.doEndUpdate(tr);
                        }
                        SplitTreeTable.this.isEndUpdateTimerRunning = false;
                    }
                }
            });
            this.isEndUpdateTimerRunning = true;
        }
    }

    public void doEndUpdate(Trace t) {
        if (!this.treeLeft.isDisposed() && !this.treeRight.isDisposed()) {
            if (this.updateCounter > 0) {
                if (!(UiPlugin.isShutdownInProgress() || this.treeLeft.isDisposed() || this.treeRight.isDisposed())) {
                    this.restoreSelection(t);
                    if (this.topTreeItemLeft != null) {
                        this.treeLeft.setTopItem(this.topTreeItemLeft);
                    }
                    if (this.topTreeItemRight != null) {
                        this.treeRight.setTopItem(this.topTreeItemRight);
                    }
                    this.setTreeTableRedraw(t, true);
                    Shell shell = this.getShell();
                    if (shell != null) {
                        if (!this.getShell().getMinimized()) {
                            this.repaint();
                            this.resizeTreeTableColumns(t, false);
                        } else if (Trace.isTracing) {
                            t.data(67, "SplitTreeTable.doEndUpdate", 300, "suppressing update - shell is minimized");
                        }
                        if (this.isStatusBar) {
                            this.statusBar.setProgressBarVisible(t, false);
                            if (!this.isListening) {
                                this.updateLastRefreshText(t);
                            }
                        }
                        --this.updateCounter;
                        this.isDMListenerUpdate = false;
                        this.sendContentChangedEvent(t);
                        this.showNormalCursor(t);
                    }
                }
            } else if (this.isInitialUpdate) {
                this.sendContentChangedEvent(t);
                this.isInitialUpdate = false;
            }
        }
    }

    protected boolean refreshItem(Object item) {
        Trace t = Trace.getDefault();
        boolean result = false;
        UiMQObject uiMQObject = null;
        if (item instanceof UiMQObject) {
            uiMQObject = (UiMQObject)item;
        } else if (item instanceof DmObject) {
            DmObject dmObject = (DmObject)item;
            if (this.objectId.compareTo("com.ibm.mq.explorer.queuemanagerhandle") == 0 && dmObject instanceof DmQueueManager) {
                dmObject = ((DmQueueManager)dmObject).getConnectionHandle();
            }
            if ((uiMQObject = this.hashtableDmObject.get(dmObject)) == null) {
                SplitTreeTable.trace(t, "SplitTreeTable.refreshItem", "dmObject " + ((DmObject)item).getTitle() + " not in table, ignoring");
            }
        }
        if (uiMQObject != null) {
            SplitTreeTable.trace(t, "SplitTreeTable.refreshItem", "refreshing UiMQObject " + uiMQObject.toString());
            if (this.hashtableItems.contains(uiMQObject)) {
                if (!this.isDMListenerUpdate) {
                    this.beginUpdate(t);
                    this.isDMListenerUpdate = true;
                }
                SplitTreeTable.trace(t, "SplitTreeTable.refreshItem", "UiMQObject " + uiMQObject.toString() + " is in table, refreshing it");
                this.updateObject(t, uiMQObject);
                result = true;
            } else {
                SplitTreeTable.trace(t, "SplitTreeTable.refreshItem", "UiMQObject " + uiMQObject.toString() + " not in table, ignoring");
            }
        }
        return result;
    }

    protected boolean addItem(Object item) {
        Trace t = Trace.getDefault();
        boolean result = false;
        if (!this.isDMListenerUpdate) {
            this.beginUpdate(t);
            this.isDMListenerUpdate = true;
        }
        UiMQObject uiMQObject = null;
        if (item instanceof UiMQObject) {
            SplitTreeTable.trace(t, "SplitTreeTable.addItem", "item being added is a UiMQObject");
            uiMQObject = (UiMQObject)item;
        } else if (item instanceof DmObject) {
            SplitTreeTable.trace(t, "SplitTreeTable.addItem", "item being added is a DmObject");
            uiMQObject = this.hashtableDmObject.get(item);
        }
        if (uiMQObject != null) {
            if (this.hashtableItems.contains(uiMQObject)) {
                SplitTreeTable.trace(t, "SplitTreeTable.addItem", "UiMQObject " + uiMQObject.toString() + " is already in table, refreshing it");
                this.updateObject(t, uiMQObject);
                result = true;
            } else {
                SplitTreeTable.trace(t, "SplitTreeTable.addItem", "adding supplied UiMQObject " + uiMQObject.toString());
                this.addTreeTableItem(t, uiMQObject);
                result = true;
            }
        } else {
            SplitTreeTable.trace(t, "SplitTreeTable.addItem", "DmObject added, does not exist in table, trying to create using factory");
            if (this.uiMQObjectFactory != null && item instanceof IDmObject) {
                DmObject dmObject = (DmObject)item;
                uiMQObject = this.uiMQObjectFactory.create(t, (IDmObject)dmObject, this.parentObjectForFactory);
                if (uiMQObject != null) {
                    SplitTreeTable.trace(t, "SplitTreeTable.addItem", "adding UiMQObject " + uiMQObject.toString());
                    this.addTreeTableItem(t, uiMQObject);
                    result = true;
                } else {
                    SplitTreeTable.trace(t, "SplitTreeTable.addItem", "failed to create uiMQObject from factory " + dmObject);
                }
            } else if (this.uiMQObjectFactory == null) {
                SplitTreeTable.trace(t, "SplitTreeTable.addItem", "No object factory, unable to make UiMQObject from object " + item.toString());
            } else {
                SplitTreeTable.trace(t, "SplitTreeTable.addItem", "Object " + item.toString() + " is not a DmObject, unable to make UiMQObject from it");
            }
        }
        return result;
    }

    protected boolean deleteItem(Object item) {
        Trace t = Trace.getDefault();
        boolean result = false;
        UiMQObject uiMQObject = null;
        if (item instanceof UiMQObject) {
            uiMQObject = (UiMQObject)item;
        } else if (item instanceof DmObject && (uiMQObject = this.hashtableDmObject.get(item)) == null) {
            SplitTreeTable.trace(t, "SplitTreeTable.deleteItem", "dmObject " + ((DmObject)item).getTitle() + " not in table, ignoring");
        }
        if (uiMQObject != null) {
            SplitTreeTable.trace(t, "SplitTreeTable.deleteItem", "deleting UiMQObject " + uiMQObject.toString());
            if (this.hashtableItems.containsKey(uiMQObject)) {
                this.hashtableItems.remove(uiMQObject);
                if (!this.isDMListenerUpdate) {
                    this.beginUpdate(t);
                    this.isDMListenerUpdate = true;
                }
                SplitTreeTable.trace(t, "SplitTreeTable.deleteItem", "UiMQObject " + uiMQObject.toString() + " was in table, removing it");
                IDmObject dmObject = uiMQObject.getDmObject();
                if (dmObject != null) {
                    this.hashtableDmObject.remove(dmObject);
                }
                result = true;
            } else {
                SplitTreeTable.trace(t, "SplitTreeTable.deleteItem", "UiMQObject " + uiMQObject.toString() + " not in table, ignoring");
            }
        }
        return result;
    }

    public void addTreeTableItem(Trace t, UiMQObject uiMQObject) {
        if (!this.treeLeft.isDisposed() && !this.treeRight.isDisposed()) {
            UiMQObject parentObject;
            boolean isAddObject = true;
            MQExtObject mqExtObject = uiMQObject.getExternalObject();
            if (isAddObject) {
                isAddObject = this.filterSystemObjects(t, uiMQObject);
            }
            if (isAddObject && uiMQObject instanceof UiMQObjectLink && (parentObject = ((UiMQObjectLink)uiMQObject).getParent(t)) != null) {
                if (uiMQObject.toString().equals(parentObject.toString()) && uiMQObject.toString().endsWith("#")) {
                    isAddObject = false;
                } else if (!(uiMQObject instanceof LoadingUiMQObject) && uiMQObject.toString().length() < parentObject.toString().length()) {
                    isAddObject = false;
                }
            }
            if (isAddObject) {
                TreeItem expandTreeItem;
                SplitTreeTableItemData parentSplitTreeTableItemData;
                UiMQObject parentUiMQObject = null;
                TreeItem parentLeftTreeItem = null;
                TreeItem parentRightTreeItem = null;
                TreeItem leftTreeItem = null;
                TreeItem rightTreeItem = null;
                if (uiMQObject instanceof IUiMQObjectLink) {
                    IUiMQObjectLink uiMQObjectLink = (IUiMQObjectLink)((Object)uiMQObject);
                    parentUiMQObject = uiMQObjectLink.getParent(t);
                }
                if (parentUiMQObject != null && this.hashtableItems.containsKey(parentUiMQObject) && (parentSplitTreeTableItemData = this.hashtableItems.get(parentUiMQObject)) != null) {
                    parentLeftTreeItem = parentSplitTreeTableItemData.treeItemLeft;
                    parentRightTreeItem = parentSplitTreeTableItemData.treeItemRight;
                }
                if (parentLeftTreeItem != null && parentRightTreeItem != null) {
                    leftTreeItem = new TreeItem(parentLeftTreeItem, 0);
                    rightTreeItem = new TreeItem(parentRightTreeItem, 0);
                } else {
                    leftTreeItem = new TreeItem(this.treeLeft, 0);
                    rightTreeItem = new TreeItem(this.treeRight, 0);
                }
                SplitTreeTableItemData splitTreeTableItemData = new SplitTreeTableItemData(uiMQObject, leftTreeItem, rightTreeItem, new Date());
                leftTreeItem.setData((Object)mqExtObject);
                rightTreeItem.setData((Object)splitTreeTableItemData);
                this.hashtableItems.put(uiMQObject, splitTreeTableItemData);
                IDmObject dmObject = uiMQObject.getDmObject();
                if (dmObject != null) {
                    this.hashtableDmObject.put(dmObject, uiMQObject);
                }
                this.updateObject(t, uiMQObject);
                mqExtObject.addObjectChangedListener(this);
                if (uiMQObject.getId().compareTo("com.ibm.mq.explorer.dummy.loading") != 0) {
                    LoadingDmObject loadingDmObject = new LoadingDmObject(t, LoadingUiMQObject.getDefaultName());
                    LoadingUiMQObject loadingUiMQObject = new LoadingUiMQObject(t, loadingDmObject);
                    loadingUiMQObject.setParent(t, uiMQObject);
                    if (uiMQObject instanceof IUiMQObjectLink) {
                        ((IUiMQObjectLink)((Object)uiMQObject)).addChild(t, loadingUiMQObject);
                    }
                    this.addTreeTableItem(t, loadingUiMQObject);
                }
                if (!(uiMQObject instanceof LoadingUiMQObject) && this.expansionManager.getExpansionState(t, uiMQObject) && !leftTreeItem.getExpanded()) {
                    expandTreeItem = leftTreeItem;
                    this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            expandTreeItem.setExpanded(true);
                            SplitTreeTable.this.leftTreeItemExpanded(Trace.getDefault(), expandTreeItem);
                        }
                    });
                }
                if (!(uiMQObject instanceof LoadingUiMQObject) && parentUiMQObject != null && this.expansionManager.getExpansionState(t, parentUiMQObject) && !parentLeftTreeItem.getExpanded()) {
                    parentLeftTreeItem.setExpanded(true);
                    expandTreeItem = parentLeftTreeItem;
                    this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SplitTreeTable.this.leftTreeItemExpanded(Trace.getDefault(), expandTreeItem);
                        }
                    });
                }
            }
        }
    }

    public void addSiblingObjects(Trace t, UiMQObject[] objects) {
        if (!this.treeLeft.isDisposed() && !this.treeRight.isDisposed()) {
            boolean allLinkObjects = true;
            int i = 0;
            while (i < objects.length) {
                if (!(objects[i] instanceof UiMQObjectLink)) {
                    allLinkObjects = false;
                    break;
                }
                ++i;
            }
            if (allLinkObjects) {
                final Collator coll = Collator.getInstance(Locale.getDefault());
                Arrays.sort(objects, new Comparator<UiMQObject>(){

                    @Override
                    public int compare(UiMQObject o1, UiMQObject o2) {
                        int response = 0;
                        response = o1 instanceof UiMQObjectLink && o2 instanceof UiMQObjectLink ? coll.compare(((UiMQObjectLink)o1).getTreeName(), ((UiMQObjectLink)o2).getTreeName()) : o1.toString().compareTo(o2.toString());
                        return response;
                    }
                });
            }
            i = 0;
            while (i < objects.length) {
                this.addTreeTableItem(t, objects[i]);
                ++i;
            }
        }
    }

    public void refreshObject(Trace t, UiMQObject parentUiMQObject, UiMQObject refreshUiMQObject, UiMQObject updatedUiMQObject) {
        if (!this.treeLeft.isDisposed() && !this.treeRight.isDisposed()) {
            if (refreshUiMQObject != null) {
                SplitTreeTableItemData splitTreeTableItemData = this.hashtableItems.get(refreshUiMQObject);
                splitTreeTableItemData.uiMQObject = updatedUiMQObject;
                splitTreeTableItemData.lastUpdateDate = new Date();
                this.hashtableItems.remove(refreshUiMQObject);
                this.hashtableItems.put(updatedUiMQObject, splitTreeTableItemData);
                this.hashtableDmObject.remove(refreshUiMQObject.getDmObject());
                this.hashtableDmObject.put(updatedUiMQObject.getDmObject(), updatedUiMQObject);
                this.updateObject(t, updatedUiMQObject);
                splitTreeTableItemData.treeItemLeft.setData((Object)updatedUiMQObject.getExternalObject());
                this.disposeChildTreeItems(splitTreeTableItemData);
                if (updatedUiMQObject.getId().compareTo("com.ibm.mq.explorer.dummy.loading") != 0) {
                    LoadingDmObject loadingDmObject = new LoadingDmObject(t, this.msgFile.getMessage("UI.TABLES.ObjectName.Refreshing"));
                    LoadingUiMQObject loadingUiMQObject = new LoadingUiMQObject(t, loadingDmObject);
                    loadingUiMQObject.setParent(t, updatedUiMQObject);
                    if (updatedUiMQObject instanceof IUiMQObjectLink) {
                        ((IUiMQObjectLink)((Object)updatedUiMQObject)).addChild(t, loadingUiMQObject);
                    }
                    this.addTreeTableItem(t, loadingUiMQObject);
                }
                Display display = UiPlugin.getDisplay();
                final Trace t1 = t;
                final UiMQObject uiMQObject1 = updatedUiMQObject;
                final SplitTreeTableItemData splitTreeTableItemData1 = splitTreeTableItemData;
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SplitTreeTable.this.loadChildObjects(t1, uiMQObject1, splitTreeTableItemData1.treeItemLeft, splitTreeTableItemData1.treeItemRight);
                    }
                });
            } else {
                this.addTreeTableItem(t, updatedUiMQObject);
            }
        }
    }

    private void updateObject(Trace t, UiMQObject uiMQObject) {
        SplitTreeTableItemData splitTreeTableItemData = this.hashtableItems.get(uiMQObject);
        if (splitTreeTableItemData != null) {
            TreeItem treeItemLeft = splitTreeTableItemData.treeItemLeft;
            TreeItem treeItemRight = splitTreeTableItemData.treeItemRight;
            treeItemLeft.setText(0, this.splitTreeTableLabelProvider.getTextForColumn(t, uiMQObject, this.treeColLeft));
            int i = 0;
            while (i < this.treeColsRight.size()) {
                TreeColumn treeCol = this.treeColsRight.get(i);
                treeItemRight.setText(i, this.splitTreeTableLabelProvider.getTextForColumn(t, uiMQObject, treeCol));
                ++i;
            }
        }
    }

    private boolean filterSystemObjects(Trace t, UiMQObject uiMQObject) {
        IDmObject dmObject;
        boolean showSystemObjects;
        boolean isInclude = true;
        if (this.explorerViewPart != null && !(showSystemObjects = UiPlugin.isShowSystemObjects()) && (dmObject = uiMQObject.getDmObject()) != null) {
            isInclude = !uiMQObject.getDmObject().isSystemObject(t);
        }
        return isInclude;
    }

    private void treeItemSelected(Trace t, SplitTreeTableItemData splitTreeTableItemData) {
        if (this.isStatusBar) {
            boolean showTime = true;
            if (splitTreeTableItemData.uiMQObject instanceof UiMQObjectLink) {
                boolean bl = showTime = !((UiMQObjectLink)splitTreeTableItemData.uiMQObject).isDummyObject();
            }
            if (showTime) {
                String dateString = splitTreeTableItemData.lastUpdateDate != null ? this.dateFormat.format(splitTreeTableItemData.lastUpdateDate) : this.dateFormat.format(new Date());
                String statusText = Message.format((String)this.msgFile.getMessage(t, "UI.TABLES.Item.Last.Updated"), (String)dateString);
                this.setStatus(t, statusText, 1);
            } else {
                this.setStatus(t, "", 1);
            }
        }
        this.sendSelectionChangedEvent(t, splitTreeTableItemData.uiMQObject);
    }

    private void loadChildObjects(Trace t, UiMQObject parentObject, TreeItem treeItemLeft, TreeItem treeItemRight) {
        if (this.splitTreeTableContentProvider != null) {
            this.splitTreeTableContentProvider.getChildObjects(t, this.ownerObject, parentObject);
        }
    }

    public void setOwnerObject(UiMQObject object) {
        this.ownerObject = object;
    }

    public void removeLoadingChild(Trace t, UiMQObject parentUiMQObject) {
        if (!this.treeLeft.isDisposed() && !this.treeRight.isDisposed() && parentUiMQObject instanceof IUiMQObjectLink) {
            UiMQObject[] children = ((IUiMQObjectLink)((Object)parentUiMQObject)).getChildren(t);
            int i = 0;
            while (i < children.length) {
                if (children[i].getId().compareTo("com.ibm.mq.explorer.dummy.loading") == 0) {
                    SplitTreeTableItemData loadingItemData;
                    ((IUiMQObjectLink)((Object)parentUiMQObject)).removeChild(t, children[i]);
                    UiMQObject loadingUiMQObject = this.hashtableDmObject.get(children[i].getDmObject());
                    if (loadingUiMQObject != null && (loadingItemData = this.hashtableItems.get(loadingUiMQObject)) != null) {
                        loadingItemData.treeItemLeft.dispose();
                        loadingItemData.treeItemRight.dispose();
                        this.hashtableItems.remove(loadingUiMQObject);
                    }
                    this.hashtableDmObject.remove(children[i].getDmObject());
                }
                ++i;
            }
        }
    }

    public void setAssociatedDmQueueManager(Trace t, DmQueueManager dmQueueManager) {
        this.associatedDmQueueManager = dmQueueManager;
        if (dmQueueManager != null && !this.isListeningForQueueManagerDisconnectActions) {
            UiPlugin.addQueueManagerDisconnectActionListener(t, this);
            this.isListeningForQueueManagerDisconnectActions = true;
        }
    }

    private void rememberSelection(Trace t, SplitTreeTableItemData splitTreeTableItemData) {
        this.selectedData.clear();
        this.selectedData.add(splitTreeTableItemData);
        TreeItem parentTreeItemRight = splitTreeTableItemData.treeItemRight.getParentItem();
        while (parentTreeItemRight != null) {
            SplitTreeTableItemData itemData = (SplitTreeTableItemData)parentTreeItemRight.getData();
            this.selectedData.add(itemData);
            parentTreeItemRight = itemData.treeItemRight.getParentItem();
        }
    }

    private void restoreSelection(Trace t) {
        TreeItem[] treeItems;
        SplitTreeTableItemData splitTreeTableItemData;
        boolean itemSelected = false;
        int count = this.selectedData.size();
        if (count > 0) {
            SplitTreeTableItemData matchingData = null;
            splitTreeTableItemData = this.selectedData.get(count - 1);
            if (splitTreeTableItemData != null) {
                String findName = splitTreeTableItemData.uiMQObject.toString();
                TreeItem[] treeItems2 = this.treeLeft.getItems();
                int i = 0;
                while (i < treeItems2.length) {
                    MQExtObject mqExtObject = (MQExtObject)treeItems2[i].getData();
                    if (mqExtObject.getName().compareTo(findName) == 0) {
                        TreeItem treeItemRight = this.treeRight.getItem(i);
                        SplitTreeTableItemData splitData = (SplitTreeTableItemData)treeItemRight.getData();
                        if (count > 1) {
                            matchingData = this.findMatchingItemInTree(t, count - 2, treeItems2[i], treeItemRight);
                            break;
                        }
                        matchingData = splitData;
                        break;
                    }
                    ++i;
                }
                if (matchingData != null) {
                    this.treeLeft.setSelection(matchingData.treeItemLeft);
                    this.treeRight.setSelection(matchingData.treeItemRight);
                    this.treeItemSelected(t, matchingData);
                    this.rememberSelection(t, matchingData);
                    itemSelected = true;
                }
            }
        }
        if (!itemSelected && (treeItems = this.treeRight.getItems()).length > 0) {
            splitTreeTableItemData = (SplitTreeTableItemData)treeItems[0].getData();
            this.treeLeft.setSelection(splitTreeTableItemData.treeItemLeft);
            this.treeRight.setSelection(splitTreeTableItemData.treeItemRight);
            this.treeItemSelected(t, splitTreeTableItemData);
            this.rememberSelection(t, splitTreeTableItemData);
        }
    }

    private SplitTreeTableItemData findMatchingItemInTree(Trace t, int index, TreeItem parentLeft, TreeItem parentRight) {
        SplitTreeTableItemData matchingData = null;
        String findName = this.selectedData.get((int)index).uiMQObject.toString();
        TreeItem[] children = parentLeft.getItems();
        int i = 0;
        while (i < children.length) {
            MQExtObject mqExtObject = (MQExtObject)children[i].getData();
            if (mqExtObject.getName().compareTo(findName) == 0) {
                if (index > 0) {
                    matchingData = this.findMatchingItemInTree(t, index - 1, children[i], parentRight.getItem(i));
                }
                if (matchingData != null) break;
                matchingData = (SplitTreeTableItemData)parentRight.getItem(i).getData();
                break;
            }
            ++i;
        }
        return matchingData;
    }

    public void refreshSelectedItem(Trace t) {
        if (!this.treeLeft.isDisposed() && !this.treeRight.isDisposed() && this.selectedData.size() > 0) {
            SplitTreeTableItemData splitTreeTableItemData = this.selectedData.get(0);
            UiMQObject refreshObject = splitTreeTableItemData.uiMQObject;
            UiMQObject parentObject = null;
            if (refreshObject instanceof UiMQObjectLink) {
                parentObject = ((UiMQObjectLink)refreshObject).getParent(t);
            }
            this.splitTreeTableContentProvider.refreshObject(t, refreshObject, this.ownerObject, parentObject);
        }
    }

    private void disposeChildTreeItems(SplitTreeTableItemData parentSplitTreeTableItemData) {
        TreeItem[] children = parentSplitTreeTableItemData.treeItemRight.getItems();
        int i = 0;
        while (i < children.length) {
            SplitTreeTableItemData childSplitTreeTableItemData = (SplitTreeTableItemData)children[i].getData();
            this.disposeChildTreeItems(childSplitTreeTableItemData);
            this.hashtableDmObject.remove(childSplitTreeTableItemData.uiMQObject.getDmObject());
            this.hashtableItems.remove(childSplitTreeTableItemData.uiMQObject);
            childSplitTreeTableItemData.treeItemLeft.dispose();
            childSplitTreeTableItemData.treeItemRight.dispose();
            ++i;
        }
    }
}

