/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.queuemanager;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrString;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthString;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeString;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.RepeatingValueObject;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.RepeatingValuesCustomPropertyItemProvider;
import com.ibm.mq.explorer.ui.internal.properties.RepeatingValuesTableCompareColumnItems;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Shell;

public class XAResourceManagerCustomItemProvider
extends RepeatingValuesCustomPropertyItemProvider {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/queuemanager/XAResourceManagerCustomItemProvider.java";
    private static final int[] supportedIds = new int[]{10009, 10011, 10012, 10013, 10010};
    private Message msgFile = null;

    public XAResourceManagerCustomItemProvider(Trace t, UiMQObject uiMQObject) {
        super(t, uiMQObject);
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Queue Manager");
    }

    @Override
    public String getObjectName(Trace t) {
        return this.msgFile.getMessage(t, "UI.QMGR.Properties.XAResource");
    }

    @Override
    public String getGroupBoxText(Trace t) {
        return null;
    }

    @Override
    public String getInformationAreaText(Trace t) {
        return null;
    }

    @Override
    public int[] getAttributeIds(Trace t) {
        return supportedIds;
    }

    @Override
    public boolean isAttributeProcessed(Trace t, int attrId) {
        boolean result = false;
        int i = 0;
        while (i < supportedIds.length) {
            if (attrId == supportedIds[i]) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    @Override
    public ArrayList<RepeatingValueObject> getRepeatingValueObjects(Trace t) {
        ArrayList<RepeatingValueObject> objects = new ArrayList<RepeatingValueObject>();
        IDmObject dmObject = this.getDmObject();
        int count = dmObject.getRepeatingIndexes(t, supportedIds[0]);
        int i = 0;
        while (i < count) {
            RepeatingValueObject rvObject = null;
            int j = 0;
            while (j < supportedIds.length) {
                Attr attr = dmObject.getAttribute(t, supportedIds[j], i);
                if (attr != null && !attr.isGroupDefaultValuesUsed(t)) {
                    if (rvObject == null) {
                        rvObject = new RepeatingValueObject(t);
                    }
                    if (Trace.isTracing) {
                        t.data(67, "XAResourceManagerCustomItemProvider.getRepeatingValueObjects", 500, "getAttribute: repeatIndex=" + i + " attrId=" + supportedIds[j] + " value=" + attr.toString(t));
                    }
                    rvObject.setAttribute(t, supportedIds[j], attr);
                    rvObject.setAttributeValue(t, supportedIds[j], attr.getValue(t));
                }
                ++j;
            }
            if (rvObject != null) {
                rvObject.setRepeatingIndex(i);
                objects.add(rvObject);
            }
            ++i;
        }
        return objects;
    }

    @Override
    public RepeatingValueObject createRepeatingValueObject(Trace t) {
        RepeatingValueObject rvObject = new RepeatingValueObject(t);
        rvObject.setDisposition(1);
        int[] attrIds = this.getAttributeIds(t);
        int i = 0;
        while (i < attrIds.length) {
            block6: {
                AttrType attrType = this.getAttributeType(t, attrIds[i]);
                AttrString attr = null;
                switch (attrType.getAttributeType()) {
                    case 2: {
                        attr = new AttrString(t, attrIds[i], -1, attrType.getDefaultValue(t).toString(), (AttrTypeString)attrType, super.getDmObject());
                        break;
                    }
                    case 6: {
                        attr = new AttrString(t, attrIds[i], -1, attrType.getDefaultValue(t).toString(), (AttrTypeString)((AttrTypeFixedLengthString)attrType), super.getDmObject());
                        break;
                    }
                    case 9: {
                        attr = new AttrString(t, attrIds[i], -1, attrType.getDefaultValue(t).toString(), (AttrTypeString)attrType, super.getDmObject());
                        break;
                    }
                    default: {
                        t.FFST(67, "XAResourceManagerCustomItemProvider.createRepeatingValueObject", 10, 50009, "Unrecognised attr type " + attrType.getAttributeType() + " for repeating value object, skipping attribute");
                        break block6;
                    }
                }
                rvObject.setAttribute(t, attrIds[i], (Attr)attr);
                rvObject.setAttributeValue(t, attrIds[i], attrType.getDefaultValue(t));
                rvObject.setRepeatingIndex(-1);
            }
            ++i;
        }
        return rvObject;
    }

    @Override
    public String getAttributeName(Trace t, int attrId) {
        String name = DmQueueManager.getAttributeTitle((Trace)t, (int)attrId);
        return name;
    }

    @Override
    public AttrType getAttributeType(Trace t, int attrId) {
        AttrType attrType = DmQueueManager.getAttributeType((Trace)t, (int)attrId);
        return attrType;
    }

    @Override
    public boolean enableEditButton(Trace t, RepeatingValueObject rvObject) {
        return rvObject != null;
    }

    @Override
    public boolean enableRemoveButton(Trace t, RepeatingValueObject rvObject) {
        return rvObject != null;
    }

    @Override
    public int[] getAdditionalButtonIds(Trace t) {
        return null;
    }

    @Override
    public String getAdditionalButtonText(Trace t, int id) {
        return null;
    }

    @Override
    public boolean enableAdditionalButton(Trace t, int id, RepeatingValueObject rvObject) {
        return false;
    }

    @Override
    public boolean additionalButtonSelected(Trace t, Shell shell, int id, RepeatingValueObject rvObject) {
        return false;
    }

    @Override
    public String getCheckboxText(Trace t) {
        return null;
    }

    @Override
    public boolean enableCheckbox(Trace t) {
        return false;
    }

    @Override
    public boolean checkboxSelected(Trace t, boolean selected) {
        return false;
    }

    @Override
    public boolean isAttributeOptional(Trace t, int attrId) {
        return false;
    }

    @Override
    public boolean isAttributeOriginallyPresent(Trace t, int attrId, RepeatingValueObject object) {
        return false;
    }

    @Override
    public boolean isCustomEditDialog(Trace t) {
        return false;
    }

    @Override
    public boolean editObject(Trace t, Shell shell, boolean isAdd, RepeatingValueObject object) {
        return false;
    }

    @Override
    public void objectRemoved(Trace t, RepeatingValueObject rvObject) {
    }

    @Override
    public boolean isSortVisibleList(Trace t) {
        return false;
    }

    @Override
    public ArrayList<RepeatingValueObject> sortVisibleList(Trace t, ArrayList<RepeatingValueObject> objects, RepeatingValuesTableCompareColumnItems compareItems) {
        return objects;
    }

    @Override
    public boolean hideEditingButtons(Trace t) {
        return false;
    }

    @Override
    public String getAddHelpId(Trace t) {
        return "com.ibm.mq.explorer.ui.infopop.UI_AddXAResourceDialog";
    }

    @Override
    public String getEditHelpId(Trace t) {
        return "com.ibm.mq.explorer.ui.infopop.UI_EditXAResourceDialog";
    }

    @Override
    public void removePendingObjects(Trace t) {
    }

    @Override
    public String getAddText(Trace t) {
        return null;
    }

    @Override
    public String getEditText(Trace t) {
        return null;
    }

    @Override
    public String getRemoveText(Trace t) {
        return null;
    }
}

