/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.queuemanager;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.event.DmQueueManagerListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmObjectFactory;
import com.ibm.mq.explorer.core.internal.objects.DmQSGMember;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.apiexits.APIExitCustomItemProvider;
import com.ibm.mq.explorer.ui.internal.apiexits.ApiExit;
import com.ibm.mq.explorer.ui.internal.base.ObjectRegistrationManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.comparewith.CompareWithProvider;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.RepeatingValueObject;
import com.ibm.mq.explorer.ui.internal.objects.SelectUiMQObjectDialog;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.objects.UiObject;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyPage;
import com.ibm.mq.explorer.ui.internal.properties.RepeatingValuesCustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import com.ibm.mq.explorer.ui.internal.queuemanager.ActionDeleteQueueManager;
import com.ibm.mq.explorer.ui.internal.queuemanager.ActionPubSubRefeshQueueManager;
import com.ibm.mq.explorer.ui.internal.queuemanager.QueueManagerChannelsCustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.queuemanager.QueueManagerClusterPropertyPage;
import com.ibm.mq.explorer.ui.internal.queuemanager.QueueManagerLogFilesCustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.queuemanager.QueueManagerLoggerEventsCustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.queuemanager.QueueManagerRepositoryPropertyPage;
import com.ibm.mq.explorer.ui.internal.queuemanager.QueueManagerSSLPropertyPage;
import com.ibm.mq.explorer.ui.internal.queuemanager.QueueManagerServicesPropertyItem;
import com.ibm.mq.explorer.ui.internal.queuemanager.SetRefreshIntervalDialog;
import com.ibm.mq.explorer.ui.internal.queuemanager.XAResourceManagerCustomItemProvider;
import com.ibm.mq.explorer.ui.internal.queuesharinggroup.UiQueueSharingGroup;
import com.ibm.mq.explorer.ui.internal.status.StatusDialog;
import com.ibm.mq.explorer.ui.internal.status.UiConfigurationProvider;
import com.ibm.mq.explorer.ui.internal.status.UiStatusProvider;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionFilter;

public class UiQueueManager
extends UiMQObject
implements IActionFilter,
DmQueueManagerListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/queuemanager/UiQueueManager.java";
    public static final int TEST_QMGR_ATTRIBUTE_UNKNOWN = -1;
    public static final int TEST_QMGR_ATTRIBUTE_RESULT_FALSE = 0;
    public static final int TEST_QMGR_ATTRIBUTE_RESULT_TRUE = 1;
    private int defaultRefreshInterval = 0;
    private static String objectType = null;
    private static String pubSubMenuText = null;
    private static String pubSubRefreshMenuText = null;
    private static String statusSuffixStopped = null;
    private static String statusSuffixRunningDisconnected = null;
    private static String statusSuffixRunningConnected = null;
    private static String statusSuffixDisconnected = null;
    private static String statusSuffixConnected = null;
    private static String statusSuffixStandby = null;
    private String treeStatusSuffix = null;
    private Action actionPubSubRefresh = null;
    private ActionDeleteQueueManager deleteQueueManagerAction;
    private ActionPubSubRefeshQueueManager pubSubRefreshQueueManagerAction;
    private UiQueueSharingGroup uiQueueSharingGroup = null;
    private BusyDialog busyDialog = null;
    private XAResourceManagerCustomItemProvider xaResourceManagerCustomItemProvider = null;
    private APIExitCustomItemProvider localAPIExitCustomItemProvider = null;
    public static final int ICON_STATUS_UNKNOWN = -1;
    public static final int ICON_STATUS_DISCONNECTED = 0;
    public static final int ICON_STATUS_CONNECTING = 0;
    public static final int ICON_STATUS_CONNECTED = 1;
    public static final int ICON_STATUS_STARTED_CONNECTED = 2;
    public static final int ICON_STATUS_STARTED_DISCONNECTED = 3;
    public static final int ICON_STATUS_STOPPED = 4;
    public static final int ICON_STATUS_STANDBY = 5;
    private int iconStatus = -1;
    private Image imageLocalStopped = null;
    private Image imageLocalStartedConnected = null;
    private Image imageLocalStartedDisconnected = null;
    private Image imageRemoteConnected = null;
    private Image imageRemoteDisconnected = null;
    private Image imageLocalStandby = null;
    private boolean showingPrompt = false;
    private String qsgName = "";
    public StatusDialog appConnStatusDialog = null;

    public UiQueueManager() {
    }

    public UiQueueManager(Trace t, IDmObject dmQmgr, UiMQObject parent) {
        super(t, dmQmgr);
        this.defaultRefreshInterval = ((DmQueueManager)dmQmgr).isLocal() ? UiPlugin.getLocalDefaultRefreshRate() : UiPlugin.getRemoteDefaultRefreshRate();
        objectType = UiPlugin.getNLSString(t, "KEY_Object_Types", "UI.OBJECT.Type.QueueManager");
        pubSubMenuText = UiPlugin.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.Pubsub.Menu");
        pubSubRefreshMenuText = UiPlugin.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.Pubsub.Refresh.Menu");
        statusSuffixStopped = "  " + UiPlugin.getNLSString(t, this.getNLSResourceFileKey(), "UI.QMGR.TreeNode.Status.Stopped");
        statusSuffixRunningDisconnected = "  " + UiPlugin.getNLSString(t, this.getNLSResourceFileKey(), "UI.QMGR.TreeNode.Status.RunningDisconnected");
        statusSuffixRunningConnected = "  " + UiPlugin.getNLSString(t, this.getNLSResourceFileKey(), "UI.QMGR.TreeNode.Status.RunningConnected");
        statusSuffixDisconnected = "  " + UiPlugin.getNLSString(t, this.getNLSResourceFileKey(), "UI.QMGR.TreeNode.Status.Disconnected");
        statusSuffixConnected = "  " + UiPlugin.getNLSString(t, this.getNLSResourceFileKey(), "UI.QMGR.TreeNode.Status.Connected");
        statusSuffixStandby = "  " + UiPlugin.getNLSString(t, this.getNLSResourceFileKey(), "UI.QMGR.TreeNode.Status.Standby");
        this.treeStatusSuffix = "";
        this.imageLocalStopped = Icons.get(Icons.iconkeyQmgrSmallLocalStopped);
        this.imageLocalStartedConnected = Icons.get(Icons.iconkeyQmgrSmallLocalStartedConnected);
        this.imageLocalStartedDisconnected = Icons.get(Icons.iconkeyQmgrSmallLocalStartedDisconnected);
        this.imageRemoteConnected = Icons.get(Icons.iconkeyQmgrSmallRemoteConnected);
        this.imageRemoteDisconnected = Icons.get(Icons.iconkeyQmgrSmallRemoteDisconnected);
        this.imageLocalStandby = Icons.get(Icons.iconkeyQmgrSmallLocalStandby);
        this.deleteQueueManagerAction = new ActionDeleteQueueManager(t, this.shell, this);
        this.pubSubRefreshQueueManagerAction = new ActionPubSubRefeshQueueManager(t, this.shell, this);
        this.xaResourceManagerCustomItemProvider = new XAResourceManagerCustomItemProvider(t, this);
        this.localAPIExitCustomItemProvider = new APIExitCustomItemProvider(t, this, 2);
    }

    @Override
    public void appendToContextMenu(Shell aShell, IMenuManager manager, Object contextObject) {
        Trace t = Trace.getDefault();
        manager.add((IContributionItem)new GroupMarker("group"));
        if (this.isZOS(t)) {
            this.setUiStatusProvider((UiStatusProvider)ObjectRegistrationManager.getExplorerProvider(t, "com.ibm.mq.explorer.queuemanager", "com.ibm.mq.explorer.provider.zos.status", (UiMQObject)this));
            this.setUiConfigurationProvider((UiConfigurationProvider)ObjectRegistrationManager.getExplorerProvider(t, "com.ibm.mq.explorer.queuemanager", "com.ibm.mq.explorer.provider.configuration", (UiMQObject)this));
        } else {
            this.setUiStatusProvider((UiStatusProvider)ObjectRegistrationManager.getExplorerProvider(t, "com.ibm.mq.explorer.queuemanager", "com.ibm.mq.explorer.provider.status", (UiMQObject)this));
            this.setUiConfigurationProvider(null);
        }
        if (this.actionPubSubRefresh == null) {
            this.actionPubSubRefresh = new Action(){

                public void run() {
                    Trace tr = Trace.getDefault();
                    UiQueueManager.this.pubSubRefreshQueueManagerAction.perform(tr);
                }
            };
            this.actionPubSubRefresh.setText(pubSubRefreshMenuText);
        }
        manager.add((IContributionItem)new GroupMarker("group0"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("group1"));
        if (this.isRunning() && this.isV7orGreater()) {
            MenuManager submanager = new MenuManager(pubSubMenuText);
            manager.add((IContributionItem)submanager);
            submanager.add((IAction)this.actionPubSubRefresh);
        }
        super.appendToContextMenu(aShell, manager, contextObject);
    }

    public void setRefreshInterval(Trace t) {
        SetRefreshIntervalDialog setRefreshIntDlg = new SetRefreshIntervalDialog(this.shell);
        boolean isEnabled = this.getRefreshInterval(t) != -1;
        int maxValue = this.isLocal() ? UiPlugin.getLocalRefreshRateMaxValue(t) : UiPlugin.getRemoteRefreshRateMaxValue(t);
        int minValue = this.isLocal() ? UiPlugin.getLocalRefreshRateMinValue(t) : UiPlugin.getRemoteRefreshRateMinValue(t);
        setRefreshIntDlg.setValues(t, isEnabled, this.getRefreshInterval(t), this.getDefaultRefreshInterval(t), maxValue, minValue);
        if (setRefreshIntDlg.open() == 0) {
            this.setRefreshInterval(t, setRefreshIntDlg.getRefreshInterval(t));
            UiPlugin.refreshContentViews(t, "com.ibm.mq.explorer.queuemanager");
        }
    }

    @Override
    public String getId() {
        return "com.ibm.mq.explorer.queuemanager";
    }

    @Override
    public String toString() {
        IDmObject dmObj = super.getDmObject();
        if (dmObj != null) {
            return dmObj.getTitle();
        }
        return "";
    }

    public boolean isVisible(Trace t) {
        boolean visible = true;
        IDmObject dmObj = super.getDmObject();
        if (dmObj != null) {
            visible = ((DmQueueManager)dmObj).isVisible(t);
        }
        return visible;
    }

    public boolean isLocal() {
        IDmObject dmObj = super.getDmObject();
        if (dmObj != null) {
            return ((DmQueueManager)dmObj).isLocal();
        }
        return true;
    }

    public boolean isRunning() {
        DmQueueManager dmQueueManager = this.getDmQueueManagerObject();
        if (dmQueueManager != null) {
            return dmQueueManager.isRunning();
        }
        return false;
    }

    public boolean isRunningAsStandby() {
        DmQueueManager dmQueueManager = this.getDmQueueManagerObject();
        if (dmQueueManager != null) {
            return dmQueueManager.isStandby();
        }
        return false;
    }

    public boolean isRunningElsewhere() {
        DmQueueManager dmQueueManager = this.getDmQueueManagerObject();
        if (dmQueueManager != null) {
            return dmQueueManager.isRunningElsewhere();
        }
        return false;
    }

    public boolean isStandbyPermitted() {
        DmQueueManager dmQueueManager = this.getDmQueueManagerObject();
        if (dmQueueManager != null) {
            return dmQueueManager.isStandbyPermitted();
        }
        return false;
    }

    public boolean getCommandServerStatus(Trace t) {
        DmQueueManager dmQueueManager = this.getDmQueueManagerObject();
        if (dmQueueManager != null) {
            return dmQueueManager.isCommandServerRunning(t);
        }
        return false;
    }

    public boolean isConnected() {
        DmQueueManager dmQueueManager = this.getDmQueueManagerObject();
        if (dmQueueManager != null) {
            return dmQueueManager.isConnected();
        }
        return false;
    }

    public boolean isConnecting() {
        DmQueueManager dmQueueManager = this.getDmQueueManagerObject();
        if (dmQueueManager != null) {
            return dmQueueManager.isConnecting();
        }
        return false;
    }

    public boolean isV7orGreater() {
        DmQueueManager dmQueueManager = this.getDmQueueManagerObject();
        if (dmQueueManager != null) {
            return dmQueueManager.getCommandLevel() >= 700;
        }
        return false;
    }

    public DmQueueManager getDmQueueManagerObject() {
        IDmObject dmQueueManager = super.getDmObject();
        if (dmQueueManager != null) {
            return (DmQueueManager)dmQueueManager;
        }
        return null;
    }

    @Override
    public boolean isCustomGroup(Trace t, UiDisplayGroup uiDisplayGroup) {
        boolean isCustom = false;
        int displayGroupId = uiDisplayGroup.getDisplayGroup().getId();
        switch (displayGroupId) {
            case 34: 
            case 35: 
            case 38: {
                isCustom = true;
                UiQueueManager.traceFinest(t, "UiQueueManager.isCustomGroup", "Display Group ID identified as requiring customisation : " + displayGroupId);
                break;
            }
            default: {
                UiQueueManager.traceFinest(t, "UiQueueManager.isCustomGroup", "Display group ID does not require customisation : " + displayGroupId);
            }
        }
        return isCustom;
    }

    @Override
    public boolean isCustomItem(Trace t, Attr attr) {
        boolean result = false;
        int attrId = attr.getAttributeID();
        if (this.xaResourceManagerCustomItemProvider.isAttributeProcessed(t, attrId) || QueueManagerChannelsCustomPropertyItem.isAttributeProcessed(t, attrId) || this.localAPIExitCustomItemProvider.isAttributeProcessed(t, attrId) || QueueManagerServicesPropertyItem.isAttributeProcessed(t, attrId) || QueueManagerLogFilesCustomPropertyItem.isAttributeProcessed(t, attrId) || QueueManagerLoggerEventsCustomPropertyItem.isAttributeProcessed(t, attrId)) {
            result = true;
        }
        return result;
    }

    @Override
    public CustomPropertyPage createCustomPropertyPage(Trace t, Composite parent, int style, UiDisplayGroup uiDisplayGroup, boolean readonly) {
        CustomPropertyPage customPage = null;
        switch (uiDisplayGroup.getDisplayGroup().getId()) {
            case 38: {
                if (!this.isCustomGroup(t, uiDisplayGroup)) break;
                customPage = new QueueManagerSSLPropertyPage(t, parent, style, this, uiDisplayGroup, readonly);
                UiQueueManager.traceFinest(t, "UiQueueManager.createCustomPropertyPage", "Match found in createCustomPropertyPage for QMGR_SSL.");
                break;
            }
            case 34: {
                if (!this.isCustomGroup(t, uiDisplayGroup)) break;
                customPage = new QueueManagerClusterPropertyPage(t, parent, style, this, uiDisplayGroup, readonly);
                UiQueueManager.traceFinest(t, "UiQueueManager.createCustomPropertyPage", "Match found in createCustomPropertyPage for QMGR_CLUSTER.");
                break;
            }
            case 35: {
                if (!this.isCustomGroup(t, uiDisplayGroup)) break;
                customPage = new QueueManagerRepositoryPropertyPage(t, parent, style, this, uiDisplayGroup, readonly);
                UiQueueManager.traceFinest(t, "UiQueueManager.createCustomPropertyPage", "Match found in createCustomPropertyPage for QMGR_EXITS.");
                break;
            }
            default: {
                UiQueueManager.traceFinest(t, "UiQueueManager.createCustomPropertyPage", "No match found in createCustomPropertyPage.");
            }
        }
        return customPage;
    }

    @Override
    public CustomPropertyItem createCustomPropertyItem(Trace t, Composite parent, int style, Attr attr, boolean readonly) {
        CustomPropertyItem customPropItem = null;
        int attrId = attr.getAttributeID();
        switch (attrId) {
            case 10009: {
                customPropItem = new RepeatingValuesCustomPropertyItem(t, parent, style, this, attr, readonly, this.xaResourceManagerCustomItemProvider);
                break;
            }
            case 10141: {
                customPropItem = new RepeatingValuesCustomPropertyItem(t, parent, style, this, attr, readonly, this.localAPIExitCustomItemProvider);
                break;
            }
            case 10017: {
                customPropItem = new QueueManagerServicesPropertyItem(t, parent, style, this, attr, readonly);
                break;
            }
            case 10000: {
                if (!QueueManagerLogFilesCustomPropertyItem.canProcessAttribute(t, this, attr.getAttributeID())) break;
                customPropItem = new QueueManagerLogFilesCustomPropertyItem(t, parent, style, this, attr, readonly);
                break;
            }
            case 10024: {
                if (!QueueManagerChannelsCustomPropertyItem.canProcessAttribute(t, this, attr.getAttributeID())) break;
                customPropItem = new QueueManagerChannelsCustomPropertyItem(t, parent, style, this, attr, readonly);
                break;
            }
            case 94: {
                if (attr.getAttrType().isPseudoPCF()) break;
                customPropItem = new QueueManagerLoggerEventsCustomPropertyItem(t, parent, style, this, attr, readonly);
            }
        }
        return customPropItem;
    }

    @Override
    public boolean isNotifyChangedOnPropertyPage(Attr attr) {
        return false;
    }

    @Override
    public boolean attrValueChangedOnPropertyPage(Trace t, Attr attr, Object newValue) {
        return false;
    }

    @Override
    public String getObjectType() {
        return objectType;
    }

    @Override
    public boolean testAttribute(Object target, String name, String value) {
        Trace t = Trace.getDefault();
        boolean result = false;
        if (target instanceof MQQmgrExtObject || target instanceof UiQueueManager || target instanceof TreeNode && ((TreeNode)((Object)target)).getId().startsWith("com.ibm.mq.explorer.treenode.qm.")) {
            int iResult = this.testQmgrAttribute(t, target, name, value);
            switch (iResult) {
                case 1: {
                    result = true;
                    break;
                }
                case 0: {
                    result = false;
                    break;
                }
                default: {
                    result = super.testAttribute(target, name, value);
                    break;
                }
            }
        } else {
            result = super.testAttribute(target, name, value);
        }
        return result;
    }

    public int testQmgrAttribute(Trace t, Object target, String name, String value) {
        int result;
        block58: {
            block63: {
                block62: {
                    block61: {
                        block60: {
                            boolean isStarted;
                            block59: {
                                result = -1;
                                if (name.compareTo("QmgrType") != 0) break block59;
                                result = 0;
                                boolean isLocal = this.isLocal();
                                if (value.compareTo("Local") == 0 && isLocal) {
                                    result = 1;
                                } else if (value.compareTo("Remote") == 0 && !isLocal) {
                                    result = 1;
                                }
                                break block58;
                            }
                            if (name.compareTo("QmgrStatus") != 0) break block60;
                            result = 0;
                            boolean bl = isStarted = this.isRunning() || this.isRunningAsStandby();
                            if (value.compareTo("Started") == 0 && isStarted) {
                                result = 1;
                            } else if (value.compareTo("Stopped") == 0 && !isStarted) {
                                result = 1;
                            } else if (value.compareTo("Running as standby") == 0 && this.isRunningAsStandby()) {
                                result = 1;
                            }
                            break block58;
                        }
                        if (name.compareTo("QmgrCmdSvrStatus") != 0) break block61;
                        result = 0;
                        boolean isCommandServerRunning = this.getCommandServerStatus(t);
                        if (value.compareTo("Running") == 0 && isCommandServerRunning) {
                            result = 1;
                        } else if (value.compareTo("Stopped") == 0 && !isCommandServerRunning) {
                            result = 1;
                        }
                        break block58;
                    }
                    if (name.compareTo("QmgrConnected") != 0) break block62;
                    result = 0;
                    boolean isConnected = this.isConnected();
                    if (value.compareTo("Connected") == 0 && isConnected) {
                        result = 1;
                    } else if (value.compareTo("Disconnected") == 0 && !isConnected) {
                        result = 1;
                    }
                    break block58;
                }
                if (name.compareTo("QmgrPlatform") != 0) break block63;
                result = 0;
                int platform = this.getDmQueueManagerObject().getPlatform();
                switch (platform) {
                    case 1: {
                        if (value.compareTo("QmgrPlatformZSeries") == 0) {
                            result = 1;
                            break;
                        }
                        break block58;
                    }
                    case 3: {
                        if (value.compareTo("QmgrPlatformUnix") == 0) {
                            result = 1;
                            break;
                        }
                        break block58;
                    }
                    case 2: {
                        if (value.compareTo("QmgrPlatformOS2") == 0) {
                            result = 1;
                            break;
                        }
                        break block58;
                    }
                    case 4: {
                        if (value.compareTo("QmgrPlatformISeries") == 0) {
                            result = 1;
                            break;
                        }
                        break block58;
                    }
                    case 5: 
                    case 11: {
                        if (value.compareTo("QmgrPlatformWindows") == 0) {
                            result = 1;
                            break;
                        }
                        break block58;
                    }
                    case 13: {
                        if (value.compareTo("QmgrPlatformNSK") == 0) {
                            result = 1;
                            break;
                        }
                        break block58;
                    }
                    case 12: {
                        if (value.compareTo("QmgrPlatformVMS") == 0) {
                            result = 1;
                            break;
                        }
                        break block58;
                    }
                    default: {
                        result = 0;
                        break;
                    }
                }
                break block58;
            }
            if (name.compareTo("QmgrCmdLevelLessThan") == 0) {
                result = 0;
                int cmdLevel = this.getDmQueueManagerObject().getCommandLevel();
                if (cmdLevel > 0) {
                    Integer intValue = null;
                    try {
                        intValue = Integer.valueOf(value);
                        if (cmdLevel < intValue) {
                            result = 1;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        result = 0;
                    }
                }
            } else if (name.compareTo("QmgrCmdLevelEqualTo") == 0) {
                result = 0;
                int cmdLevel = this.getDmQueueManagerObject().getCommandLevel();
                Integer intValue = null;
                try {
                    intValue = Integer.valueOf(value);
                    if (cmdLevel == intValue) {
                        result = 1;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    result = 0;
                }
            } else if (name.compareTo("QmgrCmdLevelGreaterThan") == 0) {
                result = 0;
                int cmdLevel = this.getDmQueueManagerObject().getCommandLevel();
                if (cmdLevel > 0) {
                    Integer intValue = null;
                    try {
                        intValue = Integer.valueOf(value);
                        if (cmdLevel > intValue) {
                            result = 1;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        result = 0;
                    }
                }
            } else if (name.compareTo("QmgrUUIDKnown") == 0) {
                result = 0;
                String uuid = this.getUUID(t);
                if (value.compareTo("Known") == 0 && uuid != null) {
                    result = 1;
                } else if (value.compareTo("Unknown") == 0 && uuid == null) {
                    result = 1;
                }
            } else if (name.compareTo("ConnectionType") == 0) {
                result = 0;
                int connType = this.getDmQueueManagerObject().getConnectionHandle().getQueueManagerHandle(t).getConnectionType();
                if (value.compareTo("Client") == 0 && connType == 2) {
                    result = 1;
                } else if (value.compareTo("Client_CCDT") == 0 && connType == 4) {
                    result = 1;
                } else if (value.compareTo("Client_Mi") == 0 && connType == 5) {
                    result = 1;
                }
            }
        }
        return result;
    }

    public ArrayList<RepeatingValueObject> getApiExitsArray(Trace t) {
        ArrayList<RepeatingValueObject> apiExits = new ArrayList<RepeatingValueObject>();
        this.appendApiExitsToArray(t, apiExits);
        return apiExits;
    }

    public void appendApiExitsToArray(Trace t, ArrayList<RepeatingValueObject> apiExits) {
        DmQueueManager dmQmgr = (DmQueueManager)this.getDmObject();
        int repeatIndex = 0;
        boolean done = false;
        while (!done) {
            ApiExit apiExit = ApiExit.loadApiExit(t, (DmObject)dmQmgr, repeatIndex, 2, 10141, 10149, 10143, 10142, 10145, 10144);
            if (apiExit != null) {
                apiExit.setOwningUiQueueManager(t, this);
                UiQueueManager.addLocalApiExit(t, apiExits, apiExit);
                ++repeatIndex;
                continue;
            }
            done = true;
        }
    }

    private static void addLocalApiExit(Trace t, ArrayList<RepeatingValueObject> apiExits, ApiExit localApiExit) {
        int i = 0;
        while (i < apiExits.size()) {
            ApiExit apiExit;
            RepeatingValueObject rvObject = apiExits.get(i);
            if (rvObject instanceof ApiExit && (apiExit = (ApiExit)rvObject).isCommon(t) && apiExit.getName(t).compareTo(localApiExit.getName(t)) == 0) {
                apiExit.addOverridingApiExit(t, localApiExit);
                localApiExit.setOverriddenApiExit(t, apiExit);
            }
            ++i;
        }
        apiExits.add(localApiExit);
    }

    @Override
    public String getNLSResourceFileKey() {
        return "KEY_Queue Manager";
    }

    public String getTreeName() {
        return this.getDmQueueManagerObject().getTreeName(Trace.getDefault());
    }

    @Override
    public void updateIcon() {
        Trace.getDefault();
        Image image = null;
        this.treeStatusSuffix = "";
        if (this.isConnected()) {
            if (this.isLocal()) {
                image = this.imageLocalStartedConnected;
                this.treeStatusSuffix = statusSuffixRunningConnected;
                this.iconStatus = 2;
            } else {
                image = this.imageRemoteConnected;
                this.treeStatusSuffix = statusSuffixConnected;
                this.iconStatus = 1;
            }
        } else if (this.isLocal()) {
            if (this.isRunningAsStandby()) {
                image = this.imageLocalStandby;
                this.treeStatusSuffix = statusSuffixStandby;
                this.iconStatus = 5;
            } else if (this.isRunning()) {
                image = this.imageLocalStartedDisconnected;
                this.treeStatusSuffix = statusSuffixRunningDisconnected;
                this.iconStatus = 3;
            } else {
                image = this.imageLocalStopped;
                this.treeStatusSuffix = statusSuffixStopped;
                this.iconStatus = 4;
            }
        } else {
            image = this.imageRemoteDisconnected;
            this.treeStatusSuffix = statusSuffixDisconnected;
            this.iconStatus = 0;
        }
        super.setImage(image);
    }

    public int getRefreshInterval(Trace t) {
        int refreshInterval = this.defaultRefreshInterval;
        DmQueueManagerHandle dmQmgrHandle = this.getDmQueueManagerObject().getConnectionHandle();
        Attr attr = dmQmgrHandle.getAttribute(t, 11011, 0);
        if (attr != null) {
            Integer value = (Integer)attr.getValue(t);
            refreshInterval = value;
        }
        return refreshInterval;
    }

    public void setRefreshInterval(Trace t, int refreshInterval) {
        DmQueueManagerHandle dmQmgrHandle = this.getDmQueueManagerObject().getConnectionHandle();
        if (dmQmgrHandle != null) {
            Object job = dmQmgrHandle.beginUpdate(t);
            boolean result = dmQmgrHandle.setAttributeValue(t, job, 11011, 0, (Object)refreshInterval);
            if (!result) {
                t.data(67, "UiQueueManager.setRefreshInterval", 900, "failed to set Autoreconnect attribute");
            }
            dmQmgrHandle.actionChange(t, null, job, false);
        }
    }

    public int getDefaultRefreshInterval(Trace t) {
        return this.defaultRefreshInterval;
    }

    @Override
    public int getDataModelObjectType(Trace t) {
        return 2;
    }

    public IUiMQObjectFactory getFactoryClass(Trace t, String objectId) {
        IUiMQObjectFactory factoryClass = null;
        if (ObjectRegistrationManager.isObjectIdRegistered(t, objectId)) {
            factoryClass = ObjectRegistrationManager.getUiMQObjectFactory(t, objectId);
        } else if (Trace.isTracing) {
            t.data(67, "UiQueueManager.getFactoryClass", 300, "Unknown object id " + objectId);
        }
        return factoryClass;
    }

    public int getPlatform(Trace t) {
        Object objValue;
        int platform = 11;
        Attr attr = this.getDmQueueManagerObject().getAttribute(t, 32, 0);
        if (attr != null && (objValue = attr.getValue(t)) instanceof Integer) {
            platform = (Integer)objValue;
        }
        return platform;
    }

    private static void traceFinest(Trace t, String fid, String msg) {
        if (Trace.isTracing) {
            t.data(67, fid, 300, msg);
        }
    }

    @Override
    public boolean isSupportDelete() {
        return this.isLocal() && !this.isRunning() && !this.isRunningAsStandby();
    }

    @Override
    public void deleteMenuAction(Trace t) {
        this.deleteQueueManagerAction.perform(t);
    }

    public String getUUID(Trace t) {
        String uuid = null;
        Attr attr = this.getDmQueueManagerObject().getAttribute(t, 2032, 0);
        if (attr != null) {
            uuid = attr.toString(t);
        } else {
            uuid = this.getDmQueueManagerObject().getConnectionHandle().getQueueManagerHandle(t).getUuid();
            if (uuid.compareTo("[not_defined]") == 0) {
                uuid = null;
            }
        }
        return uuid;
    }

    @Override
    public boolean isChangeProperties(Trace t) {
        return true;
    }

    @Override
    public String getAttributeName(Trace t, int attrId) {
        String name = null;
        if (attrId == 1149) {
            name = UiPlugin.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.Status.Title");
        } else if (attrId == 1233) {
            name = UiPlugin.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.CmdSrvrStatus.Title");
        }
        return name;
    }

    @Override
    public String getAttributeValue(Trace t, int attrId) {
        String value = null;
        if (attrId == 1149) {
            if (this.isLocal()) {
                value = this.isRunning() ? UiPlugin.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.Local.Started.Text") : UiPlugin.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.Local.Stopped.Text");
            } else if (this.isConnected()) {
                value = UiPlugin.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.Local.Started.Text");
            }
        } else if (attrId == 1233) {
            String msgId = null;
            msgId = this.getCommandServerStatus(t) ? "UI.QMGR.Local.Started.Text" : "UI.QMGR.Local.Stopped.Text";
            value = UiPlugin.getNLSString(t, "KEY_Queue Manager", msgId);
        }
        return value;
    }

    @Override
    public String toFormattedString() {
        return this.getTreeName();
    }

    public void setUiQueueSharingGroup(Trace t, UiQueueSharingGroup uiQueueSharingGroup_) {
        this.uiQueueSharingGroup = uiQueueSharingGroup_;
    }

    public UiQueueSharingGroup getUiQueueSharingGroup(Trace t) {
        DmQueueManager dmQmgr = this.getDmQueueManagerObject();
        if (dmQmgr != null) {
            String newQsgName = dmQmgr.getAttributeValue(t, 2040, 0);
            if (newQsgName != null && newQsgName.compareTo("") != 0 && newQsgName.compareTo("[not_found]") != 0) {
                if (this.uiQueueSharingGroup == null || !newQsgName.equals(this.qsgName)) {
                    DmQSGMember dmQSG = (DmQSGMember)DmObjectFactory.create((Trace)t, (DmQueueManager)dmQmgr, (int)119, (String)newQsgName);
                    IUiMQObjectFactory factory = ObjectRegistrationManager.getUiMQObjectFactory(t, "com.ibm.mq.explorer.qsg");
                    UiQueueSharingGroup uiQSG = (UiQueueSharingGroup)factory.create(t, (IDmObject)dmQSG, this);
                    this.setUiQueueSharingGroup(t, uiQSG);
                    this.qsgName = newQsgName;
                    if (Trace.isTracing) {
                        t.data(67, "UiQueueManager.getUiQueueSharingGroup", 300, "New Ui QueueSharingGroup member created with name : " + this.qsgName + " for queue manager : " + this.getTreeName());
                    }
                }
            } else {
                this.qsgName = "";
                this.uiQueueSharingGroup = null;
            }
        }
        return this.uiQueueSharingGroup;
    }

    @Override
    public boolean isAllowProperties() {
        boolean result = false;
        result = this.isLocal() ? true : this.isConnected();
        return result;
    }

    public void dmQueueManagerConnected(DmObjectEvent event) {
        DmQueueManager dmQm = (DmQueueManager)event.getSource();
        if (dmQm == this.getDmQueueManagerObject()) {
            this.shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (UiQueueManager.this.busyDialog != null) {
                        UiQueueManager.this.busyDialog.closeDialog(Trace.getDefault());
                    }
                }
            });
        }
    }

    public void dmQueueManagerDisconnected(final DmObjectEvent event) {
        final Trace t = Trace.getDefault();
        DmQueueManager dmQm = (DmQueueManager)event.getSource();
        if (dmQm == this.getDmQueueManagerObject() && !this.showingPrompt) {
            this.shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (UiQueueManager.this.busyDialog != null) {
                        UiQueueManager.this.busyDialog.closeDialog(Trace.getDefault());
                    }
                    UiQueueManager.this.checkConnectionErrors(t, event);
                }
            });
        }
    }

    private void checkConnectionErrors(Trace t, DmObjectEvent event) {
        if (event.getException() != null) {
            int rc = event.getException().getReasonCode();
            int reply = 1;
            this.showingPrompt = true;
            switch (rc) {
                case 2546: {
                    reply = MessageBox.showYesNoMessage(t, this.shell, event.getException().getMessage(), 1, event.getException().getMessageID());
                    break;
                }
                case 50058: 
                case 50059: {
                    MessageBox.showSystemMessageById(t, this.shell, event.getException().getMessageID(), null, event.getException().getMessageID(), null, event.getException().getMessage());
                    reply = 0;
                    break;
                }
                default: {
                    if (event.getException().getReasonCode() == 0) break;
                    MessageBox.showExceptionMessage(t, this.shell, event.getException());
                }
            }
            this.showingPrompt = false;
            if (reply == 0) {
                DmQueueManager dmQm = (DmQueueManager)event.getSource();
                dmQm.reconnectAsynchronously(t);
            }
        }
    }

    public boolean isShowingPrompt() {
        return this.showingPrompt;
    }

    public void dmQueueManagerShown(DmObjectEvent event) {
    }

    public void dmQueueManagerHidden(DmObjectEvent event) {
    }

    public void dmObjectAdded(DmObjectEvent event) {
    }

    public void dmObjectChanged(DmObjectEvent event) {
    }

    public void dmObjectDeleted(DmObjectEvent event) {
    }

    public void dmRefreshComplete(DmObjectEvent event) {
    }

    public void dmObjectListDone(DmObjectListEvent event) {
    }

    public void dmObjectSummary(DmObjectSummaryEvent event) {
    }

    public void toggleAutoreconnect(Trace t) {
        this.setAutoreconnect(t, !this.isAutoreconnect(t));
        UiPlugin.refreshContentViews(t, "com.ibm.mq.explorer.queuemanager");
    }

    public boolean isAutoreconnect(Trace t) {
        boolean result = false;
        DmQueueManagerHandle dmQmgrHandle = this.getDmQueueManagerObject().getConnectionHandle();
        if (dmQmgrHandle != null) {
            result = dmQmgrHandle.isAutoReconnect(t);
        }
        return result;
    }

    public void setAutoreconnect(Trace t, boolean isAuto) {
        DmQueueManagerHandle dmQmgrHandle = this.getDmQueueManagerObject().getConnectionHandle();
        if (dmQmgrHandle != null) {
            Object job;
            boolean result;
            int setting = 0;
            if (isAuto) {
                setting = 1;
            }
            if (!(result = dmQmgrHandle.setAttributeValue(t, job = dmQmgrHandle.beginUpdate(t), 11012, 0, (Object)setting))) {
                t.data(67, "UiQueueManager.setAutoreconnect", 900, "failed to set Autoreconnect attribute");
            }
            dmQmgrHandle.actionChange(t, null, job, false);
        }
    }

    public void dmQueueManagerConnecting(DmObjectEvent event) {
    }

    public boolean isZOS(Trace t) {
        boolean result = this.getPlatform(t) == 1;
        return result;
    }

    @Override
    public boolean isDefaultDataModeEbcdic(Trace t) {
        return this.isZOS(t);
    }

    @Override
    public String getCharacterSetIdForByteArray(Trace t, int attrId) {
        return null;
    }

    public String getTreeStatusSuffix() {
        return this.treeStatusSuffix;
    }

    public int getIconStatus() {
        return this.iconStatus;
    }

    @Override
    public boolean isSelectAttributeObjectFromDmObjectFilter(Trace t, int attrId, DmObjectFilter dmObjectFilter) {
        return true;
    }

    @Override
    public String selectAttributeObjectFromDmObjectFilter(Trace t, int attrId, DmObjectFilter dmObjectFilter, String currentSelection, String helpId, Shell sh) {
        return this.selectAttributeObjectFromDmObjectFilter(t, attrId, dmObjectFilter, currentSelection, helpId, sh, this.getSelectObjectDialogTitle(t, attrId), this.getSelectObjectDialogDescription(t, attrId), true);
    }

    private String getSelectObjectDialogTitle(Trace t, int attrId) {
        String template = UiPlugin.getNLSString(t, "KEY_Properties", "UI.Objects.Select.Title");
        String title = Message.format((String)template, (String)DmQueueManager.getAttributeTitle((Trace)t, (int)attrId));
        return title;
    }

    private String getSelectObjectDialogDescription(Trace t, int attrId) {
        return this.getSelectObjectDialogTitle(t, attrId);
    }

    public String selectAttributeObjectFromDmObjectFilter(Trace t, int attrId, DmObjectFilter dmObjectFilter, String currentSelection, String helpId, Shell sh, String title, String description, boolean showSystemObjects) {
        UiObject selObject = null;
        SystemObjectsViewerFilter viewerFilter = null;
        if (!showSystemObjects) {
            viewerFilter = new SystemObjectsViewerFilter();
        }
        String dialogTitle = title;
        if (title == null) {
            dialogTitle = UiPlugin.getNLSString(t, "KEY_General", "UI.GENERAL.MQ");
        }
        String dialogDescription = description;
        SelectUiMQObjectDialog selDlg = new SelectUiMQObjectDialog(sh);
        DmQueueManager dmQm = this.getDmQueueManagerObject();
        boolean isSecondaryOrder = dmQm.isZos();
        int objType = dmObjectFilter.getType();
        CompareWithProvider compWithProvider = null;
        switch (objType) {
            case 7: 
            case 13: 
            case 25: 
            case 36: 
            case 83: 
            case 97: 
            case 115: 
            case 122: 
            case 153: 
            case 174: 
            case 191: 
            case 204: 
            case 1005: 
            case 1030: {
                compWithProvider = (CompareWithProvider)ObjectRegistrationManager.getExplorerProvider(t, objType, "com.ibm.mq.explorer.provider.compare.with", (UiMQObject)this);
                break;
            }
            default: {
                t.FFST(67, "UiQueueManager.selectAttributeObjectFromDmObjectFilter", 10, 50999, 0, 0, "Unsupported object type", "", "");
            }
        }
        if (compWithProvider != null) {
            IUiMQObjectFactory uiMQObjectFactory = compWithProvider.getUiMQObjectFactory(t);
            String objectId = compWithProvider.getObjectId();
            String genericObjectName = compWithProvider.getGenericObjectName(t);
            String attributeOrderId = compWithProvider.getAttributeOrderId();
            selDlg.setExplicitFilter(t, dmObjectFilter);
            selDlg.listenToDataModel(t, (IDmObservable)dmQm, objType, uiMQObjectFactory, this);
            selDlg.setPreselectObjectName(currentSelection);
            String noObjAvailMsg = UiPlugin.getNLSString(t, "KEY_Properties", "UI.PROP.Dialog.NoObjectsAvailable");
            selDlg.setNoObjectMessage(t, 1, noObjAvailMsg);
            if (selDlg.open(t, dialogTitle, dialogDescription, objectId, genericObjectName, attributeOrderId, isSecondaryOrder, null, null, null, viewerFilter, true, true, helpId)) {
                selObject = selDlg.getSelectedObject();
            }
        }
        String retValue = null;
        if (selObject != null) {
            retValue = selObject.toString();
        }
        return retValue;
    }

    public static UiQueueManager findOwningQueueManager(Trace t, UiMQObject object) {
        UiQueueManager uiQueueManager = null;
        if (object instanceof UiQueueManager) {
            uiQueueManager = (UiQueueManager)object;
        } else if (object instanceof UiQueueSharingGroup) {
            uiQueueManager = ((UiQueueSharingGroup)object).getUiQueueManager();
        } else if (object != null) {
            MQExtObject extObject;
            MQExtObject testObject = extObject = object.getExternalObject();
            while (!(testObject instanceof MQQmgrExtObject) && testObject != null) {
                testObject = testObject.getParent();
            }
            if (testObject != null) {
                uiQueueManager = (UiQueueManager)testObject.getInternalObject();
            } else if (Trace.isTracing) {
                t.data(67, "UiQueueManager.findOwningQueueManager", 900, "parent UiQueueManager not found - source object name='" + object.toString() + "'  type='" + object.getObjectType() + "'");
            }
        }
        return uiQueueManager;
    }

    @Override
    public boolean isAllowApplyProperties() {
        return true;
    }

    private class SystemObjectsViewerFilter
    extends ViewerFilter {
        private SystemObjectsViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            Trace t = Trace.getDefault();
            boolean select = true;
            UiMQObject uiMQObject = null;
            if (element instanceof UiMQObject) {
                uiMQObject = (UiMQObject)element;
            } else if (element instanceof MQExtObject) {
                MQExtObject mqExtObject = (MQExtObject)element;
                uiMQObject = (UiMQObject)mqExtObject.getInternalObject();
            }
            if (uiMQObject != null) {
                select = !uiMQObject.getDmObject().isSystemObject(t);
            }
            return select;
        }
    }
}

