/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.queuemanager;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class SetRefreshIntervalDialog
extends TrayDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/queuemanager/SetRefreshIntervalDialog.java";
    private Label label = null;
    private Button checkAutoRefresh = null;
    private Button buttonDefault = null;
    private Label labelInterval = null;
    private Spinner spinInterval = null;
    private boolean isAutoRefresh = false;
    private int currentInterval = 0;
    private int defaultInterval = 0;
    private int maximumInterval = 0;
    private int minimumInterval = 0;
    private String nlsTitle = "";
    private String nlsAutoRefresh = "";
    private String nlsInterval = "";
    private String nlsApplyDefault = "";
    public static final int MINSIZE_X = 450;

    public SetRefreshIntervalDialog(Shell parent) {
        super(parent);
        Trace t = Trace.getDefault();
        this.setShellStyle(this.getShellStyle() | 0x10);
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_Queue Manager");
        this.nlsTitle = msgFile.getMessage(t, "UI.QMGR.RefreshDlg.Title");
        this.nlsAutoRefresh = msgFile.getMessage(t, "UI.QMGR.RefreshDlg.AutoRefresh");
        this.nlsInterval = msgFile.getMessage(t, "UI.QMGR.RefreshDlg.Interval");
        this.nlsApplyDefault = msgFile.getMessage(t, "UI.QMGR.RefreshDlg.ApplyDefault");
    }

    public void setValues(Trace t, boolean isAutoRef, int curInterval, int dfltInterval, int maxInterval, int minInterval) {
        this.isAutoRefresh = isAutoRef;
        this.currentInterval = curInterval;
        this.defaultInterval = dfltInterval;
        this.maximumInterval = maxInterval;
        this.minimumInterval = minInterval;
    }

    private void autoRefreshSelected() {
        this.isAutoRefresh = this.checkAutoRefresh.getSelection();
        this.labelInterval.setEnabled(this.isAutoRefresh);
        this.spinInterval.setEnabled(this.isAutoRefresh);
        this.buttonDefault.setEnabled(this.isAutoRefresh);
    }

    public boolean isAutoRefresh(Trace t) {
        return this.isAutoRefresh;
    }

    public int getRefreshInterval(Trace t) {
        return this.currentInterval;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.nlsTitle);
        newShell.setImage(Icons.get(Icons.iconkeyQmgrSmall));
        UiPlugin.getHelpSystem().setHelp((Control)newShell, "com.ibm.mq.explorer.ui.infopop.UI_QueueManagerSetRefreshDialog");
    }

    public Composite createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Trace t = Trace.getDefault();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.verticalSpacing = 10;
        gridLayout.marginWidth *= 3;
        gridLayout.marginHeight *= 3;
        composite.setLayout((Layout)gridLayout);
        this.checkAutoRefresh = new Button(composite, 32);
        this.checkAutoRefresh.setText(this.nlsAutoRefresh);
        GridData gridData = new GridData(768);
        gridData.widthHint = 450;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        this.checkAutoRefresh.setLayoutData((Object)gridData);
        this.checkAutoRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SetRefreshIntervalDialog.this.autoRefreshSelected();
            }
        });
        this.label = new Label(composite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.label.setLayoutData((Object)gridData);
        this.labelInterval = new Label(composite, 0);
        this.labelInterval.setText(this.nlsInterval);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.labelInterval.setLayoutData((Object)gridData);
        this.spinInterval = new Spinner(composite, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.spinInterval.setLayoutData((Object)gridData);
        this.spinInterval.setMinimum(this.minimumInterval);
        this.spinInterval.setMaximum(this.maximumInterval);
        UiUtils.limitSpinner(t, this.spinInterval);
        this.spinInterval.setSelection(this.currentInterval);
        this.buttonDefault = new Button(composite, 8);
        this.buttonDefault.setText(this.nlsApplyDefault);
        this.buttonDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SetRefreshIntervalDialog.this.spinInterval.setSelection(SetRefreshIntervalDialog.this.defaultInterval);
            }
        });
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.buttonDefault.setLayoutData((Object)gridData);
        this.label = new Label(composite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        this.label.setLayoutData((Object)gridData);
        composite.pack();
        if (!this.isAutoRefresh) {
            this.currentInterval = this.defaultInterval;
        }
        this.checkAutoRefresh.setSelection(this.isAutoRefresh);
        this.spinInterval.setSelection(this.currentInterval);
        this.autoRefreshSelected();
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button ok = this.getButton(0);
        ok.setFocus();
        this.getShell().setDefaultButton(ok);
    }

    public void okPressed() {
        this.okPressed(Trace.getDefault());
    }

    public void okPressed(Trace t) {
        this.currentInterval = this.isAutoRefresh ? this.spinInterval.getSelection() : -1;
        super.okPressed();
    }
}

