/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.queuemanager;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SelectStopQmgrModeDialog
extends TrayDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/queuemanager/SelectStopQmgrModeDialog.java";
    public static final int MODE_CONTROLLED = 0;
    public static final int MODE_IMMEDIATE = 1;
    public static final int MODE_STANDBY_INSTANCE = 2;
    public static final int ICON_BLANK = -1;
    public static final int ICON_INFO = 0;
    public static final int ICON_WARNING = 1;
    public static final int ICON_ERROR = 2;
    private static final int NUM_COLS = 1;
    private static String immediateButtonText = null;
    private static String controlledButtonText = null;
    private static String groupLabelText = null;
    private static String titleBarText = null;
    private int mode = 0;
    private int msgIconId = -1;
    private String msgText = null;
    private static String switchOverButtonText = null;
    private static String switchOverGroupLabelText = null;
    private static String switchOverGroupLabelMixtureText = null;
    private boolean switchOver = false;
    private static String reconnectButtonText = null;
    private static String reconnectGroupLabelText = null;
    private boolean clientReconnect = false;
    private boolean standbyPermitted = false;
    private boolean mixtureSelected = false;
    private String helpId = null;
    private Button radioControlled = null;
    private Button radioImmediate = null;

    public SelectStopQmgrModeDialog(Trace t, Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.helpId = "com.ibm.mq.explorer.ui.infopop.UI_QueueManagerEndTypeDialog";
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_Command Dialog");
        titleBarText = msgFile.getMessage(t, "UI.QMGRS.End.Title");
        immediateButtonText = msgFile.getMessage(t, "UI.QMGR.EndDlg.ImmediateButton");
        controlledButtonText = msgFile.getMessage(t, "UI.QMGR.EndDlg.ControlledButton");
        groupLabelText = msgFile.getMessage(t, "UI.QMGR.EndDlg.GroupLabel");
        switchOverButtonText = msgFile.getMessage(t, "UI.QMGR.EndDlg.SwitchOverButton");
        switchOverGroupLabelText = msgFile.getMessage(t, "UI.QMGR.Standby.GroupLabel");
        switchOverGroupLabelMixtureText = msgFile.getMessage(t, "UI.QMGR.Standby.GroupLabel.Mixture");
        reconnectButtonText = msgFile.getMessage(t, "UI.QMGR.EndDlg.Reconnect.Button");
        reconnectGroupLabelText = msgFile.getMessage(t, "UI.QMGR.EndDlg.Reconnect.GroupLabel");
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(titleBarText);
        newShell.setImage(Icons.get(Icons.iconkeyQmgrSmall));
        if (this.helpId != null) {
            UiPlugin.getHelpSystem().setHelp((Control)newShell, this.helpId);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button ok = this.getButton(0);
        ok.setFocus();
        this.getShell().setDefaultButton(ok);
    }

    public void setMessage(Trace t, String message, int iconId) {
        this.msgIconId = iconId;
        this.msgText = message;
    }

    public void setTitle(Trace t, String title) {
        titleBarText = title;
    }

    public void setHelpId(Trace t, String helpId) {
        this.helpId = helpId;
    }

    public int getModeSelected() {
        return this.mode;
    }

    public void setModeSelected(int mode) {
        this.mode = mode;
        if (this.radioControlled != null) {
            this.radioControlled.setSelection(mode == 0);
        }
        if (this.radioImmediate != null) {
            this.radioImmediate.setSelection(mode == 1);
        }
    }

    public boolean isSwitchOverSelected() {
        return this.switchOver;
    }

    public boolean isClientReconnectSelected() {
        return this.clientReconnect;
    }

    public Composite createDialogArea(Composite parent) {
        GridData gridData;
        Composite composite = (Composite)super.createDialogArea(parent);
        Trace t = Trace.getDefault();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth *= 3;
        gridLayout.marginHeight *= 3;
        composite.setLayout((Layout)gridLayout);
        if (this.msgText != null) {
            Composite compositeMsgBar = new Composite(composite, 0);
            gridLayout = new GridLayout();
            gridLayout.numColumns = this.msgIconId == -1 ? 1 : 2;
            gridLayout.marginWidth = 0;
            gridLayout.makeColumnsEqualWidth = false;
            compositeMsgBar.setLayout((Layout)gridLayout);
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            gridData.grabExcessHorizontalSpace = true;
            compositeMsgBar.setLayoutData((Object)gridData);
            Label labelMsgBarIcon = null;
            if (this.msgIconId != -1) {
                labelMsgBarIcon = new Label(compositeMsgBar, 0);
            }
            switch (this.msgIconId) {
                case -1: {
                    break;
                }
                case 2: {
                    labelMsgBarIcon.setImage(Dialog.getImage((String)"dialog_message_error_image"));
                    break;
                }
                case 0: {
                    labelMsgBarIcon.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
                    break;
                }
                default: {
                    labelMsgBarIcon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
                }
            }
            if (labelMsgBarIcon != null) {
                gridData = new GridData();
                gridData.horizontalSpan = 1;
                labelMsgBarIcon.setLayoutData((Object)gridData);
            }
            Text txtMsgBarMessage = new Text(compositeMsgBar, 64);
            txtMsgBarMessage.setText(this.msgText);
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            gridData.grabExcessHorizontalSpace = true;
            txtMsgBarMessage.setLayoutData((Object)gridData);
            UiUtils.makeTextControlReadOnly(t, txtMsgBarMessage, true);
            UiUtils.createBlankLine(composite, 1);
        }
        Group group = new Group(composite, 0);
        group.setText(groupLabelText);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        group.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        group.setLayout((Layout)gridLayout);
        this.radioControlled = new Button((Composite)group, 16);
        this.radioControlled.setText(controlledButtonText);
        this.radioControlled.setSelection(this.mode == 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.radioControlled.setLayoutData((Object)gridData);
        this.radioControlled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectStopQmgrModeDialog.this.mode = 0;
            }
        });
        this.radioImmediate = new Button((Composite)group, 16);
        this.radioImmediate.setText(immediateButtonText);
        this.radioImmediate.setSelection(this.mode == 1);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.radioImmediate.setLayoutData((Object)gridData);
        this.radioImmediate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectStopQmgrModeDialog.this.mode = 1;
            }
        });
        UiUtils.createBlankLine(composite, 1);
        if (this.standbyPermitted) {
            Group groupSwitchOver = new Group(composite, 0);
            if (this.mixtureSelected) {
                groupSwitchOver.setText(switchOverGroupLabelMixtureText);
            } else {
                groupSwitchOver.setText(switchOverGroupLabelText);
            }
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            groupSwitchOver.setLayoutData((Object)gridData);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            groupSwitchOver.setLayout((Layout)gridLayout);
            final Button radioSwitchOver = new Button((Composite)groupSwitchOver, 32);
            radioSwitchOver.setText(switchOverButtonText);
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            radioSwitchOver.setLayoutData((Object)gridData);
            radioSwitchOver.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectStopQmgrModeDialog.this.switchOver = radioSwitchOver.getSelection();
                }
            });
            UiUtils.createBlankLine(composite, 1);
        }
        Group groupReconnectable = new Group(composite, 0);
        groupReconnectable.setText(reconnectGroupLabelText);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        groupReconnectable.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        groupReconnectable.setLayout((Layout)gridLayout);
        final Button radioRecconectable = new Button((Composite)groupReconnectable, 32);
        radioRecconectable.setText(reconnectButtonText);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        radioRecconectable.setLayoutData((Object)gridData);
        radioRecconectable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectStopQmgrModeDialog.this.clientReconnect = radioRecconectable.getSelection();
            }
        });
        composite.pack();
        return composite;
    }

    public void setStandbyPermitted(boolean b) {
        this.standbyPermitted = b;
    }

    public boolean getStandbyPermitted() {
        return this.standbyPermitted;
    }

    public void setMixtureSelect(boolean f) {
        this.mixtureSelected = f;
    }
}

