/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.queuemanager;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SelectStartQmgrModeDialog
extends TrayDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/queuemanager/SelectStartQmgrModeDialog.java";
    public static final int ICON_BLANK = -1;
    public static final int ICON_INFO = 0;
    public static final int ICON_WARNING = 1;
    public static final int ICON_ERROR = 2;
    private static final int NUM_COLS = 1;
    public static final int MINSIZE_X = 250;
    private static String serviceButtonText = null;
    private static String asCreatedButtonText = null;
    private static String interactiveButtonText = null;
    private static String startAsGroupLabel = null;
    private int mode = 3;
    private int msgIconId = -1;
    private String msgText = null;
    private static String permitStandbyGroupLabelText = null;
    private boolean permitStandby = false;
    private boolean runningElsewhere = false;
    private static Message msgFile;
    private String titleBarText = null;
    private String helpId = null;

    public SelectStartQmgrModeDialog(Trace t, Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.helpId = "com.ibm.mq.explorer.ui.infopop.UI_QueueManagerStartTypeDialog";
        msgFile = UiPlugin.getUIMessages(t, "KEY_Command Dialog");
        serviceButtonText = msgFile.getMessage(t, "UI.QMGR.StartDlg.AsServiceButton");
        asCreatedButtonText = msgFile.getMessage(t, "UI.QMGR.StartDlg.AsCreatedButton");
        interactiveButtonText = msgFile.getMessage(t, "UI.QMGR.StartDlg.InteractiveButton");
        startAsGroupLabel = msgFile.getMessage(t, "UI.QMGR.StrDlg.StartAsGroupLabel");
        this.titleBarText = msgFile.getMessage(t, "UI.QMGRS.Start.Title");
        permitStandbyGroupLabelText = msgFile.getMessage(t, "UI.QMGR.Standby.GroupLabel");
    }

    public void setTitle(Trace t, String title) {
        this.titleBarText = title;
    }

    public void setHelpId(Trace t, String helpId) {
        this.helpId = helpId;
    }

    public void setMessage(Trace t, String message, int iconId) {
        this.msgIconId = iconId;
        this.msgText = message;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String title = this.titleBarText != null ? this.titleBarText : "";
        newShell.setText(title);
        newShell.setImage(Icons.get(Icons.iconkeyQmgrSmall));
        if (this.helpId != null) {
            UiPlugin.getHelpSystem().setHelp((Control)newShell, this.helpId);
        }
    }

    public int getStartMode() {
        return this.mode;
    }

    public boolean isPermitStandbySelected() {
        return this.permitStandby;
    }

    public Composite createDialogArea(Composite parent) {
        GridData gridData;
        Composite composite = (Composite)super.createDialogArea(parent);
        Trace t = Trace.getDefault();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth *= 3;
        gridLayout.marginHeight *= 3;
        composite.setLayout((Layout)gridLayout);
        if (this.msgText != null) {
            Composite compositeMsgBar = new Composite(composite, 0);
            gridLayout = new GridLayout();
            gridLayout.numColumns = this.msgIconId == -1 ? 1 : 2;
            gridLayout.marginWidth = 0;
            gridLayout.makeColumnsEqualWidth = false;
            compositeMsgBar.setLayout((Layout)gridLayout);
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            gridData.grabExcessHorizontalSpace = true;
            compositeMsgBar.setLayoutData((Object)gridData);
            Label labelMsgBarIcon = null;
            if (this.msgIconId != -1) {
                labelMsgBarIcon = new Label(compositeMsgBar, 0);
            }
            switch (this.msgIconId) {
                case -1: {
                    break;
                }
                case 2: {
                    labelMsgBarIcon.setImage(Dialog.getImage((String)"dialog_message_error_image"));
                    break;
                }
                case 0: {
                    labelMsgBarIcon.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
                    break;
                }
                default: {
                    labelMsgBarIcon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
                }
            }
            if (labelMsgBarIcon != null) {
                gridData = new GridData();
                gridData.horizontalSpan = 1;
                labelMsgBarIcon.setLayoutData((Object)gridData);
            }
            Text txtMsgBarMessage = new Text(compositeMsgBar, 64);
            txtMsgBarMessage.setText(this.msgText);
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            gridData.grabExcessHorizontalSpace = true;
            txtMsgBarMessage.setLayoutData((Object)gridData);
            UiUtils.makeTextControlReadOnly(t, txtMsgBarMessage, true);
            UiUtils.createBlankLine(composite, 1);
        }
        if (CommonServices.PLATFORM_ID == 1) {
            Group group = new Group(composite, 0);
            group.setText(startAsGroupLabel);
            gridData = new GridData(768);
            gridData.widthHint = 250;
            gridData.horizontalSpan = 1;
            group.setLayoutData((Object)gridData);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            group.setLayout((Layout)gridLayout);
            Button radioAsCreated = new Button((Composite)group, 16);
            radioAsCreated.setText(asCreatedButtonText);
            radioAsCreated.setSelection(this.mode == 3);
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            radioAsCreated.setLayoutData((Object)gridData);
            radioAsCreated.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectStartQmgrModeDialog.this.mode = 3;
                }
            });
            Button radioAsService = new Button((Composite)group, 16);
            radioAsService.setText(serviceButtonText);
            radioAsService.setSelection(this.mode == 2);
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            radioAsService.setLayoutData((Object)gridData);
            radioAsService.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectStartQmgrModeDialog.this.mode = 2;
                }
            });
            Button radioInteractive = new Button((Composite)group, 16);
            radioInteractive.setText(interactiveButtonText);
            radioInteractive.setSelection(this.mode == 0);
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            radioInteractive.setLayoutData((Object)gridData);
            radioInteractive.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectStartQmgrModeDialog.this.mode = 0;
                }
            });
            UiUtils.createBlankLine(composite, 1);
        }
        Group groupSwitchOver = new Group(composite, 0);
        groupSwitchOver.setText(permitStandbyGroupLabelText);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        groupSwitchOver.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        groupSwitchOver.setLayout((Layout)gridLayout);
        final Button radioSwitchOver = new Button((Composite)groupSwitchOver, 32);
        if (this.runningElsewhere) {
            radioSwitchOver.setText(msgFile.getMessage(t, "UI.QMGR.StartDlg.RunningElsewhereButton"));
        } else {
            radioSwitchOver.setText(msgFile.getMessage(t, "UI.QMGR.StartDlg.PermitStandbyButton"));
        }
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        radioSwitchOver.setLayoutData((Object)gridData);
        radioSwitchOver.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectStartQmgrModeDialog.this.permitStandby = radioSwitchOver.getSelection();
            }
        });
        radioSwitchOver.setSelection(this.runningElsewhere);
        this.permitStandby = this.runningElsewhere;
        composite.pack();
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button ok = this.getButton(0);
        ok.setFocus();
        this.getShell().setDefaultButton(ok);
    }

    public void setRunningElsewhere(boolean b) {
        this.runningElsewhere = b;
    }
}

