/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.queuemanager;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtCombo;
import com.ibm.mq.explorer.ui.internal.objects.RepeatingValueObject;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.AttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.EnumTextAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.ReadOnlyAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.RepeatingValuesCustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import com.ibm.mq.explorer.ui.internal.queuemanager.ServiceComponentCustomItemProvider;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class QueueManagerServicesPropertyItem
extends CustomPropertyItem {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/queuemanager/QueueManagerServicesPropertyItem.java";
    private static final int[] supportedIds = new int[]{10017, 10018, 10019, 10021, 10020, 10023, 10022};
    private static final int[] serviceComponentIds = new int[]{10021, 10020, 10023, 10022};
    private static final int NUM_COLS = 2;
    private UiQueueManager uiQmgr = null;
    private Attr attr = null;
    private boolean readonly = false;
    private ExtCombo comboServiceName = null;
    private Text textEntryPoints;
    private AttributeControl attrctrlBlankSecurityPolicy;
    private Composite compSecurityPolicy = null;
    private StackLayout stackSecurityPolicy = null;
    private ArrayList services = null;
    private RepeatingValuesCustomPropertyItem rvItemServiceComponents = null;
    private ServiceComponentCustomItemProvider itemProvider = null;
    protected Message msgFile = null;
    private Composite parent = null;

    public QueueManagerServicesPropertyItem(Trace t, Composite parent, int style, UiMQObject uiMQObject, Attr att, boolean ro) {
        super(t, parent, style, uiMQObject, att, ro);
        this.uiQmgr = (UiQueueManager)uiMQObject;
        this.attr = att;
        this.readonly = ro;
        this.parent = parent;
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Properties");
    }

    @Override
    public void init(Trace t) {
        String colon = this.msgFile.getMessage("UI.PROP.Colon.Suffix");
        Composite comp = new Composite(this.parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        comp.setLayout((Layout)gridLayout);
        Group group = new Group(comp, 0);
        String text = null;
        UiDisplayGroup uiDisplayGroup = this.getUiDisplayGroup();
        if (uiDisplayGroup != null) {
            text = uiDisplayGroup.getDisplayGroup().getTitle();
        }
        group.setText(text);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 10;
        gridLayout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)gridLayout);
        this.services = this.getServices(t);
        DmQueueManager dmQmgr = this.uiQmgr.getDmQueueManagerObject();
        Attr attribute = dmQmgr.getAttribute(t, 10017, 0);
        AttrType attrType = attribute.getAttrType();
        Label label = new Label((Composite)group, 0);
        label.setText(String.valueOf(attrType.getDisplayTitle()) + colon);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.comboServiceName = new ExtCombo((Composite)group, 2060);
        int i = 0;
        while (i < this.services.size()) {
            this.comboServiceName.add(this.services.get(i));
            ++i;
        }
        this.comboServiceName.select(0);
        this.comboServiceName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                QueueManagerServicesPropertyItem.this.comboServiceNameSelectionChanged(tr);
            }
        });
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.comboServiceName.setLayoutData(gridData);
        label = new Label((Composite)group, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        attribute = dmQmgr.getAttribute(t, 10018, 0);
        attrType = attribute.getAttrType();
        label = new Label((Composite)group, 0);
        label.setText(String.valueOf(attrType.getDisplayTitle()) + colon);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.textEntryPoints = new Text((Composite)group, 2048);
        UiUtils.makeTextControlReadOnly(t, this.textEntryPoints, true);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.textEntryPoints.setLayoutData((Object)gridData);
        attribute = dmQmgr.getAttribute(t, 10019, 0);
        attrType = attribute.getAttrType();
        label = new Label((Composite)group, 0);
        label.setText(String.valueOf(attrType.getDisplayTitle()) + colon);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.compSecurityPolicy = new Composite((Composite)group, 0);
        this.stackSecurityPolicy = new StackLayout();
        this.compSecurityPolicy.setLayout((Layout)this.stackSecurityPolicy);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.compSecurityPolicy.setLayoutData((Object)gridData);
        i = 0;
        while (i < this.services.size()) {
            Service service = (Service)this.services.get(i);
            service.attrctrlSecurityPolicy = service.isEditSecurityPolicy ? new EnumTextAttributeControl(t, this.compSecurityPolicy, 0, attrType, service.securityPolicy) : new ReadOnlyAttributeControl(t, this.compSecurityPolicy, 0, attrType, service.securityPolicy, false, null);
            ++i;
        }
        this.attrctrlBlankSecurityPolicy = new ReadOnlyAttributeControl(t, this.compSecurityPolicy, 0, attrType, "", false, null);
        this.itemProvider = new ServiceComponentCustomItemProvider(t, this.uiQmgr);
        if (this.services.size() > 0) {
            Service service = (Service)this.services.get(0);
            this.itemProvider.setRepeatingValueObjects(t, service.serviceComponents);
        }
        this.rvItemServiceComponents = new RepeatingValuesCustomPropertyItem(t, (Composite)group, 0, this.uiQmgr, this.attr, this.readonly, this.itemProvider);
        this.rvItemServiceComponents.init(t);
        this.comboServiceNameSelectionChanged(t);
    }

    @Override
    public void restoreDefaults(Trace t) {
    }

    @Override
    public boolean apply(Trace t, Object job) {
        boolean isChanged = false;
        int i = 0;
        while (i < this.services.size()) {
            Service service = (Service)this.services.get(i);
            if (service.isEditSecurityPolicy && service.attrctrlSecurityPolicy.isChanged(t)) {
                this.uiQmgr.getDmQueueManagerObject().setAttributeValue(t, job, 10019, service.repeatingIndex, service.attrctrlSecurityPolicy.getValue(t));
                isChanged = true;
            }
            ++i;
        }
        return isChanged;
    }

    @Override
    public boolean isEnabled(Trace t) {
        return true;
    }

    @Override
    public void changesApplied(Trace t) {
        int i = 0;
        while (i < this.services.size()) {
            Service service = (Service)this.services.get(i);
            if (service.isEditSecurityPolicy) {
                service.attrctrlSecurityPolicy.valueApplied(t);
            }
            ++i;
        }
    }

    public static boolean isAttributeProcessed(Trace t, int attrId) {
        boolean result = false;
        int i = 0;
        while (i < supportedIds.length) {
            if (attrId == supportedIds[i]) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    protected void comboServiceNameSelectionChanged(Trace t) {
        Service service = (Service)this.comboServiceName.getObject(this.comboServiceName.getSelectionIndex());
        if (service != null) {
            this.textEntryPoints.setText("" + service.entryPoints);
            this.stackSecurityPolicy.topControl = service.attrctrlSecurityPolicy;
            this.itemProvider.setRepeatingValueObjects(t, service.serviceComponents);
        } else {
            this.textEntryPoints.setText("");
            this.stackSecurityPolicy.topControl = this.attrctrlBlankSecurityPolicy;
            this.itemProvider.setRepeatingValueObjects(t, null);
        }
        this.compSecurityPolicy.layout();
        this.compSecurityPolicy.redraw();
        this.compSecurityPolicy.update();
        this.rvItemServiceComponents.refresh(t);
    }

    private ArrayList getServices(Trace t) {
        ArrayList<Service> servicesArray = new ArrayList<Service>();
        IDmObject dmObject = this.uiQmgr.getDmObject();
        int count = dmObject.getRepeatingIndexes(t, 10017);
        int i = 0;
        while (i < count) {
            boolean valid = true;
            String serviceName = null;
            int entryPoints = 0;
            String securityPolicy = "";
            boolean isEditSecurityPolicy = false;
            Attr att = dmObject.getAttribute(t, 10017, i);
            if (att != null && !att.isGroupDefaultValuesUsed(t)) {
                if (Trace.isTracing) {
                    t.data(67, "QueueManagerServicesPropertyItem.getServices", 500, "getAttribute: repeatIndex=" + i + " attrId=" + 10017 + " value=" + att.toString(t));
                }
                serviceName = (String)att.getValue(t);
            } else {
                valid = false;
            }
            if (valid) {
                att = dmObject.getAttribute(t, 10018, i);
                if (att != null && !att.isGroupDefaultValuesUsed(t)) {
                    if (Trace.isTracing) {
                        t.data(67, "QueueManagerServicesPropertyItem.getServices", 500, "getAttribute: repeatIndex=" + i + " attrId=" + 10018 + " value=" + att.toString(t));
                    }
                    entryPoints = (Integer)att.getValue(t);
                } else {
                    valid = false;
                }
            }
            if (valid) {
                att = dmObject.getAttribute(t, 10019, i);
                if (att != null && !att.isGroupDefaultValuesUsed(t)) {
                    if (Trace.isTracing) {
                        t.data(67, "QueueManagerServicesPropertyItem.getServices", 500, "getAttribute: repeatIndex=" + i + " attrId=" + 10019 + " value=" + att.toString(t));
                    }
                    securityPolicy = (String)att.getValue(t);
                    isEditSecurityPolicy = att.isReadWrite(t);
                }
                Service service = new Service(t, serviceName, entryPoints, securityPolicy, isEditSecurityPolicy, i);
                servicesArray.add(service);
            }
            ++i;
        }
        count = dmObject.getRepeatingIndexes(t, 10021);
        i = 0;
        while (i < count) {
            RepeatingValueObject rvObject = null;
            int j = 0;
            while (j < serviceComponentIds.length) {
                Attr att = dmObject.getAttribute(t, serviceComponentIds[j], i);
                if (att != null && !att.isGroupDefaultValuesUsed(t)) {
                    if (rvObject == null) {
                        rvObject = new RepeatingValueObject(t);
                    }
                    if (Trace.isTracing) {
                        t.data(67, "QueueManagerServicesPropertyItem.getServices", 500, "getAttribute: repeatIndex=" + i + " attrId=" + supportedIds[j] + " value=" + att.toString(t));
                    }
                    rvObject.setAttribute(t, serviceComponentIds[j], att);
                    rvObject.setAttributeValue(t, serviceComponentIds[j], att.getValue(t));
                }
                ++j;
            }
            if (rvObject != null) {
                rvObject.setRepeatingIndex(i);
                String servName = rvObject.getAttributeValue(t, 10020).toString();
                int j2 = 0;
                while (j2 < servicesArray.size()) {
                    Service service = (Service)servicesArray.get(j2);
                    if (servName.compareTo(service.serviceName) == 0) {
                        service.addServiceComponent(t, rvObject);
                        break;
                    }
                    ++j2;
                }
            }
            ++i;
        }
        return servicesArray;
    }

    private static class Service {
        String serviceName = "";
        int entryPoints = 0;
        String securityPolicy = "";
        ArrayList<RepeatingValueObject> serviceComponents = null;
        boolean isEditSecurityPolicy = false;
        AttributeControl attrctrlSecurityPolicy = null;
        int repeatingIndex = -1;

        public Service(Trace t, String name, int entryPts, String secPolicy, boolean isEditSecPol, int repeatIndex) {
            this.serviceName = name;
            this.entryPoints = entryPts;
            this.securityPolicy = secPolicy;
            this.serviceComponents = new ArrayList();
            this.isEditSecurityPolicy = isEditSecPol;
            this.repeatingIndex = repeatIndex;
        }

        public String toString() {
            return this.serviceName;
        }

        public void addServiceComponent(Trace t, RepeatingValueObject serviceComp) {
            this.serviceComponents.add(serviceComp);
        }

        public ArrayList getServiceComponents(Trace t) {
            return this.serviceComponents;
        }
    }
}

