/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.queuemanager;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.objects.DisplayGroup;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyPage;
import com.ibm.mq.explorer.ui.internal.properties.PropertyControl;
import com.ibm.mq.explorer.ui.internal.properties.UiAttr;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import com.ibm.mq.explorer.ui.internal.queuemanager.QueueManagerSSLHardwareDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;

public class QueueManagerSSLPropertyPage
extends CustomPropertyPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/queuemanager/QueueManagerSSLPropertyPage.java";
    private static final int NUMCOLUMNS = 2;
    private Message msgFile = null;
    private UiMQObject uiMQObject = null;
    private IDmObject dmObject = null;
    private Attr attr = null;
    private UiAttr uiAttr_SSL_KEY_REPOS = null;
    private UiAttr uiAttr_SSL_HARDWARE = null;
    private UiAttr uiAttr_SSL_CRL_NAMELIST = null;
    private DisplayGroup displayGroup = null;
    private Label labelKeyRep = null;
    private Text textCrypto = null;
    private Button buttonCrypto = null;
    private Button checkSSLCRLNamelist = null;
    private String hardware = null;
    private String SSL_KEY_REPOSITORY_SECTION_title = null;
    private String SSL_KEY_REPOSITORY_text = null;
    private String SSL_CRYPTO_HARDWARE_title = null;
    private String SSL_CONFIGURE_CRYPTO_HARDWARE_title = null;
    private String SSL_CRL_NAMELIST_CHECKING_title = null;
    private String SSL_AUTHENTICATION_INFORMATION_title = null;
    public static final String SSL_CUSTOM_HARDWARE = "GSK_PKCS11";
    public static final String SSL_RAINBOW_CS_ON = "GSK_ACCELERATOR_RAINBOW_CS_ON";
    public static final String SSL_RAINBOW_CS_OFF = "GSK_ACCELERATOR_RAINBOW_CS_OFF";
    public static final String SSL_NCIPHER_NF_ON = "GSK_ACCELERATOR_NCIPHER_NF_ON";
    public static final String SSL_NCIPHER_NF_OFF = "GSK_ACCELERATOR_NCIPHER_NF_OFF";
    public static final String SYMMETRIC_CIPHER_ON = "SYMMETRIC_CIPHER_ON";
    public static final String SYMMETRIC_CIPHER_OFF = "SYMMETRIC_CIPHER_OFF";
    private PropertyControl propertyControl = null;
    private static final int[] HANDLEDATTRIDS = new int[]{2049, 2050, 2051};

    public QueueManagerSSLPropertyPage(Trace t, Composite parent, int style, UiMQObject uiMQObject_, UiDisplayGroup uiDisplayGroup, boolean readonly) {
        super(t, parent, style, uiMQObject_, uiDisplayGroup, readonly);
        this.uiMQObject = uiMQObject_;
        this.displayGroup = uiDisplayGroup.getDisplayGroup();
        this.propertyControl = uiDisplayGroup.getPropertyControl();
    }

    @Override
    public void init(final Trace t) {
        this.dmObject = this.uiMQObject.getDmObject();
        this.SSL_KEY_REPOSITORY_SECTION_title = this.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.SSL.Key.Repository.Section.Title");
        this.SSL_KEY_REPOSITORY_text = this.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.SSL.Key.Repository.Text");
        this.SSL_CRYPTO_HARDWARE_title = this.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.SSL.Crypto.Hardware.Title");
        this.SSL_CONFIGURE_CRYPTO_HARDWARE_title = String.valueOf(this.getNLSString(t, "KEY_Queue Manager", "UI.GENERAL.CONFIGURE")) + "...";
        this.SSL_CRL_NAMELIST_CHECKING_title = this.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.SSL.CRL.Namelist.Checking.Title");
        this.SSL_AUTHENTICATION_INFORMATION_title = this.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.SSL.Authentication.Information.Title");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        this.setLayout((Layout)gridLayout);
        Group swtgroup = null;
        GridData gridData = null;
        this.attr = this.dmObject.getAttribute(t, 2049, 0);
        if (this.attr != null) {
            swtgroup = new Group((Composite)this, 0);
            swtgroup.setText(this.SSL_KEY_REPOSITORY_SECTION_title);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            swtgroup.setLayout((Layout)gridLayout);
            gridData = new GridData(256);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = 2;
            swtgroup.setLayoutData((Object)gridData);
            this.labelKeyRep = new Label((Composite)swtgroup, 64);
            this.labelKeyRep.setText(this.SSL_KEY_REPOSITORY_text);
            gridData = new GridData(256);
            gridData.horizontalSpan = 2;
            gridData.grabExcessHorizontalSpace = true;
            this.labelKeyRep.setLayoutData((Object)gridData);
            this.uiAttr_SSL_KEY_REPOS = new UiAttr(t, this.attr, this.displayGroup);
            if (this.uiAttr_SSL_KEY_REPOS != null) {
                this.propertyControl.addAttributeToPage(t, (Composite)swtgroup, this.uiAttr_SSL_KEY_REPOS);
            }
        }
        this.attr = this.dmObject.getAttribute(t, 2050, 0);
        if (this.attr != null) {
            swtgroup = new Group((Composite)this, 0);
            swtgroup.setText(this.SSL_AUTHENTICATION_INFORMATION_title);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            swtgroup.setLayout((Layout)gridLayout);
            gridData = new GridData(256);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = 2;
            swtgroup.setLayoutData((Object)gridData);
            this.checkSSLCRLNamelist = new Button((Composite)swtgroup, 32);
            this.checkSSLCRLNamelist.setText(this.SSL_CRL_NAMELIST_CHECKING_title);
            this.checkSSLCRLNamelist.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    QueueManagerSSLPropertyPage.this.uiAttr_SSL_CRL_NAMELIST.getAttributeControl().setEnabled(QueueManagerSSLPropertyPage.this.checkSSLCRLNamelist.getSelection());
                }
            });
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            this.checkSSLCRLNamelist.setLayoutData((Object)gridData);
            this.uiAttr_SSL_CRL_NAMELIST = new UiAttr(t, this.attr, this.displayGroup);
            if (this.uiAttr_SSL_CRL_NAMELIST != null) {
                this.propertyControl.addAttributeToPage(t, (Composite)swtgroup, this.uiAttr_SSL_CRL_NAMELIST);
                if (!this.uiAttr_SSL_CRL_NAMELIST.getAttr().toString(t).equals("")) {
                    this.checkSSLCRLNamelist.setSelection(true);
                } else {
                    this.checkSSLCRLNamelist.setSelection(false);
                }
            }
            this.uiAttr_SSL_CRL_NAMELIST.getAttributeControl().setEnabled(this.checkSSLCRLNamelist.getSelection());
        }
        this.attr = this.dmObject.getAttribute(t, 2051, 0);
        int sequence = 0;
        if (this.attr != null) {
            AttrType attrType = this.attr.getAttrType();
            sequence = attrType.getDisplayGroupSequence();
        }
        if (this.attr != null && sequence != -2) {
            swtgroup = new Group((Composite)this, 0);
            swtgroup.setText(this.SSL_CRYPTO_HARDWARE_title);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            swtgroup.setLayout((Layout)gridLayout);
            gridData = new GridData(256);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = 2;
            swtgroup.setLayoutData((Object)gridData);
            this.uiAttr_SSL_HARDWARE = new UiAttr(t, this.attr, this.displayGroup);
            if (this.attr != null) {
                this.hardware = (String)this.attr.getValue(t);
            }
            this.textCrypto = new Text((Composite)swtgroup, 2120);
            String cryptoText = this.parseCryptoHardware(t, false);
            this.textCrypto.setText(String.valueOf(cryptoText) + "\n\n");
            gridData = new GridData(256);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = 2;
            this.textCrypto.setLayoutData((Object)gridData);
            Menu blankMenu = new Menu((Control)this.textCrypto);
            this.textCrypto.setMenu(blankMenu);
            this.buttonCrypto = new Button((Composite)swtgroup, 8);
            this.buttonCrypto.setText(this.SSL_CONFIGURE_CRYPTO_HARDWARE_title);
            gridData = new GridData(32);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = 2;
            this.buttonCrypto.setLayoutData((Object)gridData);
            this.buttonCrypto.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    QueueManagerSSLHardwareDialog hardwareDialog = new QueueManagerSSLHardwareDialog(QueueManagerSSLPropertyPage.this.getShell());
                    hardwareDialog.setValues(t, QueueManagerSSLPropertyPage.this.hardware, QueueManagerSSLPropertyPage.this.uiAttr_SSL_HARDWARE.getAttr().getDmObject().getQueueManager().getCommandLevel());
                    if (hardwareDialog.open() == 0) {
                        QueueManagerSSLPropertyPage.this.hardware = hardwareDialog.getResult(t);
                        String crypto = QueueManagerSSLPropertyPage.this.parseCryptoHardware(t, true);
                        QueueManagerSSLPropertyPage.this.textCrypto.setText(crypto);
                        QueueManagerSSLPropertyPage.this.textCrypto.redraw();
                    }
                }
            });
            if (this.uiAttr_SSL_HARDWARE.getAttr() == null) {
                this.textCrypto.setEnabled(false);
                this.buttonCrypto.setEnabled(false);
                swtgroup.setEnabled(false);
            }
        }
        super.addUnexpectedAttributes(t, this, HANDLEDATTRIDS);
    }

    private String parseCryptoHardware(Trace t, boolean changed) {
        String retVal = null;
        String rawValue = null;
        if (this.uiAttr_SSL_HARDWARE.getAttr() == null) {
            return this.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.SSL.Crypto.Hardware.None.Text");
        }
        rawValue = this.hardware != null ? this.hardware : (String)this.uiAttr_SSL_HARDWARE.getAttr().getValue(t);
        if (rawValue.startsWith(SSL_CUSTOM_HARDWARE)) {
            int pathStart = rawValue.indexOf("=", 0) + 1;
            int pathStop = rawValue.indexOf(";", 0);
            int tokenStart = pathStop + 1;
            int tokenStop = rawValue.indexOf(";", tokenStart);
            int passStart = tokenStop + 1;
            int passStop = rawValue.indexOf(";", passStart);
            int symmetricStart = passStop + 1;
            int symmetricStop = rawValue.indexOf(";", symmetricStart);
            String path = rawValue.substring(pathStart, pathStop);
            String token = rawValue.substring(tokenStart, tokenStop);
            String symmetric = "";
            if (symmetricStop != -1) {
                symmetric = rawValue.substring(symmetricStart, symmetricStop);
            }
            String pass = new String();
            int k = 0;
            while (k < passStop - passStart) {
                pass = pass.concat("*");
                ++k;
            }
            retVal = this.uiMQObject.getDmObject().getQueueManager().getCommandLevel() >= 600 ? this.msgFile.getMessage(t, "UI.QMGR.SSL.Crypto.Hardware.CUSTOM.Text.V6", path, token, pass, symmetric) : this.msgFile.getMessage(t, "UI.QMGR.SSL.Crypto.Hardware.CUSTOM.Text", path, token, pass);
        } else {
            retVal = rawValue.equals(SSL_RAINBOW_CS_ON) ? this.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.SSL.Crypto.Hardware.RAINBOW.ON.Text") : (rawValue.equals(SSL_RAINBOW_CS_OFF) ? this.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.SSL.Crypto.Hardware.RAINBOW.OFF.Text") : (rawValue.equals(SSL_NCIPHER_NF_ON) ? this.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.SSL.Crypto.Hardware.NCIPHER.ON.Text") : (rawValue.equals(SSL_NCIPHER_NF_OFF) ? this.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.SSL.Crypto.Hardware.NCIPHER.OFF.Text") : this.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.SSL.Crypto.Hardware.None.Text"))));
        }
        return retVal;
    }

    @Override
    public void restoreDefaults(Trace t) {
    }

    @Override
    public boolean apply(Trace t, Object job) {
        boolean result = false;
        boolean isChanged = false;
        if (this.uiAttr_SSL_KEY_REPOS != null && this.uiAttr_SSL_KEY_REPOS.getAttributeControl() != null && this.uiAttr_SSL_KEY_REPOS.getAttributeControl().isChanged(t)) {
            String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4571", (String)this.dmObject.getTitle());
            int r = MessageBox.showYesNoMessage(t, this.getShell(), msg, 1, "AMQ4571");
            if (r == 0) {
                result = this.dmObject.setAttributeValue(t, job, 2049, 0, this.uiAttr_SSL_KEY_REPOS.getAttributeControl().getValue(t));
                if (result) {
                    if (Trace.isTracing) {
                        t.data(67, "QueueManagerSSLPropertyPage.apply", 900, "dmObject setAttributeValue successful for SSL key repository.");
                    }
                    isChanged = true;
                } else if (Trace.isTracing) {
                    t.data(67, "QueueManagerSSLPropertyPage.apply", 900, "dmObject setAttributeValue failed for SSL key repository.");
                }
            } else {
                String curVal = (String)this.uiAttr_SSL_KEY_REPOS.getAttributeControl().getAttr().getValue(t);
                this.uiAttr_SSL_KEY_REPOS.getAttributeControl().setValue(t, curVal);
            }
        } else if (this.uiAttr_SSL_KEY_REPOS == null && Trace.isTracing) {
            t.data(67, "QueueManagerSSLPropertyPage.apply", 900, "Not able to obtain uiAttr for SSL key repository attribute.");
        }
        if (this.uiAttr_SSL_HARDWARE != null && this.hardware != null && !this.hardware.equals(this.uiAttr_SSL_HARDWARE.getAttr().getValue(t))) {
            result = this.dmObject.setAttributeValue(t, job, 2051, 0, (Object)this.hardware);
            if (result) {
                if (Trace.isTracing) {
                    t.data(67, "QueueManagerSSLPropertyPage.apply", 900, "dmObject setAttributeValue successful for SSL hardware.");
                }
                isChanged = true;
            } else if (Trace.isTracing) {
                t.data(67, "QueueManagerSSLPropertyPage.apply", 900, "dmObject setAttributeValue failed for SSL hardware.");
            }
        } else if (this.uiAttr_SSL_HARDWARE == null && Trace.isTracing) {
            t.data(67, "QueueManagerSSLPropertyPage.apply", 900, "Not able to obtain uiAttr for SSL hardware attribute.");
        }
        if (this.uiAttr_SSL_CRL_NAMELIST != null) {
            if (!this.checkSSLCRLNamelist.getSelection()) {
                this.uiAttr_SSL_CRL_NAMELIST.getAttributeControl().setValue(t, "");
            }
            if (this.uiAttr_SSL_CRL_NAMELIST.getAttributeControl().isChanged(t)) {
                result = this.dmObject.setAttributeValue(t, job, 2050, 0, this.uiAttr_SSL_CRL_NAMELIST.getAttributeControl().getValue(t));
                if (result) {
                    if (Trace.isTracing) {
                        t.data(67, "QueueManagerSSLPropertyPage.apply", 900, "dmObject setAttributeValue successful for SSL CRL Namelist.");
                    }
                    isChanged = true;
                } else if (Trace.isTracing) {
                    t.data(67, "QueueManagerSSLPropertyPage.apply", 900, "dmObject setAttributeValue failed for SSL CRL Namelist.");
                }
            }
        } else if (this.uiAttr_SSL_CRL_NAMELIST == null && Trace.isTracing) {
            t.data(67, "QueueManagerSSLPropertyPage.apply", 900, "Not able to obtain uiAttr for SSL CRL Namelist attribute.");
        }
        return isChanged;
    }

    public String getNLSString(Trace t, String fileKey, String textKey) {
        String nlsString = "+++" + textKey + "+++";
        String msgfileKey = fileKey;
        if (msgfileKey == null) {
            msgfileKey = QueueManagerSSLPropertyPage.getNLSResourceFileKey();
        }
        this.msgFile = UiPlugin.getUIMessages(t, msgfileKey);
        if (this.msgFile != null) {
            nlsString = this.msgFile.getMessage(t, textKey);
        }
        return nlsString;
    }

    public static String getNLSResourceFileKey() {
        return "KEY_Queue Manager";
    }

    @Override
    public boolean isAnyControlEnabled(Trace t) {
        return true;
    }

    @Override
    public void changesApplied(Trace t) {
        if (this.uiAttr_SSL_KEY_REPOS != null && this.uiAttr_SSL_KEY_REPOS.getAttributeControl().isChanged(t)) {
            this.uiAttr_SSL_KEY_REPOS.getAttributeControl().valueApplied(t);
        }
    }
}

