/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.queuemanager;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class QueueManagerSSLHardwareDialog
extends TrayDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/queuemanager/QueueManagerSSLHardwareDialog.java";
    private String hardware = null;
    private int commandLevel = -1;
    private Message msgFile = null;
    private int widthHint = 400;
    private String result = null;
    private Button none = null;
    private Button rainbow = null;
    private Group grpRainbow = null;
    private Button rainbowAllow = null;
    private Button rainbowPrevent = null;
    private Button nCipher = null;
    private Group grpNCipher = null;
    private Button ncipherAllow = null;
    private Button ncipherPrevent = null;
    private Button other = null;
    private Group grpOther = null;
    private Label pathLabel = null;
    private Text pathText = null;
    private Label labelLabel = null;
    private Text labelText = null;
    private Label passwordLabel = null;
    private Text passwordText = null;
    private Combo symmetricCombo = null;
    private Label symmetricLabel = null;
    private String passwordErrorMessage;

    public QueueManagerSSLHardwareDialog(Shell parent) {
        super(parent);
        Trace t = Trace.getDefault();
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Queue Manager");
        this.passwordErrorMessage = this.msgFile.getMessage("UI.QMGR.SSL.Hardware.Dialog.OTHER.MissingPassword");
    }

    public void setValues(Trace t, String hw, int cmdlvl) {
        this.hardware = hw;
        this.commandLevel = cmdlvl;
    }

    public String getResult(Trace t) {
        return this.result;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Trace t = Trace.getDefault();
        newShell.setText(this.msgFile.getMessage(t, "UI.QMGR.SSL.Hardware.Dialog.Title"));
        newShell.setImage(Icons.get(Icons.iconkeyQmgrSmall));
        UiPlugin.getHelpSystem().setHelp((Control)newShell, "com.ibm.mq.explorer.ui.infopop.UI_QueueManagerSSLHardwareDialog");
    }

    public Composite createDialogArea(Composite parent) {
        String rawValue;
        Composite composite = (Composite)super.createDialogArea(parent);
        Trace t = Trace.getDefault();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth *= 3;
        gridLayout.marginHeight *= 3;
        gridLayout.horizontalSpacing = 12;
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)gridLayout);
        Text text = new Text(composite, 66);
        text.setText(this.msgFile.getMessage(t, "UI.QMGR.SSL.Hardware.Dialog.Text"));
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = this.widthHint;
        text.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly(t, text, true);
        this.none = new Button(composite, 16);
        this.none.setText(this.msgFile.getMessage(t, "UI.QMGR.SSL.Hardware.Dialog.NONE.Radio"));
        this.rainbow = new Button(composite, 16);
        this.rainbow.setText(this.msgFile.getMessage(t, "UI.QMGR.SSL.Hardware.Dialog.RAINBOW.Radio"));
        this.grpRainbow = new Group(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        this.grpRainbow.setLayout((Layout)gridLayout);
        gridData = new GridData(256);
        this.grpRainbow.setLayoutData((Object)gridData);
        this.rainbowAllow = new Button((Composite)this.grpRainbow, 16);
        this.rainbowAllow.setText(this.msgFile.getMessage(t, "UI.QMGR.SSL.Hardware.Dialog.ALLOW.Radio"));
        this.rainbowPrevent = new Button((Composite)this.grpRainbow, 16);
        this.rainbowPrevent.setText(this.msgFile.getMessage(t, "UI.QMGR.SSL.Hardware.Dialog.PREVENT.Radio"));
        this.nCipher = new Button(composite, 16);
        this.nCipher.setText(this.msgFile.getMessage(t, "UI.QMGR.SSL.Hardware.Dialog.NCIPHER.Radio"));
        this.grpNCipher = new Group(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        this.grpNCipher.setLayout((Layout)gridLayout);
        gridData = new GridData(256);
        gridData.grabExcessHorizontalSpace = true;
        this.grpNCipher.setLayoutData((Object)gridData);
        this.ncipherAllow = new Button((Composite)this.grpNCipher, 16);
        this.ncipherAllow.setText(this.msgFile.getMessage(t, "UI.QMGR.SSL.Hardware.Dialog.ALLOW.Radio"));
        this.ncipherPrevent = new Button((Composite)this.grpNCipher, 16);
        this.ncipherPrevent.setText(this.msgFile.getMessage(t, "UI.QMGR.SSL.Hardware.Dialog.PREVENT.Radio"));
        this.other = new Button(composite, 16);
        this.other.setText(this.msgFile.getMessage(t, "UI.QMGR.SSL.Hardware.Dialog.OTHER.Radio"));
        this.grpOther = new Group(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        this.grpOther.setLayout((Layout)gridLayout);
        gridData = new GridData(256);
        gridData.grabExcessHorizontalSpace = true;
        this.grpOther.setLayoutData((Object)gridData);
        Composite otherComp = new Composite((Composite)this.grpOther, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.horizontalSpacing = 12;
        otherComp.setLayout((Layout)gridLayout);
        gridData = new GridData(256);
        otherComp.setLayoutData((Object)gridData);
        this.pathLabel = new Label(otherComp, 0);
        this.pathLabel.setText(this.msgFile.getMessage(t, "UI.QMGR.SSL.Hardware.Dialog.OTHER.Path"));
        this.pathText = new Text(otherComp, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        this.pathText.setLayoutData((Object)gridData);
        this.labelLabel = new Label(otherComp, 0);
        this.labelLabel.setText(this.msgFile.getMessage(t, "UI.QMGR.SSL.Hardware.Dialog.OTHER.Label"));
        this.labelText = new Text(otherComp, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        this.labelText.setLayoutData((Object)gridData);
        this.passwordLabel = new Label(otherComp, 0);
        this.passwordLabel.setText(this.msgFile.getMessage(t, "UI.QMGR.SSL.Hardware.Dialog.OTHER.Password"));
        this.passwordText = new Text(otherComp, 0x400800);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        this.passwordText.setLayoutData((Object)gridData);
        UiUtils.createControlDecoration(t, (Control)this.passwordText);
        if (this.commandLevel >= 600) {
            this.symmetricLabel = new Label(otherComp, 0);
            this.symmetricLabel.setText(this.msgFile.getMessage(t, "UI.QMGR.SSL.Hardware.Dialog.OTHER.Symmetric"));
            this.symmetricCombo = new Combo(otherComp, 12);
            this.symmetricCombo.add(this.msgFile.getMessage(t, "UI.GENERAL.NO"), 0);
            this.symmetricCombo.add(this.msgFile.getMessage(t, "UI.GENERAL.YES"), 1);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            gridData.grabExcessHorizontalSpace = true;
            this.symmetricCombo.setLayoutData((Object)gridData);
            this.symmetricCombo.select(0);
        }
        this.none.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                QueueManagerSSLHardwareDialog.this.rainbowAllow.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.rainbowPrevent.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.ncipherAllow.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.ncipherPrevent.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.pathLabel.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.pathText.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.labelLabel.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.labelText.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.passwordLabel.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.passwordText.setEnabled(false);
                if (QueueManagerSSLHardwareDialog.this.symmetricCombo != null) {
                    QueueManagerSSLHardwareDialog.this.symmetricLabel.setEnabled(false);
                    QueueManagerSSLHardwareDialog.this.symmetricCombo.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.rainbow.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                QueueManagerSSLHardwareDialog.this.rainbowAllow.setEnabled(true);
                QueueManagerSSLHardwareDialog.this.rainbowPrevent.setEnabled(true);
                QueueManagerSSLHardwareDialog.this.ncipherAllow.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.ncipherPrevent.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.pathLabel.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.pathText.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.labelLabel.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.labelText.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.passwordLabel.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.passwordText.setEnabled(false);
                if (QueueManagerSSLHardwareDialog.this.symmetricCombo != null) {
                    QueueManagerSSLHardwareDialog.this.symmetricLabel.setEnabled(false);
                    QueueManagerSSLHardwareDialog.this.symmetricCombo.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.nCipher.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                QueueManagerSSLHardwareDialog.this.rainbowAllow.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.rainbowPrevent.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.ncipherAllow.setEnabled(true);
                QueueManagerSSLHardwareDialog.this.ncipherPrevent.setEnabled(true);
                QueueManagerSSLHardwareDialog.this.pathLabel.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.pathText.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.labelLabel.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.labelText.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.passwordLabel.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.passwordText.setEnabled(false);
                if (QueueManagerSSLHardwareDialog.this.symmetricCombo != null) {
                    QueueManagerSSLHardwareDialog.this.symmetricLabel.setEnabled(false);
                    QueueManagerSSLHardwareDialog.this.symmetricCombo.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.other.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                QueueManagerSSLHardwareDialog.this.rainbowAllow.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.rainbowPrevent.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.ncipherAllow.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.ncipherPrevent.setEnabled(false);
                QueueManagerSSLHardwareDialog.this.pathLabel.setEnabled(true);
                QueueManagerSSLHardwareDialog.this.pathText.setEnabled(true);
                QueueManagerSSLHardwareDialog.this.labelLabel.setEnabled(true);
                QueueManagerSSLHardwareDialog.this.labelText.setEnabled(true);
                QueueManagerSSLHardwareDialog.this.passwordLabel.setEnabled(true);
                QueueManagerSSLHardwareDialog.this.passwordText.setEnabled(true);
                if (QueueManagerSSLHardwareDialog.this.symmetricCombo != null) {
                    QueueManagerSSLHardwareDialog.this.symmetricLabel.setEnabled(true);
                    QueueManagerSSLHardwareDialog.this.symmetricCombo.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.rainbowAllow.setEnabled(false);
        this.rainbowAllow.setSelection(true);
        this.rainbowPrevent.setEnabled(false);
        this.ncipherAllow.setEnabled(false);
        this.ncipherAllow.setSelection(true);
        this.ncipherPrevent.setEnabled(false);
        this.pathLabel.setEnabled(false);
        this.pathText.setEnabled(false);
        this.labelLabel.setEnabled(false);
        this.labelText.setEnabled(false);
        this.passwordLabel.setEnabled(false);
        this.passwordText.setEnabled(false);
        if (this.symmetricCombo != null) {
            this.symmetricLabel.setEnabled(false);
            this.symmetricCombo.setEnabled(false);
        }
        if ((rawValue = this.hardware).startsWith("GSK_PKCS11")) {
            int pathStart = rawValue.indexOf("=", 0) + 1;
            int pathStop = rawValue.indexOf(";", 0);
            int tokenStart = pathStop + 1;
            int tokenStop = rawValue.indexOf(";", tokenStart);
            int passStart = tokenStop + 1;
            int passStop = rawValue.indexOf(";", passStart);
            int symmetricStart = passStop + 1;
            int symmetricStop = rawValue.indexOf(";", symmetricStart);
            String path = rawValue.substring(pathStart, pathStop);
            String token = rawValue.substring(tokenStart, tokenStop);
            String symmetric = "";
            if (symmetricStop != -1) {
                symmetric = rawValue.substring(symmetricStart, symmetricStop);
            }
            this.pathText.setText(path);
            this.labelText.setText(token);
            if (symmetric.compareTo("SYMMETRIC_CIPHER_ON") == 0) {
                this.symmetricCombo.setText(this.msgFile.getMessage(t, "UI.GENERAL.YES"));
            }
            if (symmetric.compareTo("SYMMETRIC_CIPHER_OFF") == 0) {
                this.symmetricCombo.setText(this.msgFile.getMessage(t, "UI.GENERAL.NO"));
            }
            this.pathLabel.setEnabled(true);
            this.pathText.setEnabled(true);
            this.labelLabel.setEnabled(true);
            this.labelText.setEnabled(true);
            this.passwordLabel.setEnabled(true);
            this.passwordText.setEnabled(true);
            if (this.symmetricCombo != null) {
                this.symmetricLabel.setEnabled(true);
                this.symmetricCombo.setEnabled(true);
            }
            this.other.setSelection(true);
        } else if (rawValue.equals("GSK_ACCELERATOR_RAINBOW_CS_ON")) {
            this.rainbow.setSelection(true);
            this.rainbowAllow.setEnabled(true);
            this.rainbowAllow.setSelection(true);
            this.rainbowPrevent.setEnabled(true);
            this.rainbowPrevent.setSelection(false);
        } else if (rawValue.equals("GSK_ACCELERATOR_RAINBOW_CS_OFF")) {
            this.rainbow.setSelection(true);
            this.rainbowAllow.setEnabled(true);
            this.rainbowAllow.setSelection(false);
            this.rainbowPrevent.setEnabled(true);
            this.rainbowPrevent.setSelection(true);
        } else if (rawValue.equals("GSK_ACCELERATOR_NCIPHER_NF_ON")) {
            this.nCipher.setSelection(true);
            this.ncipherAllow.setEnabled(true);
            this.ncipherAllow.setSelection(true);
            this.ncipherPrevent.setEnabled(true);
            this.ncipherPrevent.setSelection(false);
        } else if (rawValue.equals("GSK_ACCELERATOR_NCIPHER_NF_OFF")) {
            this.nCipher.setSelection(true);
            this.ncipherAllow.setEnabled(true);
            this.ncipherAllow.setSelection(false);
            this.ncipherPrevent.setEnabled(true);
            this.ncipherPrevent.setSelection(true);
        } else {
            this.none.setSelection(true);
        }
        composite.pack();
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button ok = this.getButton(0);
        ok.setFocus();
        this.getShell().setDefaultButton(ok);
    }

    public void okPressed() {
        this.okPressed(Trace.getDefault());
    }

    public void okPressed(Trace t) {
        boolean performOk = true;
        if (this.none.getSelection()) {
            this.result = "";
        } else if (this.rainbow.getSelection()) {
            this.result = this.rainbowAllow.getSelection() ? "GSK_ACCELERATOR_RAINBOW_CS_ON" : "GSK_ACCELERATOR_RAINBOW_CS_OFF";
        } else if (this.nCipher.getSelection()) {
            this.result = this.ncipherAllow.getSelection() ? "GSK_ACCELERATOR_NCIPHER_NF_ON" : "GSK_ACCELERATOR_NCIPHER_NF_OFF";
        } else if (this.other.getSelection()) {
            if (this.passwordText.getText().equals("")) {
                MessageBox.showMessageFailure(t, this.getShell(), this.passwordErrorMessage);
                performOk = false;
            } else {
                this.result = "GSK_PKCS11";
                this.result = this.result.concat("=");
                this.result = this.result.concat(this.pathText.getText());
                this.result = this.result.concat(";");
                this.result = this.result.concat(this.labelText.getText());
                this.result = this.result.concat(";");
                this.result = this.result.concat(this.passwordText.getText());
                this.result = this.result.concat(";");
                if (this.commandLevel >= 600) {
                    String txt = null;
                    txt = this.symmetricCombo.getText().equals(this.msgFile.getMessage(t, "UI.GENERAL.YES")) ? "SYMMETRIC_CIPHER_ON" : "SYMMETRIC_CIPHER_OFF";
                    this.result = this.result.concat(txt);
                    this.result = this.result.concat(";");
                }
            }
        }
        if (performOk) {
            super.okPressed();
        }
    }
}

