/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.queuemanager;

import com.ibm.mq.MQException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.PCFAction;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.AttributeModifiedEvent;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.EnumAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.IAttributeModifiedListener;
import com.ibm.mq.explorer.ui.internal.properties.ReadOnlyAttributeControl;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.event.PCFQuery;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class QueueManagerLoggerEventsCustomPropertyItem
extends CustomPropertyItem
implements IAttributeModifiedListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/queuemanager/QueueManagerLoggerEventsCustomPropertyItem.java";
    private static final int[] supportedIds = new int[]{94};
    private UiQueueManager uiQmgr = null;
    private Attr attrLoggerEvents = null;
    private boolean readonly = false;
    protected Message msgFile = null;
    EnumAttributeControl control = null;
    private Composite parent = null;

    public QueueManagerLoggerEventsCustomPropertyItem(Trace t, Composite parent, int style, UiMQObject uiMQObject, Attr att, boolean ro) {
        super(t, parent, style, uiMQObject, att, ro);
        this.uiQmgr = (UiQueueManager)uiMQObject;
        this.attrLoggerEvents = att;
        this.readonly = ro;
        this.parent = parent;
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Properties");
    }

    @Override
    public void init(Trace t) {
        String colon = this.msgFile.getMessage("UI.PROP.Colon.Suffix");
        AttrType attrTypeLoggerEvents = this.attrLoggerEvents.getAttrType();
        Label label = new Label(this.parent, 0);
        label.setText(String.valueOf(attrTypeLoggerEvents.getPropTitle()) + colon);
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        if (this.readonly || !this.isLinearLogging()) {
            ReadOnlyAttributeControl readOnlyAttrCtrl = new ReadOnlyAttributeControl(t, this.parent, 0, attrTypeLoggerEvents, this.attrLoggerEvents.toString(t), attrTypeLoggerEvents.isMultiLine(), this.getFixedSpaceFont());
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalIndent = 8;
            readOnlyAttrCtrl.setLayoutData(gridData);
        } else {
            this.control = new EnumAttributeControl(t, this.parent, 0, attrTypeLoggerEvents, this.attrLoggerEvents.getValue(t));
            this.control.setAttr(this.attrLoggerEvents);
            this.control.setAssociatedLabel(label);
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalIndent = 8;
            this.control.setLayoutData(gridData);
        }
    }

    private boolean isLinearLogging() {
        boolean linearLogging = false;
        Trace t = Trace.getInstance();
        DmQueueManager dmQmgr = this.uiQmgr.getDmQueueManagerObject();
        PCFQuery query = PCFAction.getStatusQuery((Trace)t, (String)dmQmgr.getUUID(), (int)2, null);
        PCFMessage request = query.createPCFRequest(false);
        try {
            PCFMessage[] responses = dmQmgr.sendCommand(t, request);
            if (responses != null && responses.length > 0) {
                PCFMessage[] pCFMessageArray = responses;
                int n = responses.length;
                int n2 = 0;
                while (n2 < n) {
                    String logExtent;
                    PCFMessage msg = pCFMessageArray[n2];
                    if (msg.getParameter(3073) != null && (logExtent = msg.getStringParameterValue(3073)) != null && logExtent.length() > 0) {
                        linearLogging = true;
                    }
                    ++n2;
                }
            }
        }
        catch (MQException mQException) {}
        return linearLogging;
    }

    @Override
    public void restoreDefaults(Trace t) {
    }

    @Override
    public boolean apply(Trace t, Object job) {
        boolean isChanged = false;
        if (!this.readonly && this.control != null) {
            Integer currentLoggerEvents;
            DmQueueManager dmQmgr = this.uiQmgr.getDmQueueManagerObject();
            if (this.control.isChanged(t) && dmQmgr.setAttributeValue(t, job, 94, 0, (Object)(currentLoggerEvents = (Integer)this.control.getValue(t)))) {
                this.control.valueApplied(t);
                isChanged = true;
            }
        }
        return isChanged;
    }

    @Override
    public boolean isEnabled(Trace t) {
        return !this.readonly;
    }

    @Override
    public void changesApplied(Trace t) {
    }

    public static boolean isAttributeProcessed(Trace t, int attrId) {
        boolean result = false;
        int i = 0;
        while (i < supportedIds.length) {
            if (attrId == supportedIds[i]) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    @Override
    public void attrModified(AttributeModifiedEvent event) {
    }
}

