/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.queuemanager;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeRange;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.AttributeModifiedEvent;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.IAttributeModifiedListener;
import com.ibm.mq.explorer.ui.internal.properties.RangeAttributeControl;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class QueueManagerLogFilesCustomPropertyItem
extends CustomPropertyItem
implements IAttributeModifiedListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/queuemanager/QueueManagerLogFilesCustomPropertyItem.java";
    private static final int[] supportedIds = new int[]{10000, 10001};
    private static final Integer PRIMARY_LOG_FILES = 1;
    private static final Integer SECONDARY_LOG_FILES = 2;
    private UiQueueManager uiQmgr = null;
    private Attr attrPrimary = null;
    private Attr attrSecondary = null;
    private boolean readonly = false;
    private RangeAttributeControl attrCtrlPrimary = null;
    private RangeAttributeControl attrCtrlSecondary = null;
    private int maxLogFiles = 0;
    private boolean changedByCode = false;
    protected Message msgFile = null;
    private Composite parent = null;

    public QueueManagerLogFilesCustomPropertyItem(Trace t, Composite parent, int style, UiMQObject uiMQObject, Attr att, boolean ro) {
        super(t, parent, style, uiMQObject, att, ro);
        this.uiQmgr = (UiQueueManager)uiMQObject;
        this.attrPrimary = att;
        this.readonly = ro;
        this.parent = parent;
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Properties");
        this.attrSecondary = this.uiQmgr.getDmQueueManagerObject().getAttribute(t, 10001, 0);
        try {
            this.maxLogFiles = ((AttrTypeRange)this.attrPrimary.getAttrType()).getMaximumValue() + ((AttrTypeRange)this.attrSecondary.getAttrType()).getMinimumValue();
        }
        catch (NullPointerException nullPointerException) {
            this.readonly = true;
            t.FFST(67, "QueueManagerLogFilesCustomPropertyItem.QueueManagerLogFilesCustomPropertyItem", 0, 50006, "Error getting min/max values for log files");
        }
    }

    @Override
    public void init(Trace t) {
        String colon = this.msgFile.getMessage("UI.PROP.Colon.Suffix");
        AttrType attrTypePrimary = this.attrPrimary.getAttrType();
        Label label = new Label(this.parent, 0);
        label.setText(String.valueOf(attrTypePrimary.getDisplayTitle()) + colon);
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        if (this.readonly) {
            Text text = new Text(this.parent, 0);
            UiUtils.makeTextControlReadOnly(t, text, true);
            text.setText(this.attrPrimary.toString(t));
        } else {
            this.attrCtrlPrimary = new RangeAttributeControl(t, this.parent, 0, attrTypePrimary, this.attrPrimary.getValue(t));
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalIndent = 8;
            this.attrCtrlPrimary.setLayoutData(gridData);
            this.attrCtrlPrimary.addModifyListener(this, PRIMARY_LOG_FILES);
        }
        AttrType attrTypeSecondary = this.attrSecondary.getAttrType();
        label = new Label(this.parent, 0);
        label.setText(String.valueOf(attrTypeSecondary.getDisplayTitle()) + colon);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        if (this.readonly) {
            Text text = new Text(this.parent, 0);
            UiUtils.makeTextControlReadOnly(t, text, true);
            text.setText(this.attrSecondary.toString(t));
        } else {
            this.attrCtrlSecondary = new RangeAttributeControl(t, this.parent, 0, attrTypeSecondary, this.attrSecondary.getValue(t));
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalIndent = 8;
            this.attrCtrlSecondary.setLayoutData(gridData);
            this.attrCtrlSecondary.addModifyListener(this, SECONDARY_LOG_FILES);
        }
    }

    @Override
    public void restoreDefaults(Trace t) {
    }

    @Override
    public boolean apply(Trace t, Object job) {
        boolean isChanged = false;
        if (!this.readonly) {
            Integer currentSecondaryLogFiles;
            Integer currentPrimaryLogFiles;
            DmQueueManager dmQmgr = this.uiQmgr.getDmQueueManagerObject();
            if (this.attrCtrlPrimary.isChanged(t) && dmQmgr.setAttributeValue(t, job, 10000, 0, (Object)(currentPrimaryLogFiles = (Integer)this.attrCtrlPrimary.getValue(t)))) {
                this.attrCtrlPrimary.valueApplied(t);
                isChanged = true;
            }
            if (this.attrCtrlSecondary.isChanged(t) && dmQmgr.setAttributeValue(t, job, 10001, 0, (Object)(currentSecondaryLogFiles = (Integer)this.attrCtrlSecondary.getValue(t)))) {
                this.attrCtrlSecondary.valueApplied(t);
                isChanged = true;
            }
        }
        return isChanged;
    }

    @Override
    public boolean isEnabled(Trace t) {
        return !this.readonly;
    }

    @Override
    public void changesApplied(Trace t) {
    }

    public static boolean isAttributeProcessed(Trace t, int attrId) {
        boolean result = false;
        int i = 0;
        while (i < supportedIds.length) {
            if (attrId == supportedIds[i]) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public static boolean canProcessAttribute(Trace t, UiQueueManager uiQmgr, int attrId) {
        boolean isAttrProcessed = QueueManagerLogFilesCustomPropertyItem.isAttributeProcessed(t, attrId);
        Attr secondaryAttr = uiQmgr.getDmQueueManagerObject().getAttribute(t, 10001, 0);
        boolean result = isAttrProcessed && secondaryAttr != null;
        return result;
    }

    @Override
    public void attrModified(AttributeModifiedEvent event) {
        Trace t = Trace.getDefault();
        Integer control = event.getUserType();
        if (!this.changedByCode) {
            if (control == PRIMARY_LOG_FILES) {
                int primary = (Integer)event.getAttributeControl().getValue(t);
                int maxSecondary = this.maxLogFiles - primary;
                int secondary = (Integer)this.attrCtrlSecondary.getValue(t);
                if (secondary > maxSecondary) {
                    this.changedByCode = true;
                    this.attrCtrlSecondary.setValue(t, maxSecondary);
                    this.changedByCode = false;
                }
            } else {
                int secondary = (Integer)event.getAttributeControl().getValue(t);
                int maxPrimary = this.maxLogFiles - secondary;
                int primary = (Integer)this.attrCtrlPrimary.getValue(t);
                if (primary > maxPrimary) {
                    this.changedByCode = true;
                    this.attrCtrlPrimary.setValue(t, maxPrimary);
                    this.changedByCode = false;
                }
            }
        }
    }
}

