/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.queuemanager;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListListener;
import com.ibm.mq.explorer.core.internal.objects.DmClusterQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyPage;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class QueueManagerClusterPropertyPage
extends CustomPropertyPage
implements DmObjectListListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/queuemanager/QueueManagerClusterPropertyPage.java";
    private static final int NUMCOLUMNS = 2;
    private Message msgFileQmgr;
    private UiMQObject uiMQObject = null;
    private IDmObject dmObject = null;
    private Table table = null;
    private Shell shell = null;
    protected Message msgFileProp = null;
    private Composite composite = null;
    private static final int[] HANDLED_ATTR_IDS = new int[]{2029, 2035, 2036};
    private ArrayList<String> knownClusters = null;

    public QueueManagerClusterPropertyPage(Trace t, Composite parent, int style, UiMQObject uiMQObject_, UiDisplayGroup uiDispGroup, boolean readonly) {
        super(t, parent, style, uiMQObject_, uiDispGroup, readonly);
        this.uiMQObject = uiMQObject_;
        this.composite = parent;
        this.knownClusters = new ArrayList();
    }

    @Override
    public void init(Trace t) {
        this.msgFileQmgr = UiPlugin.getUIMessages(t, "KEY_Queue Manager");
        this.msgFileProp = UiPlugin.getUIMessages(t, "KEY_Properties");
        String colon = this.msgFileProp.getMessage("UI.PROP.Colon.Suffix");
        this.dmObject = this.uiMQObject.getDmObject();
        this.shell = this.getShell();
        GridData gridData = null;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        this.setLayout((Layout)gridLayout);
        boolean connected = false;
        DmQueueManager dmQueueManager = this.dmObject.getQueueManager();
        if (dmQueueManager != null) {
            connected = dmQueueManager.isConnected();
        }
        if (connected) {
            Group swtgroup = new Group((Composite)this, 0);
            swtgroup.setText(this.msgFileQmgr.getMessage(t, "UI.QMGR.Cluster.Membership.Title"));
            gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            swtgroup.setLayout((Layout)gridLayout);
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = 2;
            swtgroup.setLayoutData((Object)gridData);
            Text labelText = new Text((Composite)swtgroup, 0);
            labelText.setText(this.msgFileQmgr.getMessage(t, "UI.QMGR.Cluster.Membership.Text"));
            UiUtils.makeTextControlReadOnly(t, labelText, true);
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = 2;
            labelText.setLayoutData((Object)gridData);
            this.table = new Table((Composite)swtgroup, 2048);
            this.table.setHeaderVisible(true);
            this.table.setLinesVisible(false);
            final TableColumn column0 = new TableColumn(this.table, 16384, 0);
            column0.setText(this.msgFileQmgr.getMessage(t, "UI.QMGR.Cluster.Name.Title"));
            final TableColumn column1 = new TableColumn(this.table, 16384, 1);
            column1.setText(String.valueOf(this.msgFileQmgr.getMessage(t, "UI.QMGR.Repository.Name.Title")) + colon);
            this.table.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    int tablex;
                    Point pt = QueueManagerClusterPropertyPage.this.table.getSize();
                    int space = tablex = pt.x;
                    if (QueueManagerClusterPropertyPage.this.table.getVerticalBar().isVisible()) {
                        int barsize = ((QueueManagerClusterPropertyPage)QueueManagerClusterPropertyPage.this).table.getVerticalBar().getSize().x;
                        space -= barsize;
                    }
                    int width0 = (int)((double)space * 0.6);
                    int width1 = (int)((double)space * 0.39);
                    column0.setWidth(width0);
                    column1.setWidth(width1);
                }
            });
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = 2;
            gridData.heightHint = 2 * this.table.getItemHeight() + this.table.getHeaderHeight();
            this.table.setLayoutData((Object)gridData);
            DmQueueManager dmQm = (DmQueueManager)this.dmObject;
            dmQm.getObjects(t, (DmObjectListListener)this, new DmObjectFilter(t, 70));
            Label labelDummy = new Label((Composite)this, 0);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            labelDummy.setLayoutData((Object)gridData);
        }
        super.addUnexpectedAttributes(t, this, HANDLED_ATTR_IDS);
    }

    @Override
    public void restoreDefaults(Trace t) {
    }

    @Override
    public boolean apply(Trace t, Object job) {
        return false;
    }

    @Override
    public boolean isAnyControlEnabled(Trace t) {
        return true;
    }

    @Override
    public void changesApplied(Trace t) {
    }

    public void dmObjectListDone(DmObjectListEvent event) {
        final Trace t = Trace.getDefault();
        if (!this.shell.isDisposed()) {
            final ArrayList objects = new ArrayList(event.getList());
            this.shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    QueueManagerClusterPropertyPage.this.updateValues(t, objects);
                }
            });
        }
    }

    private void updateValues(final Trace t, ArrayList objects) {
        Attr attr;
        ArrayList<DmClusterQueueManager> objs = new ArrayList<DmClusterQueueManager>();
        for (Object o : objects) {
            int deftype;
            DmClusterQueueManager dmClusQm;
            if (!(o instanceof DmClusterQueueManager) || (attr = (dmClusQm = (DmClusterQueueManager)o).getAttribute(t, 1084, 0)) == null || attr.getValue(t) == null || (deftype = ((Integer)attr.getValue(t)).intValue()) != 3) continue;
            objs.add(dmClusQm);
        }
        Collections.sort(objs, new Comparator<DmClusterQueueManager>(){

            @Override
            public int compare(DmClusterQueueManager dcqm1, DmClusterQueueManager dcqm2) {
                String name1 = dcqm1.getAttributeValue(t, 2029, 0);
                String name2 = dcqm2.getAttributeValue(t, 2029, 0);
                return name1.compareTo(name2);
            }
        });
        int idx1 = 0;
        while (idx1 < objs.size()) {
            DmClusterQueueManager clusqmgr = (DmClusterQueueManager)objs.get(idx1);
            String clusterName = clusqmgr.getAttributeValue(t, 2029, 0);
            if (!this.knownClusters.contains(clusterName)) {
                this.knownClusters.add(clusterName);
                attr = clusqmgr.getAttribute(t, 1085, 0);
                if (attr != null && attr.getValue(t) != null) {
                    int repos = (Integer)attr.getValue(t);
                    boolean isRepos = repos == 1;
                    TableItem ti = new TableItem(this.table, 0);
                    ti.setText(0, clusterName);
                    ti.setText(1, UiPlugin.getNLSString(t, this.uiMQObject.getNLSResourceFileKey(), isRepos ? "UI.GENERAL.YES" : "UI.GENERAL.NO"));
                    this.composite.layout();
                }
            }
            ++idx1;
        }
        if (objs.size() == 0 && this.table.getItems().length == 0) {
            TableItem ti = new TableItem(this.table, 0);
            ti.setText(0, "");
            ti.setText(1, "");
            this.composite.layout();
        }
    }
}

