/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.queuemanager;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.AttributeModifiedEvent;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.IAttributeModifiedListener;
import com.ibm.mq.explorer.ui.internal.properties.RangeAttributeControl;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class QueueManagerChannelsCustomPropertyItem
extends CustomPropertyItem
implements IAttributeModifiedListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/queuemanager/QueueManagerChannelsCustomPropertyItem.java";
    private static final int[] supportedIds = new int[]{10024, 10025};
    private static final Integer MAX_CHANNELS = 1;
    private static final Integer MAX_ACTIVE_CHANNLES = 2;
    private UiQueueManager uiQmgr = null;
    private Attr attrMaxChannels = null;
    private Attr attrMaxActiveChannels = null;
    private boolean readonly = false;
    private RangeAttributeControl attrCtrlMaxChannels = null;
    private RangeAttributeControl attrCtrlMaxActiveChannels = null;
    private boolean changedByCode = false;
    private boolean attCtrlMaxActiveChannelsChanged = false;
    protected Message msgFile = null;
    private Composite parent = null;

    public QueueManagerChannelsCustomPropertyItem(Trace t, Composite parent, int style, UiMQObject uiMQObject, Attr attr, boolean ro) {
        super(t, parent, style, uiMQObject, attr, ro);
        this.uiQmgr = (UiQueueManager)uiMQObject;
        this.attrMaxChannels = attr;
        this.readonly = ro;
        this.parent = parent;
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Properties");
        this.attrMaxActiveChannels = this.uiQmgr.getDmQueueManagerObject().getAttribute(t, 10025, 0);
    }

    @Override
    public void attrModified(AttributeModifiedEvent event) {
        Trace t = Trace.getDefault();
        Integer control = event.getUserType();
        if (!this.changedByCode) {
            if (control == MAX_CHANNELS) {
                int currentMaxChannels = (Integer)event.getAttributeControl().getValue(t);
                if (!this.attCtrlMaxActiveChannelsChanged) {
                    this.changedByCode = true;
                    this.attrCtrlMaxActiveChannels.setValue(t, currentMaxChannels);
                    this.changedByCode = false;
                }
            } else {
                this.attCtrlMaxActiveChannelsChanged = true;
            }
        }
    }

    @Override
    public void init(Trace t) {
        String colon = this.msgFile.getMessage("UI.PROP.Colon.Suffix");
        AttrType attrTypeChannels = this.attrMaxChannels.getAttrType();
        Label label = new Label(this.parent, 0);
        label.setText(String.valueOf(attrTypeChannels.getDisplayTitle()) + colon);
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        if (this.readonly) {
            Text text = new Text(this.parent, 0);
            UiUtils.makeTextControlReadOnly(t, text, true);
            text.setText(this.attrMaxChannels.toString(t));
        } else {
            this.attrCtrlMaxChannels = new RangeAttributeControl(t, this.parent, 0, attrTypeChannels, this.attrMaxChannels.getValue(t));
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            this.attrCtrlMaxChannels.setLayoutData(gridData);
            this.attrCtrlMaxChannels.addModifyListener(this, MAX_CHANNELS);
        }
        AttrType attrTypeActiveChannels = this.attrMaxActiveChannels.getAttrType();
        label = new Label(this.parent, 0);
        label.setText(String.valueOf(attrTypeActiveChannels.getDisplayTitle()) + colon);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        if (this.readonly) {
            Text text = new Text(this.parent, 0);
            UiUtils.makeTextControlReadOnly(t, text, true);
            text.setText(this.attrMaxActiveChannels.toString(t));
        } else {
            Integer defaultValue = (Integer)this.attrMaxActiveChannels.getDefaultValue(t);
            Integer initialValue = (Integer)this.attrMaxActiveChannels.getValue(t);
            if (initialValue.intValue() == defaultValue.intValue()) {
                initialValue = (Integer)this.attrMaxChannels.getValue(t);
            } else {
                this.attCtrlMaxActiveChannelsChanged = true;
            }
            this.attrCtrlMaxActiveChannels = new RangeAttributeControl(t, this.parent, 0, attrTypeActiveChannels, initialValue);
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            this.attrCtrlMaxActiveChannels.setLayoutData(gridData);
            this.attrCtrlMaxActiveChannels.addModifyListener(this, MAX_ACTIVE_CHANNLES);
        }
    }

    @Override
    public void restoreDefaults(Trace t) {
    }

    @Override
    public boolean apply(Trace t, Object job) {
        boolean isChanged = false;
        if (!this.readonly) {
            Integer currentMaxActiveChannels;
            Integer currentMaxChannels;
            DmQueueManager dmQmgr = this.uiQmgr.getDmQueueManagerObject();
            if (this.attrCtrlMaxChannels.isChanged(t) && dmQmgr.setAttributeValue(t, job, 10024, 0, (Object)(currentMaxChannels = (Integer)this.attrCtrlMaxChannels.getValue(t)))) {
                this.attrCtrlMaxChannels.valueApplied(t);
                isChanged = true;
            }
            if (this.attrCtrlMaxActiveChannels.isChanged(t) && this.attCtrlMaxActiveChannelsChanged && dmQmgr.setAttributeValue(t, job, 10025, 0, (Object)(currentMaxActiveChannels = (Integer)this.attrCtrlMaxActiveChannels.getValue(t)))) {
                this.attrCtrlMaxActiveChannels.valueApplied(t);
                isChanged = true;
            }
        }
        return isChanged;
    }

    @Override
    public boolean isEnabled(Trace t) {
        return false;
    }

    @Override
    public void changesApplied(Trace t) {
    }

    public static boolean isAttributeProcessed(Trace t, int attrId) {
        boolean result = false;
        int i = 0;
        while (i < supportedIds.length) {
            if (attrId == supportedIds[i]) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public static boolean canProcessAttribute(Trace t, UiQueueManager uiQmgr, int attrId) {
        boolean isAttrProcessed = QueueManagerChannelsCustomPropertyItem.isAttributeProcessed(t, attrId);
        Attr secondaryAttr = uiQmgr.getDmQueueManagerObject().getAttribute(t, 10025, 0);
        boolean result = isAttrProcessed && secondaryAttr != null;
        return result;
    }
}

