/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.queuemanager;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ActionPubSubRefeshQueueManager
extends Action
implements DmActionListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/queuemanager/ActionPubSubRefeshQueueManager.java";
    private Shell shell;
    private UiQueueManager uiQmgr;
    private BusyDialog busyDialog = null;

    public ActionPubSubRefeshQueueManager(Trace t, Shell aShell, UiQueueManager aQmgr) {
        this.shell = aShell;
        this.uiQmgr = aQmgr;
    }

    public void perform(Trace t) {
        String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4495");
        String title = UiPlugin.getNLSString(t, "KEY_General", "UI.GENERAL.MQ");
        String msgBusy = UiPlugin.getNLSString(t, "KEY_Queue Manager", "UI.QMGR.Busy.Pubsub.Refresh");
        int rc = MessageBox.showYesNoMessage(t, this.shell, title, msg, 1, "AMQ4495");
        if (rc == 0) {
            this.busyDialog = new BusyDialog(this.shell, msgBusy);
            DmQueueManager dmQm = this.uiQmgr.getDmQueueManagerObject();
            dmQm.actionRefresh(t, (DmActionListener)this);
            this.busyDialog.showDialog(t);
        }
    }

    public void dmActionDone(DmActionEvent event) {
        final int rc = event.getReasonCode();
        final DmCoreException exc = event.getException();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Trace trace = Trace.getDefault();
                ActionPubSubRefeshQueueManager.this.busyDialog.closeDialog(trace);
                if (rc == 0) {
                    MessageBox.showSystemMessageById(trace, UiPlugin.getShell(), "AMQ4496", null, "AMQ4496");
                } else if (exc != null) {
                    MessageBox.showExceptionMessage(trace, UiPlugin.getShell(), exc);
                } else {
                    MessageBox.showExceptionMessage(trace, UiPlugin.getShell(), new DmCoreException("Reason code: " + rc, "Unknown", rc, 0, 1));
                }
            }
        });
    }
}

