/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.queuemanager;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.extensions.ExplorerNotifyEvent;
import com.ibm.mq.explorer.ui.internal.base.NotificationManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.console.ConsoleCommand;
import com.ibm.mq.explorer.ui.internal.console.ConsoleDialog;
import com.ibm.mq.explorer.ui.internal.console.IConsoleDialogUser;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Shell;

public class ActionDeleteQueueManager
implements IConsoleDialogUser {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/queuemanager/ActionDeleteQueueManager.java";
    public static final int STRMQM_ALREADY_RUNNING_EXITVALUE = 5;
    public static final int STRMQCSV_ALREADY_RUNNING_EXITVALUE = 20;
    private static String deleteTextGeneral = null;
    private static String deleteTextDetail = null;
    private Shell shell;
    private UiQueueManager qmgr;

    public ActionDeleteQueueManager(Trace t, Shell aShell, UiQueueManager aQmgr) {
        this.shell = aShell;
        this.qmgr = aQmgr;
        if (deleteTextGeneral == null) {
            deleteTextGeneral = UiPlugin.getNLSString(t, "KEY_Queue Manager", "UI.QMGRS.DeleteGeneral.Text");
            deleteTextDetail = UiPlugin.getNLSString(t, "KEY_Queue Manager", "UI.QMGRS.DeleteDetail.Text");
        }
    }

    public void perform(Trace t) {
        String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4117", (String)this.qmgr.toString());
        int rc = MessageBox.showDeleteCancelMessage(t, this.shell, msg, 1, "AMQ4117");
        if (rc == 0) {
            ArrayList<ConsoleCommand> list = new ArrayList<ConsoleCommand>();
            if (this.qmgr.isDeleteSystemObject(t, this.shell)) {
                ConsoleDialog dialog = new ConsoleDialog(t, this.shell, this);
                dialog.setTitle(Message.format((String)deleteTextDetail, (String)this.qmgr.toString()));
                dialog.setHelp("com.ibm.mq.explorer.ui.infopop.UI_QueueManagerDeleteDialog");
                String commandString = "dltmqm " + this.qmgr.toString();
                ConsoleCommand c = new ConsoleCommand(deleteTextGeneral, commandString);
                c.addExitValue(0);
                list.add(c);
                NotificationManager notificationManager = UiPlugin.getNotificationManager();
                ExplorerNotifyEvent notifyEvent = new ExplorerNotifyEvent(this.qmgr.getExternalObject(), null);
                if (!notificationManager.notifyIsPreventDeleteQueueManager(t, notifyEvent)) {
                    notificationManager.notifyQueueManagerDeleted(t, notifyEvent);
                    dialog.execute(t, list);
                    this.qmgr.getDmObject().actionDelete(t, null, null);
                }
                if (Trace.isTracing) {
                    t.data(67, "ActionDeleteQueueManager.perform", "QM " + this.qmgr.toString() + " deletion prevented");
                }
            }
        }
    }

    @Override
    public void finished(final Trace t, int id, boolean result) {
        UiPlugin.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                UiPlugin.getTheDataModel().refreshDmMonitor(t);
            }
        });
    }
}

