/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties.mapping;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.internal.properties.mapping.IPropertyMapper;
import com.ibm.mq.explorer.ui.internal.properties.mapping.PropertyMapperStore;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class PropertyMapperFactory {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/mapping/PropertyMapperFactory.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    private static PropertyMapperFactory singleton = new PropertyMapperFactory();
    private PropertyMapperStore store;

    private PropertyMapperFactory() {
        Trace t = Trace.getDefault();
        this.store = new PropertyMapperStore(t);
        this.loadPropertyMappers(t);
    }

    private void loadPropertyMappers(Trace t) {
        String extensionPointString = "internal_registerPropertyMapper";
        String fromClassString = "fromClass";
        String toClassString = "toClass";
        String mapperClassString = "class";
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.mq.explorer.ui", extensionPointString);
        if (extensionPoint != null) {
            PropertyMapperFactory.trace(t, "PropertyMapperFactory.loadPropertyMappers", "    label = " + extensionPoint.getLabel());
            PropertyMapperFactory.trace(t, "PropertyMapperFactory.loadPropertyMappers", "    schemaReference = " + extensionPoint.getSchemaReference());
            PropertyMapperFactory.trace(t, "PropertyMapperFactory.loadPropertyMappers", "    simpleIdentifier = " + extensionPoint.getSimpleIdentifier());
            PropertyMapperFactory.trace(t, "PropertyMapperFactory.loadPropertyMappers", "    uniqueIdentifier = " + extensionPoint.getUniqueIdentifier());
            IConfigurationElement[] configArray = extensionPoint.getConfigurationElements();
            PropertyMapperFactory.trace(t, "PropertyMapperFactory.loadPropertyMappers", "    Number of ConfigurationElements = " + configArray.length);
            int i = 0;
            while (i < configArray.length) {
                IConfigurationElement element = configArray[i];
                PropertyMapperFactory.trace(t, "PropertyMapperFactory.loadPropertyMappers", "        name  = " + element.getName());
                PropertyMapperFactory.trace(t, "PropertyMapperFactory.loadPropertyMappers", "        value = " + element.getValue());
                PropertyMapperFactory.trace(t, "PropertyMapperFactory.loadPropertyMappers", "");
                ++i;
            }
            IExtension[] extensionArray = extensionPoint.getExtensions();
            PropertyMapperFactory.trace(t, "PropertyMapperFactory.loadPropertyMappers", "    Number of Extensions = " + extensionArray.length);
            int i2 = 0;
            while (i2 < extensionArray.length) {
                IExtension extension = extensionArray[i2];
                PropertyMapperFactory.trace(t, "PropertyMapperFactory.loadPropertyMappers", "        label = " + extension.getLabel());
                PropertyMapperFactory.trace(t, "PropertyMapperFactory.loadPropertyMappers", "        simpleIdentifier = " + extension.getSimpleIdentifier());
                PropertyMapperFactory.trace(t, "PropertyMapperFactory.loadPropertyMappers", "        uniqueIdentifier = " + extension.getUniqueIdentifier());
                IConfigurationElement[] configArray2 = extension.getConfigurationElements();
                PropertyMapperFactory.trace(t, "PropertyMapperFactory.loadPropertyMappers", "        Number of ConfigurationElements = " + configArray2.length);
                int j = 0;
                while (j < configArray2.length) {
                    block15: {
                        IConfigurationElement element = configArray2[j];
                        PropertyMapperFactory.trace(t, "PropertyMapperFactory.loadPropertyMappers", "            element.name  = " + element.getName());
                        PropertyMapperFactory.trace(t, "PropertyMapperFactory.loadPropertyMappers", "            element.value = " + element.getValue());
                        String plugin_id = element.getDeclaringExtension().getNamespaceIdentifier();
                        String fromClass = element.getAttribute(fromClassString);
                        if (fromClass != null && fromClass.length() > 0) {
                            PropertyMapperFactory.trace(t, "PropertyMapperFactory.loadPropertyMappers", "              " + fromClassString + "            = " + fromClass);
                            String toClass = element.getAttribute(toClassString);
                            if (toClass != null && toClass.length() > 0) {
                                PropertyMapperFactory.trace(t, "PropertyMapperFactory.loadPropertyMappers", "                " + toClassString + "    = " + toClass);
                                String mapperClass = element.getAttribute(mapperClassString);
                                PropertyMapperFactory.trace(t, "PropertyMapperFactory.loadPropertyMappers", "                " + mapperClassString + " = " + mapperClass);
                                try {
                                    IPropertyMapper mapper = (IPropertyMapper)element.createExecutableExtension(mapperClassString);
                                    if (mapper != null) {
                                        this.store.put(t, fromClass, toClass, mapper);
                                        break block15;
                                    }
                                    if (Trace.isTracing) {
                                        t.data(67, "PropertyMapperFactory.loadPropertyMappers", 900, "Unable to load the IPropertyMapper '" + mapperClass + "' for pluginId '" + plugin_id + "'");
                                    }
                                    t.FFST(67, "PropertyMapperFactory.loadPropertyMappers", 60, 50999, 0, 0, "Unable to load IPropertyMapper specified in " + extensionPointString + " extension point", "pluginId = '" + plugin_id + "'", String.valueOf(mapperClassString) + " = '" + mapperClass + "'");
                                }
                                catch (CoreException coreException) {
                                    if (Trace.isTracing) {
                                        t.data(67, "PropertyMapperFactory.loadPropertyMappers", 900, "CoreException loading the " + mapperClassString + " '" + mapperClass + "' for pluginId '" + plugin_id + "'");
                                    }
                                    t.FFST(67, "PropertyMapperFactory.loadPropertyMappers", 70, 50999, 0, 0, "CoreException loading class specified in " + extensionPointString + " extension point", "pluginId = '" + plugin_id + "'", String.valueOf(mapperClassString) + " = '" + mapperClass + "'");
                                }
                            } else {
                                if (Trace.isTracing) {
                                    t.data(67, "PropertyMapperFactory.loadPropertyMappers", 900, String.valueOf(extensionPointString) + " extension point ignored, " + toClassString + " '" + toClass + "' is not registered for pluginId '" + plugin_id + "'");
                                }
                                t.FFST(67, "PropertyMapperFactory.loadPropertyMappers", 80, 50999, 0, 0, String.valueOf(extensionPointString) + " extension point ignored, " + fromClassString + " is not registered", "pluginId = '" + plugin_id + "'", "objectId = '" + fromClass + "'");
                            }
                        } else {
                            if (Trace.isTracing) {
                                t.data(67, "PropertyMapperFactory.loadPropertyMappers", 900, String.valueOf(extensionPointString) + " extension point ignored, " + fromClassString + " '" + fromClass + "' is not registered for pluginId '" + plugin_id + "'");
                            }
                            t.FFST(67, "PropertyMapperFactory.loadPropertyMappers", 80, 50999, 0, 0, String.valueOf(extensionPointString) + " extension point ignored, " + fromClassString + " is not registered", "pluginId = '" + plugin_id + "'", "objectId = '" + fromClass + "'");
                        }
                    }
                    ++j;
                }
                ++i2;
            }
        }
    }

    public static PropertyMapperFactory getFactory() {
        return singleton;
    }

    public IPropertyMapper getPropertyMapper(Trace t, Class fromClass, Class toClass) {
        IPropertyMapper mapper = this.store.get(t, fromClass.getName(), toClass.getName());
        return mapper;
    }

    public Collection getPropertyMappersFrom(Trace t, Class fromClass) {
        return this.store.getMappersFrom(t, fromClass.getName());
    }

    private static void trace(Trace t, String fid, String message) {
        if (Trace.isTracing) {
            t.data(67, fid, 300, message);
        }
    }
}

