/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.properties.AttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.AttributeModifiedEvent;
import com.ibm.mq.explorer.ui.internal.properties.EditURLDialog;
import com.ibm.mq.explorer.ui.internal.properties.IAttributeModifiedListener;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class URLAttributeControl
extends AttributeControl {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/URLAttributeControl.java";
    private static final int MAX_WIDTH = 500;
    private Text text = null;
    private Button buttonEdit = null;
    private AttrType attrType = null;
    private boolean enabled = true;
    private Object originalValue = null;

    public URLAttributeControl(Trace t, Composite parent, int style, AttrType attType, Object currentValue) {
        super(t, parent, style, attType, currentValue);
        this.originalValue = currentValue;
        this.attrType = attType;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this.text = new Text((Composite)this, 2048);
        String string = currentValue == null ? "" : currentValue.toString();
        this.text.setText(string);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        this.text.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly(t, this.text, false);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace tr = Trace.getDefault();
                URLAttributeControl.this.valueChanged(tr);
            }
        });
        this.buttonEdit = new Button((Composite)this, 8);
        Message msgFile2 = UiPlugin.getUIMessages(t, "KEY_NewObject");
        this.buttonEdit.setText(msgFile2.getMessage(t, "UI.GENERAL.EDIT"));
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.horizontalSpan = 1;
        this.buttonEdit.setLayoutData((Object)gridData);
        this.buttonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                URLAttributeControl.this.editURL(tr);
            }
        });
    }

    private void valueChanged(Trace t) {
        if (!this.modifyListeners.isEmpty()) {
            AttributeModifiedEvent attrModifiedEvent = new AttributeModifiedEvent((Object)this, this.getValue(t));
            Enumeration keys = this.modifyListeners.keys();
            while (keys.hasMoreElements()) {
                IAttributeModifiedListener listener = (IAttributeModifiedListener)keys.nextElement();
                attrModifiedEvent.setUserType((Integer)this.modifyListeners.get(listener));
                listener.attrModified(attrModifiedEvent);
            }
        }
    }

    @Override
    public String toString() {
        String value = "";
        if (this.text != null) {
            value = this.text.getText();
        }
        return value;
    }

    @Override
    public Object getValue(Trace t) {
        URL url = null;
        String name = this.toString();
        if (name.length() > 0) {
            try {
                url = new URL(name);
            }
            catch (MalformedURLException malformedURLException) {
                t.FFST(67, "URLAttributeControl.getValue", 0, 50024, 0, 0, name, null, null);
            }
        }
        URL value = url;
        return value;
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
        this.buttonEdit.setEnabled(b);
    }

    @Override
    public boolean setValue(Trace t, Object value) {
        boolean accepted = true;
        this.text.setText(value.toString());
        return accepted;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isChanged(Trace t) {
        URL url2;
        URL url1;
        boolean changed = false;
        Object currentValue = this.getValue(t);
        changed = currentValue == null ? this.originalValue != null : (this.originalValue == null ? true : !(url1 = (URL)currentValue).sameFile(url2 = (URL)this.originalValue));
        return changed;
    }

    @Override
    public void valueApplied(Trace t) {
        this.originalValue = this.getValue(t);
    }

    public Point computeSize(int wHint, int hHint) {
        Trace t = Trace.getDefault();
        return this.computeSize(t, wHint, hHint);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Trace t = Trace.getDefault();
        return this.computeSize(t, wHint, hHint);
    }

    private Point computeSize(Trace t, int wHint, int hHint) {
        Point size = null;
        size = super.computeSize(wHint, hHint, true);
        if (wHint == -1 && size.x > 500) {
            if (Trace.isTracing) {
                t.data(67, "URLAttributeControl.computeSize", 300, "constraining size to 500");
            }
            size.x = 500;
        }
        return size;
    }

    @Override
    public void setAdditionalValidCharacters(Trace t, String addValidChars) {
    }

    private void editURL(Trace t) {
        EditURLDialog editURLDialog = new EditURLDialog(t, this.getShell(), 0);
        if (editURLDialog.open(t, this.text.getText(), this.attrType)) {
            this.text.setText(editURLDialog.getCurrentValue(t));
        }
    }

    @Override
    public void addMandatoryDecoration(Trace t) {
        this.createControlDecoration(t, (Control)this.text);
    }
}

