/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeStringArray;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.properties.AttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.AttributeModifiedEvent;
import com.ibm.mq.explorer.ui.internal.properties.EditStringArrayDialog;
import com.ibm.mq.explorer.ui.internal.properties.IAttributeModifiedListener;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;

public class StringArrayAttributeControl
extends AttributeControl {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/StringArrayAttributeControl.java";
    private static final int MIN_LINES = 2;
    private static final int MAX_LINES = 8;
    private Text textCtrl = null;
    private GridData textGridData = null;
    private Button buttonEdit = null;
    private boolean enabled = true;
    private Composite parentComposite = null;
    private ArrayList<String> currentValueArray = null;
    private String currentValueString = null;
    private String originalValueString = null;
    private AttrTypeStringArray attrType = null;

    public StringArrayAttributeControl(Trace t, Composite parent, int style, AttrTypeStringArray attType, String valueString, ArrayList valueArray, Font fontFixedSpace) {
        super(t, parent, style, (AttrType)attType, valueArray);
        this.parentComposite = parent;
        this.attrType = attType;
        this.currentValueArray = new ArrayList(valueArray);
        this.currentValueString = new String(valueString);
        this.originalValueString = valueString;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        int flags = 2818;
        this.textCtrl = new Text((Composite)this, flags);
        this.textCtrl.setText(valueString);
        UiUtils.makeTextControlReadOnly(t, this.textCtrl, true);
        Menu blankMenu = new Menu((Control)this.textCtrl);
        this.textCtrl.setMenu(blankMenu);
        this.textCtrl.setFont(fontFixedSpace);
        this.textGridData = new GridData(768);
        this.textGridData.grabExcessHorizontalSpace = true;
        int linesToShow = this.currentValueArray.size();
        if (linesToShow < 2) {
            linesToShow = 2;
        }
        if (linesToShow > 8) {
            linesToShow = 8;
        }
        this.textGridData.heightHint = this.textCtrl.getLineHeight() * linesToShow;
        this.textCtrl.setLayoutData((Object)this.textGridData);
        this.buttonEdit = new Button((Composite)this, 8);
        Message messageFile = UiPlugin.getUIMessages(t, "KEY_General");
        this.buttonEdit.setText(messageFile.getMessage(t, "UI.GENERAL.EDIT"));
        GridData gridData = new GridData();
        this.buttonEdit.setLayoutData((Object)gridData);
        this.buttonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                EditStringArrayDialog editDlg = new EditStringArrayDialog(StringArrayAttributeControl.this.parentComposite.getShell(), StringArrayAttributeControl.this.currentValueArray, StringArrayAttributeControl.this.attrType);
                if (editDlg.open() == 0) {
                    StringArrayAttributeControl.this.currentValueArray = editDlg.getStringArrayValues();
                    StringArrayAttributeControl.this.setValue(tr, StringArrayAttributeControl.this.currentValueArray);
                    if (StringArrayAttributeControl.this.isChanged(tr)) {
                        StringArrayAttributeControl.this.valueChanged(tr);
                    }
                }
            }
        });
        this.layout();
    }

    @Override
    public String toString() {
        return this.currentValueString;
    }

    @Override
    public Object getValue(Trace t) {
        ArrayList<String> value = this.currentValueArray;
        return value;
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
        this.buttonEdit.setEnabled(b);
    }

    @Override
    public boolean setValue(Trace t, Object value) {
        boolean accepted = false;
        if (value instanceof String) {
            this.currentValueString = (String)value;
            this.textCtrl.setText(this.currentValueString);
            this.currentValueArray.clear();
            this.currentValueArray.add(this.currentValueString);
            accepted = true;
        } else if (value instanceof ArrayList) {
            this.currentValueArray = (ArrayList)value;
            this.currentValueString = StringArrayAttributeControl.arrayToString(t, this.currentValueArray);
            this.textCtrl.setText(this.currentValueString);
            accepted = true;
        }
        return accepted;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isChanged(Trace t) {
        boolean result = false;
        result = this.currentValueString.compareTo(this.originalValueString) != 0;
        return result;
    }

    @Override
    public void valueApplied(Trace t) {
        this.originalValueString = this.currentValueString;
    }

    private static String arrayToString(Trace t, ArrayList<String> arrayList) {
        String string = "";
        int i = 0;
        while (i < arrayList.size()) {
            if (string.length() > 0) {
                string = String.valueOf(string) + "\n";
            }
            string = String.valueOf(string) + arrayList.get(i);
            ++i;
        }
        return string;
    }

    private void valueChanged(Trace t) {
        if (!this.modifyListeners.isEmpty()) {
            AttributeModifiedEvent attrModifiedEvent = new AttributeModifiedEvent((Object)this, this.getValue(t));
            Enumeration keys = this.modifyListeners.keys();
            while (keys.hasMoreElements()) {
                IAttributeModifiedListener listener = (IAttributeModifiedListener)keys.nextElement();
                attrModifiedEvent.setUserType((Integer)this.modifyListeners.get(listener));
                listener.attrModified(attrModifiedEvent);
            }
        }
    }

    public int getItemCount(Trace t) {
        return this.currentValueArray.size();
    }

    @Override
    public void setAdditionalValidCharacters(Trace t, String addValidChars) {
    }
}

