/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.controls.ExtViewerSorter;
import com.ibm.mq.explorer.ui.internal.objects.RepeatingValueObject;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.TableColumn;

public class RepeatingValuesTableCompareColumnItems
extends ExtViewerSorter
implements Comparator {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/RepeatingValuesTableCompareColumnItems.java";
    private boolean isSortAscending = true;
    private int columnNo = 0;
    private boolean isPrevSortAscending = true;
    private int prevColumnNo = 0;
    private ArrayList tableColumns = null;

    public RepeatingValuesTableCompareColumnItems(ArrayList columns) {
        this.tableColumns = columns;
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        int result = this.compare(o1, o2);
        return result;
    }

    private int compareString(Trace t, Collator coll, String value1, String value2) {
        int result = 0;
        result = this.isSortAscending ? coll.compare(value1, value2) : coll.compare(value2, value1);
        return result;
    }

    private int compareInt(Trace t, int value1, int value2) {
        int result = 0;
        result = this.isSortAscending ? value1 - value2 : value2 - value1;
        return result;
    }

    @Override
    public void setSortDirection(Trace t, boolean sortAscending) {
        this.isSortAscending = sortAscending;
    }

    @Override
    public void setSortColumnIndex(Trace t, int index) {
        if (index != this.columnNo) {
            this.prevColumnNo = this.columnNo;
        }
        this.columnNo = index;
    }

    public int compare(Object o1, Object o2) {
        Trace t = Trace.getDefault();
        int result = 0;
        Collator coll = Collator.getInstance(Locale.getDefault());
        TableColumn column = (TableColumn)this.tableColumns.get(this.columnNo);
        int attrId = (Integer)column.getData();
        RepeatingValueObject rvObject1 = null;
        RepeatingValueObject rvObject2 = null;
        if (o1 instanceof MQExtObject) {
            rvObject1 = (RepeatingValueObject)((MQExtObject)o1).getInternalObject();
        } else if (o1 instanceof RepeatingValueObject) {
            rvObject1 = (RepeatingValueObject)o1;
        }
        if (o2 instanceof MQExtObject) {
            rvObject2 = (RepeatingValueObject)((MQExtObject)o2).getInternalObject();
        } else if (o2 instanceof RepeatingValueObject) {
            rvObject2 = (RepeatingValueObject)o2;
        }
        if (rvObject1 == null && rvObject2 == null) {
            result = 0;
        } else if (rvObject1 == null) {
            result = this.isSortAscending ? -1 : 1;
        } else if (rvObject2 == null) {
            result = this.isSortAscending ? 1 : -1;
        } else {
            Object value1 = rvObject1.getAttributeValue(t, attrId);
            Object value2 = rvObject2.getAttributeValue(t, attrId);
            if (value1 == null && value2 == null) {
                result = 0;
            } else if (value1 == null) {
                result = this.isSortAscending ? -1 : 1;
            } else if (value2 == null) {
                result = this.isSortAscending ? 1 : -1;
            } else {
                if (value1 instanceof String && value2 instanceof String) {
                    result = this.compareString(t, coll, (String)value1, (String)value2);
                } else if (value1 instanceof Integer && value2 instanceof Integer) {
                    result = this.compareInt(t, (Integer)value1, (Integer)value2);
                }
                if (result == 0 && this.prevColumnNo != this.columnNo) {
                    column = (TableColumn)this.tableColumns.get(this.prevColumnNo);
                    attrId = (Integer)column.getData();
                    value1 = rvObject1.getAttributeValue(t, attrId);
                    value2 = rvObject2.getAttributeValue(t, attrId);
                    if (value1 != null && value2 != null) {
                        if (value1 instanceof String && value2 instanceof String) {
                            result = this.isPrevSortAscending ? this.compareString(t, coll, (String)value1, (String)value2) : this.compareString(t, coll, (String)value2, (String)value1);
                        } else if (value1 instanceof Integer && value2 instanceof Integer) {
                            result = this.isPrevSortAscending ? this.compareInt(t, (Integer)value1, (Integer)value2) : this.compareInt(t, (Integer)value2, (Integer)value1);
                        }
                    }
                }
            }
        }
        return result;
    }

    @Override
    public void setSortDirections(Trace t, boolean primarySortAscending, boolean secondarySortAscending) {
        this.isSortAscending = primarySortAscending;
        this.isPrevSortAscending = secondarySortAscending;
    }

    @Override
    public void setSortColumnIndices(Trace t, int primaryIndex, int secondaryIndex) {
        this.columnNo = primaryIndex;
        this.prevColumnNo = secondaryIndex;
    }
}

