/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtTableColumnManager;
import com.ibm.mq.explorer.ui.internal.controls.ExtTableViewer;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTable;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableContentChangedListener;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.RepeatingValueObject;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.RepeatingValueObjectEditDialog;
import com.ibm.mq.explorer.ui.internal.properties.RepeatingValuesCustomPropertyItemProvider;
import com.ibm.mq.explorer.ui.internal.properties.RepeatingValuesTableCompareColumnItems;
import com.ibm.mq.explorer.ui.internal.properties.RepeatingValuesTableContentProvider;
import com.ibm.mq.explorer.ui.internal.properties.RepeatingValuesTableLabelProvider;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class RepeatingValuesCustomPropertyItem
extends CustomPropertyItem
implements DisposeListener,
IPropertyChangeListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/RepeatingValuesCustomPropertyItem.java";
    private static final int MAX_BUTTONS = 6;
    private static final int MAX_ADDITIONAL_BUTTONS = 3;
    private boolean readonly = false;
    private RepeatingValuesCustomPropertyItemProvider itemProvider = null;
    private ExtTableViewer tableViewer = null;
    private RepeatingValuesTableContentProvider contentProvider = null;
    private RepeatingValuesTableLabelProvider labelProvider = null;
    private RepeatingValuesTableCompareColumnItems compareItems = null;
    private ExtTableColumnManager columnManager = null;
    private Button checkbox = null;
    private Composite compActions = null;
    private Button buttonAdd = null;
    private Button buttonEdit = null;
    private Button buttonRemove = null;
    private GridData gridDataAdd = null;
    private GridData gridDataEdit = null;
    private GridData gridDataRemove = null;
    private int[] additionalButtonIds = null;
    private Button[] additionalButtons = null;
    private GridData[] gridDataAdditionalButtons = null;
    private int numAdditionalButtons = 0;
    private ArrayList<TableColumn> tableColumns = new ArrayList();
    private TableColumn lastSortTableColumn = null;
    private int numColumns = 0;
    private ArrayList<RepeatingValueObject> objectArray = null;
    private int[] sortedAttrIds = null;
    private RepeatingValueObject selectedRVObject = null;
    private Message msgFile = null;
    private Composite parent = null;
    private ArrayList<ExplorerTableContentChangedListener> contentChangedListenerList = null;

    public RepeatingValuesCustomPropertyItem(Trace t, Composite parent, int style, UiMQObject uiMQObject, Attr att, boolean ro, RepeatingValuesCustomPropertyItemProvider provider) {
        super(t, parent, style, uiMQObject, att, ro);
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Properties");
        this.itemProvider = provider;
        this.readonly = ro;
        this.contentChangedListenerList = new ArrayList();
        this.parent = parent;
        parent.addDisposeListener((DisposeListener)this);
        UiPlugin.getPrefStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    public void init(Trace t) {
        String checkboxText;
        Group group = new Group(this.parent, 0);
        String groupText = this.itemProvider.getGroupBoxText(t);
        if (groupText != null) {
            group.setText(groupText);
        }
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        group.setLayout((Layout)gridLayout);
        String infoText = this.itemProvider.getInformationAreaText(t);
        if (infoText != null) {
            Text text = new Text((Composite)group, 0);
            text.setText(infoText);
            UiUtils.makeTextControlReadOnly(t, text, true);
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            gridData.grabExcessHorizontalSpace = true;
            text.setLayoutData((Object)gridData);
        }
        if ((checkboxText = this.itemProvider.getCheckboxText(t)) != null) {
            this.checkbox = new Button((Composite)group, 32);
            this.checkbox.setText(checkboxText);
            this.checkbox.setSelection(this.itemProvider.enableCheckbox(t));
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            gridData.grabExcessHorizontalSpace = true;
            this.checkbox.setLayoutData((Object)gridData);
            this.checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace tr = Trace.getDefault();
                    Button checkbx = (Button)event.widget;
                    RepeatingValuesCustomPropertyItem.this.checkboxSelected(tr, checkbx.getSelection());
                }
            });
        }
        this.tableViewer = new ExtTableViewer((Composite)group, 67588);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        gridData = new GridData(768);
        gridData.heightHint = this.tableViewer.getTable().getItemHeight() * 4;
        this.tableViewer.getTable().setLayoutData((Object)gridData);
        Table table = this.tableViewer.getTable();
        this.sortedAttrIds = this.getSortedAttributeIds(t);
        this.numColumns = this.sortedAttrIds.length;
        int i = 0;
        while (i < this.numColumns) {
            TableColumn column = new TableColumn(table, 16384);
            column.setText(this.itemProvider.getAttributeName(t, this.sortedAttrIds[i]));
            column.setWidth(100);
            column.setData((Object)this.sortedAttrIds[i]);
            this.tableColumns.add(column);
            ++i;
        }
        this.objectArray = this.itemProvider.getRepeatingValueObjects(t);
        this.contentProvider = new RepeatingValuesTableContentProvider(this.itemProvider, this.tableColumns, this.objectArray);
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new RepeatingValuesTableLabelProvider(t, this.itemProvider);
        this.labelProvider.setTable(table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.compareItems = new RepeatingValuesTableCompareColumnItems(this.tableColumns);
        this.contentProvider.setComparator(this.compareItems);
        this.columnManager = new ExtTableColumnManager(t, this.tableViewer, this.labelProvider, true);
        this.columnManager.setViewerSorter(t, this.compareItems, !this.itemProvider.isSortVisibleList(t));
        this.columnManager.addColumnSortListeners(t);
        this.columnManager.sortOnColumn(t, 0);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Trace tr = Trace.getDefault();
                RepeatingValuesCustomPropertyItem.this.tableSelectionChanged(tr);
            }
        });
        this.tableViewer.setInput(this.objectArray);
        if (!this.readonly && !this.itemProvider.hideEditingButtons(t)) {
            this.addEditingButtons(t, group);
        }
        this.refreshTable(t);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.tableViewer.addSelectionChangedListener(listener);
    }

    public void setSelection(Trace t, RepeatingValueObject rvo) {
        MQExtObject selectMe = null;
        TableItem[] tItems = this.tableViewer.getTable().getItems();
        int k = 0;
        while (k < tItems.length) {
            MQExtObject ob;
            Object rv;
            Object data = tItems[k].getData();
            if (data instanceof MQExtObject && (rv = (ob = (MQExtObject)data).getInternalObject()) instanceof RepeatingValueObject && rv.equals(rvo)) {
                selectMe = ob;
                break;
            }
            ++k;
        }
        if (selectMe != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection(selectMe), true);
        }
    }

    public void addContentsChangedListener(ExplorerTableContentChangedListener listener) {
        if (listener != null) {
            this.contentChangedListenerList.add(listener);
        }
    }

    public ArrayList getRepeatingValueObjects() {
        return this.objectArray;
    }

    private void addEditingButtons(Trace t, Group group) {
        this.compActions = new Composite((Composite)group, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        this.compActions.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.compActions.setLayoutData((Object)gridData);
        int buttonsAdded = 0;
        this.buttonAdd = new Button(this.compActions, 8);
        String addText = this.itemProvider.getAddText(t);
        if (addText == null || addText.length() == 0) {
            addText = this.msgFile.getMessage(t, "UI.PROP.Dialog.Add");
        }
        this.buttonAdd.setText(addText);
        this.gridDataAdd = new GridData();
        this.buttonAdd.setLayoutData((Object)this.gridDataAdd);
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                RepeatingValuesCustomPropertyItem.this.addSelected(tr);
            }
        });
        ++buttonsAdded;
        this.buttonEdit = new Button(this.compActions, 8);
        String editText = this.itemProvider.getEditText(t);
        if (editText == null || editText.length() == 0) {
            editText = this.msgFile.getMessage(t, "UI.PROP.Dialog.Edit");
        }
        this.buttonEdit.setText(editText);
        this.buttonEdit.setEnabled(false);
        this.gridDataEdit = new GridData();
        this.buttonEdit.setLayoutData((Object)this.gridDataEdit);
        this.buttonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                RepeatingValuesCustomPropertyItem.this.editSelected(tr);
            }
        });
        ++buttonsAdded;
        this.buttonRemove = new Button(this.compActions, 8);
        String removeText = this.itemProvider.getRemoveText(t);
        if (removeText == null || removeText.length() == 0) {
            removeText = this.msgFile.getMessage(t, "UI.PROP.Dialog.Remove");
        }
        this.buttonRemove.setText(removeText);
        this.buttonRemove.setEnabled(false);
        this.gridDataRemove = new GridData();
        this.buttonRemove.setLayoutData((Object)this.gridDataRemove);
        this.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                RepeatingValuesCustomPropertyItem.this.removeSelected(tr);
            }
        });
        ++buttonsAdded;
        this.additionalButtonIds = this.itemProvider.getAdditionalButtonIds(t);
        if (this.additionalButtonIds != null) {
            this.numAdditionalButtons = this.additionalButtonIds.length;
            if (this.numAdditionalButtons > 3) {
                this.numAdditionalButtons = 3;
            }
            this.additionalButtons = new Button[this.numAdditionalButtons];
            this.gridDataAdditionalButtons = new GridData[this.numAdditionalButtons];
            int i = 0;
            while (i < this.numAdditionalButtons) {
                this.additionalButtons[i] = new Button(this.compActions, 8);
                this.additionalButtons[i].setText(this.itemProvider.getAdditionalButtonText(t, this.additionalButtonIds[i]));
                this.additionalButtons[i].setEnabled(false);
                this.gridDataAdditionalButtons[i] = new GridData();
                this.additionalButtons[i].setLayoutData((Object)this.gridDataAdditionalButtons[i]);
                this.additionalButtons[i].setData((Object)this.additionalButtonIds[i]);
                this.additionalButtons[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        Trace tr = Trace.getDefault();
                        Object data = event.widget.getData();
                        if (data instanceof Integer) {
                            RepeatingValuesCustomPropertyItem.this.additionalButtonSelected(tr, (Integer)data);
                        }
                    }
                });
                ++buttonsAdded;
                ++i;
            }
        }
        Label label = new Label(this.compActions, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 6 - buttonsAdded;
        label.setLayoutData((Object)gridData);
        int maxWidth = 0;
        Point sizeAdd = this.buttonAdd.computeSize(-1, -1);
        Point sizeEdit = this.buttonEdit.computeSize(-1, -1);
        Point sizeRemove = this.buttonRemove.computeSize(-1, -1);
        Point[] sizeAdditionalButtons = new Point[this.numAdditionalButtons];
        int i = 0;
        while (i < this.numAdditionalButtons) {
            sizeAdditionalButtons[i] = this.additionalButtons[i].computeSize(-1, -1);
            ++i;
        }
        if (sizeAdd.x > maxWidth) {
            maxWidth = sizeAdd.x;
        }
        if (sizeEdit.x > maxWidth) {
            maxWidth = sizeEdit.x;
        }
        if (sizeRemove.x > maxWidth) {
            maxWidth = sizeRemove.x;
        }
        i = 0;
        while (i < this.numAdditionalButtons) {
            if (sizeAdditionalButtons[i].x > maxWidth) {
                maxWidth = sizeAdditionalButtons[i].x;
            }
            ++i;
        }
        this.gridDataAdd.widthHint = maxWidth;
        this.gridDataEdit.widthHint = maxWidth;
        this.gridDataRemove.widthHint = maxWidth;
        i = 0;
        while (i < this.numAdditionalButtons) {
            this.gridDataAdditionalButtons[i].widthHint = maxWidth;
            ++i;
        }
    }

    @Override
    public void restoreDefaults(Trace t) {
    }

    @Override
    public boolean apply(Trace t, Object job) {
        boolean changed = false;
        DmObject dmObject = (DmObject)this.itemProvider.getDmObject();
        int i = 0;
        while (i < this.objectArray.size()) {
            RepeatingValueObject rvObject = this.objectArray.get(i);
            int disposition = rvObject.getDisposition();
            switch (disposition) {
                case 1: {
                    Attr createdAttr;
                    int actualAttrId;
                    Attr attr;
                    int repeatIndex = rvObject.getRepeatingIndex();
                    int j = 0;
                    while (j < this.sortedAttrIds.length) {
                        attr = rvObject.getAttribute(t, this.sortedAttrIds[j]);
                        if (attr != null && attr.isReadWrite(t)) {
                            actualAttrId = attr.getAttributeID();
                            Object value = rvObject.getAttributeValue(t, this.sortedAttrIds[j]);
                            if (value != null) {
                                createdAttr = dmObject.createAttribute(t, job, actualAttrId, repeatIndex, value);
                                if (Trace.isTracing) {
                                    t.data(67, "RepeatingValuesCustomPropertyItem.apply", 500, "createAttribute: repeatIndex=" + repeatIndex + " attrId=" + actualAttrId + " value=" + rvObject.getAttributeValue(t, this.sortedAttrIds[j]));
                                }
                                if (createdAttr != null && j == 0) {
                                    repeatIndex = createdAttr.getRepeatingIndex();
                                }
                            }
                        }
                        ++j;
                    }
                    rvObject.setDisposition(0);
                    changed = true;
                    break;
                }
                case 3: {
                    Attr createdAttr;
                    int actualAttrId;
                    Attr attr;
                    int j = 0;
                    while (j < this.sortedAttrIds.length) {
                        attr = rvObject.getAttribute(t, this.sortedAttrIds[j]);
                        if (attr != null && attr.isReadWrite(t)) {
                            actualAttrId = attr.getAttributeID();
                            Object value = rvObject.getAttributeValue(t, this.sortedAttrIds[j]);
                            if (value != null) {
                                if (this.itemProvider.isAttributeOptional(t, this.sortedAttrIds[j])) {
                                    if (this.itemProvider.isAttributeOriginallyPresent(t, this.sortedAttrIds[j], rvObject)) {
                                        dmObject.setAttributeValue(t, job, actualAttrId, rvObject.getRepeatingIndex(), value);
                                        if (Trace.isTracing) {
                                            t.data(67, "RepeatingValuesCustomPropertyItem.apply", 500, "setAttributeValue: repeatIndex=" + rvObject.getRepeatingIndex() + " attrId=" + actualAttrId + " value=" + rvObject.getAttributeValue(t, this.sortedAttrIds[j]));
                                        }
                                    } else {
                                        createdAttr = dmObject.createAttribute(t, job, actualAttrId, rvObject.getRepeatingIndex(), value);
                                        if (Trace.isTracing) {
                                            t.data(67, "RepeatingValuesCustomPropertyItem.apply", 500, "createAttribute: repeatIndex=" + rvObject.getRepeatingIndex() + " attrId=" + actualAttrId + " value=" + rvObject.getAttributeValue(t, this.sortedAttrIds[j]));
                                        }
                                    }
                                } else {
                                    dmObject.setAttributeValue(t, job, actualAttrId, rvObject.getRepeatingIndex(), value);
                                    if (Trace.isTracing) {
                                        t.data(67, "RepeatingValuesCustomPropertyItem.apply", 500, "setAttributeValue: repeatIndex=" + rvObject.getRepeatingIndex() + " attrId=" + actualAttrId + " value=" + rvObject.getAttributeValue(t, this.sortedAttrIds[j]));
                                    }
                                }
                            } else if (this.itemProvider.isAttributeOriginallyPresent(t, this.sortedAttrIds[j], rvObject)) {
                                dmObject.deleteAttribute(t, job, actualAttrId, rvObject.getRepeatingIndex());
                                if (Trace.isTracing) {
                                    t.data(67, "RepeatingValuesCustomPropertyItem.apply", 500, "deleteAttribute: repeatIndex=" + rvObject.getRepeatingIndex() + " attrId=" + actualAttrId + " value=" + rvObject.getAttributeValue(t, this.sortedAttrIds[j]));
                                }
                            }
                        }
                        ++j;
                    }
                    rvObject.setDisposition(0);
                    changed = true;
                    break;
                }
                case 2: {
                    int actualAttrId;
                    Attr attr;
                    int j = 0;
                    while (j < this.sortedAttrIds.length) {
                        attr = rvObject.getAttribute(t, this.sortedAttrIds[j]);
                        if (attr != null) {
                            actualAttrId = attr.getAttributeID();
                            boolean deleteAttr = true;
                            if (this.itemProvider.isAttributeOptional(t, this.sortedAttrIds[j])) {
                                deleteAttr = this.itemProvider.isAttributeOriginallyPresent(t, this.sortedAttrIds[j], rvObject);
                            }
                            if (deleteAttr) {
                                dmObject.deleteAttribute(t, job, actualAttrId, rvObject.getRepeatingIndex());
                                if (Trace.isTracing) {
                                    t.data(67, "RepeatingValuesCustomPropertyItem.apply", 500, "deleteAttribute: repeatIndex=" + rvObject.getRepeatingIndex() + " attrId=" + actualAttrId + " value=" + rvObject.getAttributeValue(t, this.sortedAttrIds[j]));
                                }
                            }
                        }
                        ++j;
                    }
                    rvObject.setDisposition(5);
                    changed = true;
                }
            }
            ++i;
        }
        return changed;
    }

    private void refreshTable(Trace t) {
        this.tableViewer.refresh();
        this.tableViewer.getControl().redraw();
        Table table = this.tableViewer.getTable();
        int i = 0;
        while (i < table.getColumnCount()) {
            TableColumn column = table.getColumn(i);
            if (!column.equals(this.lastSortTableColumn)) {
                column.pack();
            }
            ++i;
        }
        ExplorerTable.paintGreyCells(t, this.tableViewer.getTable(), this.labelProvider);
        this.tableSelectionChanged(t);
    }

    private void sendChangedEvent() {
        for (ExplorerTableContentChangedListener o : this.contentChangedListenerList) {
            if (!(o instanceof ExplorerTableContentChangedListener)) continue;
            ExplorerTableContentChangedListener listener = o;
            listener.contentChanged(null);
        }
    }

    private void addSelected(Trace t) {
        RepeatingValueObject rvObject = this.itemProvider.createRepeatingValueObject(t);
        if (this.itemProvider.isCustomEditDialog(t)) {
            if (this.itemProvider.editObject(t, this.parent.getShell(), true, rvObject)) {
                this.objectArray.add(rvObject);
                this.refreshTable(t);
                this.sendChangedEvent();
            }
        } else {
            RepeatingValueObjectEditDialog editDlg = new RepeatingValueObjectEditDialog(this.parent.getShell(), 0);
            if (editDlg.open(t, true, this.sortedAttrIds, rvObject, this.itemProvider)) {
                this.objectArray.add(rvObject);
                this.refreshTable(t);
                this.sendChangedEvent();
            }
        }
    }

    private void editSelected(Trace t) {
        RepeatingValueObject rvObject = this.selectedRVObject;
        if (this.itemProvider.isCustomEditDialog(t)) {
            if (this.itemProvider.editObject(t, this.parent.getShell(), false, rvObject)) {
                int disposition = rvObject.getDisposition();
                if (disposition == 0) {
                    rvObject.setDisposition(3);
                }
                this.refreshTable(t);
                this.sendChangedEvent();
            }
        } else {
            RepeatingValueObjectEditDialog editDlg = new RepeatingValueObjectEditDialog(this.parent.getShell(), 0);
            if (editDlg.open(t, false, this.sortedAttrIds, rvObject, this.itemProvider)) {
                int disposition = rvObject.getDisposition();
                if (disposition == 0) {
                    rvObject.setDisposition(3);
                }
                this.refreshTable(t);
                this.sendChangedEvent();
            }
        }
    }

    private void removeSelected(Trace t) {
        RepeatingValueObject rvObject = this.selectedRVObject;
        String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4002", (String)this.selectedRVObject.getName(t));
        int rc = MessageBox.showDeleteCancelMessage(t, this.parent.getShell(), msg, 1, "AMQ4002");
        if (rc == 0) {
            rvObject.setDisposition(2);
            this.itemProvider.objectRemoved(t, rvObject);
            this.refreshTable(t);
            this.tableSelectionChanged(t);
            this.sendChangedEvent();
        }
    }

    private int[] getSortedAttributeIds(Trace t) {
        int[] unsortedIds = this.itemProvider.getAttributeIds(t);
        int count = unsortedIds.length;
        int[] unsortedSeqNos = new int[count];
        int[] sortedIds = new int[count];
        int i = 0;
        while (i < count) {
            AttrType attrType = this.itemProvider.getAttributeType(t, unsortedIds[i]);
            unsortedSeqNos[i] = attrType.getDisplayGroupSequence();
            ++i;
        }
        i = 0;
        while (i < count) {
            int lowestSeq = 999999999;
            int lowestIndex = 0;
            int j = 0;
            while (j < count) {
                if (unsortedSeqNos[j] < lowestSeq) {
                    lowestIndex = j;
                    lowestSeq = unsortedSeqNos[j];
                }
                ++j;
            }
            sortedIds[i] = unsortedIds[lowestIndex];
            unsortedSeqNos[lowestIndex] = 999999999;
            ++i;
        }
        return sortedIds;
    }

    private void tableSelectionChanged(Trace t) {
        Object obj;
        this.selectedRVObject = null;
        ISelection selection = this.tableViewer.getSelection();
        if (selection != null && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof MQExtObject) {
            this.selectedRVObject = (RepeatingValueObject)((MQExtObject)obj).getInternalObject();
        }
        if (this.buttonEdit != null) {
            this.buttonEdit.setEnabled(this.itemProvider.enableEditButton(t, this.selectedRVObject));
        }
        if (this.buttonRemove != null) {
            this.buttonRemove.setEnabled(this.itemProvider.enableRemoveButton(t, this.selectedRVObject));
        }
        int i = 0;
        while (i < this.numAdditionalButtons) {
            this.additionalButtons[i].setEnabled(this.itemProvider.enableAdditionalButton(t, this.additionalButtonIds[i], this.selectedRVObject));
            ++i;
        }
    }

    @Override
    public boolean isEnabled(Trace t) {
        return true;
    }

    @Override
    public void setUiDisplayGroup(UiDisplayGroup group) {
        super.setUiDisplayGroup(group);
        this.itemProvider.setUiDisplayGroup(group);
    }

    private void additionalButtonSelected(Trace t, int buttonId) {
        if (this.itemProvider.additionalButtonSelected(t, this.parent.getShell(), buttonId, this.selectedRVObject)) {
            this.refreshTable(t);
        }
    }

    private void checkboxSelected(Trace t, boolean selected) {
        if (this.itemProvider.checkboxSelected(t, selected)) {
            this.refreshTable(t);
        }
    }

    @Override
    public void changesApplied(Trace t) {
        this.itemProvider.removePendingObjects(t);
        this.refresh(t);
    }

    public void refresh(Trace t) {
        this.objectArray = this.itemProvider.getRepeatingValueObjects(t);
        this.tableViewer.setInput(this.objectArray);
        this.refreshTable(t);
    }

    public void widgetDisposed(DisposeEvent e) {
        this.itemProvider.removePendingObjects(Trace.getDefault());
        UiPlugin.getPrefStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        Trace t = Trace.getDefault();
        String strProperty = event.getProperty();
        if (strProperty.compareTo("InvalidCellColorChanged") == 0) {
            ExplorerTable.paintGreyCells(t, this.tableViewer.getTable(), this.labelProvider);
        }
    }
}

