/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrIntArrayEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrStringArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeByteArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIntArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeStringArray;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.RepeatingValueObject;
import com.ibm.mq.explorer.ui.internal.properties.AttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.EnumAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.EnumRangeAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.EnumTextAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.EnumTextRangeAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.IntArrayEnumAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.LongNumericAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.NumericAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.ObjectAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.RangeAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.ReadOnlyAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.RepeatingValuesCustomPropertyItemProvider;
import com.ibm.mq.explorer.ui.internal.properties.StringArrayAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.TextAttributeControl;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RepeatingValueObjectEditDialog
extends Dialog
implements DisposeListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/RepeatingValueObjectEditDialog.java";
    private Shell shellDlg = null;
    private static final int NUM_COLS = 3;
    private boolean isOK = false;
    private Composite compositeOKCancelButtons = null;
    private Button buttonOK = null;
    private Button buttonCancel = null;
    private GridData gridDataOK = null;
    private GridData gridDataCancel = null;
    private Message msgFile = null;
    private RepeatingValueObject rvObject = null;
    private RepeatingValuesCustomPropertyItemProvider itemProvider = null;
    private int[] sortedAttrIds = null;
    private ArrayList<AttributeControl> attrControls = null;
    private Font fontFixedSpace = null;

    public RepeatingValueObjectEditDialog(Shell parent, int style) {
        super(parent, style);
    }

    public boolean open(Trace t, boolean isAdd, int[] attrIds, RepeatingValueObject object, RepeatingValuesCustomPropertyItemProvider provider) {
        this.sortedAttrIds = attrIds;
        this.rvObject = object;
        this.itemProvider = provider;
        this.attrControls = new ArrayList();
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Properties");
        String colon = this.msgFile.getMessage("UI.PROP.Colon.Suffix");
        Shell parent = this.getParent();
        this.shellDlg = new Shell(parent, 67696);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth *= 2;
        gridLayout.marginHeight *= 2;
        this.shellDlg.setLayout((Layout)gridLayout);
        String title = "";
        if (isAdd) {
            title = Message.format((String)this.msgFile.getMessage(t, "UI.PROP.Dialog.AddTitle"), (String)this.itemProvider.getObjectName(t));
            UiPlugin.getHelpSystem().setHelp((Control)this.shellDlg, this.itemProvider.getAddHelpId(t));
        } else {
            title = Message.format((String)this.msgFile.getMessage(t, "UI.PROP.Dialog.EditTitle"), (String)this.itemProvider.getObjectName(t));
            UiPlugin.getHelpSystem().setHelp((Control)this.shellDlg, this.itemProvider.getEditHelpId(t));
        }
        this.shellDlg.setText(title);
        Image image = this.getParent().getImage();
        if (image == null) {
            image = Icons.get(Icons.iconkeyExplorerSmall);
        }
        this.shellDlg.setImage(image);
        Label label = new Label((Composite)this.shellDlg, 0);
        label.setVisible(false);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        int i = 0;
        while (i < this.sortedAttrIds.length) {
            AttrType attrType = this.itemProvider.getAttributeType(t, this.sortedAttrIds[i]);
            Attr attr = this.rvObject.getAttribute(t, this.sortedAttrIds[i]);
            if (attr != null) {
                Font stdFont;
                GridData gridDataLabel = null;
                Label labelName = null;
                Button checkbox = null;
                boolean optional = this.itemProvider.isAttributeOptional(t, this.sortedAttrIds[i]);
                if (optional) {
                    checkbox = new Button((Composite)this.shellDlg, 32);
                    checkbox.setText(String.valueOf(attrType.getDisplayTitle()) + colon);
                    gridDataLabel = new GridData();
                    checkbox.setLayoutData((Object)gridDataLabel);
                    stdFont = checkbox.getFont();
                } else {
                    labelName = new Label((Composite)this.shellDlg, 0);
                    labelName.setText(String.valueOf(attrType.getDisplayTitle()) + colon);
                    gridDataLabel = new GridData();
                    labelName.setLayoutData((Object)gridDataLabel);
                    stdFont = labelName.getFont();
                }
                if (this.fontFixedSpace == null) {
                    Font textFont = JFaceResources.getTextFont();
                    FontData[] textFontData = textFont.getFontData();
                    FontData[] stdFontData = stdFont.getFontData();
                    int height = stdFontData[0].getHeight();
                    if (height < 10) {
                        height = 10;
                    }
                    textFontData[0].setHeight(height);
                    this.fontFixedSpace = new Font((Device)UiPlugin.getDisplay(), textFontData[0]);
                }
                AttributeControl attrControl = null;
                Object value = this.rvObject.getAttributeValue(t, this.sortedAttrIds[i]);
                if (!attr.isReadWrite(t)) {
                    boolean isMultiLine = false;
                    String attrString = attr.toString(t);
                    if (attrType instanceof AttrTypeByteArray || attrType instanceof AttrTypeIntArray || attrType instanceof AttrTypeStringArray) {
                        isMultiLine = true;
                        attrString = attr.toFormattedString(t);
                    }
                    ReadOnlyAttributeControl readOnlyAttrCtrl = new ReadOnlyAttributeControl(t, (Composite)this.shellDlg, 0, attrType, attrString, isMultiLine, this.fontFixedSpace);
                    if (isMultiLine) {
                        gridDataLabel.verticalAlignment = 1;
                    }
                    attrControl = readOnlyAttrCtrl;
                } else {
                    int attribType = attrType.getAttributeType();
                    switch (attribType) {
                        case 3: {
                            attrControl = new EnumAttributeControl(t, (Composite)this.shellDlg, 0, attrType, value);
                            break;
                        }
                        case 11: {
                            attrControl = new EnumRangeAttributeControl(t, (Composite)this.shellDlg, 0, attrType, value);
                            break;
                        }
                        case 6: {
                            attrControl = new TextAttributeControl(t, (Composite)this.shellDlg, 0, attrType, value, true);
                            break;
                        }
                        case 9: {
                            attrControl = new EnumTextAttributeControl(t, (Composite)this.shellDlg, 0, attrType, value);
                            break;
                        }
                        case 13: {
                            attrControl = new EnumTextRangeAttributeControl(t, (Composite)this.shellDlg, 0, attrType, value);
                            break;
                        }
                        case 1: {
                            attrControl = new NumericAttributeControl(t, (Composite)this.shellDlg, 0, attrType, value);
                            break;
                        }
                        case 12: {
                            attrControl = new LongNumericAttributeControl(t, (Composite)this.shellDlg, 0, attrType, value);
                            break;
                        }
                        case 7: {
                            attrControl = new TextAttributeControl(t, (Composite)this.shellDlg, 0, attrType, value, true);
                            break;
                        }
                        case 4: {
                            attrControl = new RangeAttributeControl(t, (Composite)this.shellDlg, 0, attrType, value);
                            break;
                        }
                        case 29: {
                            attrControl = new LongNumericAttributeControl(t, (Composite)this.shellDlg, 0, attrType, value);
                            break;
                        }
                        case 2: {
                            attrControl = new TextAttributeControl(t, (Composite)this.shellDlg, 0, attrType, value, true);
                            break;
                        }
                        case 10: {
                            attrControl = new NumericAttributeControl(t, (Composite)this.shellDlg, 0, attrType, value);
                            break;
                        }
                        case 8: {
                            attrControl = new TextAttributeControl(t, (Composite)this.shellDlg, 0, attrType, value, true);
                            break;
                        }
                        case 18: {
                            AttrIntArrayEnum attrIntArrayEnum = (AttrIntArrayEnum)attr;
                            attrControl = new IntArrayEnumAttributeControl(t, (Composite)this.shellDlg, 0, attrType, attr.toFormattedString(t), (ArrayList)attrIntArrayEnum.getValue(t), this.itemProvider.getUiMQObject(), attr.getAttributeID(), this.fontFixedSpace);
                            gridDataLabel.verticalAlignment = 1;
                            break;
                        }
                        case 15: {
                            AttrStringArray attrStringArray = (AttrStringArray)attr;
                            attrControl = new StringArrayAttributeControl(t, (Composite)this.shellDlg, 0, (AttrTypeStringArray)attrType, attr.toFormattedString(t), (ArrayList)attrStringArray.getValue(t), this.fontFixedSpace);
                            gridDataLabel.verticalAlignment = 1;
                            break;
                        }
                        case 5: {
                            attrControl = new TextAttributeControl(t, (Composite)this.shellDlg, 0, attrType, value, true);
                            break;
                        }
                        case 26: {
                            attrControl = new ObjectAttributeControl(t, (Composite)this.shellDlg, 0, attrType, value, true, this.itemProvider.getUiMQObject(), attr.getAttributeID());
                            break;
                        }
                        default: {
                            if (Trace.isTracing) {
                                t.data(67, "RepeatingValueObjectEditDialog.open", 900, "unable to add controls for AttrType: " + attrType);
                            }
                            t.FFST(67, "RepeatingValueObjectEditDialog.open", 10, 50002, 0, 0, "unable to add controls for AttrType: " + attrType, null, null);
                            attrControl = new ReadOnlyAttributeControl(t, (Composite)this.shellDlg, 0, attrType, value, false, this.fontFixedSpace);
                        }
                    }
                }
                attrControl.setAttr(attr);
                gridData = new GridData(768);
                gridData.grabExcessHorizontalSpace = true;
                gridData.horizontalSpan = 2;
                attrControl.setLayoutData(gridData);
                attrControl.setAssociatedLabel(labelName);
                attrControl.setEnabled(attr.isReadWrite(t));
                this.attrControls.add(attrControl);
                if (optional && checkbox != null) {
                    checkbox.setData((Object)attrControl);
                    checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            Button checkbx = (Button)event.widget;
                            AttributeControl attrCtrl = (AttributeControl)((Object)checkbx.getData());
                            attrCtrl.setEnabled(checkbx.getEnabled());
                        }
                    });
                }
            } else {
                t.FFST(67, "RepeatingValueObjectEditDialog.open", 20, 50006, 0, 0, "Attr is null for attr type " + attrType, null, null);
            }
            ++i;
        }
        label = new Label((Composite)this.shellDlg, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        this.compositeOKCancelButtons = new Composite((Composite)this.shellDlg, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = false;
        this.compositeOKCancelButtons.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        this.compositeOKCancelButtons.setLayoutData((Object)gridData);
        label = new Label(this.compositeOKCancelButtons, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.buttonOK = new Button(this.compositeOKCancelButtons, 8);
        this.buttonOK.setText(this.msgFile.getMessage(t, "UI.GENERAL.OK"));
        this.gridDataOK = new GridData();
        this.gridDataOK.horizontalAlignment = 3;
        this.buttonOK.setLayoutData((Object)this.gridDataOK);
        this.buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                RepeatingValueObjectEditDialog.this.isOK = RepeatingValueObjectEditDialog.this.getNewValues(tr);
                RepeatingValueObjectEditDialog.this.shellDlg.close();
            }
        });
        this.buttonCancel = new Button(this.compositeOKCancelButtons, 8);
        this.buttonCancel.setText(this.msgFile.getMessage(t, "UI.GENERAL.CANCEL"));
        this.gridDataCancel = new GridData();
        this.gridDataCancel.horizontalAlignment = 3;
        this.buttonCancel.setLayoutData((Object)this.gridDataCancel);
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RepeatingValueObjectEditDialog.this.isOK = false;
                RepeatingValueObjectEditDialog.this.shellDlg.close();
            }
        });
        int maxWidth = 0;
        Point sizeOK = this.buttonOK.computeSize(-1, -1);
        Point sizeCancel = this.buttonCancel.computeSize(-1, -1);
        if (sizeOK.x > maxWidth) {
            maxWidth = sizeOK.x;
        }
        if (sizeCancel.x > maxWidth) {
            maxWidth = sizeCancel.x;
        }
        this.gridDataOK.widthHint = maxWidth;
        this.gridDataCancel.widthHint = maxWidth;
        this.shellDlg.setDefaultButton(this.buttonOK);
        this.buttonOK.setFocus();
        this.shellDlg.pack();
        UiUtils.makeShellCenteredOnParent(t, parent, this.shellDlg);
        this.buttonOK.addDisposeListener((DisposeListener)this);
        this.shellDlg.open();
        Display display = parent.getDisplay();
        while (!this.shellDlg.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.isOK;
    }

    private boolean getNewValues(Trace t) {
        boolean result = false;
        int i = 0;
        while (i < this.attrControls.size()) {
            AttributeControl attrCtrl = this.attrControls.get(i);
            if (attrCtrl.isChanged(t)) {
                Attr attr = attrCtrl.getAttr();
                int attrId = attr.getAttributeID();
                this.rvObject.setAttributeValue(t, attrId, attrCtrl.getValue(t));
                result = true;
            }
            ++i;
        }
        return result;
    }

    public void widgetDisposed(DisposeEvent e) {
        this.fontFixedSpace.dispose();
    }
}

