/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.ui.internal.properties.AttributeControl;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;

public class ReadOnlyAttributeControl
extends AttributeControl {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/ReadOnlyAttributeControl.java";
    private Text textCtrl = null;
    private boolean enabled = true;
    private boolean isMultiLine = false;
    private boolean expand = false;
    private static final int EXPAND_LINE_COUNT = 4;

    public ReadOnlyAttributeControl(Trace t, Composite parent, int style, AttrType attrType, Object currentValue, boolean multiLine, Font fontFixedSpace) {
        super(t, parent, style, attrType, currentValue);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        this.isMultiLine = multiLine;
        int flags = 2048;
        if (this.isMultiLine) {
            flags |= 0x302;
        }
        this.textCtrl = new Text((Composite)this, flags);
        this.textCtrl.setText(currentValue.toString());
        UiUtils.makeTextControlReadOnly(t, this.textCtrl, true);
        Menu blankMenu = new Menu((Control)this.textCtrl);
        this.textCtrl.setMenu(blankMenu);
        if (this.isMultiLine) {
            this.textCtrl.setFont(fontFixedSpace);
        }
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        if (this.isMultiLine) {
            gridData.widthHint = 100;
            if (this.textCtrl.getLineCount() > 4) {
                gridData.verticalAlignment = 4;
                gridData.heightHint = 4 * this.textCtrl.getLineHeight();
                this.expand = true;
            }
        }
        this.textCtrl.setLayoutData((Object)gridData);
    }

    public boolean isExpand() {
        return this.expand;
    }

    @Override
    public String toString() {
        String value = "";
        if (this.textCtrl != null) {
            value = this.textCtrl.getText();
        }
        return value;
    }

    @Override
    public Object getValue(Trace t) {
        String value = this.toString();
        return value;
    }

    @Override
    public void setEnabled(boolean b) {
    }

    @Override
    public boolean setValue(Trace t, Object value) {
        boolean accepted = true;
        this.textCtrl.setText(value.toString());
        return accepted;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isMultiLine() {
        return this.isMultiLine;
    }

    @Override
    public boolean isChanged(Trace t) {
        return false;
    }

    @Override
    public void valueApplied(Trace t) {
    }

    @Override
    public void setAdditionalValidCharacters(Trace t, String addValidChars) {
    }
}

