/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeRange;
import com.ibm.mq.explorer.ui.internal.properties.AttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.AttributeModifiedEvent;
import com.ibm.mq.explorer.ui.internal.properties.IAttributeModifiedListener;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.Enumeration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class RangeAttributeControl
extends AttributeControl {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/RangeAttributeControl.java";
    private Spinner spinner = null;
    private AttrTypeRange attrTypeRange = null;
    private boolean enabled = true;
    private Object originalValue = null;

    public RangeAttributeControl(Trace t, Composite parent, int style, AttrType attrType, Object currentValue) {
        super(t, parent, style, attrType, currentValue);
        this.attrTypeRange = (AttrTypeRange)attrType;
        this.originalValue = currentValue;
        int intValue = this.attrTypeRange.getMinimumValue();
        if (currentValue instanceof Integer) {
            intValue = (Integer)currentValue;
        } else if (currentValue instanceof Long) {
            intValue = ((Long)currentValue).intValue();
        } else if (currentValue instanceof String) {
            try {
                intValue = Integer.parseInt((String)currentValue, 0);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        this.spinner = new Spinner((Composite)this, 2048);
        this.spinner.setMaximum(this.attrTypeRange.getMaximumValue());
        this.spinner.setMinimum(this.attrTypeRange.getMinimumValue());
        UiUtils.limitSpinner(t, this.spinner);
        this.spinner.setSelection(intValue);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.spinner.setLayoutData((Object)gridData);
        this.spinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace tr = Trace.getDefault();
                RangeAttributeControl.this.valueChanged(tr);
            }
        });
    }

    private void valueChanged(Trace t) {
        if (!this.modifyListeners.isEmpty()) {
            AttributeModifiedEvent attrModifiedEvent = new AttributeModifiedEvent((Object)this, this.getValue(t));
            Enumeration keys = this.modifyListeners.keys();
            while (keys.hasMoreElements()) {
                IAttributeModifiedListener listener = (IAttributeModifiedListener)keys.nextElement();
                attrModifiedEvent.setUserType((Integer)this.modifyListeners.get(listener));
                listener.attrModified(attrModifiedEvent);
            }
        }
    }

    @Override
    public String toString() {
        String value = "";
        if (this.spinner != null) {
            value = "" + this.spinner.getSelection();
        }
        return value;
    }

    @Override
    public Object getValue(Trace t) {
        Integer value = this.spinner.getSelection();
        return value;
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
        this.spinner.setEnabled(this.enabled);
    }

    @Override
    public boolean setValue(Trace t, Object value) {
        boolean accepted = true;
        int intValue = this.attrTypeRange.getMinimumValue();
        if (value instanceof String) {
            try {
                intValue = Integer.parseInt((String)value, 0);
            }
            catch (NumberFormatException numberFormatException) {
                accepted = false;
            }
        } else if (value instanceof Integer) {
            intValue = (Integer)value;
        } else if (value instanceof Long) {
            intValue = ((Long)value).intValue();
        }
        if (accepted) {
            if (intValue >= this.attrTypeRange.getMinimumValue() && intValue <= this.attrTypeRange.getMaximumValue()) {
                this.spinner.setSelection(intValue);
            } else {
                accepted = false;
            }
        }
        return accepted;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isChanged(Trace t) {
        Object currentValue = this.getValue(t);
        boolean changed = AttributeControl.compareObjectValues(t, currentValue, this.originalValue) != 0;
        return changed;
    }

    @Override
    public void valueApplied(Trace t) {
        this.originalValue = this.getValue(t);
    }

    @Override
    public void setAdditionalValidCharacters(Trace t, String addValidChars) {
    }
}

