/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.DialogClosedEvent;
import com.ibm.mq.explorer.ui.internal.properties.IDialogClosedListener;
import com.ibm.mq.explorer.ui.internal.properties.InvalidCharsAttributeEvent;
import com.ibm.mq.explorer.ui.internal.properties.InvalidCharsEventListener;
import com.ibm.mq.explorer.ui.internal.properties.MandatoryAttributeEvent;
import com.ibm.mq.explorer.ui.internal.properties.MandatoryAttributeEventListener;
import com.ibm.mq.explorer.ui.internal.properties.PropertyControl;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PropertyDlg
extends TrayDialog
implements MandatoryAttributeEventListener,
InvalidCharsEventListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/PropertyDlg.java";
    private UiMQObject uiMQObject = null;
    private PropertyControl propertyControl = null;
    private boolean isOK = false;
    protected Vector<IDialogClosedListener> dialogClosedListeners = null;
    private boolean readonlyMode = false;
    private int displayGroupId;
    private Hashtable<Integer, MandatoryAttributeEvent> missingMandatoryAttrEvents = null;
    private Hashtable<String, InvalidCharsAttributeEvent> invalidCharsAttrEvents = null;

    public PropertyDlg(Trace t, Shell parent, int style) {
        super(parent);
        this.setBlockOnOpen(false);
        this.setShellStyle(style | 0x860 | 0x10 | PropertyDlg.getDefaultOrientation());
        this.dialogClosedListeners = new Vector();
        this.missingMandatoryAttrEvents = new Hashtable();
        this.invalidCharsAttrEvents = new Hashtable();
    }

    public void open(Trace t, UiMQObject uiMQObj, boolean readonly) {
        this.open(t, uiMQObj, -1, readonly);
    }

    public void open(Trace t, UiMQObject uiMQObj, int initialDisplayGroupId, boolean readonly) {
        this.uiMQObject = uiMQObj;
        this.readonlyMode = readonly;
        this.displayGroupId = initialDisplayGroupId;
        this.open();
    }

    public final Control createDialogArea(Composite parent) {
        Trace t = Trace.getDefault();
        Composite composite = (Composite)super.createDialogArea(parent);
        this.propertyControl = new PropertyControl(t, composite, 0, false, this.readonlyMode, true);
        this.propertyControl.addMandatoryAttributeEventListener(t, this);
        this.propertyControl.addInvalidCharsEventListener(t, this);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 7;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.propertyControl.setLayoutData(gridData);
        this.propertyControl.setObject(t, this.uiMQObject, this.displayGroupId);
        return composite;
    }

    protected final void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Trace t = Trace.getDefault();
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_Properties");
        String titleText = Message.format((String)msgFile.getMessage(t, "UI.PROP.Main.PropsFor"), (String)this.uiMQObject.toString());
        newShell.setText(titleText);
        newShell.setImage(this.uiMQObject.getImage());
    }

    public boolean close() {
        boolean ret = super.close();
        if (!this.dialogClosedListeners.isEmpty()) {
            DialogClosedEvent dlgClosedEvent = new DialogClosedEvent(this, this.isOK);
            int size = this.dialogClosedListeners.size();
            int i = 0;
            while (i < size) {
                IDialogClosedListener listener = this.dialogClosedListeners.elementAt(i);
                listener.dialogClosed(dlgClosedEvent);
                ++i;
            }
        }
        return ret;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.readonlyMode) {
            Button button = this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, true);
            button.setFocus();
        } else {
            Button button = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            button.setFocus();
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }

    public void enableOKButton(Trace t, boolean enable) {
        Button buttonOK = this.getButton(0);
        if (buttonOK != null) {
            buttonOK.setEnabled(enable);
        }
    }

    private void updateErrorMessage(Trace t) {
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_NewObject");
        if (!this.invalidCharsAttrEvents.isEmpty()) {
            Enumeration<String> keys = this.invalidCharsAttrEvents.keys();
            String key = keys.nextElement();
            InvalidCharsAttributeEvent event = this.invalidCharsAttrEvents.get(key);
            String msg = Message.format((String)msgFile.getMessage(t, "UI.NewObject.Wizard.InvalidChars"), (String)event.getAttributeName());
            this.propertyControl.showErrorMessage(msg);
        } else if (this.missingMandatoryAttrEvents.isEmpty()) {
            this.propertyControl.clearErrorMessage();
        } else {
            Enumeration<Integer> keys = this.missingMandatoryAttrEvents.keys();
            Integer key = keys.nextElement();
            MandatoryAttributeEvent event = this.missingMandatoryAttrEvents.get(key);
            this.propertyControl.showErrorMessage(Message.format((String)msgFile.getMessage(t, "UI.NewObject.Wizard.ValueRequired"), (String)event.getAttributeName()));
        }
    }

    public void addDialogClosedListener(IDialogClosedListener listener) {
        this.dialogClosedListeners.addElement(listener);
    }

    public void removeDialogClosedListener(IDialogClosedListener listener) {
        this.dialogClosedListeners.removeElement(listener);
    }

    protected void okPressed() {
        this.okSelected(Trace.getDefault());
        if (this.isOK) {
            super.okPressed();
        }
    }

    private void okSelected(Trace t) {
        boolean isChanged = false;
        boolean isCloseDlg = false;
        int returnCode = this.propertyControl.applyAllChanges(t);
        switch (returnCode) {
            case 0: {
                isChanged = true;
                isCloseDlg = true;
                break;
            }
            case 1: {
                isChanged = false;
                isCloseDlg = true;
                break;
            }
            case 2: {
                isChanged = true;
                isCloseDlg = false;
                break;
            }
            case 3: {
                isChanged = false;
                isCloseDlg = false;
            }
        }
        if (isChanged && Trace.isTracing) {
            t.data(67, "PropertyDlg.okSelected", 300, "attribute value(s) changed - refreshing");
        }
        if (isCloseDlg) {
            this.isOK = true;
        }
    }

    @Override
    public void attributeValueMissing(MandatoryAttributeEvent event) {
        Trace t = Trace.getDefault();
        this.addToMissingMandatoryAttrEvents(t, event);
        this.updateErrorMessage(t);
        this.enableOKButton(t, false);
    }

    @Override
    public void attributeValuePresent(MandatoryAttributeEvent event) {
        Trace t = Trace.getDefault();
        this.removeFromMissingMandatoryAttrEvents(t, event);
        this.updateErrorMessage(t);
        this.enableOKButton(t, this.missingMandatoryAttrEvents.size() + this.invalidCharsAttrEvents.size() == 0);
    }

    private void addToMissingMandatoryAttrEvents(Trace t, MandatoryAttributeEvent event) {
        Integer key = event.getAttributeId();
        if (!this.missingMandatoryAttrEvents.containsKey(key)) {
            this.missingMandatoryAttrEvents.put(key, event);
        }
    }

    private void removeFromMissingMandatoryAttrEvents(Trace t, MandatoryAttributeEvent event) {
        Integer key = event.getAttributeId();
        if (this.missingMandatoryAttrEvents.containsKey(key)) {
            this.missingMandatoryAttrEvents.remove(key);
        }
    }

    @Override
    public void invalidCharsAbsent(InvalidCharsAttributeEvent event) {
        Trace t = Trace.getDefault();
        this.removeFromInvalidCharsAttrEvents(t, event);
        this.updateErrorMessage(t);
        this.enableOKButton(t, this.invalidCharsAttrEvents.size() + this.missingMandatoryAttrEvents.size() == 0);
    }

    @Override
    public void invalidCharsPresent(InvalidCharsAttributeEvent event) {
        Trace t = Trace.getDefault();
        this.addToInvalidCharsAttrEvents(t, event);
        this.updateErrorMessage(t);
        this.enableOKButton(t, false);
    }

    private void addToInvalidCharsAttrEvents(Trace t, InvalidCharsAttributeEvent event) {
        String key = event.getAttributeName();
        if (!this.invalidCharsAttrEvents.containsKey(key)) {
            this.invalidCharsAttrEvents.put(key, event);
        }
    }

    private void removeFromInvalidCharsAttrEvents(Trace t, InvalidCharsAttributeEvent event) {
        String key = event.getAttributeName();
        if (this.invalidCharsAttrEvents.containsKey(key)) {
            this.invalidCharsAttrEvents.remove(key);
        }
    }
}

