/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrByteArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrIntArrayEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrStringArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthString;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeLong;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeString;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeStringArray;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DisplayGroup;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.trace.weaving.TraceAspect;
import com.ibm.mq.explorer.ui.extensions.IPropertyTabFactory;
import com.ibm.mq.explorer.ui.extensions.PropertyPage;
import com.ibm.mq.explorer.ui.internal.base.PropertyTabFactoryManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.AttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.AttributeModifiedEvent;
import com.ibm.mq.explorer.ui.internal.properties.BooleanAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.ByteArrayAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.CompareAttrGroupSequenceNumbers;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyPage;
import com.ibm.mq.explorer.ui.internal.properties.EnumAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.EnumRangeAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.EnumTextAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.EnumTextRangeAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.IAttributeModifiedListener;
import com.ibm.mq.explorer.ui.internal.properties.IntArrayEnumAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.InvalidCharsAttributeEvent;
import com.ibm.mq.explorer.ui.internal.properties.InvalidCharsEventListener;
import com.ibm.mq.explorer.ui.internal.properties.LongEnumAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.LongEnumRangeAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.LongNumericAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.MandatoryAttributeEvent;
import com.ibm.mq.explorer.ui.internal.properties.MandatoryAttributeEventListener;
import com.ibm.mq.explorer.ui.internal.properties.NumericAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.ObjectAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.PasswordAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.RangeAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.ReadOnlyAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.StringArrayAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.TextAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.URLAttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.UiAttr;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.dialogs.DialogMessageArea;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class PropertyControl
extends Composite
implements IAttributeModifiedListener,
DmActionListener,
DisposeListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/PropertyControl.java";
    public static final int APPLY_CHANGES_APPLIED_NO_ERRORS = 0;
    public static final int APPLY_NO_CHANGES_REQUIRED = 1;
    public static final int APPLY_CHANGES_APPLIED_WITH_ERRORS = 2;
    public static final int APPLY_NOT_POSSIBLE = 3;
    private static final int ATTR_RW_ALWAYS_READONLY = 0;
    private static final int ATTR_RW_ALWAYS_READWRITE = 1;
    private static final int ATTR_RW_NOW_READONLY = 2;
    private static final int ATTR_RW_NOW_READWRITE = 3;
    public static final Integer LISTENER_TYPE_NOTIFY = 1;
    public static final Integer LISTENER_TYPE_MANDATORY = 2;
    public static final Integer LISTENER_TYPE_VALIDATE = 3;
    private static final int[] weights = new int[]{25, 75};
    private UiMQObject uiMQObject = null;
    private Tree tree = null;
    private Label messageLabel;
    private DialogMessageArea messageArea;
    private Button buttonApply = null;
    private Button buttonRestore = null;
    private GridData gridDataRestore = null;
    private GridData gridDataApply = null;
    private Composite compProperties = null;
    private StackLayout stackLayout = null;
    private ArrayList<AttributeControl> attrControls = null;
    private ArrayList<TreeItem> treeItems = new ArrayList();
    private ArrayList<Composite> pages = new ArrayList();
    private ArrayList<CustomPropertyPage> customPages = new ArrayList();
    private ArrayList<CustomPropertyItem> customItems = new ArrayList();
    private ArrayList<UiAttr> uiAttrs = null;
    private int[] mandatoryAttrIds = null;
    private ArrayList<UiDisplayGroup> uiDisplayGroups = new ArrayList();
    private boolean enableRestore = false;
    private UiDisplayGroup selectedGroup = null;
    private boolean createMode = false;
    private boolean readonlyMode = false;
    private ArrayList<AttributeControl> changedAttrCtrls = null;
    private BusyDialog busyDialog = null;
    private DmActionEvent dmActionEvent = null;
    protected Shell shell = null;
    protected Message msgFile = null;
    private Font fontFixedSpace = null;
    private Vector<MandatoryAttributeEventListener> mandatoryAttrEventListeners = null;
    private Vector<InvalidCharsEventListener> invalidCharsEventListeners = null;
    private PropertyTabFactoryManager propertyTabFactoryManager = null;
    private ArrayList<UiDisplayGroup> propertyExtensions = null;
    private int highestUniqueId = 0;
    private int highestSeqId = 0;
    private AttributeControl initialFocus = null;
    private DisplayGroup initialDisplayGroup = null;

    public PropertyControl(Trace t, Composite parent, int style, boolean create, boolean readonly, boolean showButtons) {
        super(parent, style);
        this.uiAttrs = new ArrayList();
        this.attrControls = new ArrayList();
        this.readonlyMode = readonly;
        this.createMode = create;
        this.mandatoryAttrEventListeners = new Vector();
        this.invalidCharsEventListeners = new Vector();
        this.propertyExtensions = new ArrayList(0);
        this.shell = parent.getShell();
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (PropertyControl.this.fontFixedSpace != null && !PropertyControl.this.fontFixedSpace.isDisposed()) {
                    PropertyControl.this.fontFixedSpace.dispose();
                }
            }
        });
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Properties");
        this.addDisposeListener(this);
        FillLayout fillLayout = new FillLayout();
        this.setLayout((Layout)fillLayout);
        SashForm sashForm = new SashForm((Composite)this, 256);
        Composite compTree = new Composite((Composite)sashForm, 2048);
        fillLayout = new FillLayout();
        compTree.setLayout((Layout)fillLayout);
        Composite compProps = new Composite((Composite)sashForm, 2048);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        compProps.setLayout((Layout)gridLayout);
        sashForm.setWeights(weights);
        this.tree = new Tree(compTree, 4);
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                PropertyControl.this.treeSelectionChanged(t2);
            }
        });
        int margins = 2;
        Composite titleArea = new Composite(compProps, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = margins;
        titleArea.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        layoutData.verticalAlignment = 128;
        titleArea.setLayoutData((Object)layoutData);
        if (this.createMode) {
            this.messageLabel = new Label(titleArea, 0);
            this.messageLabel.setFont(JFaceResources.getBannerFont());
            this.messageLabel.setLayoutData((Object)this.createMessageAreaData());
        } else {
            this.messageArea = new DialogMessageArea();
            this.messageArea.createContents(titleArea);
            this.messageArea.setTitleLayoutData((Object)this.createMessageAreaData());
            this.messageArea.setMessageLayoutData((Object)this.createMessageAreaData());
        }
        Label separator = new Label(compProps, 258);
        separator.setLayoutData((Object)new GridData(768));
        Font font = JFaceResources.getDefaultFont();
        Font textFont = JFaceResources.getTextFont();
        FontData[] textFontData = textFont.getFontData();
        FontData[] stdFontData = font.getFontData();
        int height = stdFontData[0].getHeight();
        if (height < 10) {
            height = 10;
        }
        textFontData[0].setHeight(height);
        this.fontFixedSpace = new Font((Device)this.getDisplay(), textFontData[0]);
        Composite composite = new Composite(compProps, 0);
        fillLayout = new FillLayout();
        composite.setLayout((Layout)fillLayout);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 5;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalSpan = 1;
        composite.setLayoutData((Object)gridData);
        this.compProperties = new Composite(composite, 0);
        this.stackLayout = new StackLayout();
        this.compProperties.setLayout((Layout)this.stackLayout);
        if (showButtons) {
            Composite compButtons = new Composite(compProps, 0);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 5;
            compButtons.setLayout((Layout)gridLayout);
            gridData = new GridData(768);
            gridData.horizontalSpan = 5;
            gridData.verticalSpan = 1;
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = false;
            compButtons.setLayoutData((Object)gridData);
            Label label = new Label(compButtons, 0);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            gridData.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)gridData);
            this.enableRestore = false;
            this.buttonRestore = new Button(compButtons, 8);
            this.buttonRestore.setText(this.msgFile.getMessage(t, "UI.PROP.Main.Restore"));
            this.buttonRestore.setEnabled(this.enableRestore);
            this.buttonRestore.setVisible(false);
            this.gridDataRestore = new GridData();
            this.gridDataRestore.horizontalAlignment = 3;
            this.gridDataRestore.verticalAlignment = 3;
            this.buttonRestore.setLayoutData((Object)this.gridDataRestore);
            this.buttonRestore.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace t2 = Trace.getDefault();
                    PropertyControl.this.restoreDefaults(t2);
                }
            });
            this.buttonApply = new Button(compButtons, 8);
            this.buttonApply.setText(this.msgFile.getMessage(t, "UI.PROP.Main.Apply"));
            this.buttonApply.setEnabled(true);
            this.gridDataApply = new GridData();
            this.gridDataApply.horizontalAlignment = 3;
            this.gridDataApply.verticalAlignment = 3;
            this.buttonApply.setLayoutData((Object)this.gridDataApply);
            this.buttonApply.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace t2 = Trace.getDefault();
                    PropertyControl.this.applySelected(t2);
                }
            });
            int maxWidth = 0;
            Point sizeRestore = this.buttonRestore.computeSize(-1, -1);
            Point sizeApply = this.buttonApply.computeSize(-1, -1);
            if (sizeRestore.x > maxWidth) {
                maxWidth = sizeRestore.x;
            }
            if (sizeApply.x > maxWidth) {
                maxWidth = sizeApply.x;
            }
            this.gridDataRestore.widthHint = maxWidth;
            this.gridDataApply.widthHint = maxWidth;
            if (this.readonlyMode) {
                this.buttonApply.setVisible(false);
                this.buttonRestore.setVisible(false);
            }
        }
    }

    private FormData createMessageAreaData() {
        FormData messageData = new FormData();
        messageData.top = new FormAttachment(0);
        messageData.bottom = new FormAttachment(100);
        messageData.right = new FormAttachment(100);
        messageData.left = new FormAttachment(0);
        return messageData;
    }

    public void setObject(Trace t, UiMQObject uiMQObj, int initDisplayGroupId) {
        this.uiMQObject = uiMQObj;
        this.propertyTabFactoryManager = UiPlugin.getPropertyTabFactoryManager();
        this.treeItems.clear();
        this.pages.clear();
        this.customPages.clear();
        this.customItems.clear();
        this.uiDisplayGroups.clear();
        this.uiAttrs.clear();
        this.attrControls.clear();
        this.tree.removeAll();
        this.initialFocus = null;
        this.initialDisplayGroup = null;
        this.getMandatoryAttributeIds(t);
        this.getAttributes(t);
        this.getGroupList(t);
        this.getPropertyExtensions(t);
        this.sortAttributesByGroup(t);
        this.createTreeNodes(t);
        this.createPropertyPages(t, this.compProperties);
        this.compProperties.layout();
        int initialDisplayGroupId = initDisplayGroupId;
        if (this.initialDisplayGroup != null) {
            initialDisplayGroupId = this.initialDisplayGroup.getId();
        }
        if (this.treeItems.size() > 0) {
            TreeItem[] selTreeItems = new TreeItem[1];
            boolean isSelectedItem = false;
            if (initialDisplayGroupId != -1) {
                int i = 0;
                while (i < this.treeItems.size()) {
                    TreeItem treeItem = this.treeItems.get(i);
                    UiDisplayGroup uiDisplayGroup = (UiDisplayGroup)treeItem.getData();
                    if (uiDisplayGroup.getDisplayGroup().getId() == initialDisplayGroupId) {
                        selTreeItems[0] = treeItem;
                        isSelectedItem = true;
                        break;
                    }
                    ++i;
                }
                if (!isSelectedItem && Trace.isTracing) {
                    t.data(67, "PropertyControl.setObject", 900, "requested initial DisplayGroup id " + initialDisplayGroupId + "not found, defaulting to first");
                }
            }
            if (!isSelectedItem) {
                selTreeItems[0] = this.treeItems.get(0);
            }
            this.tree.setSelection(selTreeItems);
            this.tree.setFocus();
            this.treeSelectionChanged(t);
        }
        if (this.initialFocus != null) {
            Layout layout = this.initialFocus.getParent().getParent().getLayout();
            if (layout instanceof StackLayout) {
                StackLayout stack = (StackLayout)layout;
                if (this.initialFocus.getParent() != stack.topControl) {
                    Control[] children = ((Composite)stack.topControl).getChildren();
                    boolean found = false;
                    int i = 0;
                    while (!found && i < children.length) {
                        if (children[i] instanceof AttributeControl) {
                            this.initialFocus = (AttributeControl)children[i];
                            found = true;
                        }
                        ++i;
                    }
                }
            }
            this.initialFocus.setFocus();
        } else {
            Button button = this.shell.getDefaultButton();
            if (button != null) {
                button.setFocus();
            }
        }
    }

    private void getPropertyExtensions(Trace t) {
        String objectType = this.uiMQObject.getId();
        ArrayList<String> propertyTabNames = this.propertyTabFactoryManager.getPropertyTabNames(t, objectType);
        int i = 0;
        while (i < propertyTabNames.size()) {
            String propertyTabName = propertyTabNames.get(i);
            UiDisplayGroup uiDisplayGroup = new UiDisplayGroup(t, new DisplayGroup(t, this.highestSeqId++, this.highestUniqueId++, propertyTabName), this);
            this.uiDisplayGroups.add(uiDisplayGroup);
            this.propertyExtensions.add(uiDisplayGroup);
            ++i;
        }
    }

    public void showRestoreApply(Trace t, boolean showRestore, boolean showApply) {
        if (this.buttonRestore != null) {
            this.buttonRestore.setVisible(showRestore);
        }
        if (this.buttonApply != null) {
            this.buttonApply.setVisible(showApply);
        }
    }

    public int applyAllChanges(Trace t) {
        int returnCode = 1;
        IDmObject dmObj = this.uiMQObject.getDmObject();
        boolean allowApply = this.uiMQObject.isAllowApplyProperties();
        if (!allowApply) {
            returnCode = 3;
        } else {
            int i = 0;
            while (i < this.uiDisplayGroups.size()) {
                UiDisplayGroup uiDisplayGroup = this.uiDisplayGroups.get(i);
                int iRC = this.applyChangesToGroup(t, uiDisplayGroup, dmObj);
                if (iRC == 2) {
                    returnCode = iRC;
                    break;
                }
                if (iRC == 0) {
                    returnCode = iRC;
                }
                ++i;
            }
        }
        return returnCode;
    }

    private int applyChangesToGroup(Trace t, UiDisplayGroup uiDisplayGroup, IDmObject dmObj) {
        int returnCode = 1;
        boolean isChanged = false;
        boolean changesApplied = false;
        boolean isError = false;
        Object job = dmObj.beginUpdate(t);
        if (this.addChangesInGroupToJob(t, uiDisplayGroup, job)) {
            isChanged = true;
            if (Trace.isTracing) {
                t.data(67, "PropertyControl.applyChangesToGroup", 300, "attribute value(s) changed - calling actionChange");
            }
        }
        if (isChanged) {
            String message = Message.format((String)this.msgFile.getMessage(t, "UI.PROP.Dialog.ApplyingChanges"), (String)uiDisplayGroup.getDisplayGroup().getTitle());
            this.busyDialog = new BusyDialog(this.shell, message);
            int rc = dmObj.actionChange(t, (DmActionListener)this, job, uiDisplayGroup.isForce());
            if (rc == 0) {
                changesApplied = true;
                this.busyDialog.showDialog(t);
                if (this.dmActionEvent != null) {
                    String msg;
                    int mbRC;
                    rc = this.dmActionEvent.getReasonCode();
                    if (!(rc != 4004 && rc != 3210 || uiDisplayGroup.isForce() || (mbRC = MessageBox.showYesNoMessage(t, this.shell, msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4020", (String)uiDisplayGroup.getTreeItem().getText()), 1, "AMQ4020")) != 0)) {
                        uiDisplayGroup.setForce(true);
                        int forceRC = this.applyChangesToGroup(t, uiDisplayGroup, dmObj);
                        return forceRC;
                    }
                    if (rc == 0) {
                        if (Trace.isTracing) {
                            t.data(67, "PropertyControl.applyChangesToGroup", 300, "changes applied - tell attribute controls");
                        }
                        int j = 0;
                        while (j < this.changedAttrCtrls.size()) {
                            AttributeControl attrCtrl = this.changedAttrCtrls.get(j);
                            attrCtrl.valueApplied(Trace.getDefault());
                            ++j;
                        }
                        int i = 0;
                        while (i < this.customPages.size()) {
                            CustomPropertyPage page = this.customPages.get(i);
                            if (page.getUiDisplayGroup() == uiDisplayGroup) {
                                page.changesApplied(t);
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < this.customItems.size()) {
                            CustomPropertyItem item = this.customItems.get(i);
                            if (item.getUiDisplayGroup() == uiDisplayGroup) {
                                item.changesApplied(t);
                            }
                            ++i;
                        }
                    } else {
                        if (Trace.isTracing) {
                            t.data(67, "PropertyControl.applyChangesToGroup", 900, "dmObject apply failed");
                        }
                        msg = Message.format((String)this.msgFile.getMessage(t, "UI.PROP.Dialog.ApplyFailed"), (String)uiDisplayGroup.getDisplayGroup().getTitle());
                        MessageBox.showMessageFailure(Trace.getDefault(), this.getShell(), msg, (Exception)((Object)this.dmActionEvent.getException()), this.dmActionEvent.getException().getMessageID());
                        isError = true;
                    }
                } else {
                    if (Trace.isTracing) {
                        t.data(67, "PropertyControl.applyChangesToGroup", 900, "dmObject apply failed, dmActionEvent is null");
                    }
                    String msg = Message.format((String)this.msgFile.getMessage(t, "UI.PROP.Dialog.ApplyFailed"), (String)uiDisplayGroup.getDisplayGroup().getTitle());
                    MessageBox.showMessageFailure(Trace.getDefault(), this.getShell(), msg, (Exception)((Object)this.dmActionEvent.getException()), null);
                    isError = true;
                }
            } else {
                isError = true;
                this.busyDialog.closeDialog(t);
            }
            if (isError) {
                TreeItem[] treeItemsArray = new TreeItem[]{uiDisplayGroup.getTreeItem()};
                this.tree.setSelection(treeItemsArray);
                this.treeSelectionChanged(t);
            }
        }
        dmObj.endUpdate(t, job);
        this.changedAttrCtrls.clear();
        this.reloadAttrsInAttrCtrls(t);
        if (changesApplied) {
            returnCode = isError ? 2 : 0;
        }
        return returnCode;
    }

    private void reloadAttrsInAttrCtrls(Trace t) {
        IDmObject dmObject = this.uiMQObject.getDmObject();
        for (AttributeControl attrCtrl : this.attrControls) {
            int attrId = attrCtrl.getAttr().getAttributeID();
            attrCtrl.setAttr(dmObject.getAttribute(t, attrId, 0));
        }
    }

    public boolean addAllChangesToJob(Trace t, Object job) {
        boolean isAdded = false;
        int i = 0;
        while (i < this.uiDisplayGroups.size()) {
            UiDisplayGroup uiDisplayGroup = this.uiDisplayGroups.get(i);
            if (this.addChangesInGroupToJob(t, uiDisplayGroup, job)) {
                isAdded = true;
            }
            ++i;
        }
        return isAdded;
    }

    private void treeSelectionChanged(Trace t) {
        TreeItem[] selTreeItems = new TreeItem[1];
        selTreeItems = this.tree.getSelection();
        TreeItem selTreeItem = selTreeItems[0];
        if (this.createMode) {
            this.messageLabel.setText(selTreeItem.getText());
        } else {
            this.messageArea.showTitle(selTreeItem.getText(), null);
        }
        this.selectedGroup = (UiDisplayGroup)selTreeItem.getData();
        if (Trace.isTracing) {
            t.data(67, "PropertyControl.treeSelectionChanged", 300, "selected group " + this.selectedGroup.getDisplayGroup().getTitle());
        }
        int i = 0;
        while (i < this.pages.size()) {
            Composite composite = this.pages.get(i);
            UiDisplayGroup pageGroup = (UiDisplayGroup)composite.getData();
            if (pageGroup.equals(this.selectedGroup)) {
                DialogTray tray;
                String helpId = this.uiMQObject.getHelpId(this.selectedGroup);
                UiPlugin.getHelpSystem().setHelp((Control)this.shell, helpId);
                UiPlugin.getHelpSystem().setHelp((Control)this, helpId);
                Object data = this.shell.getData();
                if (data instanceof TrayDialog && (tray = ((TrayDialog)data).getTray()) != null) {
                    this.notifyListeners(28, new Event());
                }
                this.stackLayout.topControl = composite;
                this.compProperties.layout();
                this.enableRestore = false;
                this.enableApplyAndDefaultsButtons(t);
                break;
            }
            ++i;
        }
    }

    private void getMandatoryAttributeIds(Trace t) {
        IDmObject dmObject = this.uiMQObject.getDmObject();
        this.mandatoryAttrIds = dmObject.getMandatoryIds(t);
    }

    private void getAttributes(Trace t) {
        IDmObject dmObject = this.uiMQObject.getDmObject();
        int[] attrIds = dmObject.getAllAttributes(t);
        int i = 0;
        while (i < attrIds.length) {
            Attr attr = dmObject.getAttribute(t, attrIds[i], 0);
            if (attr != null) {
                AttrType attrType = attr.getAttrType();
                DisplayGroup displayGroup = attrType.getDisplayGroup();
                UiAttr uiAttr = new UiAttr(t, attr, displayGroup);
                this.uiAttrs.add(uiAttr);
                if (attr instanceof AttrByteArray) {
                    uiAttr.setRequiresCodePage(true);
                }
                uiAttr.setMandatory(this.isMandatoryAttributeId(t, attrIds[i]));
                if (attrType.isRepeating()) {
                    UiAttr prevUiAttr = uiAttr;
                    int j = 1;
                    while (j < dmObject.getRepeatingIndexes(t, attrIds[i])) {
                        attr = dmObject.getAttribute(t, attrIds[i], j);
                        uiAttr = new UiAttr(t, attr, displayGroup);
                        uiAttr.setRepeatingIndex(j);
                        prevUiAttr.setNextUiAttr(uiAttr);
                        prevUiAttr = uiAttr;
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    private void getGroupList(Trace t) {
        DisplayGroup displayGroup;
        List<Integer> groupExclusions = this.uiMQObject.getGroupExclusions(t);
        if (groupExclusions == null) {
            groupExclusions = new ArrayList<Integer>();
        }
        ArrayList<DisplayGroup> groups = new ArrayList<DisplayGroup>();
        ArrayList<Integer> sequences = new ArrayList<Integer>();
        int i = 0;
        while (i < this.uiAttrs.size()) {
            UiAttr uiAttr = this.uiAttrs.get(i);
            Attr attr = uiAttr.getAttr();
            AttrType attrType = attr.getAttrType();
            displayGroup = attrType.getDisplayGroup();
            if (!groups.contains(displayGroup) && !groupExclusions.contains(displayGroup.getId())) {
                groups.add(displayGroup);
                sequences.add(displayGroup.getSequence());
            }
            ++i;
        }
        while (groups.size() > 0) {
            int lowestSeq = 999999999;
            DisplayGroup lowestGroup = null;
            int lowestIndex = 999999999;
            int i2 = 0;
            while (i2 < groups.size()) {
                int seq;
                displayGroup = (DisplayGroup)groups.get(i2);
                int id = displayGroup.getId();
                if (id > this.highestUniqueId) {
                    this.highestUniqueId = id;
                }
                if ((seq = displayGroup.getSequence()) > this.highestSeqId) {
                    this.highestSeqId = seq;
                }
                if (seq < lowestSeq) {
                    lowestSeq = seq;
                    lowestGroup = displayGroup;
                    lowestIndex = i2;
                } else if (seq == lowestSeq && lowestGroup != null) {
                    if (displayGroup.getTitle().compareTo(lowestGroup.getTitle()) < 0) {
                        lowestSeq = seq;
                        lowestGroup = displayGroup;
                        lowestIndex = i2;
                    }
                } else if (seq == lowestSeq) {
                    lowestSeq = seq;
                    lowestGroup = displayGroup;
                    lowestIndex = i2;
                }
                ++i2;
            }
            if (lowestGroup == null) continue;
            UiDisplayGroup uiDisplayGroup = new UiDisplayGroup(t, lowestGroup, this);
            this.uiDisplayGroups.add(uiDisplayGroup);
            groups.remove(lowestIndex);
        }
    }

    private void sortAttributesByGroup(Trace t) {
        int i = 0;
        while (i < this.uiAttrs.size()) {
            UiAttr uiAttr = this.uiAttrs.get(i);
            Attr attr = uiAttr.getAttr();
            AttrType attrType = attr.getAttrType();
            int sequence = attrType.getDisplayGroupSequence();
            if (sequence != -2 && sequence != -1) {
                DisplayGroup displayGroup = attrType.getDisplayGroup();
                int j = 0;
                while (j < this.uiDisplayGroups.size()) {
                    UiDisplayGroup uiDisplayGroup = this.uiDisplayGroups.get(j);
                    if (uiDisplayGroup.getDisplayGroup().getId() == displayGroup.getId()) {
                        uiDisplayGroup.addUiAttr(t, uiAttr);
                        break;
                    }
                    ++j;
                }
            } else if (Trace.isTracing) {
                t.data(67, "PropertyControl.sortAttributesByGroup", 300, "not including hidden attribute " + attr.getAttributeID());
            }
            ++i;
        }
    }

    private void createTreeNodes(Trace t) {
        int i = 0;
        while (i < this.uiDisplayGroups.size()) {
            UiDisplayGroup uiDisplayGroup = this.uiDisplayGroups.get(i);
            if (this.isPropertyExtension(t, uiDisplayGroup) || uiDisplayGroup.getUiAttrsCount() > 0) {
                String groupName = uiDisplayGroup.getDisplayGroup().getTitle();
                TreeItem treeItem = new TreeItem(this.tree, 0);
                treeItem.setText(groupName);
                treeItem.setData((Object)uiDisplayGroup);
                uiDisplayGroup.setTreeItem(treeItem);
                this.treeItems.add(treeItem);
            } else if (Trace.isTracing) {
                t.data(67, "PropertyControl.createTreeNodes", 300, "not showing group '" + uiDisplayGroup.getDisplayGroup().getTitle() + "' which has no attributes");
            }
            ++i;
        }
    }

    private void createPropertyPages(Trace t, Composite composite) {
        int i = 0;
        while (i < this.uiDisplayGroups.size()) {
            UiDisplayGroup uiDisplayGroup = this.uiDisplayGroups.get(i);
            ScrolledComposite scrolledComp = new ScrolledComposite(composite, 768);
            Composite page = new Composite((Composite)scrolledComp, 0);
            scrolledComp.setContent((Control)page);
            page.setData((Object)uiDisplayGroup);
            scrolledComp.setData((Object)uiDisplayGroup);
            this.pages.add((Composite)scrolledComp);
            this.populatePage(t, page, uiDisplayGroup);
            page.layout();
            scrolledComp.setMinSize(page.computeSize(-1, -1));
            int scrollMax = scrolledComp.getVerticalBar().getMaximum();
            int scrollItem = scrollMax / (this.uiDisplayGroups.size() + 1);
            int pageHeight = page.computeSize((int)-1, (int)-1).y;
            scrolledComp.getVerticalBar().setIncrement(scrollItem);
            scrolledComp.getVerticalBar().setPageIncrement(pageHeight);
            scrolledComp.setExpandHorizontal(true);
            scrolledComp.setExpandVertical(true);
            UiUtils.addScrollListeners(scrolledComp);
            ++i;
        }
    }

    private void restoreDefaults(Trace t) {
        if (this.selectedGroup != null) {
            if (this.selectedGroup.isCustom()) {
                if (Trace.isTracing) {
                    t.data(67, "PropertyControl.restoreDefaults", 300, "selected group has a custom page - calling it to restore defaults");
                }
                CustomPropertyPage customPropertyPage = this.selectedGroup.getCustomPropertyPage();
                customPropertyPage.restoreDefaults(t);
            } else {
                ArrayList<UiAttr> attrsInGroup = this.selectedGroup.getUiAttrsArray();
                int i = 0;
                while (i < attrsInGroup.size()) {
                    UiAttr uiAttr = attrsInGroup.get(i);
                    if (Trace.isTracing) {
                        t.data(67, "PropertyControl.restoreDefaults", 300, "processing attribute " + uiAttr.getAttr().getAttributeID());
                    }
                    if (uiAttr.isCustom()) {
                        if (Trace.isTracing) {
                            t.data(67, "PropertyControl.restoreDefaults", 300, "attribute is a custom item - calling it to restore defaults");
                        }
                        CustomPropertyItem customPropertyItem = uiAttr.getCustomPropertyItem();
                        customPropertyItem.restoreDefaults(t);
                    } else {
                        AttributeControl attrCtrl = uiAttr.getAttributeControl();
                        if (attrCtrl instanceof ReadOnlyAttributeControl || !attrCtrl.isEnabled()) {
                            if (Trace.isTracing) {
                                t.data(67, "PropertyControl.restoreDefaults", 300, "attribute is read/only so doing nothing");
                            }
                        } else {
                            if (Trace.isTracing) {
                                t.data(67, "PropertyControl.restoreDefaults", 300, "restoring default value for attribute");
                            }
                            PropertyControl.restoreDefaultAttributeValue(t, uiAttr);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private void applySelected(Trace t) {
        boolean allowApply = this.uiMQObject.isAllowApplyProperties();
        if (allowApply) {
            this.applyChangesToGroup(t, this.selectedGroup, this.uiMQObject.getDmObject());
        }
    }

    private void enableApplyAndDefaultsButtons(Trace t) {
        boolean anyControlsEnabled = false;
        boolean enableApply = true;
        if (this.selectedGroup != null) {
            if (this.selectedGroup.isCustom()) {
                anyControlsEnabled = this.selectedGroup.getCustomPropertyPage().isAnyControlEnabled(t);
            } else {
                ArrayList<UiAttr> attrsInGroup = this.selectedGroup.getUiAttrsArray();
                int i = 0;
                while (i < attrsInGroup.size()) {
                    UiAttr uiAttr = attrsInGroup.get(i);
                    if (uiAttr.isCustom()) {
                        CustomPropertyItem customProperty = uiAttr.getCustomPropertyItem();
                        if (customProperty != null) {
                            ArrayList<UiAttr> attrsInCustomItem;
                            if (customProperty.isEnabled(t)) {
                                anyControlsEnabled = true;
                            }
                            if ((attrsInCustomItem = customProperty.getUiAttrsArray()) != null) {
                                for (UiAttr customItemAttribute : attrsInCustomItem) {
                                    AttributeControl attrCtrl = customItemAttribute.getAttributeControl();
                                    if (attrCtrl == null) continue;
                                    if (!attrCtrl.isValid()) {
                                        enableApply = false;
                                    }
                                    if (!customItemAttribute.isMandatory() || attrCtrl.getValue(t).toString().length() != 0) continue;
                                    enableApply = false;
                                }
                            }
                        }
                    } else {
                        Object value;
                        AttributeControl attrCtrl = uiAttr.getAttributeControl();
                        if (attrCtrl != null) {
                            if (attrCtrl.isEnabled() && !(attrCtrl instanceof ReadOnlyAttributeControl)) {
                                anyControlsEnabled = true;
                            }
                            if (!attrCtrl.isValid()) {
                                enableApply = false;
                            }
                        }
                        if ((uiAttr.alwaysMandatory() || !this.uiMQObject.getDmObject().isSystemObject(t) && uiAttr.isMandatory()) && attrCtrl != null && ((value = attrCtrl.getValue(t)) == null || value.toString().length() == 0)) {
                            enableApply = false;
                        }
                    }
                    ++i;
                }
            }
            if (anyControlsEnabled) {
                if (this.buttonApply != null) {
                    this.buttonApply.setEnabled(enableApply);
                }
                if (this.buttonRestore != null) {
                    this.buttonRestore.setEnabled(this.enableRestore);
                }
            } else {
                if (this.buttonApply != null) {
                    this.buttonApply.setEnabled(false);
                }
                if (this.buttonRestore != null) {
                    this.buttonRestore.setEnabled(false);
                }
            }
        }
    }

    private void populatePage(Trace t, Composite page, UiDisplayGroup uiDisplayGroup) {
        if (Trace.isTracing) {
            t.data(67, "PropertyControl.populatePage", 300, "populating page for display group " + uiDisplayGroup.getDisplayGroup().getTitle());
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 10;
        page.setLayout((Layout)gridLayout);
        if (this.isPropertyExtension(t, uiDisplayGroup)) {
            if (Trace.isTracing) {
                t.data(67, "PropertyControl.populatePage", 300, "creating page for a property tab extension");
            }
            this.createExtensionPropertyPage(t, page, uiDisplayGroup);
        } else if (this.uiMQObject.isCustomGroup(t, uiDisplayGroup)) {
            if (Trace.isTracing) {
                t.data(67, "PropertyControl.populatePage", 300, "creating custom group page");
            }
            this.createCustomPropertyPage(t, page, uiDisplayGroup);
        } else {
            if (Trace.isTracing) {
                t.data(67, "PropertyControl.populatePage", 300, "creating standard group page");
            }
            this.createStandardPropertyPage(t, page, uiDisplayGroup);
        }
    }

    private void createExtensionPropertyPage(Trace t, Composite page, UiDisplayGroup uiDisplayGroup) {
        IPropertyTabFactory propertyTabFactory = this.propertyTabFactoryManager.getPropertyTabFactory(t, uiDisplayGroup.getDisplayGroup().getTitle());
        PropertyPage customPage = propertyTabFactory.createPropertyPage(page, this.uiMQObject.getExternalObject(), uiDisplayGroup);
        if (customPage != null) {
            customPage.setFixedSpaceFont(this.fontFixedSpace);
            this.customPages.add(customPage);
            GridData gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            customPage.setLayoutData(gridData);
            ((CustomPropertyPage)customPage).init(t);
            uiDisplayGroup.setCustomPropertyPage(customPage);
        }
    }

    private boolean isPropertyExtension(Trace t, UiDisplayGroup uiDisplayGroup) {
        boolean isAnExtendedProperty = false;
        if (this.propertyExtensions.contains(uiDisplayGroup)) {
            isAnExtendedProperty = true;
        }
        return isAnExtendedProperty;
    }

    private static void restoreDefaultAttributeValue(Trace t, UiAttr uiAttr) {
        boolean accepted = false;
        boolean attempted = false;
        Object defaultValue = null;
        AttributeControl attrCtrl = uiAttr.getAttributeControl();
        Attr attr = attrCtrl.getAttr();
        AttrType attrType = attr.getAttrType();
        if (attrType instanceof AttrTypeString || attrType instanceof AttrTypeInt || attrType instanceof AttrTypeLong) {
            defaultValue = attr.getDefaultValue(t);
            accepted = attrCtrl.setValue(t, defaultValue);
            attempted = true;
        } else {
            if (Trace.isTracing) {
                t.data(67, "PropertyControl.restoreDefaultAttributeValue", 900, "Unable to restore default value - unknown AttrType: " + attrType);
            }
            t.FFST(67, "PropertyControl.restoreDefaultAttributeValue", 10, 50009, 0, 0, "Unable to restore default value - unknown AttrType: " + attrType, null, null);
        }
        if (attempted && !accepted) {
            if (Trace.isTracing) {
                t.data(67, "PropertyControl.restoreDefaultAttributeValue", 900, "Failed to restore default value");
                t.data(67, "PropertyControl.restoreDefaultAttributeValue", 900, "   attribute name: " + uiAttr.getAttr().getAttrType().getDisplayTitle());
                t.data(67, "PropertyControl.restoreDefaultAttributeValue", 900, "   attribute default value: " + defaultValue);
            }
            t.FFST(67, "PropertyControl.restoreDefaultAttributeValue", 20, 50009, 0, 0, "Failed to restore default value", uiAttr.getAttr().getAttrType().getDisplayTitle(), defaultValue != null ? defaultValue.toString() : "null");
        }
    }

    private boolean addChangesInGroupToJob(Trace t, UiDisplayGroup uiDisplayGroup, Object job) {
        boolean isChanged = false;
        this.changedAttrCtrls = new ArrayList();
        IDmObject dmObj = this.uiMQObject.getDmObject();
        if (uiDisplayGroup.isCustom()) {
            CustomPropertyPage customPage;
            boolean result;
            if (Trace.isTracing) {
                t.data(67, "PropertyControl.addChangesInGroupToJob", 300, "display group has custom page - calling it to apply changes");
            }
            if (result = (customPage = uiDisplayGroup.getCustomPropertyPage()).apply(t, job)) {
                isChanged = true;
            }
        }
        if (Trace.isTracing) {
            t.data(67, "PropertyControl.addChangesInGroupToJob", 300, "display group is not a custom page - applying changes");
        }
        int i = 0;
        while (i < this.attrControls.size()) {
            AttributeControl attrCtrl = this.attrControls.get(i);
            if (attrCtrl.getAttr().getAttrType().getDisplayGroup().getId() == uiDisplayGroup.getDisplayGroup().getId() && attrCtrl.isChanged(t)) {
                isChanged = true;
                if (Trace.isTracing) {
                    t.data(67, "PropertyControl.addChangesInGroupToJob", 300, "applying change for attribute " + attrCtrl.getAttr().getAttributeID());
                }
                if (PropertyControl.setAttributeValueFromControl(t, job, dmObj, attrCtrl)) {
                    this.changedAttrCtrls.add(attrCtrl);
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.customItems.size()) {
            CustomPropertyItem customItem = this.customItems.get(i);
            if (customItem.getUiDisplayGroup().equals(uiDisplayGroup)) {
                boolean result;
                if (Trace.isTracing) {
                    t.data(67, "PropertyControl.addChangesInGroupToJob", 300, "calling custom item to apply change for attribute " + customItem.getAttr().getAttributeID());
                }
                if (result = customItem.apply(t, job)) {
                    isChanged = true;
                }
            }
            ++i;
        }
        return isChanged;
    }

    private void createStandardPropertyPage(Trace t, Composite page, UiDisplayGroup uiDisplayGroup) {
        ArrayList<UiAttr> attrsInGroup = uiDisplayGroup.getUiAttrsArray();
        PropertyControl.sortAttributesBySequenceNumber(t, attrsInGroup);
        int i = 0;
        while (i < attrsInGroup.size()) {
            UiAttr uiAttr = attrsInGroup.get(i);
            Attr attr = uiAttr.getAttr();
            if (this.uiMQObject.isCustomItem(t, attr)) {
                CustomPropertyItem customItem;
                if (Trace.isTracing) {
                    t.data(67, "PropertyControl.createStandardPropertyPage", 300, "creating custom item for attribute " + attr.getAttributeID());
                }
                if ((customItem = this.uiMQObject.createCustomPropertyItem(t, page, 0, attr, this.readonlyMode)) != null) {
                    customItem.setUiDisplayGroup(uiDisplayGroup);
                    customItem.setFixedSpaceFont(this.fontFixedSpace);
                    this.customItems.add(customItem);
                    customItem.init(t);
                    uiAttr.setCustomPropertyItem(customItem);
                }
            } else {
                if (Trace.isTracing) {
                    t.data(67, "PropertyControl.createStandardPropertyPage", 300, "adding item to page for attribute " + attr.getAttributeID());
                }
                this.addAttributeToPage(t, page, uiAttr);
            }
            ++i;
        }
    }

    private void createCustomPropertyPage(Trace t, Composite page, UiDisplayGroup uiDisplayGroup) {
        CustomPropertyPage customPage = this.uiMQObject.createCustomPropertyPage(t, page, 0, uiDisplayGroup, this.readonlyMode);
        if (customPage != null) {
            customPage.setFixedSpaceFont(this.fontFixedSpace);
            this.customPages.add(customPage);
            GridData gridData = new GridData(1808);
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            customPage.setLayoutData(gridData);
            customPage.init(t);
            uiDisplayGroup.setCustomPropertyPage(customPage);
            ArrayList<UiAttr> attrsInGroup = uiDisplayGroup.getUiAttrsArray();
            int i = 0;
            while (i < attrsInGroup.size()) {
                Attr attr;
                UiAttr uiAttr = attrsInGroup.get(i);
                if (uiAttr != null && (attr = uiAttr.getAttr()) != null) {
                    int rwStatus = this.getAttrReadWriteStatus(t, uiAttr);
                    AttributeControl attrControl = uiAttr.getAttributeControl();
                    if (attrControl != null) {
                        if (this.uiMQObject.isNotifyChangedOnPropertyPage(attr)) {
                            attrControl.addModifyListener(this, LISTENER_TYPE_NOTIFY);
                        }
                        if (attrControl.isEnabled()) {
                            attrControl.addModifyListener(new IAttributeModifiedListener(){

                                @Override
                                public void attrModified(AttributeModifiedEvent event) {
                                    Trace t2 = Trace.getDefault();
                                    PropertyControl.this.enableApplyAndDefaultsButtons(t2);
                                    AttributeControl attrCtrl = event.getAttributeControl();
                                    boolean valid = attrCtrl.isValid();
                                    if (!attrCtrl.isEnabled()) {
                                        valid = true;
                                    }
                                    int attrId = attrCtrl.getAttr().getAttributeID();
                                    String attrName = attrCtrl.getAttrType().getPropTitle();
                                    PropertyControl.this.sendInvalidCharsEvent(t2, attrId, attrName, valid);
                                }
                            }, LISTENER_TYPE_VALIDATE);
                        }
                        if (uiAttr.isMandatory()) {
                            if (Trace.isTracing) {
                                t.data(67, "PropertyControl.createCustomPropertyPage", 300, "setting listener and style for mandatory attribute " + attr.getAttributeID() + " on custom page");
                            }
                            attrControl.addModifyListener(this, LISTENER_TYPE_MANDATORY);
                            int attrId = attr.getAttributeID();
                            String attrName = attr.getAttrType().getPropTitle();
                            Object value = attr.getValue(t);
                            boolean present = value.toString().length() > 0;
                            this.sendMandatoryAttributeEvent(t, attrId, attrName, present);
                            if (rwStatus == 3 || rwStatus == 1) {
                                attrControl.addMandatoryDecoration(t);
                            }
                            if (!present && this.initialFocus == null) {
                                this.initialFocus = attrControl;
                                this.initialDisplayGroup = uiAttr.getDisplayGroup();
                            }
                        }
                        if (this.uiMQObject.isNotifyChangedOnPropertyPage(attr)) {
                            if (Trace.isTracing) {
                                t.data(67, "PropertyControl.createCustomPropertyPage", 300, "notifying object for attribute " + attr.getAttributeID());
                            }
                            if (this.uiMQObject.attrValueChangedOnPropertyPage(t, attr, attr.getValue(t))) {
                                if (Trace.isTracing) {
                                    t.data(67, "PropertyControl.createCustomPropertyPage", 300, "object requested re-enable edit controls");
                                }
                                this.enableEditControls(t);
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    private static boolean setAttributeValueFromControl(Trace t, Object job, IDmObject dmObj, AttributeControl attrCtrl) {
        Attr tmp;
        if (Trace.isTracing) {
            String value;
            String strValue = attrCtrl.getValue(t) == null ? "(null)" : attrCtrl.getValue(t).toString();
            int id = attrCtrl.getAttr().getAttributeID();
            if (TraceAspect.isSensitivePCF((Object)id) && (value = attrCtrl.getValue(t).toString()) != null && !value.equals("")) {
                strValue = "********";
            }
            t.data(67, "PropertyControl.setAttributeValueFromControl", 300, "Setting attribute: " + attrCtrl.getAttrType().getDisplayTitle() + " - new value: " + strValue);
        }
        boolean result = attrCtrl.getAttrType().getPCFType() == 1 ? (PropertyControl.isEmpty(t, attrCtrl) ? dmObj.setAttributeValue(t, job, attrCtrl.getAttr().getAttributeID(), 0, attrCtrl.getValue(t)) : (attrCtrl.getAttr().isDefaultValueUsed(t) ? (tmp = dmObj.createAttribute(t, job, attrCtrl.getAttr().getAttributeID(), 0, attrCtrl.getValue(t))) != null : dmObj.setAttributeValue(t, job, attrCtrl.getAttr().getAttributeID(), 0, attrCtrl.getValue(t)))) : dmObj.setAttributeValue(t, job, attrCtrl.getAttr().getAttributeID(), 0, attrCtrl.getValue(t));
        if (!result) {
            if (Trace.isTracing) {
                t.data(67, "PropertyControl.setAttributeValueFromControl", 900, "dmObject setAttributeValue failed");
            }
            t.FFST(67, "PropertyControl.setAttributeValueFromControl", 10, 50002, 0, 0, "Failed to set attribute value", attrCtrl.getAttrType().getDisplayTitle(), attrCtrl.getValue(t).toString());
        }
        return result;
    }

    private static boolean isEmpty(Trace t, AttributeControl attrCtrl) {
        boolean result = false;
        AttrType type = attrCtrl.getAttrType();
        if ((type instanceof AttrTypeString || type instanceof AttrTypeFixedLengthString) && ((String)attrCtrl.getValue(t)).compareTo("") == 0) {
            result = true;
        }
        return result;
    }

    public void addAttributeToPage(Trace t, Composite page, UiAttr uiAttr) {
        Attr attr = uiAttr.getAttr();
        if (attr == null) {
            if (Trace.isTracing) {
                t.data(67, "PropertyControl.addAttributeToPage", 1000, "Trying to add an attribute to the page when attribute is null");
            }
            return;
        }
        Label labelName = new Label(page, 0);
        int rwStatus = this.getAttrReadWriteStatus(t, uiAttr);
        String colon = this.msgFile.getMessage("UI.PROP.Colon.Suffix");
        labelName.setText(String.valueOf(attr.getAttrType().getPropTitle()) + colon);
        GridData gridDataLabel = new GridData();
        if (attr.getAttrType().isMultiLine()) {
            gridDataLabel.verticalAlignment = 1;
        }
        labelName.setLayoutData((Object)gridDataLabel);
        AttributeControl attrControl = null;
        if (rwStatus == 0 || this.readonlyMode) {
            AttrType attrType = attr.getAttrType();
            String attrString = attr.toString(t);
            if (attrString.equals("[not_found]")) {
                Message messageFile = UiPlugin.getUIMessages(t, "KEY_General");
                attrString = messageFile != null ? messageFile.getMessage(t, "UI.GENERAL.NOT.FOUND") : "";
                if (Trace.isTracing) {
                    t.data(67, "PropertyControl.addAttributeToPage", 900, "no valid string for enum value found for attr: " + attr);
                }
            }
            if (uiAttr.isRequiresCodePage()) {
                int attrId = attr.getAttributeID();
                String codePage = this.uiMQObject.getCharacterSetIdForByteArray(t, attrId);
                if (codePage == null) {
                    codePage = "UTF8";
                }
                attrString = attrType.isMultiLine() ? attr.toFormattedString(t, codePage, -1) : attr.toString(t, codePage, -1);
            } else if (attrType.isMultiLine()) {
                attrString = attr.toFormattedString(t);
            }
            ReadOnlyAttributeControl readOnlyAttrCtrl = new ReadOnlyAttributeControl(t, page, 0, attrType, attrString, attrType.isMultiLine(), this.fontFixedSpace);
            attrControl = readOnlyAttrCtrl;
        } else {
            int attrType = attr.getAttrType().getAttributeType();
            Number[] validValues = null;
            PropertyControl.traceAttr(t, attr, attrType);
            switch (attrType) {
                case 3: {
                    attrControl = new EnumAttributeControl(t, page, 0, attr.getAttrType(), attr.getValue(t));
                    validValues = this.getValidSelections(t, attr.getAttrType(), attr.getAttributeID());
                    if (validValues == null) break;
                    ((EnumAttributeControl)attrControl).setValidSelections(t, validValues);
                    break;
                }
                case 11: {
                    attrControl = new EnumRangeAttributeControl(t, page, 0, attr.getAttrType(), attr.getValue(t));
                    break;
                }
                case 6: {
                    AttrTypeFixedLengthString attrTypeFixedLengthString = (AttrTypeFixedLengthString)attr.getAttrType();
                    if (attrTypeFixedLengthString.isPassword()) {
                        attrControl = new PasswordAttributeControl(t, page, 0, (AttrType)attrTypeFixedLengthString, attr.getValue(t));
                        break;
                    }
                    attrControl = new TextAttributeControl(t, page, 0, attr.getAttrType(), attr.getValue(t), true);
                    break;
                }
                case 9: {
                    attrControl = new EnumTextAttributeControl(t, page, 0, attr.getAttrType(), attr.getValue(t));
                    break;
                }
                case 13: {
                    attrControl = new EnumTextRangeAttributeControl(t, page, 0, attr.getAttrType(), attr.getValue(t));
                    break;
                }
                case 1: {
                    attrControl = new NumericAttributeControl(t, page, 0, attr.getAttrType(), attr.getValue(t));
                    break;
                }
                case 12: {
                    attrControl = new LongNumericAttributeControl(t, page, 0, attr.getAttrType(), attr.getValue(t));
                    break;
                }
                case 7: {
                    attrControl = new TextAttributeControl(t, page, 0, attr.getAttrType(), attr.getValue(t), true);
                    break;
                }
                case 4: {
                    attrControl = new RangeAttributeControl(t, page, 0, attr.getAttrType(), attr.getValue(t));
                    break;
                }
                case 29: {
                    attrControl = new LongNumericAttributeControl(t, page, 0, attr.getAttrType(), attr.getValue(t));
                    break;
                }
                case 2: {
                    attrControl = new TextAttributeControl(t, page, 0, attr.getAttrType(), attr.getValue(t), true);
                    break;
                }
                case 10: {
                    attrControl = new NumericAttributeControl(t, page, 0, attr.getAttrType(), attr.getValue(t));
                    break;
                }
                case 8: {
                    AttrStringArray attStringArray = (AttrStringArray)attr;
                    ArrayList stringList = (ArrayList)attStringArray.getValue(t);
                    attrControl = new StringArrayAttributeControl(t, page, 0, (AttrTypeStringArray)attr.getAttrType(), attr.toFormattedString(t), stringList, this.fontFixedSpace);
                    gridDataLabel.verticalAlignment = 1;
                    break;
                }
                case 18: {
                    AttrIntArrayEnum attrIntArrayEnum = (AttrIntArrayEnum)attr;
                    ArrayList enumList = (ArrayList)attrIntArrayEnum.getValue(t);
                    attrControl = new IntArrayEnumAttributeControl(t, page, 0, attr.getAttrType(), attr.toFormattedString(t), enumList, this.uiMQObject, attr.getAttributeID(), this.fontFixedSpace);
                    gridDataLabel.verticalAlignment = 1;
                    break;
                }
                case 15: {
                    AttrStringArray attrStringArray = (AttrStringArray)attr;
                    ArrayList stringArrayList = (ArrayList)attrStringArray.getValue(t);
                    attrControl = new StringArrayAttributeControl(t, page, 0, (AttrTypeStringArray)attr.getAttrType(), attr.toFormattedString(t), stringArrayList, this.fontFixedSpace);
                    gridDataLabel.verticalAlignment = 1;
                    break;
                }
                case 16: {
                    attrControl = new ByteArrayAttributeControl(t, page, 0, attr.getAttrType(), attr.getValue(t));
                    break;
                }
                case 5: {
                    attrControl = new TextAttributeControl(t, page, 0, attr.getAttrType(), attr.getValue(t), true);
                    break;
                }
                case 24: {
                    attrControl = new URLAttributeControl(t, page, 0, attr.getAttrType(), attr.getValue(t));
                    break;
                }
                case 25: {
                    attrControl = new BooleanAttributeControl(t, page, 0, attr.getAttrType(), attr.getValue(t));
                    break;
                }
                case 26: {
                    attrControl = new ObjectAttributeControl(t, page, 0, attr.getAttrType(), attr.getValue(t), true, this.uiMQObject, attr.getAttributeID());
                    break;
                }
                case 27: {
                    attrControl = new LongEnumAttributeControl(t, page, 0, attr.getAttrType(), attr.getValue(t));
                    break;
                }
                case 28: {
                    attrControl = new LongEnumRangeAttributeControl(t, page, 0, attr.getAttrType(), attr.getValue(t));
                    break;
                }
                default: {
                    if (Trace.isTracing) {
                        t.data(67, "PropertyControl.addAttributeToPage", 900, "unable to add controls for AttrType: " + attrType);
                    }
                    t.FFST(67, "PropertyControl.addAttributeToPage", 10, 50002, 0, 0, "unable to add controls for AttrType: " + attrType, null, null);
                    attrControl = new ReadOnlyAttributeControl(t, page, 0, attr.getAttrType(), attr.getValue(t), false, this.fontFixedSpace);
                }
            }
        }
        attrControl.setAttr(attr);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        if (attr.getAttrType().isMultiLine() && attrControl instanceof ReadOnlyAttributeControl && ((ReadOnlyAttributeControl)attrControl).isExpand()) {
            gridData.grabExcessVerticalSpace = true;
            gridData.verticalAlignment = 4;
        }
        gridData.widthHint = 280;
        gridData.horizontalIndent = 8;
        attrControl.setLayoutData(gridData);
        attrControl.setAssociatedLabel(labelName);
        attrControl.setEnabled(rwStatus == 3 || rwStatus == 1);
        this.attrControls.add(attrControl);
        if (this.uiMQObject.isNotifyChangedOnPropertyPage(attr)) {
            attrControl.addModifyListener(this, LISTENER_TYPE_NOTIFY);
        }
        if (attrControl.isEnabled()) {
            attrControl.addModifyListener(new IAttributeModifiedListener(){

                @Override
                public void attrModified(AttributeModifiedEvent event) {
                    Trace t2 = Trace.getDefault();
                    PropertyControl.this.enableApplyAndDefaultsButtons(t2);
                    AttributeControl attrCtrl = event.getAttributeControl();
                    boolean valid = attrCtrl.isValid();
                    if (!attrCtrl.isEnabled()) {
                        valid = true;
                    }
                    int attrId = attrCtrl.getAttr().getAttributeID();
                    String attrName = attrCtrl.getAttrType().getPropTitle();
                    PropertyControl.this.sendInvalidCharsEvent(t2, attrId, attrName, valid);
                }
            }, LISTENER_TYPE_VALIDATE);
        }
        uiAttr.setAttributeControl(attrControl);
        if (uiAttr.alwaysMandatory() || !this.uiMQObject.getDmObject().isSystemObject(t) && uiAttr.isMandatory()) {
            attrControl.addModifyListener(this, LISTENER_TYPE_MANDATORY);
            int attrId = attr.getAttributeID();
            String attrName = attr.getAttrType().getPropTitle();
            Object value = attr.getValue(t);
            boolean present = value != null && value.toString().length() > 0;
            this.sendMandatoryAttributeEvent(t, attrId, attrName, present);
            if (rwStatus == 3 || rwStatus == 1) {
                attrControl.addMandatoryDecoration(t);
            }
            if (!present && this.initialFocus == null) {
                this.initialFocus = attrControl;
                this.initialDisplayGroup = uiAttr.getDisplayGroup();
            }
        }
    }

    private void enableEditControls(Trace t) {
        int i = 0;
        while (i < this.uiAttrs.size()) {
            UiAttr uiAttr = this.uiAttrs.get(i);
            AttributeControl attrCtrl = uiAttr.getAttributeControl();
            Label label = attrCtrl.getAssociatedLabel();
            attrCtrl.setEnabled(!uiAttr.isForcedReadOnly());
            label.setEnabled(!uiAttr.isForcedReadOnly());
            ++i;
        }
    }

    private int getAttrReadWriteStatus(Trace t, UiAttr uiAttr) {
        int status = 0;
        Attr attr = uiAttr.getAttr();
        AttrType attrType = null;
        if (attr != null) {
            attrType = attr.getAttrType();
        }
        int controlAttrId = -1;
        if (attrType != null) {
            controlAttrId = attrType.getRWControl();
        }
        if (controlAttrId != -1) {
            UiAttr controlUiAttr = this.getUiAttr(t, controlAttrId);
            if (controlUiAttr != null) {
                controlUiAttr.addControlledAttribute(t, uiAttr);
                uiAttr.setControlled(true);
            }
            status = attr != null && attr.isReadWrite(t) ? 3 : 2;
        } else {
            status = attr != null && attr.isReadWrite(t, this.createMode) ? 1 : 0;
        }
        return status;
    }

    private UiAttr getUiAttr(Trace t, int attrId) {
        UiAttr uiAttr = null;
        int i = 0;
        while (i < this.uiAttrs.size()) {
            UiAttr testUiAttr = this.uiAttrs.get(i);
            if (testUiAttr.getAttr().getAttributeID() == attrId) {
                uiAttr = testUiAttr;
                break;
            }
            ++i;
        }
        return uiAttr;
    }

    public static void sortAttributesBySequenceNumber(Trace t, ArrayList<UiAttr> uiAtts) {
        int count = uiAtts.size();
        UiAttr[] objArray = new UiAttr[count];
        objArray = uiAtts.toArray(objArray);
        CompareAttrGroupSequenceNumbers compAttrGroupSeqNos = new CompareAttrGroupSequenceNumbers();
        Arrays.sort(objArray, compAttrGroupSeqNos);
        uiAtts.clear();
        int i = 0;
        while (i < count) {
            uiAtts.add(objArray[i]);
            ++i;
        }
    }

    private static void traceAttr(Trace t, Attr attr, int attrType) {
        String type = "unknown";
        switch (attrType) {
            case 1: {
                type = "Int";
                break;
            }
            case 2: {
                type = "String";
                break;
            }
            case 3: {
                type = "Enum";
                break;
            }
            case 4: {
                type = "Range";
                break;
            }
            case 29: {
                type = "LongRange";
                break;
            }
            case 5: {
                type = "IP Address";
                break;
            }
            case 6: {
                type = "FixedString";
                break;
            }
            case 7: {
                type = "MQ String";
                break;
            }
            case 8: {
                type = "FixedStringListItem";
                break;
            }
            case 9: {
                type = "FixedStringEnum";
                break;
            }
            case 10: {
                type = "Unsigned int";
                break;
            }
            case 11: {
                type = "EnumRange";
                break;
            }
            case 12: {
                type = "Long";
                break;
            }
            case 13: {
                type = "FixedStringEnumRange";
                break;
            }
            case 14: {
                type = "IntArray";
                break;
            }
            case 15: {
                type = "StringArray";
                break;
            }
            case 16: {
                type = "ByteArray";
                break;
            }
            case 17: {
                type = "Unsigned Long";
                break;
            }
            case 18: {
                type = "IntArrayEnum";
                break;
            }
            case 19: {
                type = "QMGRURID";
                break;
            }
            case 20: {
                type = "BitEnum";
                break;
            }
            case 24: {
                type = "URL";
                break;
            }
            case 25: {
                type = "Boolean";
                break;
            }
            case 26: {
                type = "Object";
                break;
            }
            case 27: {
                type = "LongEnum";
                break;
            }
            case 28: {
                type = "LongEnumRange";
                break;
            }
            default: {
                if (Trace.isTracing) {
                    t.data(67, "PropertyControl.traceAttr", 900, "unknown AttrType: " + attrType);
                }
                t.FFST(67, "PropertyControl.traceAttr", 10, 50009, 0, 0, "unknown AttrType: " + attrType, null, null);
            }
        }
        if (Trace.isTracing) {
            t.data(67, "PropertyControl.traceAttr", 300, "type = " + type);
        }
    }

    @Override
    public void attrModified(AttributeModifiedEvent event) {
        Trace t = Trace.getDefault();
        Integer userType = event.getUserType();
        if (userType == LISTENER_TYPE_NOTIFY) {
            Object newValue = event.getNewValue();
            AttributeControl attrCtrl = event.getAttributeControl();
            Attr attr = attrCtrl.getAttr();
            if (Trace.isTracing) {
                t.data(67, "PropertyControl.attrModified", 300, "type = " + attr.getClass().getName());
            }
            if (this.uiMQObject.attrValueChangedOnPropertyPage(t, attr, newValue)) {
                if (Trace.isTracing) {
                    t.data(67, "PropertyControl.attrModified", 300, "object requested re-enabling of edit controls");
                }
                this.enableEditControls(t);
            }
        } else if (userType == LISTENER_TYPE_MANDATORY) {
            boolean present;
            this.enableApplyAndDefaultsButtons(t);
            AttributeControl attrCtrl = event.getAttributeControl();
            int attrId = attrCtrl.getAttr().getAttributeID();
            String attrName = attrCtrl.getAttrType().getPropTitle();
            Object newValue = event.getNewValue();
            boolean bl = present = newValue.toString().length() > 0;
            if (!attrCtrl.isEnabled()) {
                present = true;
            }
            this.sendMandatoryAttributeEvent(t, attrId, attrName, present);
        }
    }

    public void dmActionDone(DmActionEvent event) {
        this.dmActionEvent = event;
        if (this.busyDialog != null) {
            this.shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PropertyControl.this.busyDialog.closeDialog(Trace.getDefault());
                    PropertyControl.this.busyDialog = null;
                }
            });
        }
    }

    private boolean isMandatoryAttributeId(Trace t, int attrId) {
        boolean result = false;
        int i = 0;
        while (i < this.mandatoryAttrIds.length) {
            if (this.mandatoryAttrIds[i] == attrId) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    public void addMandatoryAttributeEventListener(Trace t, MandatoryAttributeEventListener listener) {
        this.mandatoryAttrEventListeners.addElement(listener);
    }

    public void removeContentChangedListener(Trace t, MandatoryAttributeEventListener listener) {
        this.mandatoryAttrEventListeners.removeElement(listener);
    }

    public void addInvalidCharsEventListener(Trace t, InvalidCharsEventListener listener) {
        this.invalidCharsEventListeners.addElement(listener);
    }

    public void sendMandatoryAttributeEvent(Trace t, int attrId, String attrName, boolean present) {
        MandatoryAttributeEvent maEvent = new MandatoryAttributeEvent(this, attrId, attrName);
        int size = this.mandatoryAttrEventListeners.size();
        int i = 0;
        while (i < size) {
            MandatoryAttributeEventListener listener = this.mandatoryAttrEventListeners.elementAt(i);
            if (present) {
                listener.attributeValuePresent(maEvent);
            } else {
                listener.attributeValueMissing(maEvent);
            }
            ++i;
        }
    }

    private void sendInvalidCharsEvent(Trace t, int attrId, String attrName, boolean valid) {
        InvalidCharsAttributeEvent maEvent = new InvalidCharsAttributeEvent(this, attrId, attrName);
        int size = this.invalidCharsEventListeners.size();
        int i = 0;
        while (i < size) {
            InvalidCharsEventListener listener = this.invalidCharsEventListeners.elementAt(i);
            if (valid) {
                listener.invalidCharsAbsent(maEvent);
            } else {
                listener.invalidCharsPresent(maEvent);
            }
            ++i;
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.fontFixedSpace != null && !this.fontFixedSpace.isDisposed()) {
            this.fontFixedSpace.dispose();
        }
    }

    public Number[] getValidSelections(Trace t, AttrType attrType, int attrId) {
        int validIds = 0;
        int count = 0;
        Number[] validEnums = null;
        AttrTypeEnum attrTypeEnum = null;
        attrTypeEnum = (AttrTypeEnum)attrType;
        Integer[] enumIds = attrTypeEnum.getEnumerationIds(t);
        int i = 0;
        while (i < enumIds.length) {
            if (this.uiMQObject.getDmObject().isEnumerationIdValid(t, attrId, enumIds[i].intValue())) {
                ++validIds;
            }
            ++i;
        }
        if (validIds > 0) {
            validEnums = new Number[validIds];
            i = 0;
            while (i < enumIds.length) {
                if (this.uiMQObject.getDmObject().isEnumerationIdValid(t, attrId, enumIds[i].intValue())) {
                    validEnums[count] = (int)enumIds[i];
                    ++count;
                }
                ++i;
            }
        }
        return validEnums;
    }

    public void showErrorMessage(String errorMessage) {
        if (this.messageArea != null) {
            this.messageArea.updateText(errorMessage, 3);
        }
    }

    public void clearErrorMessage() {
        if (this.messageArea != null) {
            this.messageArea.restoreTitle();
        }
    }
}

