/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthString;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.properties.AttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.ChangePasswordDialog;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PasswordAttributeControl
extends AttributeControl {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/PasswordAttributeControl.java";
    private static final int MAX_WIDTH = 500;
    private Text text = null;
    private static final int TEXT_ANY_LENGTH = -1;
    private Object originalValue = null;
    private Button clearPasswordButton = null;
    private int maxLength = 0;

    public PasswordAttributeControl(Trace t, Composite parent, int style, AttrType attrType, Object currentValue) {
        super(t, parent, style, attrType, currentValue);
        this.originalValue = currentValue;
        this.maxLength = -1;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 3;
        this.setLayout((Layout)gridLayout);
        this.text = new Text((Composite)this, 0x400800);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        this.text.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly(t, this.text, true);
        AttrTypeFixedLengthString attrTypeFixedLengthString = (AttrTypeFixedLengthString)attrType;
        this.maxLength = attrTypeFixedLengthString.getLength();
        if (this.maxLength != -1) {
            this.text.setTextLimit(this.maxLength);
        }
        this.text.setText(currentValue.toString());
        Button buttonChangePassword = new Button((Composite)this, 8);
        buttonChangePassword.setText(this.msgFile.getMessage(t, "Ui.Change.Password.Button"));
        GridData gridDataChangePassword = new GridData();
        gridDataChangePassword.horizontalSpan = 1;
        buttonChangePassword.setLayoutData((Object)gridDataChangePassword);
        buttonChangePassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t1 = Trace.getDefault();
                PasswordAttributeControl.this.changePassword(t1, PasswordAttributeControl.this.getShell());
            }
        });
        String password = this.originalValue.toString();
        boolean enableClearPassword = password != null && password.compareTo("") != 0;
        this.clearPasswordButton = new Button((Composite)this, 8);
        this.clearPasswordButton.setText(this.msgFile.getMessage(t, "Ui.Clear.Password.Button"));
        this.clearPasswordButton.setEnabled(enableClearPassword);
        GridData gridDataClearPassword = new GridData();
        gridDataClearPassword.horizontalAlignment = 3;
        gridDataClearPassword.horizontalSpan = 1;
        this.clearPasswordButton.setLayoutData((Object)gridDataClearPassword);
        this.clearPasswordButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                PasswordAttributeControl.this.clearPassword(t2);
            }
        });
    }

    public void clearPassword(Trace t) {
        String title = this.msgFile.getMessage(t, "Ui.Clear.Password.Button");
        String message = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4096");
        int result = MessageBox.showYesNoMessage(t, UiPlugin.getShell(), title, null, message, 1, null);
        if (result == 0) {
            this.clearPasswordButton.setEnabled(false);
            this.text.setText("");
        }
    }

    public boolean changePassword(Trace t, Shell shell) {
        boolean changed = false;
        ChangePasswordDialog changePasswordDlg = new ChangePasswordDialog(shell, 0, this.maxLength);
        changePasswordDlg.create(t);
        if (changePasswordDlg.open(t)) {
            String password = changePasswordDlg.getPassword();
            this.text.setText(password);
            if (password == null || password.compareTo("") == 0) {
                this.clearPasswordButton.setEnabled(false);
            } else {
                this.clearPasswordButton.setEnabled(true);
            }
        }
        return changed;
    }

    @Override
    public String toString() {
        return this.text.getText();
    }

    @Override
    public Object getValue(Trace t) {
        String value = this.text.getText();
        return value;
    }

    @Override
    public void setEnabled(boolean b) {
    }

    @Override
    public boolean setValue(Trace t, Object value) {
        boolean accepted = true;
        this.text.setText(value.toString());
        return accepted;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isChanged(Trace t) {
        boolean changed = false;
        Object currentValue = this.getValue(t);
        changed = AttributeControl.compareObjectValues(t, currentValue, this.originalValue) != 0;
        return changed;
    }

    @Override
    public void valueApplied(Trace t) {
        this.originalValue = this.getValue(t);
    }

    @Override
    public void setAdditionalValidCharacters(Trace t, String addValidChars) {
    }

    public Point computeSize(int wHint, int hHint) {
        Trace t = Trace.getDefault();
        return this.computeSize(t, wHint, hHint);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Trace t = Trace.getDefault();
        return this.computeSize(t, wHint, hHint);
    }

    private Point computeSize(Trace t, int wHint, int hHint) {
        Point size = null;
        size = super.computeSize(wHint, hHint, true);
        if (wHint == -1 && size.x > 500) {
            if (Trace.isTracing) {
                t.data(67, "PasswordAttributeControl.computeSize", 300, "constraining size to 500");
            }
            size.x = 500;
        }
        return size;
    }

    @Override
    public void addMandatoryDecoration(Trace t) {
        this.createControlDecoration(t, (Control)this.text);
    }
}

