/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeObject;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.AttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.AttributeModifiedEvent;
import com.ibm.mq.explorer.ui.internal.properties.IAttributeModifiedListener;
import com.ibm.mq.explorer.ui.internal.utils.StringValidation;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ObjectAttributeControl
extends AttributeControl {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/ObjectAttributeControl.java";
    private static final int MAX_WIDTH = 500;
    private Text text = null;
    private static final int TEXT_ANY_LENGTH = -1;
    private static final int CHECK_NONE = 0;
    private static final int CHECK_MQ_CHARSET = 1;
    private static final int CHECK_MQ_CUSTOM = 2;
    private Button buttonSelect = null;
    private boolean enabled = true;
    private Object originalValue = null;
    private String additionalValidCharacters = "";
    private UiMQObject ownerUiMQObject = null;
    private int attributeId = -1;
    private AttrTypeObject attrTypeObject = null;
    private boolean doValueChanged;

    public ObjectAttributeControl(final Trace t, Composite parent, int style, AttrType attrType, Object currentValue, boolean canUseRegularExpressionVerification, UiMQObject ownerUiMQObj, int attrId) {
        super(t, parent, style, attrType, currentValue);
        Pattern p;
        this.originalValue = currentValue;
        this.ownerUiMQObject = ownerUiMQObj;
        this.attributeId = attrId;
        int maxLength = -1;
        int checkType = 0;
        boolean isSelectButton = true;
        switch (attrType.getAttributeType()) {
            case 26: {
                this.attrTypeObject = (AttrTypeObject)attrType;
                maxLength = this.attrTypeObject.getLength();
                checkType = this.attrTypeObject.getRegularExpression() == null || !canUseRegularExpressionVerification ? 1 : 2;
                DmObjectFilter dmObjectFilter = this.attrTypeObject.getDmObjectFilter();
                if (dmObjectFilter == null) break;
                isSelectButton = this.ownerUiMQObject.isSelectAttributeObjectFromDmObjectFilter(t, attrId, dmObjectFilter);
                break;
            }
            default: {
                System.out.println(">> ObjectAttributeControl - unknown AttrType: " + attrType);
            }
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this.text = new Text((Composite)this, 2048);
        String stringValue = currentValue.toString();
        this.text.setText(stringValue);
        this.ownerUiMQObject.setObjectAttributeControlValue(t, this.attributeId, stringValue);
        if (maxLength != -1) {
            this.text.setTextLimit(maxLength);
        }
        this.doValueChanged = true;
        if (checkType == 1) {
            this.text.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    Trace tr = Trace.getDefault();
                    ObjectAttributeControl.this.valid = StringValidation.verifyMQObjectNameAdditional(tr, e, ObjectAttributeControl.this.additionalValidCharacters);
                }
            });
        } else if (checkType == 2 && (p = this.attrTypeObject.getRegularExpression()) != null) {
            this.text.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    String current = ObjectAttributeControl.this.text.getText();
                    ObjectAttributeControl.this.valid = StringValidation.verifyUsingRegularExpression(t, current, e, p);
                }
            });
        }
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = isSelectButton ? 1 : 2;
        this.text.setLayoutData((Object)gridData);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace tr = Trace.getDefault();
                if (ObjectAttributeControl.this.doValueChanged) {
                    ObjectAttributeControl.this.valueChanged(tr);
                }
            }
        });
        if (isSelectButton) {
            this.buttonSelect = new Button((Composite)this, 8);
            Message msgFile = UiPlugin.getUIMessages(t, "KEY_NewObject");
            this.buttonSelect.setText(msgFile.getMessage(t, "UI.NewObject.WizPage1.ButtonSelect"));
            gridData = new GridData();
            gridData.horizontalAlignment = 3;
            gridData.horizontalSpan = 1;
            this.buttonSelect.setLayoutData((Object)gridData);
            this.buttonSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace tr = Trace.getDefault();
                    ObjectAttributeControl.this.selectObject(tr);
                }
            });
        }
    }

    private void valueChanged(Trace t) {
        if (!this.modifyListeners.isEmpty()) {
            AttributeModifiedEvent attrModifiedEvent = new AttributeModifiedEvent((Object)this, this.getValue(t));
            Enumeration keys = this.modifyListeners.keys();
            while (keys.hasMoreElements()) {
                IAttributeModifiedListener listener = (IAttributeModifiedListener)keys.nextElement();
                attrModifiedEvent.setUserType((Integer)this.modifyListeners.get(listener));
                listener.attrModified(attrModifiedEvent);
            }
        }
        this.ownerUiMQObject.setObjectAttributeControlValue(t, this.attributeId, this.getValue(t));
    }

    @Override
    public String toString() {
        return this.text.getText();
    }

    @Override
    public Object getValue(Trace t) {
        String value = this.toString();
        return value;
    }

    @Override
    public void setEnabled(boolean b) {
        ControlDecoration cd;
        Trace t = Trace.getDefault();
        if (this.buttonSelect != null) {
            this.enabled = b;
            this.text.setEnabled(this.enabled);
            if (this.enabled) {
                UiUtils.makeTextControlReadWrite(t, this.text);
            } else {
                UiUtils.makeTextControlReadOnly(t, this.text, false);
            }
            this.buttonSelect.setEnabled(b);
        }
        if ((cd = this.getMandatoryDecoration()) != null) {
            if (this.enabled) {
                cd.show();
            } else {
                cd.hide();
            }
        }
    }

    @Override
    public boolean setValue(Trace t, Object value) {
        boolean accepted = true;
        String stringValue = value.toString();
        this.text.setText(stringValue);
        this.ownerUiMQObject.setObjectAttributeControlValue(t, this.attributeId, stringValue);
        return accepted;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isChanged(Trace t) {
        boolean changed = false;
        Object currentValue = this.getValue(t);
        changed = AttributeControl.compareObjectValues(t, currentValue, this.originalValue) != 0;
        return changed;
    }

    @Override
    public void valueApplied(Trace t) {
        this.originalValue = this.getValue(t);
    }

    @Override
    public void setAdditionalValidCharacters(Trace t, String addValidChars) {
        this.additionalValidCharacters = addValidChars;
    }

    public Point computeSize(int wHint, int hHint) {
        Trace t = Trace.getDefault();
        return this.computeSize(t, wHint, hHint);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Trace t = Trace.getDefault();
        return this.computeSize(t, wHint, hHint);
    }

    private Point computeSize(Trace t, int wHint, int hHint) {
        Point size = null;
        size = super.computeSize(wHint, hHint, true);
        if (wHint == -1 && size.x > 500) {
            if (Trace.isTracing) {
                t.data(67, "ObjectAttributeControl.computeSize", 300, "constraining size to 500");
            }
            size.x = 500;
        }
        return size;
    }

    private void selectObject(Trace t) {
        String objectName;
        String currentSelection = null;
        String currentText = this.text.getText();
        if (currentText.length() > 0) {
            currentSelection = currentText;
        }
        if ((objectName = this.ownerUiMQObject.selectAttributeObjectFromDmObjectFilter(t, this.attributeId, this.attrTypeObject.getDmObjectFilter(), currentSelection, this.attrTypeObject.getInfopopId(), this.getShell())) != null) {
            this.doValueChanged = false;
            this.text.setText("");
            this.doValueChanged = true;
            this.text.setText(objectName);
        }
    }

    @Override
    public void addMandatoryDecoration(Trace t) {
        this.createControlDecoration(t, (Control)this.text);
    }
}

