/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthString;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeString;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeWMQName;
import com.ibm.mq.explorer.ui.internal.properties.AttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.AttributeModifiedEvent;
import com.ibm.mq.explorer.ui.internal.properties.IAttributeModifiedListener;
import com.ibm.mq.explorer.ui.internal.utils.StringValidation;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MultiLineTextAttributeControl
extends AttributeControl {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/MultiLineTextAttributeControl.java";
    private static final int MAX_WIDTH = 500;
    private Text text = null;
    private int heightHint = -1;
    private static final int TEXT_ANY_LENGTH = -1;
    private static final boolean IS_A_PASSWORD = false;
    private static final int CHECK_NONE = 0;
    private static final int CHECK_MQ_CHARSET = 1;
    private static final int CHECK_NUMERIC = 2;
    private static final int CHECK_MQ_CUSTOM = 3;
    private static final int CHECK_IP_ADDRESS = 4;
    private boolean enabled = true;
    private Object originalValue = null;
    private String additionalValidCharacters = "";

    public MultiLineTextAttributeControl(final Trace t, Composite parent, int style, int numOfRows, AttrType attrType, Object currentValue, boolean canUseRegularExpressionVerification) {
        super(t, parent, style, attrType, currentValue);
        this.originalValue = currentValue;
        int maxLength = -1;
        int checkType = 0;
        boolean password = false;
        switch (attrType.getAttributeType()) {
            case 6: {
                AttrTypeFixedLengthString attrTypeFixedLengthString = (AttrTypeFixedLengthString)attrType;
                maxLength = attrTypeFixedLengthString.getLength();
                password = attrTypeFixedLengthString.isPassword();
                break;
            }
            case 7: 
            case 26: {
                AttrTypeWMQName attrTypeWMQName = (AttrTypeWMQName)attrType;
                maxLength = attrTypeWMQName.getLength();
                if (attrTypeWMQName.getRegularExpression() == null || !canUseRegularExpressionVerification) {
                    checkType = 1;
                    break;
                }
                checkType = 3;
                break;
            }
            case 1: {
                checkType = 2;
                break;
            }
            case 10: {
                checkType = 2;
                break;
            }
            case 12: {
                checkType = 2;
                break;
            }
            case 2: {
                checkType = 3;
                break;
            }
            case 8: {
                checkType = 0;
                break;
            }
            case 5: {
                checkType = 4;
                break;
            }
            default: {
                System.out.println(">> TextAttributeControl - unknown AttrType: " + attrType);
            }
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        this.text = password ? new Text((Composite)this, 4197122) : new Text((Composite)this, 2818);
        this.text.setText(currentValue.toString());
        if (maxLength != -1) {
            this.text.setTextLimit(maxLength);
        }
        if (checkType == 1) {
            this.text.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    Trace tr = Trace.getDefault();
                    MultiLineTextAttributeControl.this.valid = StringValidation.verifyMQObjectNameAdditional(tr, e, MultiLineTextAttributeControl.this.additionalValidCharacters);
                }
            });
        } else if (checkType == 3) {
            final Pattern p = ((AttrTypeString)attrType).getRegularExpression();
            if (p != null) {
                this.text.addVerifyListener(new VerifyListener(){

                    public void verifyText(VerifyEvent e) {
                        String current = MultiLineTextAttributeControl.this.text.getText();
                        MultiLineTextAttributeControl.this.valid = StringValidation.verifyUsingRegularExpression(t, current, e, p);
                    }
                });
            }
        } else if (checkType == 2) {
            this.text.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    Trace tr = Trace.getDefault();
                    MultiLineTextAttributeControl.this.valid = StringValidation.verifyNumeric(tr, e);
                }
            });
        } else if (checkType == 4) {
            this.text.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    Trace tr = Trace.getDefault();
                    MultiLineTextAttributeControl.this.valid = StringValidation.verifyIPAddress(tr, e);
                }
            });
        }
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        GC gc = new GC((Drawable)this.text);
        try {
            gc.setFont(this.text.getFont());
            FontMetrics fontInfo = gc.getFontMetrics();
            gridData.heightHint = numOfRows * fontInfo.getHeight();
            this.heightHint = (numOfRows + 2) * fontInfo.getHeight();
        }
        finally {
            gc.dispose();
        }
        this.text.setLayoutData((Object)gridData);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace tr = Trace.getDefault();
                MultiLineTextAttributeControl.this.valueChanged(tr);
            }
        });
    }

    private void valueChanged(Trace t) {
        if (!this.modifyListeners.isEmpty()) {
            AttributeModifiedEvent attrModifiedEvent = new AttributeModifiedEvent((Object)this, this.getValue(t));
            Enumeration keys = this.modifyListeners.keys();
            while (keys.hasMoreElements()) {
                IAttributeModifiedListener listener = (IAttributeModifiedListener)keys.nextElement();
                attrModifiedEvent.setUserType((Integer)this.modifyListeners.get(listener));
                listener.attrModified(attrModifiedEvent);
            }
        }
    }

    @Override
    public String toString() {
        String value = "";
        if (this.text != null) {
            value = this.text.getText();
        }
        return value;
    }

    @Override
    public Object getValue(Trace t) {
        String value = this.toString();
        return value;
    }

    @Override
    public void setEnabled(boolean b) {
        Trace t = Trace.getDefault();
        this.enabled = b;
        this.text.setEnabled(this.enabled);
        if (this.enabled) {
            UiUtils.makeTextControlReadWrite(t, this.text);
        } else {
            UiUtils.makeTextControlReadOnly(t, this.text, false);
        }
        ControlDecoration cd = this.getMandatoryDecoration();
        if (cd != null) {
            if (this.enabled) {
                cd.show();
            } else {
                cd.hide();
            }
        }
    }

    public boolean setFocus() {
        return this.text.setFocus();
    }

    @Override
    public boolean setValue(Trace t, Object value) {
        boolean accepted = true;
        this.text.setText(value.toString());
        return accepted;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isChanged(Trace t) {
        boolean changed = false;
        Object currentValue = this.getValue(t);
        changed = AttributeControl.compareObjectValues(t, currentValue, this.originalValue) != 0;
        return changed;
    }

    @Override
    public void valueApplied(Trace t) {
        this.originalValue = this.getValue(t);
    }

    @Override
    public void setAdditionalValidCharacters(Trace t, String addValidChars) {
        this.additionalValidCharacters = addValidChars;
    }

    public Point computeSize(int wHint, int hHint) {
        Trace t = Trace.getDefault();
        return this.computeSize(t, wHint, hHint);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Trace t = Trace.getDefault();
        return this.computeSize(t, wHint, hHint);
    }

    private Point computeSize(Trace t, int wHint, int hHint) {
        Point size = null;
        size = super.computeSize(wHint, hHint, true);
        if (wHint == -1 && size.x > 500) {
            if (Trace.isTracing) {
                t.data(67, "TextAttributeControl.computeSize", 300, "constraining size to 500");
            }
            size.x = 500;
        }
        return size;
    }

    @Override
    public void addMandatoryDecoration(Trace t) {
        this.createControlDecoration(t, (Control)this.text);
    }

    public int getHeightHintForRows() {
        return this.heightHint;
    }
}

