/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIntArrayEnum;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.AttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.AttributeModifiedEvent;
import com.ibm.mq.explorer.ui.internal.properties.EditIntArrayEnumDialog;
import com.ibm.mq.explorer.ui.internal.properties.IAttributeModifiedListener;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;

public class IntArrayEnumAttributeControl
extends AttributeControl {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/IntArrayEnumAttributeControl.java";
    private Text textCtrl = null;
    private Button buttonEdit = null;
    private boolean enabled = true;
    private Composite parentComposite = null;
    private AttrTypeIntArrayEnum attrTypeIntArrayEnum = null;
    private ArrayList currentValueArray = null;
    private String currentValueString = null;
    private ArrayList originalValueArray = null;
    private UiMQObject uiMQObject = null;
    private int attrId = -1;

    public IntArrayEnumAttributeControl(Trace t, Composite parent, int style, AttrType attrType, String valueString, ArrayList valueArray, UiMQObject uiMQObj, int attId, Font fontFixedSpace) {
        super(t, parent, style, attrType, valueArray);
        this.parentComposite = parent;
        this.attrTypeIntArrayEnum = (AttrTypeIntArrayEnum)attrType;
        this.currentValueArray = new ArrayList(valueArray);
        this.originalValueArray = valueArray;
        this.currentValueString = new String(valueString);
        this.uiMQObject = uiMQObj;
        this.attrId = attId;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        int flags = 2818;
        this.textCtrl = new Text((Composite)this, flags);
        this.textCtrl.setText(valueString);
        UiUtils.makeTextControlReadOnly(t, this.textCtrl, true);
        Menu blankMenu = new Menu((Control)this.textCtrl);
        this.textCtrl.setMenu(blankMenu);
        this.textCtrl.setFont(fontFixedSpace);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        int showLines = this.currentValueArray.size();
        if (showLines > 5) {
            showLines = 5;
        }
        gridData.heightHint = this.textCtrl.getLineHeight() * showLines;
        this.textCtrl.setLayoutData((Object)gridData);
        this.buttonEdit = new Button((Composite)this, 8);
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_General");
        this.buttonEdit.setText(msgFile.getMessage(t, "UI.GENERAL.EDIT"));
        gridData = new GridData();
        this.buttonEdit.setLayoutData((Object)gridData);
        this.buttonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                EditIntArrayEnumDialog editDlg = new EditIntArrayEnumDialog(tr, IntArrayEnumAttributeControl.this.parentComposite.getShell(), 0);
                if (editDlg.open(tr, IntArrayEnumAttributeControl.this.currentValueArray, IntArrayEnumAttributeControl.this.attrTypeIntArrayEnum, IntArrayEnumAttributeControl.this.uiMQObject, IntArrayEnumAttributeControl.this.attrId)) {
                    IntArrayEnumAttributeControl.this.currentValueArray = editDlg.getIntegerValues();
                    ArrayList stringArray = editDlg.getStringValues();
                    IntArrayEnumAttributeControl.this.currentValueString = IntArrayEnumAttributeControl.arrayToString(tr, stringArray);
                    IntArrayEnumAttributeControl.this.textCtrl.setText(IntArrayEnumAttributeControl.this.currentValueString);
                    if (IntArrayEnumAttributeControl.this.isChanged(tr)) {
                        IntArrayEnumAttributeControl.this.valueChanged(tr);
                    }
                }
            }
        });
        this.layout();
    }

    @Override
    public String toString() {
        return this.currentValueString;
    }

    @Override
    public Object getValue(Trace t) {
        ArrayList value = this.currentValueArray;
        return value;
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
        this.buttonEdit.setEnabled(b);
    }

    @Override
    public boolean setValue(Trace t, Object value) {
        boolean accepted = false;
        if (value instanceof ArrayList) {
            this.currentValueArray = (ArrayList)value;
            this.currentValueString = IntArrayEnumAttributeControl.arrayToString(t, this.currentValueArray);
            this.textCtrl.setText(this.currentValueString);
            accepted = true;
        }
        return accepted;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isChanged(Trace t) {
        boolean result = false;
        result = false;
        if (this.originalValueArray.size() != this.currentValueArray.size()) {
            result = true;
        } else {
            int i = 0;
            while (i < this.originalValueArray.size()) {
                int newValue;
                int oldValue = (Integer)this.originalValueArray.get(i);
                if (oldValue != (newValue = ((Integer)this.currentValueArray.get(i)).intValue())) {
                    result = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public void valueApplied(Trace t) {
        this.originalValueArray = this.currentValueArray;
    }

    private static String arrayToString(Trace t, ArrayList arrayList) {
        String string = "";
        int i = 0;
        while (i < arrayList.size()) {
            if (string.length() > 0) {
                string = String.valueOf(string) + "\n";
            }
            string = String.valueOf(string) + arrayList.get(i);
            ++i;
        }
        return string;
    }

    private void valueChanged(Trace t) {
        if (!this.modifyListeners.isEmpty()) {
            AttributeModifiedEvent attrModifiedEvent = new AttributeModifiedEvent((Object)this, this.getValue(t));
            Enumeration keys = this.modifyListeners.keys();
            while (keys.hasMoreElements()) {
                IAttributeModifiedListener listener = (IAttributeModifiedListener)keys.nextElement();
                attrModifiedEvent.setUserType((Integer)this.modifyListeners.get(listener));
                listener.attrModified(attrModifiedEvent);
            }
        }
    }

    public int getItemCount(Trace t) {
        return this.currentValueArray.size();
    }

    @Override
    public void setAdditionalValidCharacters(Trace t, String addValidChars) {
    }
}

